CLS : DIM MPNF(5), MPLTBITE(18), MPTABLE(14, 18), TSLASHDMAX(11), NC(11), TCOEF(11), JA(11), JB(11), JC(11)
PRINT "   BALLISTIC LIMIT COMPUTATION FOR A NON-DEFORMING MONOBLOC AP SHOT WITH WWII":
PRINT "       U.S. ARMY 3-INCH M79 1.667-CALIBER-RADIUS TANGENT-OGIVE NOSE SHAPE"
PRINT " VS U.S. NAVY CLASS 'B' ARMOR OR STS OF 225 BRINELL/115,000 PSI TENSILE STRENGTH"
PRINT "   (THIS ARMOR HAS A QUALITY FACTOR OF 1.00 AND A PERCENT ELONGATION OF 25%)"
PRINT " [PLATE THICKNESS RANGE VERSUS NAVY B.L., ENERGY DENSITY, & N.B.L.(NOSE-FIRST)]"
PRINT
PRINT "Press RETURN with no entry to repeat previously entered value.": REM INITIALIZE CONSTANTS
PRINT "Exit hole in plate back at NBL is circular at OB <= 45 deg; oval above this OB."
PRINT "Linear interpolation used here to be compatible with other nose shape formulae."
PRINT "Maximum NBL allowed is 3500 feet/second; program terminates printout next pass."
PRINT "Plate Thickness T & Projectile Diameter D in inches. NBL/NBLNF in Feet/Second."
PRINT "Obliquity Angle OB in Degrees (0 Degree=Normal=Right-Angles to Plate Surface)."
PRINT "NBLNF is Nose-First Penetration NBL and is sometimes greater than regular NBL."
PRINT "  NBLNF > NBL when Base-First Penetration happens at the NBL, which occurs for"
PRINT "  thin plates (under 0.25 caliber) hit at OB > 67.5 degrees for T/D < 0.1 or"
PRINT "  hit at OB > 65 degrees for T/D = 0.1-0.2499. Otherwise, ALL penetrations are"
PRINT "  Nose-First Penetrations. NBLNF is an estimate based on limited data."
PRINT "ENERGY is projectile's regular NBL kinetic energy divided by the volume of a"
PRINT "  cylindrical hole of projectile diameter entirely through the plate (minimum"
PRINT "  possible hole size); what is called that NBL's 'Actual Energy Density'."
PRINT "ECOSOB^2 is the A.E.D. times the square of COS(OB), where OB=Obliquity Angle--"
PRINT "  that is, using the NBL component that is 'normal' to the plate surface--and"
PRINT "  it is called the 'Normal Energy Density'.  It is convenient for graphing."
PRINT "ENERGY and ECOSOB^2 are in Foot-Pounds/Cubic Inch (= Work/Volume)."
D = 3: WT = 15: QA = 1: PE = 25: GOSUB 300: GOSUB 600: REM INITIALIZE VALUES
10 : INPUT "Projectile Diameter (Inches): ", D$: IF (D$ = "") THEN IF (D > 0) THEN PRINT "Projectile Diameter Used is"; D; "inches": GOTO 20:  ELSE 10
D = VAL(D$): IF (D <= 0) THEN 10
20 : INPUT "Projectile Total Weight (Pounds): ", WT$: IF (WT$ = "") THEN IF (WT > 0) THEN PRINT "Projectile Weight Used is"; WT; "pounds": GOTO 30:  ELSE 20
WT = VAL(WT$): IF (WT <= 0) THEN 20
30 : PROJDENSITY = WT / D ^ 3: LOGTEMP = D / 3!: SCALEFACTOR = (1 - .04 * LOG(LOGTEMP)) ^ .5: REM NATURAL LOG (BASE E)
PRINT : PRINT "MAXIMUM ALLOWED PLATE THICKNESS IS 6 CALIBERS ="; 6 * D; "INCHES"
PRINT "MINIMUM ALLOWED PLATE THICKNESS IS .001 CALIBER ="; .001 * D; "INCH": PRINT
40 : INPUT "Minimum Plate Thickness (Inches): ", MINT$: IF (MINT$ = "") THEN IF (MIND >= .0009999#) AND (MIND <= 6) THEN PRINT "Minimum Plate Thickness Used is"; MINT; "inches": GOTO 50:  ELSE 40
MINT = VAL(MINT$): MIND = MINT / D: IF (MIND < .0009999#) OR (MIND > 6.00001#) THEN 40
IF (MIND >= 6!) THEN MIND = 5.99999: MINT = 5.99999 * D: REM KEEP MINIMUM VALUE SLIGHTLY LESS THAN TABLE UPPER LIMIT
IF (MIND < .001) THEN MIND = .001: MINT = .001 * D: REM KEEP MINIMUM VALUE AT OR ABOVE STATED LOWER LIMIT
50 : INPUT "Maximum Plate Thickness (Inches): ", MAXT$: IF (MAXT$ = "") THEN IF (MAXT > 0) AND (MAXT >= MINT) AND (MAXD <= 6) THEN PRINT "Maximum Plate Thickness Used is"; MAXT; "inches": GOTO 60:  ELSE 50
MAXT = VAL(MAXT$): MAXD = MAXT / D: IF (MAXT < MINT) OR (MAXD > 6.0001) THEN 100
IF (MAXD >= 6!) THEN MAXD = 5.999999: MAXT = MAXD * D: REM KEEP MAXIMUM VALUE SLIGHTLY LESS THAN TABLE UPPER LIMIT
60 : IF ((MAXT - MINT) < .0001) THEN STEPT = 0: PRINT "Thickness Step = 0 inches": GOTO 80
70 : INPUT "Thickness Step (Inches) (0.0001 minimum, if not zero): ", STEPT$: IF (STEPT$ = "") THEN IF (STEPT = 0) OR (STEPT >= .0001) THEN PRINT "Plate Thickness Step Used is"; STEPT; "inches": GOTO 80:  ELSE 70
STEPT = VAL(STEPT$): IF (STEPT < 0) OR ((STEPT > 0) AND (STEPT < .0001)) THEN 70
80 : INPUT "Plate Quality Factor (Dimensionless): ", QA$: IF (QA$ = "") THEN IF (QA > 0) THEN PRINT "Plate Quality Used is"; QA: GOTO 90:  ELSE 80
QA = VAL(QA$): IF (QA <= 0) THEN 80
90 : INPUT "Plate Percent Elongation (10% Minimum): ", PE$: IF (PE$ = "") THEN IF (PE >= 10) THEN PRINT "Plate Percent Elongation Used is"; PE; "percent": GOTO 100:  ELSE 90
PE = VAL(PE$): IF (PE < 10) THEN 90
100 : IF (PE >= 25) OR (D <= 8) THEN NBLMOD = 1: GOTO 110: REM NO EFFECT IF PE >= 25% OR ON 8-INCH OR SMALLER PROJECTILES
NBLMOD = 1 - (1 - SQR(PE / 25)) * (D - 8) / 8: REM MATERIAL NOT DUCTILE ENOUGH FOR MAXIMUM RESISTANCE (PE < 25% & BIG PROJECTILES)
110 : INPUT "Obliquity (Degrees) (80 Degrees Maximum): ", OB$: IF (OB$ = "") THEN IF (OB >= 0) AND (OB <= 80!) THEN PRINT "Obliquity Angle Used is"; OBPRT; "degrees": GOTO 120:  ELSE 110
OB = VAL(OB$): IF (OB < 0) OR (OB > 80!) THEN 110
120 : MINTMP = MINT * 10000 + .5: MINTRNDED = INT(MINTMP) / 10000: MAXTMP = MAXT * 10000 + .5: MAXTRNDED = INT(MAXTMP) / 10000: REM USED FOR MAXIMUM VALUE CHECK & PRINTOUTS
MINDTMP = MIND * 10000 + .5: MINDRNDED = INT(MINDTMP) / 10000: MAXDTMP = MAXD * 10000 + .5: MAXDRNDED = INT(MAXDTMP) / 10000
STPTMP = STEPT * 10000 + .5: STPRNDED = INT(STPTMP) / 10000: STPDTMP = 10000 * (STEPT / D) + .5: STPDRNDED = INT(STPDTMP) / 10000
REM ****** INITIALIZE PLATE THICKNESS AND OBLIQUITY ******
TA = MINT: OBPRT = OB: IF (OB >= 80!) THEN OB = 79.9999: OBPRT = 80: REM INTERPOLATION FORMULA WILL CRASH AT ITS EXTREME EDGE HERE, SO KEEP MAXIMUM JUST A HAIR BELOW EDGE
OBRAD = OB / 57.29578: CSOB = COS(OBRAD): COSSQD = CSOB ^ 2: REM BASIC USES RADIANS
REM ****** PRINT HEADERS ******
IF (NOHEADER = 1) THEN 130: REM ONLY PRINT PROJECTILE/RUN INFORMATION LINE OF HEADER (SAME PAGE AS LAST RUN)
LPRINT : LPRINT " Steel Monobloc AP Shot Projectile with 1.667-Caliber-Radius Tangent-Ogive Nose"
LPRINT " of WWII U.S. Army 3-Inch M79 AP Projectile Vs US Navy WWII Class 'B' Armor or"
LPRINT "    STS of 225 Brinell/115,000 PSI Tensile Stength (No Projectile Damage)"
LPRINT : LPRINT "Plate Quality is 1.00 for Above Armor -- Plate Quality Used Here is"; QA
LPRINT "Plate Percent Elongation is 25% for Above Armor -- P.E. Used Here is"; PE
LPRINT
LPRINT "Plate Thickness T & Projectile Diameter D in inches. NBL/NBLNF in Feet/Second."
LPRINT "Obliquity Angle OB in Degrees (0 Degree=Normal=Right-Angles to Plate Surface)."
LPRINT "NBLNF is Nose-First Penetration NBL and is sometimes greater than regular NBL."
LPRINT "  NBLNF > NBL when Base-First Penetration happens at the NBL, which occurs for"
LPRINT "  thin plates (under 0.25 caliber) hit at OB > 67.5 degrees for T/D < 0.1 or"
LPRINT "  hit at OB > 65 degrees for T/D = 0.1-0.2499. Otherwise, ALL penetrations are"
LPRINT "  Nose-First Penetrations. NBLNF is an estimate based on limited data."
LPRINT "ENERGY is projectile's regular NBL kinetic energy divided by the volume of a"
LPRINT "  cylindrical hole of projectile diameter entirely through the plate (minimum"
LPRINT "  possible hole size); what is called that NBL's 'Actual Energy Density'."
LPRINT "ECOSOB^2 is the A.E.D. times the square of COS(OB), where OB=Obliquity Angle--"
LPRINT "  that is, using the NBL component that is 'normal' to the plate surface--and"
LPRINT "  it is called the 'Normal Energy Density'.  It is convenient for graphing."
LPRINT "ENERGY and ECOSOB^2 are in Foot-Pounds/Cubic Inch (= Work/Volume)."
LPRINT
LPRINT "Projectile Diameter ="; D; "inch"; : IF (D <= 1!) THEN LPRINT " "; :  ELSE LPRINT "es ";
LPRINT "-- Projectile Total Weight ="; WT; "pound"; : IF (WT <= 1!) THEN LPRINT :  ELSE LPRINT "s"
REM ***** 'P' ENTRY PRINTOUT BELOW
130 : OBTMP = OBPRT * 100 + .5: OBRNDED = INT(OBTMP) / 100
LPRINT "Impact Obliquity Angle ="; OBRNDED; "degree"; : IF (OBRNDED <= 1!) THEN LPRINT :  ELSE LPRINT "s"
LPRINT "Plate Actual Thickness Range is"; MINTRNDED; "to"; MAXTRNDED; "inch"; : IF (MAXTRNDED <= 1!) THEN LPRINT " "; :  ELSE LPRINT "es";
LPRINT "(="; MINDRNDED; "to"; MAXDRNDED; "cal)"
LPRINT "Step is"; STPRNDED; "inch"; : IF (STPRNDED <= 1!) THEN LPRINT " "; :  ELSE LPRINT "es ";
LPRINT "(="; STPDRNDED; "cal)"
REM ****** COLUMN HEADER ******
LPRINT : LPRINT "    T     T/D       NBL    ENERGY    ECOSOB^2     NBLNF   ENRGNF    ENFCOB^2": LPRINT : REM COLUMN HEADER
REM ****** COMPUTE DATA FOR ONE PASS ******
140 : TSLASHD = TA / D: TQASLASHD = QA * TSLASHD: TSLDTMP = TSLASHD * 10000 + .5: TSLASHDRNDED = INT(TSLDTMP) / 10000:
TATMP = TA * 10000 + .5: TRNDED = INT(TATMP) / 10000: REM ROUNDED VALUES USED BY PRINTOUT LOGIC
GOSUB 200: REM COMPUTE NAVY BALLISTIC LIMIT
NBLTMP = NAVYBL + .5: NAVYBLRNDED = INT(NBLTMP): REM USE NAVY BL IN WHOLE NUMBER FEET/SECOND FOR PRINTOUT
GOSUB 800: REM COMPUTE NOSE-FIRST NBL (NBLNF) = REGULAR NBL (NAVYBLM79) *EXCEPT* WHEN BASE-FIRST PENETRATIONS ARE POSSIBLE
NBLNFTMP = NBLNF + .5: NBLNFRNDED = INT(NBLNFTMP)
REM COMPUTE HOW MUCH ENERGY PER VOLUME OF ARMOR MATERIAL REMOVED WAS NEEDED TO OPEN UP A CALIBER-DIAMETER HOLE IN THAT PLATE.
REM ALSO COMPUTE THAT ENERGY TIMES THE SQUARE OF THE COSINE OF OBLIQUITY TO GIVE A MEASURE OF HOW THE ENERGY CHANGES WITH OBLIQUITY ANGLE.
ENERGYDENSITY = .5 * (WT / 32.185) * NAVYBL ^ 2 / (3.141592654# * TA * (D / 2) ^ 2): ENERGYRNDED = INT(ENERGYDENSITY + .5)
ENDENCSQD = ENERGYDENSITY * COSSQD + .5: ENERGYCOSRNDED = INT(ENDENCSQD)
ENDENNF = .5 * (WT / 32.185) * NBLNF ^ 2 / (3.141592654# * TA * (D / 2) ^ 2): ENRGNFRNDED = INT(ENDENNF + .5)
ENDENNFCSQD = ENDENNF * COSSQD + .5: ENRGNFCOSRNDED = INT(ENDENNFCSQD)
REM ****** PRINT DATA FOR ONE PASS ******
LPRINT USING "##.####  "; TRNDED; : LPRINT USING "#.####    "; TSLASHDRNDED;
LPRINT USING "####  "; NAVYBLRNDED; : LPRINT USING "########   "; ENERGYRNDED; : LPRINT USING "########      "; ENERGYCOSRNDED;
NBLDIFF = ABS(NBLNFRNDED - NAVYBLRNDED): IF (NBLDIFF > .1) THEN LPRINT USING "####  "; NBLNFRNDED; :  ELSE LPRINT "=NBL    ";
IF (NBLDIFF <= .1) THEN LPRINT "=ENRGY    =ECSOB^2": GOTO 150
LPRINT USING "########   "; ENRGNFRNDED;
LPRINT USING "########"; ENRGNFCOSRNDED
150 : IF (Z = -1) THEN LPRINT "NBL > 3500:  TERMINATING RUN!"
TMAXDIFF = TRNDED - MAXTRNDED
IF (Z = -1) OR (STEPT = 0) OR (ABS(TMAXDIFF) < .000001) THEN LPRINT : GOTO 160: REM LAST PASS COMPLETED
TA = TA + STEPT: TCHKTMP = TA * 10000 + .5: TCHK = INT(TCHKTMP) / 10000: TCHKDIFF = TCHK - MAXTRNDED
TNXTDIFF = TCHK - TRNDED: IF (ABS(TNXTDIFF) < .000001) THEN LPRINT : GOTO 160: REM NEXT LINE WILL REPEAT THIS ONE'S "T", SO DO NOT PRINT IT
IF (TCHKDIFF > 0) THEN TA = MAXT: LPRINT "Last pass reduced to maximum plate thickness!": REM LIMIT MAXIMUM TO MANUAL MAXIMUM ENTRY (THIS IS LAST PASS)
GOTO 140: REM DO NEXT PASS
REM ****** MANUAL TERMINATE/CONTINUE OPTIONS ******
160 : PRINT "Finished!"
NOHEADER = 0: PRINT : PRINT "Y or N answer will start NEW PAGE on printer; P answer stays on same page."
PRINT "Another run? (Y=Yes/N=No/P=Yes but only projectile & run data) ";
170 : YN$ = INKEY$: IF (YN$ = "") THEN 170: REM WAIT FOR KEYBOARD INPUT ("Y" or "N" or "P" (EITHER CASE))
IF (YN$ = "Y") OR (YN$ = "y") THEN PRINT "Yes": PRINT : LPRINT CHR$(12): GOTO 10: REM START NEW PAGE WITH COMPLETE HEADER
IF (YN$ = "N") OR (YN$ = "n") THEN PRINT "No": LPRINT CHR$(12): END: REM EXIT PROGRAM AND FORCE OUT LAST PAGE (NEEDED FOR LASER PRINTER)
IF (YN$ = "P") OR (YN$ = "p") THEN NOHEADER = 1: PRINT "Only run data": PRINT : GOTO 10: REM BEGIN NEW PRINTOUT ON SAME PAGE WITH ONLY PROJECTILE/RUN DATA
GOTO 170: REM IGNORE ILLEGAL INPUT
REM **********  <<SUBROUTINES FOLLOW>>  **********
REM ****** COMPUTE NAVY BALLISTIC LIMIT FOR 3-INCH-M79-NOSE PROJECTILE *****
200 : GOSUB 500: REM COMPUTE OBLIQUITY ANGLE VELOCITY MULTIPLIER M
GOSUB 400: REM SELECT COEFFICIENTS FOR PLATE THICKNESS RANGE & COMPUTE GREEN'S FUNCTION, IF USED
NAVYBLM79 = NBLMOD * NUM * J * MOBLIQUITY * SCALEFACTOR * (TQASLASHD) ^ TEXP / PROJDENSITY ^ .5: REM FINAL M79-NOSE-SHAPE NAVY BL VALUE
Z = 0: IF (NAVYBLM79 > 3500) THEN Z = -1: REM SET 'NBL ABOVE 35OO FEET/SECOND' FLAG
NAVYBL = NAVYBLM79: REM USE STANDARD NOMENCLATURE FOR PRINTOUT LOGIC
RETURN: REM NOW COMPUTE ENERGY DENSITY VALUES AND DO PRINTOUT LOGIC
REM ****** M79 DATA TABLES FOR INCREASING PLATE THICKNESS INTERVALS ******
300 : TSLASHDMAX(1) = .01156: NC(1) = 335.25392#: TCOEF(1) = .4336513: JA(1) = 0: JB(1) = 0: JC(1) = 0
TSLASHDMAX(2) = .05: NC(2) = 516.85756#: TCOEF(2) = .5306597: JA(2) = -.02: JB(2) = 4682.6223#: JC(2) = 54.131113#
TSLASHDMAX(3) = .075: NC(3) = 902.41425#: TCOEF(3) = .7166931: JA(3) = -.01: JB(3) = 7200!: JC(3) = 360!
TSLASHDMAX(4) = .1: NC(4) = 1290.90181#: TCOEF(4) = .8549115: JA(4) = 0: JB(4) = 0: JC(4) = 0
TSLASHDMAX(5) = .2549: NC(5) = 1687.6956#: TCOEF(5) = .9713125: JA(5) = 0: JB(5) = 0: JC(5) = 0
TSLASHDMAX(6) = .47931: NC(6) = 1361.41055#: TCOEF(6) = .8141355: JA(6) = .02: JB(6) = 802.10329#: JC(6) = 204.45613#
TSLASHDMAX(7) = 1!: NC(7) = 1179.94178#: TCOEF(7) = .619609: JA(7) = 0: JB(7) = 0: JC(7) = 0
TSLASHDMAX(8) = 2!: NC(8) = 1179.94178#: TCOEF(8) = .6387357: JA(8) = 0: JB(8) = 0: JC(8) = 0
TSLASHDMAX(9) = 3!: NC(9) = 1173.77728#: TCOEF(9) = .6462927: JA(9) = 0: JB(9) = 0: JC(9) = 0
TSLASHDMAX(10) = 4!: NC(10) = 1201.73299#: TCOEF(10) = .6248678: JA(10) = 0: JB(10) = 0: JC(10) = 0
TSLASHDMAX(11) = 6!: NC(11) = 1227.31234#: TCOEF(11) = .609576: JA(11) = 0: JB(11) = 0: JC(11) = 0
RETURN
REM ****** SELECT CONSTANTS FOR THREE PARTS OF M79 ENERGY VS THICKNESS PLOT & COMPUTE GREEN'S FUNCTION INTERPOLATION CURVES IF NEEDED ******
400 : N = 1: REM INITIALIZE LOOP COUNTER
410 : IF (TSLASHD > TSLASHDMAX(N)) THEN N = N + 1: GOTO 410:  ELSE NUM = NC(N): TEXP = TCOEF(N): JCA = JA(N): JCB = JB(N): JCC = JC(N): REM SELECT PROPER CONSTANT SET FOR PLATE THICKNESS RANGE
J = 1!: JSIN = 0: IF (JCA <> 0) THEN JDEG = JCB * (TA / D) - JCC: JRAD = JDEG * 3.141593 / 180!: JSIN = SIN(JRAD): IF (JSIN <= 0) THEN JSIN = 0:  ELSE J = 1! + JCA * JSIN: REM COMPUTE GREEN'S FUNCTION WHEN USED (J <> 0)
RETURN
REM ****** COMPUTE OLBIQUITY ANGLE VELOCITY MULTIPLIER "MOBLIQUITY" ******
500 : IF (OB >= 45!) THEN 510: REM IF OBLIQUITY IS 45 DEGREES AND UP, PLATE THICKNESS IN THE RANGE 0-.9 CALIBER CHANGES MULTIPLIER COEFFICIENT M' VALUE (CONSTANT ABOVE .9 CALIBER)
REM **** USE LINEAR INTERPOLATION FORMULA FOR OBLIQUITY ANGLES UNDER 45 DEGREES ******
REM U.S. ARMY 3" M79 AP SHOT UP TO 45 DEGREES HAS A SINGLE M' VALUE FOR EACH ANGLE FOR ALL PLATE THICKNESSES
I1 = INT(OB / 2.5): I2 = (OB - 2.5 * I1) / 2.5: REM 2.5 DEG INTERVAL
MPRIME = MPLTBITE(I1) + I2 * (MPLTBITE(I1 + 1) - MPLTBITE(I1)): REM M' FOR OBLIQUITY UP TO 45 DEGREES
GOTO 520: REM JUMP TO SET MULTIPLIER VALUE
REM **** USE TWO-DIMENSIONAL LINEAR INTERPOLATION FORMULA FOR OBLIQUITY ANGLE VELOCITY MULTIPLIER VALUES ABOVE 45 DEGREES ******
510 : C1 = INT((OB - 45!) / 2.5): C2 = ((OB - 45!) - 2.5 * C1) / 2.5: REM OBLIQUITY AXIS: DELTA(OB)  = 2.5-DEGREE  INTERVAL (INCREASING)
TSLASHDPR = TSLASHD: IF (TSLASHD > .899) THEN TSLASHDPR = .899: REM  M' BECOMES A CONSTANT AT 0.9-CALIBER OR LESS PLATE THICKNESS FOR ALL OBLIQUITY VALUES
T1 = INT(TSLASHDPR / .05): T2 = (TSLASHDPR - .05 * T1) / .05: REM   THICKNESS AXIS: DELTA(T/D) = .05-CALIBER INTERVAL (INCREASING)
N = 0: GOSUB 700: MP0 = MPVAL: REM FIND THE LOWEST  OB INTERPOLATION POINT
N = 1: GOSUB 700: MP1 = MPVAL: REM FIND THE HIGHEST OB INTERPOLATION POINT
MPRIME = MP0 + C2 * (MP1 - MP0): REM MULTIPLIER COEFFICIENT M' FOR OBLIQUITY GREATER THAN 45 DEGREES
520 : MOBLIQUITY = MPRIME / CSOB: REM FINAL VALUE OF OBLIQUITY ANGLE VELOCITY MULTIPLIER
RETURN
REM ****** OBLIQUITY ANGLE VELOCITY MULTIPLIER TABLE FOR ANGLES ABOVE 45 DEGREES ******
REM U.S. ARMY 3" M79 AP SHOT ABOVE 45 DEGREES (PLATE THICKNESS ALTERS RESULTS)
REM FIRST INDEX IS OBLIQUITY FROM 45 TO 80 DEGREES IN 2.5-DEGREE INCREMENTS. SECOND INDEX IS PLATE THICKNESS IN .05-CALIBER INCREMENTS UP TO INDEX 18 = .9 CALIBER
600 : MPTABLE(0, 0) = .885: MPTABLE(0, 1) = .885: MPTABLE(0, 2) = .885: MPTABLE(0, 3) = .885: MPTABLE(0, 4) = .885: MPTABLE(0, 5) = .885: REM 45.0 DEG
MPTABLE(0, 6) = .885: MPTABLE(0, 7) = .885: MPTABLE(0, 8) = .885: MPTABLE(0, 9) = .885: MPTABLE(0, 10) = .885: MPTABLE(0, 11) = .885: MPTABLE(0, 12) = .885
MPTABLE(0, 13) = .885: MPTABLE(0, 14) = .885: MPTABLE(0, 15) = .885: MPTABLE(0, 16) = .885: MPTABLE(0, 17) = .885: MPTABLE(0, 18) = .885
MPTABLE(1, 0) = .918: MPTABLE(1, 1) = .916: MPTABLE(1, 2) = .912: MPTABLE(1, 3) = .906: MPTABLE(1, 4) = .902: MPTABLE(1, 5) = .901: REM 47.5 DEG
MPTABLE(1, 6) = .905: MPTABLE(1, 7) = .909: MPTABLE(1, 8) = .912: MPTABLE(1, 9) = .914: MPTABLE(1, 10) = .914: MPTABLE(1, 11) = .914: MPTABLE(1, 12) = .914
MPTABLE(1, 13) = .914: MPTABLE(1, 14) = .914: MPTABLE(1, 15) = .914: MPTABLE(1, 16) = .914: MPTABLE(1, 17) = .914: MPTABLE(1, 18) = .914
MPTABLE(2, 0) = .968: MPTABLE(2, 1) = .96: MPTABLE(2, 2) = .949: MPTABLE(2, 3) = .932: MPTABLE(2, 4) = .922: MPTABLE(2, 5) = .921: REM 50.0 DEG
MPTABLE(2, 6) = .928: MPTABLE(2, 7) = .936: MPTABLE(2, 8) = .944: MPTABLE(2, 9) = .951: MPTABLE(2, 10) = .956: MPTABLE(2, 11) = .96: MPTABLE(2, 12) = .961
MPTABLE(2, 13) = .961: MPTABLE(2, 14) = .961: MPTABLE(2, 15) = .961: MPTABLE(2, 16) = .961: MPTABLE(2, 17) = .961: MPTABLE(2, 18) = .961
MPTABLE(3, 0) = 1.05: MPTABLE(3, 1) = 1.028: MPTABLE(3, 2) = 1!: MPTABLE(3, 3) = .97: MPTABLE(3, 4) = .958: MPTABLE(3, 5) = .952: REM 52.5 DEG
MPTABLE(3, 6) = .96: MPTABLE(3, 7) = .968: MPTABLE(3, 8) = .982: MPTABLE(3, 9) = .995: MPTABLE(3, 10) = 1.005: MPTABLE(3, 11) = 1.015: MPTABLE(3, 12) = 1.021
MPTABLE(3, 13) = 1.023: MPTABLE(3, 14) = 1.023: MPTABLE(3, 15) = 1.023: MPTABLE(3, 16) = 1.023: MPTABLE(3, 17) = 1.023: MPTABLE(3, 18) = 1.023
MPTABLE(4, 0) = 1.153: MPTABLE(4, 1) = 1.111: MPTABLE(4, 2) = 1.057: MPTABLE(4, 3) = 1.008: MPTABLE(4, 4) = .992: MPTABLE(4, 5) = .987: REM 55.0 DEG
MPTABLE(4, 6) = .993: MPTABLE(4, 7) = 1.006: MPTABLE(4, 8) = 1.024: MPTABLE(4, 9) = 1.042: MPTABLE(4, 10) = 1.062: MPTABLE(4, 11) = 1.076: MPTABLE(4, 12) = 1.088
MPTABLE(4, 13) = 1.094: MPTABLE(4, 14) = 1.098: MPTABLE(4, 15) = 1.098: MPTABLE(4, 16) = 1.098: MPTABLE(4, 17) = 1.098: MPTABLE(4, 18) = 1.098
MPTABLE(5, 0) = 1.272: MPTABLE(5, 1) = 1.203: MPTABLE(5, 2) = 1.12: MPTABLE(5, 3) = 1.053: MPTABLE(5, 4) = 1.027: MPTABLE(5, 5) = 1.021: REM 57.5 DEG
MPTABLE(5, 6) = 1.031: MPTABLE(5, 7) = 1.049: MPTABLE(5, 8) = 1.072: MPTABLE(5, 9) = 1.094: MPTABLE(5, 10) = 1.12: MPTABLE(5, 11) = 1.14: MPTABLE(5, 12) = 1.154
MPTABLE(5, 13) = 1.165: MPTABLE(5, 14) = 1.172: MPTABLE(5, 15) = 1.179: MPTABLE(5, 16) = 1.182: MPTABLE(5, 17) = 1.184: MPTABLE(5, 18) = 1.184
MPTABLE(6, 0) = 1.376: MPTABLE(6, 1) = 1.29: MPTABLE(6, 2) = 1.178: MPTABLE(6, 3) = 1.092: MPTABLE(6, 4) = 1.058: MPTABLE(6, 5) = 1.052: REM 60.0 DEG
MPTABLE(6, 6) = 1.067: MPTABLE(6, 7) = 1.089: MPTABLE(6, 8) = 1.116: MPTABLE(6, 9) = 1.142: MPTABLE(6, 10) = 1.172: MPTABLE(6, 11) = 1.197: MPTABLE(6, 12) = 1.215
MPTABLE(6, 13) = 1.231: MPTABLE(6, 14) = 1.241: MPTABLE(6, 15) = 1.25: MPTABLE(6, 16) = 1.257: MPTABLE(6, 17) = 1.26: MPTABLE(6, 18) = 1.261
MPTABLE(7, 0) = 1.441: MPTABLE(7, 1) = 1.354: MPTABLE(7, 2) = 1.213: MPTABLE(7, 3) = 1.119: MPTABLE(7, 4) = 1.083: MPTABLE(7, 5) = 1.079: REM 62.5 DEG
MPTABLE(7, 6) = 1.095: MPTABLE(7, 7) = 1.119: MPTABLE(7, 8) = 1.147: MPTABLE(7, 9) = 1.178: MPTABLE(7, 10) = 1.211: MPTABLE(7, 11) = 1.24: MPTABLE(7, 12) = 1.262
MPTABLE(7, 13) = 1.28: MPTABLE(7, 14) = 1.294: MPTABLE(7, 15) = 1.302: MPTABLE(7, 16) = 1.31: MPTABLE(7, 17) = 1.315: MPTABLE(7, 18) = 1.316
MPTABLE(8, 0) = 1.5: MPTABLE(8, 1) = 1.4: MPTABLE(8, 2) = 1.232: MPTABLE(8, 3) = 1.134: MPTABLE(8, 4) = 1.099: MPTABLE(8, 5) = 1.094: REM 65.0 DEG
MPTABLE(8, 6) = 1.111: MPTABLE(8, 7) = 1.139: MPTABLE(8, 8) = 1.165: MPTABLE(8, 9) = 1.194: MPTABLE(8, 10) = 1.232: MPTABLE(8, 11) = 1.262: MPTABLE(8, 12) = 1.291
MPTABLE(8, 13) = 1.313: MPTABLE(8, 14) = 1.326: MPTABLE(8, 15) = 1.339: MPTABLE(8, 16) = 1.345: MPTABLE(8, 17) = 1.351: MPTABLE(8, 18) = 1.353
MPTABLE(9, 0) = 1.519: MPTABLE(9, 1) = 1.414: MPTABLE(9, 2) = 1.232: MPTABLE(9, 3) = 1.13: MPTABLE(9, 4) = 1.098: MPTABLE(9, 5) = 1.092: REM 67.5 DEG
MPTABLE(9, 6) = 1.109: MPTABLE(9, 7) = 1.138: MPTABLE(9, 8) = 1.165: MPTABLE(9, 9) = 1.195: MPTABLE(9, 10) = 1.232: MPTABLE(9, 11) = 1.265: MPTABLE(9, 12) = 1.295
MPTABLE(9, 13) = 1.32: MPTABLE(9, 14) = 1.337: MPTABLE(9, 15) = 1.35: MPTABLE(9, 16) = 1.36: MPTABLE(9, 17) = 1.365: MPTABLE(9, 18) = 1.37
MPTABLE(10, 0) = 1.498: MPTABLE(10, 1) = 1.386: MPTABLE(10, 2) = 1.2: MPTABLE(10, 3) = 1.109: MPTABLE(10, 4) = 1.075: MPTABLE(10, 5) = 1.07: REM 70.0 DEG
MPTABLE(10, 6) = 1.087: MPTABLE(10, 7) = 1.114: MPTABLE(10, 8) = 1.14: MPTABLE(10, 9) = 1.171: MPTABLE(10, 10) = 1.209: MPTABLE(10, 11) = 1.24: MPTABLE(10, 12) = 1.27
MPTABLE(10, 13) = 1.293: MPTABLE(10, 14) = 1.311: MPTABLE(10, 15) = 1.325: MPTABLE(10, 16) = 1.337: MPTABLE(10, 17) = 1.344: MPTABLE(10, 18) = 1.349
MPTABLE(11, 0) = 1.448: MPTABLE(11, 1) = 1.326: MPTABLE(11, 2) = 1.157: MPTABLE(11, 3) = 1.064: MPTABLE(11, 4) = 1.029: MPTABLE(11, 5) = 1.02: REM 72.5 DEG
MPTABLE(11, 6) = 1.037: MPTABLE(11, 7) = 1.064: MPTABLE(11, 8) = 1.091: MPTABLE(11, 9) = 1.119: MPTABLE(11, 10) = 1.156: MPTABLE(11, 11) = 1.189: MPTABLE(11, 12) = 1.217
MPTABLE(11, 13) = 1.24: MPTABLE(11, 14) = 1.257: MPTABLE(11, 15) = 1.268: MPTABLE(11, 16) = 1.28: MPTABLE(11, 17) = 1.287: MPTABLE(11, 18) = 1.292
MPTABLE(12, 0) = 1.36: MPTABLE(12, 1) = 1.255: MPTABLE(12, 2) = 1.087: MPTABLE(12, 3) = 1.004: MPTABLE(12, 4) = .968: MPTABLE(12, 5) = .961: REM 75.0 DEG
MPTABLE(12, 6) = .977: MPTABLE(12, 7) = 1!: MPTABLE(12, 8) = 1.026: MPTABLE(12, 9) = 1.055: MPTABLE(12, 10) = 1.087: MPTABLE(12, 11) = 1.112: MPTABLE(12, 12) = 1.149
MPTABLE(12, 13) = 1.17: MPTABLE(12, 14) = 1.19: MPTABLE(12, 15) = 1.202: MPTABLE(12, 16) = 1.212: MPTABLE(12, 17) = 1.218: MPTABLE(12, 18) = 1.221
MPTABLE(13, 0) = 1.26: MPTABLE(13, 1) = 1.167: MPTABLE(13, 2) = 1.013: MPTABLE(13, 3) = .932: MPTABLE(13, 4) = .897: MPTABLE(13, 5) = .891: REM 77.5 DEG
MPTABLE(13, 6) = .906: MPTABLE(13, 7) = .929: MPTABLE(13, 8) = .957: MPTABLE(13, 9) = .98: MPTABLE(13, 10) = 1.012: MPTABLE(13, 11) = 1.04: MPTABLE(13, 12) = 1.066
MPTABLE(13, 13) = 1.088: MPTABLE(13, 14) = 1.109: MPTABLE(13, 15) = 1.121: MPTABLE(13, 16) = 1.132: MPTABLE(13, 17) = 1.14: MPTABLE(13, 18) = 1.145
MPTABLE(14, 0) = 1.153: MPTABLE(14, 1) = 1.071: MPTABLE(14, 2) = .933: MPTABLE(14, 3) = .858: MPTABLE(14, 4) = .826: MPTABLE(14, 5) = .82: REM 80.0 DEG
MPTABLE(14, 6) = .837: MPTABLE(14, 7) = .853: MPTABLE(14, 8) = .881: MPTABLE(14, 9) = .908: MPTABLE(14, 10) = .933: MPTABLE(14, 11) = .961: MPTABLE(14, 12) = .982
MPTABLE(14, 13) = 1.007: MPTABLE(14, 14) = 1.025: MPTABLE(14, 15) = 1.039: MPTABLE(14, 16) = 1.049: MPTABLE(14, 17) = 1.055: MPTABLE(14, 18) = 1.06
REM **** M' VALUE TABLE FOR OBLIQUITIES UNDER 45 DEGREES (INDEPENDENT OF PLATE THICKNESS) ******
MPLTBITE(0) = 1!: MPLTBITE(1) = .999: MPLTBITE(2) = .998: MPLTBITE(3) = .995: MPLTBITE(4) = .991: MPLTBITE(5) = .986: MPLTBITE(6) = .981: MPLTBITE(7) = .974: MPLTBITE(8) = .966: MPLTBITE(9) = .958: MPLTBITE(10) = .948
MPLTBITE(11) = .937: MPLTBITE(12) = .925: MPLTBITE(13) = .912: MPLTBITE(14) = .901: MPLTBITE(15) = .889: MPLTBITE(16) = .881: MPLTBITE(17) = .879: MPLTBITE(18) = .885
REM **** BASE-FIRST PENETRATION COMPUTATION M'(OB) VALUES
MPNF(0) = 1.519: MPNF(1) = 1.414: MPNF(2) = 1.232: MPNF(3) = 1.134: MPNF(4) = 1.099:
MPNF(5) = 1.094: REM MPNF(0)-MPNF(2) AT 67.5 DEG; MPNF(3)-MPNF(5) AT 65 DEG
REM ****
RETURN
REM ****** COMPUTE ONE OF THE TWO OBLIQUITY ANGLE MULTIPLIER VALUES FROM ABOVE TABLE FOR USE BY TWO-DIMENSIONAL LINEAR INTERPOLATION FORMULAE ******
700 : MPTH0 = MPTABLE(C1 + N, T1): MPTH1 = MPTABLE(C1 + N, T1 + 1)
MPVAL = MPTH0 + T2 * (MPTH1 - MPTH0)
RETURN
REM ******
REM COMPUTE NOSE-FIRST PENETRATION NBL USING MPNF(T/D) TABLE (UP TO T/D = 0.25 AND OB FROM 65-67.5 DEG TO 80 DEG)
800 : IF (TSLASHD > .1) AND (TSLASHD < .25) AND (OB > 65) THEN 810: REM 65 DEG M' IS MAXIMUM VALUE
IF (TSLASHD <= .1) AND (OB > 67.5) THEN 810: REM 67.5 DEG M' IS MAXIMUM VALUE (SAME AS 65 DEG VALUE AT T/D = 0.1)
REM ****
NBLNF = NAVYBLM79: RETURN: REM NBL IS ALWAYS NBLNF OUTSIDE DEFINED REGION
REM ****
REM NOSE-FIRST NBL (NBLNF) AT HIGHER VELOCITY THAN ACTUAL NBL, WHICH IS FOR BASE-FIRST PENETRATIONS IN DEFINED REGION
810 : MPRNF0 = MPNF(T1): MPRNF1 = MPNF(T1 + 1)
MPRIMEMAX = MPRNF0 + T2 * (MPRNF1 - MPRNF0): REM M' FOR 65 (T/D > 0.1) OR 67.5 DEG (T/D = 0-0.1) (MAXIMUM VALUE)
MPRIMENF = MPRIMEMAX - (MPRIMEMAX - MPRIME) * (TSLASHD / .25): REM AT T/D = 0.25 AND UP, ALL NLNF VALUES MERGE WITH ACTUAL NL VALUES
NBLNF = (MPRIMENF / MPRIME) * NAVYBLM79
RETURN
REM ******
REM    <<<<END OF PROGRAM LISTING>>>>

