CLS : DIM MPLTBITE(18), MPTABLE(14, 18), TSLASHDMAX(11), NC(11), TCOEF(11), JA(11), JB(11), JC(11), MPNF(5)
REM ****
PRINT " NAVY BALLISTIC LIMIT, ENERGY, EXIT ANGLE, & REMAINING VELOCITY FOR PROJECTILES"
PRINT " LIKE WWII U.S. ARMY 3-INCH M79 AP SHOT (TANGENT OGIVE W/1.667-CALIBER RADIUS)"
PRINT " VS WWII U.S. NAVY CLASS 'B' ARMOR OR S.T.S. OF 115,000 P.S.I. TENSILE STRENGTH "; ""
PRINT " (THIS ARMOR HAS A PLATE QUALITY FACTOR OF 1.00 & A PERCENT ELONGATION OF 25%)"
REM ****
REM INITIALIZE PROGRAM CONSTANTS
QA = 1: PE = 25: VS = 1500: D = 3: TA = 3: WT = 15: OB = 0: RAD45 = .78539816#: REPEAT = 1
GOSUB 500: GOSUB 800
REM ****
PRINT : PRINT "Press RETURN with no entry to repeat previously entered value."
PRINT "This program assumes no projectile damage ever occurs.  The projectile has no"
PRINT "  AP cap, hood, or windscreen, and no explosive filler cavity, only a tracer."
PRINT "  Its nose shape is in the middle between long-point WWI & blunt WWII designs."
PRINT "At the Navy Ballistic Limit, the hole in the plate back is always circular if"
PRINT "  the impact obliquity is up to 45 degrees.  Above 45 degrees the hole becomes"
PRINT "  more and more elongated along the forward direction in the obliquity plane."
PRINT "Linear interpolation is used here to be compatible with all other nose shape"
PRINT "  computation formulae.  Error is negligible.": PRINT
REM ****
10 : INPUT "Projectile Diameter (Inches): ", D$
IF (D$ = "") THEN IF (D > 0) THEN PRINT "Projectile Diameter Used is"; D; "inches": GOTO
20:  ELSE 10
D = VAL(D$): IF (D <= 0) THEN 10
REM ****
20 : INPUT "Projectile Total Weight (Pounds): ", WT$
IF (WT$ = "") THEN IF (WT > 0) THEN PRINT "Projectile Weight Used is"; WT; "pounds": GOTO 30: ELSE 20
WT = VAL(WT$): IF (WT <= 0) THEN 20
30 : PROJDENSITY = WT / D ^ 3: LOGTMP = D / 3!: SCALEFACTOR = (1 - .04 * LOG(LOGTMP)) ^ .5: REM NATURAL LOG (BASE E)
REM ****
PRINT : PRINT "MAXIMUM ALLOWED PLATE THICKNESS IS 6 CALIBERS ="; 6 * D; "INCHES"
PRINT "MINIMUM ALLOWED PLATE THICKNESS IS .001 CALIBER ="; .001 * D; "INCH": PRINT
40 : INPUT "Plate Thickness (Inches): ", TA$
IF (TA$ = "") THEN IF (TA / D >= .001) AND (TA / D <= 6) THEN PRINT "Plate Thickness Used is"; TA; "inches": GOTO 50:  ELSE 40
TA = VAL(TA$): IF (TA / D < .001) OR (TA / D > 6.00001#) THEN 40
IF (TA / D >= 6!) THEN TA = 5.99999 * D: REM MUST KEEP BELOW UPPER EDGE
50 : PRINT "PLATE THICKNESS IN CALIBERS ="; TA / D
REM ****
60 : INPUT "Plate Quality Factor (Dimensionless): ", QA$
IF (QA$ = "") THEN IF (QA > 0) THEN PRINT "Plate Quality Factor Used is"; QA: GOTO 70:  ELSE 60
QA = VAL(QA$): IF (QA <= 0) THEN 60
REM ****
70 : INPUT "Obliquity (Degrees) (80 Degrees Maximum): ", OB$
IF (OB$ = "") THEN IF (OB >= 0) AND (OB <= 80!) THEN PRINT "Obliquity Angle Used is"; OB; "degrees": GOTO 80: ELSE 70
OB = VAL(OB$): IF (OB < 0) OR (OB > 80!) THEN 70
80 : IF (OB = 80!) THEN OB = 79.9999: REM INTERPOLATION FORMULA WILL CRASH AT ITS EXTREME EDGE HERE, SO KEEP MAXIMUM JUST A HAIR BELOW EDGE
OBRAD = OB * 3.1415927# / 180!: CSOB = COS(OBRAD): CSOBSQD = CSOB ^ 2: REM BASIC USES RADIANS
REM ****
TSLASHD = TA / D: REM PLATE QUALITY FACTOR 'QA' USED ONLY FOR FINAL VELOCITY COMPUTATION, NOT FOR GEOMETRICAL PLATE THICKNESS AND OBLIQUITY EFFECTS
REM ****
90 : INPUT "Striking Velocity (Feet/Second) (3500 Feet/Second Maximum): ", VS$
IF (VS$ = "") THEN IF (VS > 0) AND (VS <= 3500!) THEN PRINT "Striking Velocity Used is"; VS; "feet/second": GOTO 100:  ELSE 90
VS = VAL(VS$): IF (VS <= 0) OR (VS > 3500!) THEN 90
REM ****
100 : PRINT "PERCENT ELONGATION (PE) MEASURES RESILIENCE. LOWER PE INCREASES SCALING EFFECTS."
PRINT "PE DECREASES NBL WITH INCREASING PROJECTILE SIZE ONLY IF PROJECTILE OVER 8 INCH."
PRINT "ALSO, IF PE IS 25% OR MORE, IT HAS NO EFFECT & ONLY STANDARD SCALING IS USED."
110 : INPUT "Percent Elongation of Armor Metal Used (10% Minimum): ", PE$
IF (PE$ = "") THEN IF (PE >= 10) THEN PRINT "Percent Elongation Used is"; PE; "percent": GOTO 120:  ELSE 110
PE = VAL(PE$): IF (PE < 10) THEN 110
REM ****** END INPUTS ******
120 : GOSUB 700: REM COMPUTE VELOCITY OBLIQUITY MULTIPLIER M
GOSUB 600: REM SELECT COEFFICIENTS FOR PLATE THICKNESS RANGE & COMPUTE GREEN'S FUNCTION, IF USED
REM CALCULATE REGULAR NBL
NAVYBLM79 = NUM * J * MOBLIQUITY * SCALEFACTOR * (QA * TSLASHD) ^ TEXP / PROJDENSITY ^ .5
REM ADD IN EXTRA PERCENT ELONGATION SCALING EFFECTS, IF ANY
IF (PE < 25) AND (D > 8) THEN NAVYBLM79 = NAVYBLM79 * (1 - (1 - SQR(PE / 25)) * (D - 8) / 8)
NAVYBLTMP = NAVYBLM79 + .5: NAVYBLM79RNDED = INT(NAVYBLTMP)
REM ****
VSTMP = VS + .5: VSRNDED = INT(VSTMP): REM USE ROUNDED VALUES FOR COMPARISONS
GOSUB 1000: REM CALCULATE VMIN = NOSE-FIRST NBL WHEN OB > 45
REM ****
REM SET BASE-FIRST PENETRATION FLAG BFPEN TO VARIOUS VALUES
BFPEN = 1: IF (OB <= 45!) THEN BFPEN = 0: GOTO 130: REM NOSE-FIRST ALWAYS AND OB <= 45
IF (NBLNFRNDED = NAVYBLM79RNDED) THEN BFPEN = -1: GOTO 130: REM NOSE-FIRST ALWAYS AND OB > 45
IF (VSRNDED >= NBLNFRNDED) THEN BFPEN = -2: REM NOSE-FIRST AT THIS VS AND OB > 45
REM ****
REM HOW MUCH ENERGY PER VOLUME OF ARMOR MATERIAL REMOVED WAS NEEDED TO OPEN UP A CALIBER-DIAMETER HOLE IN THAT PLATE
130 : ENERGYDENSITY = .5 * (WT / 32.186) * NAVYBLM79 ^ 2 / (3.1415927# * TA * (D / 2) ^ 2)
ENERGYTMP = ENERGYDENSITY + .5: ENERGYRNDED = INT(ENERGYTMP)
REM ENERGY PER VOLUME USING ONLY COMPONENT OF NBL NORMAL TO PLATE FACE AT IMPACT POINT (=NBL*COS(OB))
ENERGYCOSSQD = ENERGYDENSITY * CSOBSQD: ECTMP = ENERGYCOSSQD + .5:
ECSOBRNDED = INT(ECTMP)
REM **********
PRINT : PRINT "Navy Ballistic Limit ="; NAVYBLM79RNDED; "feet/second"
PRINT "Energy/Unit Hole Volume      ="; ENERGYRNDED; "ft-lbs/in^3 (Actual Energy Density)"
PRINT "Energy Density X COS(OB)^2   ="; ECSOBRNDED; "ft-lbs/in^3 (Normal Energy Density)"
PRINT : PRINT "BASE-FIRST PENETRATIONS OCCUR AT THE NAVY B.L. IF T/D UNDER 0.25 CALIBER AND"
PRINT "OB > 67.5 DEG FOR T/D <= 0.1 CALIBER OR OB > 65 DEG FOR T/D < 0.25 CALIBER."
PRINT "THIS OCCURS ONLY IF THE STRIKING VELOCITY IS BETWEEN THE TRUE NBL & NBL(N.F.)."
PRINT "Navy B.L. (Nose-First Penetration) =";
IF (BFPEN = 0) OR (BFPEN = -1) THEN PRINT " NAVY B.L. (Always Nose-First)": GOTO 140
PRINT NBLNFRNDED; "feet/second"
REM ****
140 : NBLRATMP0 = NBLNFRNDED / NAVYBLM79RNDED: NBLRATMP1 = 10000 * NBLRATMP0 .5: NBLRATIO = INT(NBLRATMP1) / 10000
VSNBLTMP0 = VSRNDED / NAVYBLM79RNDED: VSNBLTMP1 = 10000 * VSNBLTMP0
+ .5: VSNBLRATIO = INT(VSNBLTMP1) / 10000
PRINT "NBL(N.F.)/TRUE NBL RATIO ="; NBLRATIO; "--- VS/TRUE NBL RATIO ="; VSNBLRATIO
REM ****
PRINT "SHARPLY POINTED PROJECTILES DO NOT PUNCH OUT ARMOR MATERIAL DURING PENETRATION."
REM ****
VMIN = NAVYBLM79: VMINRNDED = NAVYBLM79RNDED: REM USE NOSE-FIRST NBL AT OB <=45 OR BASE-FIRST NBL AT OB > 45
IF (BFPEN <> 0) THEN 150: REM CHECK FOR BASE-FIRST PENETRATION IF OB > 45
REM ****
REM OB <= 45 (BFPEN = 0)
REM VMIN ALWAYS EQUALS REGULAR NBL, WHICH IS FOR NOSE-FIRST PENETRATIONS HERE
PRINT "ALL PENETRATIONS NOSE-FIRST AT OB <= 45 SO VR = EX = 0 & ENERGY NBL = TRUE NBL."
GOTO 160
REM ****
REM OB > 45 (BFPEN = 1 (BASE-FIRST PEN) OR BFPEN < 0 (NOSE-FIRST PEN))
150 : IF (BFPEN <> 1) THEN 170: REM JUMP TO COMPUTE V'MIN(OB) IF NOT A BASE-FIRST PENETRATION
REM BASE-FIRST PENETRATION IF VS > NBL (BFPEN = 1)
PRINT "BASE-FIRST PENETRATION AT OB > 45 SO VR = EX = 0 & ENERGY NBL = TRUE NBL."
REM ****
REM VR FORMULA FOR OB <= 45 OR FOR BASE-FIRST PENETRATIONS WITH OB > 45
160 : PRINT "REMAINING VELOCITY VR = [COS(OB - EX)]SQRT[VS^2 - (TRUE NBL)^2]."
GOTO 180
REM ****
REM NOSE-FIRST PENETRATION AT OB > 45 IF VS > NOSE-FIRST N.L. (BFPEN < 0)
170 : GOSUB 1100: REM COMPUTE ENERGY NBL, WHICH REPLACES NBL IN VR CALC WHEN NOSE-FIRST PEN OCCURS AT OB > 45
PRINT "NOSE-FIRST PENETRATION AT OB > 45 SO VR > 0 & EX > 0 & ENERGY NBL < TRUE NBL."
PRINT "REMAINING VELOCITY VR = [COS(OB - EX)]SQRT[VS^2 - (ENERGY NBL)^2].": REM ONLY USED FOR NOSE-FIRST PEN AT OB > 45
VMINRATIO = VMINRNDED / NAVYBLM79RNDED: VMINRATRNDED1 = 10000 *
VMINRATIO .5: VMINRATRNDED = INT(VMINRATRNDED1) / 10000
PRINT "ENERGY NBL ="; VMINRNDED; "feet/second -- ENERGY NBL/TRUE NBL RATIO = "; VMINRATRNDED; ""
REM ****
180 : PRINT : OBTMP = 10 * OB + .5: OBRNDED = INT(OBTMP) / 10
PRINT "Striking Velocity (VS) ="; VSRNDED; : IF (VSRNDED <= 1!) THEN PRINT "foot/second":  ELSE PRINT "feet/second"
PRINT "Obliquity Angle   (OB) ="; OBRNDED; : IF (OBRNDED <= 1!) THEN PRINT "degree":  ELSE PRINT "degrees"
PRINT
REM ****
EX = 0: EXRAD = 0: EXRNDED = 0: VR = 0: VRRNDED = 0: DF = 0: DFRAD = 0: DFRNDED = 0: REM INIT POST-IMPACT VALUES
IF (VSRNDED < NAVYBLM79RNDED) THEN PRINT "No complete penetration.  EX & VR are UNDEFINED.": GOTO 400: REM JUMP TO END-OF-PROGRAM LOGIC
REM ****
REM CALCULATE AND PRINT EX, DF, AND VR
GOSUB 1200: REM CALCULATE EX & DF
IF (BFPEN <> 1) THEN PRINT "Nose-First Penetration occurred at given Striking Velocity.": GOTO 190
PRINT "Base-First Penetration occurred at given Striking Velocity."
190 : PRINT "Exit Angle (EX) (assumed to be in same plane as OB) ="; EXRNDED; : IF (EXRNDED <= 1!) THEN PRINT "degree":  ELSE PRINT "degrees"
PRINT "Deflection Angle (OB - EX) ="; DFRNDED; : IF (DFRNDED <= 1!) THEN PRINT "degree":  ELSE PRINT "degrees"
REM ****
REM VMIN IS EITHER REGULAR M79 NBL OR CALCULATED ENERGY NBL, AS SELECTED ABOVE
IF (VS < VMIN) THEN VMIN = VS: REM PREVENT ROUND-OFF ERROR
VSVMIN = (VS ^ 2 - VMIN ^ 2): VR = COS(DFRAD) * SQR(VSVMIN): VRTMP = VR + .5: VRRNDED = INT(VRTMP): REM CALCULATE VR
PRINT "Remaining Velocity (VR) ="; VRRNDED; : IF (VRRNDED <= 1!) THEN PRINT "foot/second":  ELSE PRINT "feet/second"
REM **********
REM END-OF-PROGRAM LOGIC
400 : PRINT : PRINT "Print Copy of Results on Printer (Y or N)? ";
GOSUB 1500: REM ANSWER QUESTION
IF (YESNO = 0) THEN 410: REM JUMP TO CHECK FOR HEADER PAGE PRINTOUT
REM ****
GOSUB 1400: REM PRINT RESULTS OF LAST RUN TO PRINTER
REM NOTE:  IF LASER PRINTER, ONLY FORM-FEEDS PAGE AFTER SECOND RESULTS PRINTOUT
REM ****
410 : PRINT "Print A Header-Only Introduction Page on Printer (Y or N)? ";
GOSUB 1500: REM ANSWER QUESTION
IF (YESNO = 1) THEN GOSUB 1300: REM PRINT HEADER PAGE (DO ONCE PER CALCULATION DOCUMENT)
REM ****
IF (REPEAT = 1) THEN 420: REM ALREADY PRINTED ENTIRE PAGE ON PRINTER
REM ****
PRINT "Only Top Half of Page Sent to Printer. Print It by Itself Now? (Y or N) "; : REM CHECK TO DO HALF-PAGE PRINTOUT
GOSUB 1500: REM ANSWER QUESTION
IF (YESNO = 0) THEN 420
PRINT "Resetting Printer Page to Top for Next Run."
REPEAT = 1: LPRINT CHR$(12): REM RESET TO TOP OF PAGE AFTER PRINTOUT
REM ****
420 : PRINT : PRINT "Another Run (Y or N)? ";
GOSUB 1500: REM ANSWER QUESTION
IF (YESNO = 1) THEN CLS : GOTO 10: REM DO ANOTHER RUN
IF (REPEAT = -1) THEN PRINT "Printing Out Last Unprinted Top Half Page Results to Printer. ": LPRINT CHR$(12); ""
END: REM TERMINATE PROGRAM
REM ********** SUBROUTINES FOLLOW **********
REM TABLE OF VALUES FOR VARIOUS PARTS OF THE M79 PENETRATION
FORMULA PLUS THE MAXIMUM THICKNESS IN CALIBERS FOR USING THAT SET
OF VALUES
500 : TSLASHDMAX(1) = .01156: NC(1) = 335.25392#: TCOEF(1) = .4336513: JA(1) = 0: JB(1) = 0: JC(1) = 0
TSLASHDMAX(2) = .05: NC(2) = 516.85756#: TCOEF(2) = .5306597: JA(2) = -.02: JB(2) = 4682.6223#: JC(2) = 54.131113#
TSLASHDMAX(3) = .075: NC(3) = 902.41425#: TCOEF(3) = .7166931: JA(3) = -.01: JB(3) = 7200!: JC(3) = 360!
TSLASHDMAX(4) = .1: NC(4) = 1290.90181#: TCOEF(4) = .8549115: JA(4) = 0: JB(4) = 0: JC(4) = 0
TSLASHDMAX(5) = .2549: NC(5) = 1687.6956#: TCOEF(5) = .9713125: JA(5) = 0: JB(5) = 0: JC(5) = 0
TSLASHDMAX(6) = .47931: NC(6) = 1361.41055#: TCOEF(6) = .8141355: JA(6) = .02: JB(6) = 802.10329#: JC(6) = 204.45613#
TSLASHDMAX(7) = 1!: NC(7) = 1179.94178#: TCOEF(7) = .619609: JA(7) = 0: JB(7) = 0: JC(7) = 0
TSLASHDMAX(8) = 2!: NC(8) = 1179.94178#: TCOEF(8) = .6387357: JA(8) = 0: JB(8) = 0: JC(8) = 0
TSLASHDMAX(9) = 3!: NC(9) = 1173.77728#: TCOEF(9) = .6462927: JA(9) = 0: JB(9) = 0: JC(9) = 0
TSLASHDMAX(10) = 4!: NC(10) = 1201.73299#: TCOEF(10) = .6248678: JA(10) = 0: JB(10) = 0: JC(10) = 0
TSLASHDMAX(11) = 6!: NC(11) = 1227.31234#: TCOEF(11) = .609576: JA(11) = 0: JB(11) = 0: JC(11) = 0
RETURN
REM **********
REM SELECT COEFFICIENTS FOR PENETRATION FORMULAE BASED ON TA/D
RANGE
600 : N = 1
610 : IF (TSLASHD > TSLASHDMAX(N)) THEN N = N + 1: GOTO 610: REM SELECT PROPER CONSTANT SET FOR PLATE THICKNESS RANGE
NUM = NC(N): TEXP = TCOEF(N): JCA = JA(N): JCB = JB(N): JCC = JC(N)
REM COMPUTE GREEN'S FUNCTION (J), WHEN USED
JSIN = 0: REM DEFAULT VALUE (J = 1)
IF (JCA <> 0) THEN JDEG = JCB * (TA / D) - JCC: JRAD = JDEG / 57.29578: JSIN = SIN(JRAD)
IF (JSIN < 0) THEN JSIN = 0
J = 1! + JCA * JSIN: REM "J" USUALLY IS 1.00 (NOT USED)
RETURN
REM **********
REM COMPUTE OBLIQUITY MULTIPLIER (FUNCTION OF OB ONLY IF OB <= 45, BUT TA NEEDED IF OB > 45)
700 : IF (OB >= 45!) THEN 710: REM ABOVE 45 DEG PLATE THICKNESS CHANGES MULTIPLIER COEFFICIENT M'
REM ****
REM COMPUTE M' FOR U.S. ARMY 3" M79 AP SHOT BELOW 45 DEGREES OBLIQUITY USING LINEAR INTERPOLATION
I1TMP = OB / 2.5: I1 = INT(I1TMP): I2 = (OB - 2.5 * I1) / 2.5: REM 2.5 DEG INTERVAL
MPRIME = MPLTBITE(I1) + I2 * (MPLTBITE(I1 + 1) - MPLTBITE(I1)): REM M' FOR OBLIQUITY UP TO 45 DEGREES
GOTO 720: REM JUMP TO CALCULATE OBLIQUITY ANGLE VELOCITY MULTIPLIER 'MOBLIQUITY'
REM ****
REM COMPUTE M' FOR U.S. ARMY 3" M79 AP SHOT AT AND ABOVE 45 DEGREES OBLIQUITY
710 : C1TMP = (OB - 45!) / 2.5: C1 = INT(C1TMP): C2 = ((OB - 45!) - 2.5 * C1) / 2.5: REM OBLIQUITY AXIS: DELTA(OB)  =  2.5-DEGREE INTERVAL (INCREASING)
TSLASHDPR = TSLASHD: IF (TSLASHD > .899) THEN TSLASHDPR = .899: REM M' BECOMES CONSTANT AT 0.9 CALIBER (OR LESS) FOR ALL OBLIQUITY VALUES
T1TMP = TSLASHDPR / .05: T1 = INT(T1TMP): T2 = (TSLASHDPR - .05 * T1) / .05: REM         THICKNESS AXIS: DELTA(T/D) = .05-CALIBER INTERVAL (INCREASING)
N = 0: GOSUB 900: MP0 = MPVAL: REM FIND THE LOWEST  OB INTERPOLATION POINTS HOLDING OBLIQUITY AXIS FIXED
N = 1: GOSUB 900: MP1 = MPVAL: REM FIND THE HIGHEST OB INTERPOLATION POINTS HOLDING OBLIQUITY AXIS FIXED
REM USING THE ABOVE TWO THICKNESS-AXIS POINTS JUST FOUND, CALCULATE THE FINAL OBLIQUITY-AXIS INTERPOLATED VALUE USING LINEAR INTERPOLATION
MPRIME = MP0 + C2 * (MP1 - MP0): REM COMPUTE M' FOR OBLIQUITY ANGLES OF 45 DEGREES AND UP
REM ****
720 : MOBLIQUITY = MPRIME / CSOB: REM FINAL VALUE OF OBLIQUITY ANGLE VELOCITY MULTIPLIER
RETURN
REM **********
REM TABLE OF M' VALUES FOR OBLIQUITY ANGLES UP TO 45 DEGREES (ALL PLATE THICKNESSES)
800 : MPLTBITE(0) = 1!: MPLTBITE(1) = .999: MPLTBITE(2) = .998: MPLTBITE(3) = .995: MPLTBITE(4) = .991
MPLTBITE(5) = .986: MPLTBITE(6) = .981: MPLTBITE(7) = .974: MPLTBITE(8) = .966: MPLTBITE(9) = .958
MPLTBITE(10) = .948: MPLTBITE(11) = .937: MPLTBITE(12) = .925: MPLTBITE(13) = .912: : MPLTBITE(14) = .901
MPLTBITE(15) = .889: MPLTBITE(16) = .881: MPLTBITE(17) = .879: MPLTBITE(18) = .885:
REM **********
REM TABLE OF M' VALUES FOR OBLIQUITY ANGLES ABOVE 45 DEGREES (PLATE THICKNESS ALTERS RESULTS)
REM FIRST  INDEX IS OBLIQUITY ANGLE IN 2.5-DEGREE  INCREMENTS UP TO 80 DEGREES
REM SECOND INDEX IS PLATE THICKNESS IN .05-CALIBER INCREMENTS UP TO INDEX 18 = .9 CALIBER
MPTABLE(0, 0) = .885: MPTABLE(0, 1) = .885: MPTABLE(0, 2) = .885: MPTABLE(0, 3) = .885: MPTABLE(0, 4) = .885: MPTABLE(0, 5) = .885: REM 45.0 DEG
MPTABLE(0, 6) = .885: MPTABLE(0, 7) = .885: MPTABLE(0, 8) = .885: MPTABLE(0, 9) = .885: MPTABLE(0, 10) = .885: MPTABLE(0, 11) = .885: MPTABLE(0, 12) = .885
MPTABLE(0, 13) = .885: MPTABLE(0, 14) = .885: MPTABLE(0, 15) = .885: MPTABLE(0, 16) = .885: MPTABLE(0, 17) = .885: MPTABLE(0, 18) = .885
MPTABLE(1, 0) = .918: MPTABLE(1, 1) = .916: MPTABLE(1, 2) = .912: MPTABLE(1, 3) = .906: : MPTABLE(1, 4) = .902: MPTABLE(1, 5) = .901: REM 47.5 DEG
MPTABLE(1, 6) = .905: MPTABLE(1, 7) = .909: MPTABLE(1, 8) = .912: MPTABLE(1, 9) = .914: : MPTABLE(1, 10) = .914: MPTABLE(1, 11) = .914: MPTABLE(1, 12) = .914
MPTABLE(1, 13) = .914: MPTABLE(1, 14) = .914: MPTABLE(1, 15) = .914: MPTABLE(1, 16) = .914: MPTABLE(1, 17) = .914: MPTABLE(1, 18) = .914
MPTABLE(2, 0) = .968: MPTABLE(2, 1) = .96: MPTABLE(2, 2) = .949: MPTABLE(2, 3) = .932: : MPTABLE(2, 4) = .922: MPTABLE(2, 5) = .921: REM 50.0 DEG
MPTABLE(2, 6) = .928: MPTABLE(2, 7) = .936: MPTABLE(2, 8) = .944: MPTABLE(2, 9) = .951: : MPTABLE(2, 10) = .956: MPTABLE(2, 11) = .96: MPTABLE(2, 12) = .961
MPTABLE(2, 13) = .961: MPTABLE(2, 14) = .961: MPTABLE(2, 15) = .961: MPTABLE(2, 16) = .961: MPTABLE(2, 17) = .961: MPTABLE(2, 18) = .961
MPTABLE(3, 0) = 1.05: MPTABLE(3, 1) = 1.028: MPTABLE(3, 2) = 1!: MPTABLE(3, 3) = .97: : MPTABLE(3, 4) = .958: MPTABLE(3, 5) = .952: REM 52.5 DEG
MPTABLE(3, 6) = .96: MPTABLE(3, 7) = .968: MPTABLE(3, 8) = .982: MPTABLE(3, 9) = .995: : MPTABLE(3, 10) = 1.005: MPTABLE(3, 11) = 1.015: MPTABLE(3, 12) = 1.021
MPTABLE(3, 13) = 1.023: MPTABLE(3, 14) = 1.023: MPTABLE(3, 15) = 1.023: MPTABLE(3, 16) = 1.023: MPTABLE(3, 17) = 1.023: MPTABLE(3, 18) = 1.023
MPTABLE(4, 0) = 1.153: MPTABLE(4, 1) = 1.111: MPTABLE(4, 2) = 1.057: MPTABLE(4, 3) = 1.008: MPTABLE(4, 4) = .992: MPTABLE(4, 5) = .987: REM 55.0 DEG
MPTABLE(4, 6) = .993: MPTABLE(4, 7) = 1.006: MPTABLE(4, 8) = 1.024: MPTABLE(4, 9) = 1.042: MPTABLE(4, 10) = 1.062: MPTABLE(4, 11) = 1.076: MPTABLE(4, 12) = 1.088
MPTABLE(4, 13) = 1.094: MPTABLE(4, 14) = 1.098: MPTABLE(4, 15) = 1.098: MPTABLE(4, 16) = 1.098: MPTABLE(4, 17) = 1.098: MPTABLE(4, 18) = 1.098
MPTABLE(5, 0) = 1.272: MPTABLE(5, 1) = 1.203: MPTABLE(5, 2) = 1.12: MPTABLE(5, 3) = 1.053: MPTABLE(5, 4) = 1.027: MPTABLE(5, 5) = 1.021: REM 57.5 DEG
MPTABLE(5, 6) = 1.031: MPTABLE(5, 7) = 1.049: MPTABLE(5, 8) = 1.072: MPTABLE(5, 9) = 1.094: MPTABLE(5, 10) = 1.12: MPTABLE(5, 11) = 1.14: MPTABLE(5, 12) = 1.154
MPTABLE(5, 13) = 1.165: MPTABLE(5, 14) = 1.172: MPTABLE(5, 15) = 1.179: MPTABLE(5, 16) = 1.182: MPTABLE(5, 17) = 1.184: MPTABLE(5, 18) = 1.184
MPTABLE(6, 0) = 1.376: MPTABLE(6, 1) = 1.29: MPTABLE(6, 2) = 1.178: MPTABLE(6, 3) = 1.092: MPTABLE(6, 4) = 1.058: MPTABLE(6, 5) = 1.052: REM 60.0 DEG
MPTABLE(6, 6) = 1.067: MPTABLE(6, 7) = 1.089: MPTABLE(6, 8) = 1.116: MPTABLE(6, 9) = 1.142: MPTABLE(6, 10) = 1.172: MPTABLE(6, 11) = 1.197: MPTABLE(6, 12) = 1.215
MPTABLE(6, 13) = 1.231: MPTABLE(6, 14) = 1.241: MPTABLE(6, 15) = 1.25: MPTABLE(6, 16) = 1.257: MPTABLE(6, 17) = 1.26: MPTABLE(6, 18) = 1.261
MPTABLE(7, 0) = 1.441: MPTABLE(7, 1) = 1.354: MPTABLE(7, 2) = 1.213: MPTABLE(7, 3) = 1.119: MPTABLE(7, 4) = 1.083: MPTABLE(7, 5) = 1.079: REM 62.5 DEG
MPTABLE(7, 6) = 1.095: MPTABLE(7, 7) = 1.119: MPTABLE(7, 8) = 1.147: MPTABLE(7, 9) = 1.178: MPTABLE(7, 10) = 1.211: MPTABLE(7, 11) = 1.24: MPTABLE(7, 12) = 1.262
MPTABLE(7, 13) = 1.28: MPTABLE(7, 14) = 1.294: MPTABLE(7, 15) = 1.302: MPTABLE(7, 16) = 1.31: MPTABLE(7, 17) = 1.315: MPTABLE(7, 18) = 1.316
MPTABLE(8, 0) = 1.5: MPTABLE(8, 1) = 1.4: MPTABLE(8, 2) = 1.232: MPTABLE(8, 3) = 1.134: MPTABLE(8, 4) = 1.099: MPTABLE(8, 5) = 1.094: REM 65.0 DEG
MPTABLE(8, 6) = 1.111: MPTABLE(8, 7) = 1.139: MPTABLE(8, 8) = 1.165: MPTABLE(8, 9) = 1.194: MPTABLE(8, 10) = 1.232: MPTABLE(8, 11) = 1.262: MPTABLE(8, 12) = 1.291
MPTABLE(8, 13) = 1.313: MPTABLE(8, 14) = 1.326: MPTABLE(8, 15) = 1.339: MPTABLE(8, 16) = 1.345: MPTABLE(8, 17) = 1.351: MPTABLE(8, 18) = 1.353
MPTABLE(9, 0) = 1.519: MPTABLE(9, 1) = 1.414: MPTABLE(9, 2) = 1.232: MPTABLE(9, 3) = 1.13: MPTABLE(9, 4) = 1.098: MPTABLE(9, 5) = 1.092: REM 67.5 DEG
MPTABLE(9, 6) = 1.109: MPTABLE(9, 7) = 1.138: MPTABLE(9, 8) = 1.165: MPTABLE(9, 9) = 1.195: MPTABLE(9, 10) = 1.232: MPTABLE(9, 11) = 1.265: MPTABLE(9, 12) = 1.295
MPTABLE(9, 13) = 1.32: MPTABLE(9, 14) = 1.337: MPTABLE(9, 15) = 1.35: MPTABLE(9, 16) = 1.36: MPTABLE(9, 17) = 1.365: MPTABLE(9, 18) = 1.37
MPTABLE(10, 0) = 1.498: MPTABLE(10, 1) = 1.386: MPTABLE(10, 2) = 1.2: MPTABLE(10, 3) = 1.109: MPTABLE(10, 4) = 1.075: MPTABLE(10, 5) = 1.07: REM 70.0 DEG
MPTABLE(10, 6) = 1.087: MPTABLE(10, 7) = 1.114: MPTABLE(10, 8) = 1.14: MPTABLE(10, 9) = 1.171: MPTABLE(10, 10) = 1.209: MPTABLE(10, 11) = 1.24: MPTABLE(10, 12) = 1.27
MPTABLE(10, 13) = 1.293: MPTABLE(10, 14) = 1.311: MPTABLE(10, 15) = 1.325: MPTABLE(10, 16) = 1.337: MPTABLE(10, 17) = 1.344: MPTABLE(10, 18) = 1.349
MPTABLE(11, 0) = 1.448: MPTABLE(11, 1) = 1.326: MPTABLE(11, 2) = 1.157: MPTABLE(11, 3) = 1.064: MPTABLE(11, 4) = 1.029: MPTABLE(11, 5) = 1.02: REM 72.5 DEG
MPTABLE(11, 6) = 1.037: MPTABLE(11, 7) = 1.064: MPTABLE(11, 8) = 1.091: MPTABLE(11, 9) = 1.119: MPTABLE(11, 10) = 1.156: MPTABLE(11, 11) = 1.189: MPTABLE(11, 12) = 1.217
MPTABLE(11, 13) = 1.24: MPTABLE(11, 14) = 1.257: MPTABLE(11, 15) = 1.268: MPTABLE(11, 16) = 1.28: MPTABLE(11, 17) = 1.287: MPTABLE(11, 18) = 1.292
MPTABLE(12, 0) = 1.36: MPTABLE(12, 1) = 1.255: MPTABLE(12, 2) = 1.087: MPTABLE(12, 3) = 1.004: MPTABLE(12, 4) = .968: MPTABLE(12, 5) = .961: REM 75.0 DEG
MPTABLE(12, 6) = .977: MPTABLE(12, 7) = 1!: MPTABLE(12, 8) = 1.026: MPTABLE(12, 9) = 1.055: MPTABLE(12, 10) = 1.087: MPTABLE(12, 11) = 1.112: MPTABLE(12, 12) = 1.149
MPTABLE(12, 13) = 1.17: MPTABLE(12, 14) = 1.19: MPTABLE(12, 15) = 1.202: MPTABLE(12, 16) = 1.212: MPTABLE(12, 17) = 1.218: MPTABLE(12, 18) = 1.221
MPTABLE(13, 0) = 1.26: MPTABLE(13, 1) = 1.167: MPTABLE(13, 2) = 1.013: MPTABLE(13, 3) = .932: MPTABLE(13, 4) = .897: MPTABLE(13, 5) = .891: REM 77.5 DEG
MPTABLE(13, 6) = .906: MPTABLE(13, 7) = .929: MPTABLE(13, 8) = .957: MPTABLE(13, 9) = .98: MPTABLE(13, 10) = 1.012: MPTABLE(13, 11) = 1.04: MPTABLE(13, 12) = 1.066
MPTABLE(13, 13) = 1.088: MPTABLE(13, 14) = 1.109: MPTABLE(13, 15) = 1.121: MPTABLE(13, 16) = 1.132: MPTABLE(13, 17) = 1.14: MPTABLE(13, 18) = 1.145
MPTABLE(14, 0) = 1.153: MPTABLE(14, 1) = 1.071: MPTABLE(14, 2) = .933: MPTABLE(14, 3) = .858: MPTABLE(14, 4) = .826: MPTABLE(14, 5) = .82: REM 80.0 DEG
MPTABLE(14, 6) = .837: MPTABLE(14, 7) = .853: MPTABLE(14, 8) = .881: MPTABLE(14, 9) = .908: MPTABLE(14, 10) = .933: MPTABLE(14, 11) = .961: MPTABLE(14, 12) = .982
MPTABLE(14, 13) = 1.007: MPTABLE(14, 14) = 1.025: MPTABLE(14, 15) = 1.039: MPTABLE(14, 16) = 1.049: MPTABLE(14, 17) = 1.055: MPTABLE(14, 18) = 1.06
REM *****
REM BASE-FIRST PENETRATION COMPUTATION M'(OB) VALUES
MPNF(0) = 1.519: MPNF(1) = 1.414: MPNF(2) = 1.232: MPNF(3) = 1.134: MPNF(4) = 1.099: MPNF(5) = 1.094: REM MPNF(0)-MPNF(2) AT 67.5 DEG; MPNF(3)-MPNF(5) AT 65 DEG
REM *****
RETURN
REM **********
REM USE TABLE'S THICKNESS INCREMENT TO COMPUTE THE EFFECT THAT THICKNESS HAS ON M' USING LINEAR INTERPOLATION
900 : MPTH0 = MPTABLE(C1 + N, T1): MPTH1 = MPTABLE(C1 + N, T1 + 1)
MPVAL = MPTH0 + T2 * (MPTH1 - MPTH0)
RETURN
REM **********
REM COMPUTE NOSE-FIRST PENETRATION NBL USING MPNF(T/D) TABLE (UP TO T/D = 0.25 AND OB FROM 65-67.5 DEG TO 80 DEG)
1000 : IF (TSLASHD > .1) AND (TSLASHD < .25) AND (OB > 65) THEN 1010: REM 65 DEG M' IS MAXIMUM VALUE
IF (TSLASHD <= .1) AND (OB > 67.5) THEN 1010: REM 67.5 DEG M' IS MAXIMUM VALUE (SAME AS 65 DEG VALUE AT T/D = 0.1)
REM ****
NBLNF = NAVYBLM79: NBLNFRNDED = NAVYBLM79RNDED: RETURN: REM NL IS ALWAYS NLNF OUTSIDE DEFINED REGION
REM ****
REM NOSE-FIRST NL (NLNF) AT HIGHER VELOCITY THAN ACTUAL NL, WHICH IS FOR BASE-FIRST PENETRATIONS IN DEFINED REGION
1010 : MPRNF0 = MPNF(T1): MPRNF1 = MPNF(T1 + 1)
MPRIMEMAX = MPRNF0 + T2 * (MPRNF1 - MPRNF0): REM M' FOR 65 (T/D > 0.1) OR 67.5 DEG (T/D = 0-0.1) (MAXIMUM VALUE)
MPRIMENF = MPRIMEMAX - (MPRIMEMAX - MPRIME) * (TSLASHD / .25): REM AT T/D = 0.25 AND UP, ALL NLNF VALUES MERGE WITH ACTUAL NL VALUES
NBLNF = (MPRIMENF / MPRIME) * NAVYBLM79: NBLNFRNDED = INT(NBLNF + .5)
RETURN
REM **********
REM COMPUTE EFFECTIVE V'MIN(OB) FOR OB OVER 45 DEG FOR VR CALCULATION WHEN NOSE-FIRST PENETRATIONS OCCUR
1100 : E1 = 1 + (OB - 45!) / 45!: REM FRACTION OF OB OVER 45 DEG
E2 = 2 * SIN(OBRAD) * CSOB: REM (1/DEFLECTION AT 45 DEG) TIMES (DEFLECTION AT OB WHEN VS IS THE NOSE-FIRST NL)
E3 = E1 / E2: E4 = SQR(2 * E3 - 1) / E3
VMIN = E4 * NAVYBLM79: VMINTMP = VMIN + .5: VMINRNDED = INT(VMINTMP)
RETURN
REM **********
REM COMPUTE EXIT ANGLE EX FROM STRIKING VELOCITY, OBLIQUITY, AND NBL VALUES
1200 : IF (OB > .005) THEN 1210
EX = 0: EXRAD = 0: EXRNDED = 0: DF = OB: DFRAD = OB / 57.29578: RETURN: REM PREVENT DIVIDE-BY-ZERO ERROR
REM ****
1210 : VRAT = VS / VMIN: IF (VRAT < 1) THEN VRAT = 1: REM PREVENT ROUND-OFF ERROR
TMPV = VRAT ^ 2 - 1: TMPVEL = VRAT ^ 2 + VRAT * SQR(TMPV)
SNCSTST = SIN(OBRAD) * CSOB: SNCS = SNCSTST: REM NOSE-FIRST PENETRATION AT ALL OB VALUES
REM ****
REM CHECK FOR AND FLAG BASE-FIRST PENETRATION AT OB > 45, IF IT OCCURS
IF (BFPEN = 1) THEN SNCS = SIN(RAD45) * COS(RAD45)
REM ****
REM CALCULATE DEFLECTION ANGLE DF (SYMMETRICAL ABOUT OB = 45 IF NOSE-FIRST PENETRATION)
TMPDF1 = SNCS / TMPVEL: TMPDF2 = 1 - 4 * TMPDF1 ^ 2
TANDF = (1 - SQR(TMPDF2)) / (2 * TMPDF1): REM TRIG IDENTITY FOR TANGENT OF DF
DF = ATN(TANDF) * 57.29578
REM ****
REM CHECK FOR BASE-FIRST PENETRATION WHEN OB > 45
IF (SNCS <> SNCSTST) THEN OBM45 = (OB - 45!) / 45!: DF = DF * (1 + OBM45): REM EX IS ZERO AT NBL IN THIS CASE
REM ****
DFRAD = DF / 57.29578: DFTMP = 10 * DF + .5: DFRNDED = INT(DFTMP) / 10: REM RADIANS REQUIRED IN ALL BASIC TRIG FUNCTIONS
EX = OB - DF: EXRAD = EX / 57.29578: EXTMP = 10 * EX + .5: EXRNDED = INT(EXTMP) / 10
RETURN
REM **********
REM PRINT RESULTS ON PAPER
REM PRINT HEADER ONLY PAGE
1300 : LPRINT "NAVY BALLISTIC LIMIT, ENERGY, EXIT ANGLE, & REMAINING VELOCITY FOR PROJECTILES"
LPRINT "LIKE WWII U.S. ARMY 3-INCH M79 AP SHOT (TANGENT OGIVE W/1.667-CALIBER RADIUS)"
LPRINT "VS WWII U.S. NAVY CLASS 'B' ARMOR OR S.T.S. OF 115,000 P.S.I. TENSILE STRENGTH "; ""
LPRINT "(THIS ARMOR HAS A PLATE QUALITY FACTOR OF 1.00 & A PERCENT ELONGATION OF 25%)"
REM ****
LPRINT
LPRINT "This program assumes no projectile damage ever occurs.  The projectile has no"
LPRINT "  AP cap, hood, or windscreen, and no explosive filler cavity, only a tracer."
LPRINT "  Its nose shape is in the middle between long-point WWI & blunt WWII designs."
LPRINT "At the Navy Ballistic Limit, the hole in the plate back is always circular if"
LPRINT "  the impact obliquity is up to 45 degrees.  Above 45 degrees the hole becomes"
LPRINT "  more and more elongated along the forward direction in the obliquity plane."
LPRINT "Linear interpolation is used here to be compatible with all other nose shape"
LPRINT "  computation formulae.  Error is negligible."
LPRINT
LPRINT "SHARPLY POINTED PROJECTILES DO NOT PUNCH OUT ARMOR MATERIAL DURING PENETRATION."
LPRINT
LPRINT "BASE-FIRST PENETRATIONS OCCUR AT THE NAVY B.L. IF T/D UNDER 0.25 CALIBER AND"
LPRINT "OB > 67.5 DEG FOR T/D <= 0.1 CALIBER OR OB > 65 DEG FOR T/D < 0.25 CALIBER. "; ""
LPRINT "THIS OCCURS ONLY IF THE STRIKING VELOCITY IS BETWEEN THE TRUE NBL & NBL(N.F.)."
LPRINT CHR$(12): REM OUTPUT PAGE
RETURN
REM **********
REM PRINT RESULTS ON PAPER
1400 : TATMP = 1000 * TA + .5: DTMP = 1000 * D + .5
QATMP = 1000 * QA + .5: WTTMP = 1000 * WT + .5: PETMP = 10 * PE + .5
TARNDED = INT(TATMP) / 1000: DRNDED = INT(DTMP) / 1000
QARNDED = INT(QATMP) / 1000: PERNDED = INT(PETMP) / 10
WTRNDED = INT(WTTMP) / 1000
REM ****
IF (REPEAT = 1) THEN LPRINT "** M79APCLC PROGRAM RESULTS PRINTOUT PAGE **": LPRINT
LPRINT "  **INPUTS:"
LPRINT "PLATE Actual Thickness ="; TARNDED; : IF (TARNDED <= 1!) THEN LPRINT "inch":  ELSE LPRINT "inches"
LPRINT "PLATE Quality Factor   ="; QARNDED; "--- Percent Elongation ="; PERNDED
LPRINT "PROJECTILE Diameter    ="; DRNDED; : IF (DRNDED <= 1!) THEN LPRINT "inch "; :  ELSE LPRINT "inches ";
LPRINT "--- Total Weight ="; WTRNDED; : IF (WTRNDED <= 1!) THEN LPRINT "pound":  ELSE LPRINT "pounds"
LPRINT "Striking Velocity (VS) ="; VSRNDED; : IF (VSRNDED <= 1!) THEN LPRINT "foot/second":  ELSE LPRINT "feet/second"
LPRINT "Obliquity Angle (OB)   ="; OBRNDED; : IF (OBRNDED <= 1!) THEN LPRINT "degree":  ELSE LPRINT "degrees"
REM ****
LPRINT
LPRINT "  **RESULTS:"
LPRINT "Navy Ballistic Limit       ="; NAVYBLM79RNDED; "feet/second"
LPRINT "Energy/Unit Hole Volume    ="; ENERGYRNDED; "ft-lbs/in^3 (Actual Energy Density)"
LPRINT "Energy Density X COS(OB)^2 ="; ECSOBRNDED; "ft-lbs/in^3 (Normal Energy Density)"
LPRINT "Navy B.L. (Nose-First Penetration) =";
IF (BFPEN = 0) OR (BFPEN = -1) THEN LPRINT " NAVY B.L. (Always Nose-First)": GOTO 1410
LPRINT NBLNFRNDED; "feet/second"
1410 : LPRINT "NBL(N.F.)/TRUE NBL RATIO ="; NBLRATIO; "--- VS/TRUE NBL RATIO ="; VSNBLRATIO
REM ****
IF (BFPEN <> 0) THEN 1420
LPRINT "ALL PENETRATIONS NOSE-FIRST AT OB <= 45 SO VR = EX = 0 & ENERGY NBL = TRUE NBL.": GOTO 1430
REM ****
1420 : IF (BFPEN <> 1) THEN 1440
LPRINT "BASE-FIRST PENETRATION AT OB > 45 SO VR = EX = 0 & ENERGY NBL = TRUE NBL."
REM ****
1430 : LPRINT "REMAINING VELOCITY VR = [COS(OB - EX)]SQRT[VS^2 - (TRUE NBL)^2]."
GOTO 1450
REM ****
1440 : LPRINT "NOSE-FIRST PENETRATION AT OB > 45 SO VR > 0 & EX > 0 & ENERGY NBL < TRUE NBL."
LPRINT "REMAINING VELOCITY VR = [COS(OB - EX)]SQRT[VS^2 - (ENERGY NBL)^2]."
LPRINT "ENERGY NBL ="; VMINRNDED; "feet/second -- ENERGY NBL/TRUE NBL RATIO = "; VMINRATRNDED; ""
REM ****
1450 : LPRINT
IF (VSRNDED < NAVYBLM79RNDED) THEN LPRINT "No complete penetration.  EX & VR are UNDEFINED.": GOTO 1470
REM ****
IF (BFPEN <> 1) THEN LPRINT "Nose-First Penetration occurred at given Striking Velocity.": GOTO 1460
LPRINT "Base-First Penetration occurred at given Striking Velocity."
1460 : LPRINT "Exit Angle (EX) (assumed to be in same plane as OB) ="; EXRNDED; : IF (EXRNDED <= 1!) THEN LPRINT "degree":  ELSE LPRINT "degrees"
LPRINT "Deflection Angle (OB - EX) ="; DFRNDED; : IF (DFRNDED <= 1!) THEN LPRINT "degree":  ELSE LPRINT "degrees"
LPRINT "Remaining Velocity (VR) ="; VRRNDED; : IF (VRRNDED <= 1!) THEN LPRINT "foot/second":  ELSE LPRINT "feet/second"
REM ****
REM ONLY 2 RESULTS PRINTOUTS PER PRINTER PAGE
1470 : IF (REPEAT < 0) THEN LPRINT CHR$(12): REPEAT = 1: GOTO 1480: REM FINISH PAGE & RESET TO TOP HALF OF NEXT PAGE
REM PRINT DIVIDER FOR AFTER FIRST RESULTS PRINTOUT ON A PAGE
REPEAT = -1: REM SET UP FOR BOTTOM HALF OF PAGE (SECOND RESULTS PRINTOUT)
LPRINT
LPRINT "** ** ** ** ** ** **"
LPRINT
1480 : RETURN
REM **********
REM YES/NO ANSWER SUBROUTINE ("YESNO = 1" MEANS "YES" ELSE "NO")
1500 : YN$ = INKEY$: IF (YN$ = "") THEN 1500: REM WAIT FOR USER ENTRY
IF (YN$ = "Y") OR (YN$ = "y") THEN PRINT "Yes": YESNO = 1: RETURN
IF (YN$ = "N") OR (YN$ = "n") THEN PRINT "No": YESNO = 0: RETURN
GOTO 1500: REM ALL OTHER INPUTS ARE ILLEGAL (IGNORE)
REM **********
REM *** >>> END OF PROGRAM LISTING <<< ***

