REM **** 1ST UPDATE OF PROGRAM 'HCWCALC' ADD-ON SUBROUTINES, NAME NOW 'HCWCLCR1' OF 11 AUGUST 2012
REM **** CHANGE:  SUBROUTINE 'INTRODOC2' HAS NEW LAST LINE FOR PRINTOUT PAGE.

SUB ALTNBLDOC STATIC

PRINT "*ALL VELOCITY ENTRIES IN WHOLE NUMBERS ONLY TO PREVENT ROUNDING ERRORS*"
PRINT
PRINT "IF M79 NOSE SHAPE NOT CORRECT, INPUT BARE-NOSED NBL FROM ANOTHER SOURCE."
PRINT "INPUT ZERO OR LESS TO USE M79 CALCULATION AS BASE-LINE BARE-NOSED NBL."
PRINT "PROGRAM WILL ADJUST VALUE FOR AP CAP/HOOD/WINDSCREEN AS DESIRED BY USER."
PRINT "USER NBL IS ALWAYS NOSE-FIRST HERE (NO DATA FOR BASE-FIRST ADJUSTMENT)."

REM ** END SUBROUTINE ALTNBLDOC **
END SUB

SUB DECAPDOC STATIC

PRINT "THE PLATE THICKNESS TO DECAP A CAPPED AP/SAP PROJECTILE IN DR. HERSHEY'S REPORTS"
PRINT "SEEMS INDEPENDENT OF IMPACT OBLIQUITY.  FOR MOST CAPS, INCLUDING UNCAPPED SAP"
PRINT "PROJECTILE HOODS, THE THICKNESS SEEMS TO HAVE BEEN 0.0805 CALIBER THICKNESS OF"
PRINT "ANY KIND OF HOMOGENEOUS, DUCTILE IRON OR STEEL MATERIAL.  THIS IS FOR ANY METHOD"
PRINT "OF RETAINING THE AP CAP OR HOOD. THE SOLE EXCEPTION TO THIS IS THE USE OF EXTRA-"
PRINT "HIGH-STRENGTH HIGH-TEMPERATURE (HIGH MELTING POINT) SOLDER.  THIS WAS USED BY"
PRINT "THE GERMAN KRUPP COMPANY IN ALL CAPPED AP & SAP PROJECTILES THAT WERE SOLDERED"
PRINT "ON, TO MY KNOWLEDGE, WITH THE SOLE EXCEPTION OF SOME 16-IN APC MADE FOR COAST-"
PRINT "DEFENSE LATE IN WWII WHICH USED A STRONG RUBBER CEMENT DUE TO METAL SHORTAGES."
PRINT "DURING WWII SEVERAL SMALL STEEL MANUFACTURING COMPANIES GOT CONTRACTS TO MAKE"
PRINT "US ARMY APC PROJECTILES AND SOME OF THEM USED A SIMILAR HIGH-STRENGTH SOLDER IN"
PRINT "THEIR REGULAR PRODUCTS, SO THEY CONTINUED TO USE IT IN THEIR PROJECTILES.  THE"
PRINT "76mm M62 APC (CAP #2 PROJECTILE) AND SEVERAL SIMILAR APC PROJECTILES OF VARIOUS"
PRINT "SIZES THUS ALSO REQUIRED A THICKER PLATE TO DECAP THEM.  THIS SEEMS TO HAVE BEEN"
PRINT "A THICKNESS VALUE ALMOST EXACTLY TWICE THAT OF THE USUAL CAPS -- 0.1605 CALIBER."
PRINT "I CALL THE REGULAR CAPS 'TYPE 1' AND THE EXTRA-STRONG-GRIP CAPS 'TYPE 2', WHICH"
PRINT "HAS NOTHING TO DO WITH THE NUMBERS ASSIGNED TO THE TWO EXAMPLE CAPS USED IN THIS"
PRINT "PROGRAM.  NOTE THAT BRITTLE FACE-HARDENED ARMORS SEEM TO NEED SOMEWHAT THICKER"
PRINT "PLATE TO DECAP AN APC PROJECTILE, WITH REGULAR TYPE 1 CAPS REMAINING INTACT AND"
PRINT "ATTACHED AFTER PUNCHING THROUGH 0.25-CALIBER KC-TYPE ARMOR AT 30 DEGREES IN SOME"
PRINT "TESTS.  I ASSUME THAT THE MINIMUM THICKNESS TO SHATTER THE CAP IS THE NECESSARY"
PRINT "THICKNESS TO DECAP IT TOO AGAINST KC-TYPE ARMOR, BETWEEN 0.25 & 0.33 CALIBER."
PRINT
PRINT "NOTE: **ALWAYS USE ACTUAL IRON OR STEEL PLATE THICKNESS -- NEVER ADJUSTED**"

REM ** END SUBROUTINE DECAPDOC **
END SUB

SUB EDGEDOC STATIC

PRINT "THE CAP EDGE EFFECT IS THE THIRD AP CAP EFFECT THAT CHANGES THE NBL IF IT IS"
PRINT "TRIGGERED.  IT IS UNUSUAL IN THAT IT HAS THE FOLLOWING RULES:"
PRINT "  (1)  ONLY HARD AP CAPS WITH THE CORRECT FACE SHAPE WILL CAUSE IT."
PRINT "  (2)  THE EDGE CORNER OF THE FACE OF THE CAP MUST FORM A SHARP ANGLE -- NOT BE"
PRINT "       ROUNDED AS ARE CONTOURED BRITISH HADFIELD POST-WWI AP CAPS, FOR EXAMPLE."
PRINT "  (3)  NEITHER CAP SHATTER NOR CAP WEIGHT HAVE ANY EFFECT ON THE RESULT."
PRINT "  (4)  FOR THE STANDARD US NAVY WWII AP CAP FACE WITH A 50-DEGREE FACE ANGLE"
PRINT "       (100-DEG CONICAL ARC SYMMETRICAL ABOUT THE CENTERLINE), THE EDGE INNER"
PRINT "       ANGLE IS CIRCA 133-135 DEGREES, INCLUDING THE CURVED/TAPERED CAP SIDE, &"
PRINT "       THIS GIVES A CONSTANT DROP OF 12% TO THE NBL REGARDLESS OF OBLIQUITY IF"
PRINT "       THE EFFECT OCCURS.  OTHER CAPS WITH NEARER-90-DEG ANGLES AT THE EDGES,"
PRINT "       SUCH AS KNOB-&-RING POST-WWI BRITISH FIRTH & GERMAN KRUPP AP CAPS OR THE"
PRINT "       JAPANESE TYPE 88/91/1 AP PROJ WHEN THEIR CAP HEADS ARE LOST AT >45 DEG"
PRINT "       OBLIQUITY MAY GIVE DIFFERENT RESULTS, BUT I HAVE NO DATA NOW.  THE USER"
PRINT "       MAY ENTER A DIFFERENT DROP VALUE OR TURN IT OFF COMPLETELY, AS DESIRED."
PRINT "  (5)  THE EFFECT OCCURS ONLY AT 50 DEG & UP OBLIQUITY (NO EFFECT <50 DEG)."
PRINT "  (6)  THE EFFECT HAS A *MINIMUM* PLATE THICKNESS FOR IT TO OCCUR, VARYING WITH"  
PRINT "       OBLIQUITY.  FOR STANDARD STS ARMOR, THESE ARE IN CALIBERS:"
PRINT "           50 DEG -- 0.5   55 DEG -- 0.35   60 DEG -- 0.25   65 DEG -- 0.185"
PRINT "           70 DEG -- 0.15  75 DEG -- 0.125  80 DEG -- 0.106 (EXTRAPOLATED)"
PRINT "       I USE LINEAR INTERPOLATION BETWEEN THESE TABLED OBLIQUITY VALUES."
PRINT "  (7)  THE MINIMUMS ARE BASED ON THE SPEED OF A TRANSVERSE OUTWARD-MOVING RIPPLE"
PRINT "       ON THE PLATE FACE CAUSED BY THE IMPACT.  THE SHARP CAP FACE EDGE MAKES A"
PRINT "       CURVED SIDEWAYS CREASE IN THE PLATE SURFACE & MUST BE ABLE TO MOVE FASTER"
PRINT "       THAN THE RIPPLE TO DIG THE EDGE IN & PEEL UP THE FACE LIKE A WOOD PLANE."
PRINT "       THE DEEPER IT DIGS IN, THE GREATER THE EFFECT (12% LOSS FOR THE 50-DEG"
PRINT "       US WWII CAP FACE ANGLE).  THE HIGHER THE OBLIQUITY, THE FASTER THE NOSE"
PRINT "       MOVES FORWARD PARALLEL TO THE SURFACE, MAKING IT EASIER TO CATCH UP TO"
PRINT "       THE RIPPLE, SO A MORE FLEXIBLE, THINNER PLATE IS NEEDED TO PREVENT THE"
PRINT "       CAP EDGE FROM CATCHING UP TO THE RIPPLE AND ALLOW THIS CAP EDGE EFFECT."
PRINT "       THIS BEING THE CASE, A LOWER % ELONGATION MAKES THE PLATE MORE RIGID &"
PRINT "       ALLOWS A THINNER PLATE AT EACH ANGLE, SO I ADDED A (% EL/25) MULTIPLIER"
PRINT "       TO THE FORMULA FOR PLATES WITH INFERIOR (<25%) TENSILE TEST RESULTS."

REM ** END SUBROUTINE EDGEDOC **
END SUB

SUB INTACTDOC1 STATIC

PRINT "IF TYPE 1 CAP & PLATE 0.0805 CALIBER OR THICKER OR TYPE 2 CAP & PLATE 0.1605"
PRINT "CALIBER OR THICKER, CAP ATTACHMENT TO NOSE FAILS, AS MENTIONED.  IF CAP DOES"
PRINT "NOT SHATTER & PROJECTILE NOSE IS ROUNDED & VERY BLUNT, THEN AT MEDIUM AND HIGH"
PRINT "OBLIQUITY, FREE CAP MAY SLIDE SIDEWAYS AT SOME TILT ANGLE SO THAT IT ACTS LIKE"
PRINT "AN OFFSET (BENT) NOSE, REDUCING PENETRATION ABILITY.  THE MAXIMUM NOSE HEIGHT"
PRINT "FOR AN OVAL OR VERY BLUNT POINTED NOSE THAT ALLOWS CAP TILT DURING PENETRATION"
PRINT "IS (I ESTIMATE) 0.866 CALIBER (UNDER THE NOSE HEIGHT FOR A 1-CRH TANGENT OGIVE"
PRINT "NOSE).  THE DEFAULT IS *YES* FOR 6-INCH MK 35 MOD 5 AP NOSE (& SIMILAR NOSES)"
PRINT "AND *NO* FOR THE LONGER 76mm M62 APC (& ALL FOREIGN CAPPED SHELLS).  IN THIS"
PRINT "PROGRAM, THE USER CAN ALWAYS SELECT THE INTACT CAP EFFECT BY ANSWERING 'Y'"
PRINT "FOR 'YES'.  'NO' RESETS THE MULTIPLIER TO DEFAULT=1 (USE TABLE VALUES AS-IS)."

REM ** END SUBROUTINE INTACTDOC1 **
END SUB

SUB INTACTDOC2 STATIC

PRINT "THE FOLLOWING IS ONLY USED IF THE INTACT CAP EFFECT (TILTED CAP) IS SELECTED."
PRINT "INTACT CAP EFFECT ONLY OCCURS BETWEEN 40-75 DEGREES OBLIQUITY WHEN SELECTED."
PRINT "THIS EFFECT ONLY OCCURS ABOVE THE CAP'S MINIMUM DECAPPING PLATE THICKNESS."
PRINT "INTACT AP CAP EFFECT GOES UP FROM & THEN DOWN TO ZERO AS OBLIQUITY INCREASES."
PRINT "AP CAP HARDNESS HAS NO MEANING, SINCE THE AP CAP REPLACES PROJECTILE'S INTACT"
PRINT "NOSE; IT IS JUST DISLODGED DUE TO DECAPPING.  CAP WEIGHT CHANGES EFFECT, SINCE"
PRINT "HEAVIER CAPS ARE THICKER AND MAKE A MORE OVAL HOLE WHEN TILTED AT ANY ANGLE."
PRINT "THE INTACT CAP EFFECT HAS 1 ADJUSTMENT TO ALLOW MATCHING TEST RESULTS (DEFAULT"
PRINT "=1=TABLED VALUES). WHEN CAP SHATTER OCCURS, THE EFFECT DISAPPEARS IMMEDIATELY."

REM ** END SUBROUTINE INTACTDOC2 **
END SUB

SUB INTRODOC1 STATIC

PRINT
PRINT "The current program assumes no projectile damage occurs.  The baseline M79 AP"
PRINT "  SHOT has no AP Cap, Hood, or Windscreen, and no explosive filler cavity."
PRINT "  This projectile has a simple, single-circular-arc nose with a blunt point."
PRINT "Pointed projectiles do not punch out much armor from high-quality plate during"
PRINT "  penetration.  Flat-, tapered-flat-, or shallow-dome-nosed projectiles can"
PRINT "  form a solid circular/oval armor plug depending on projectile nose shape."
PRINT "  If the nose is flat, it always punches out a plug of the total nose width"
PRINT "  (no other option is possible).  As the flat or nearly-flat (if dome shaped),"
PRINT "  if any, end of a tapering nose narrows, the plug width (by 'width' I mean"
PRINT "  parallel to the plate face) narrows too.  If flat portion has a sharp edge"
PRINT "  then that becomes the edge of the plug, too.  If not, then the higher the"
PRINT "  striking velocity above the NBL (see below), the wider the plug gets, until"
PRINT "  steepness of the tapered nose edge makes wedging the armor sideways easier"
PRINT "  for all velocities likely to be reached.  The minimum width is roughly where"
PRINT "  the blunt portion edge tilts at 15 degrees from flat."
PRINT "The plug thickness is complex.  For a full flat nose, it is the entire plate"
PRINT "  thickness if nose intact.  A tapered-flat nose with X fraction flat, if 'X'"
PRINT "  is half projectile diameter & up (>=0.5 caliber), plug thickness T(plug) ="
PRINT "  [(1.5*X)-0.5] caliber, dropping twice as fast as the width does.  If X is"
PRINT "  <0.5 caliber, then T(plug) = X/2.  If the total plate thickness is less than"
PRINT "  T(plug), then T(plug) = total plate thickness; the rest of the plate's holed"
PRINT "  armor material is wedged sideways &/or stretched into 'petals' at the back."
PRINT "The (U.S.) Navy Ballistic Limit (NBL) is the minimum striking velocity where a"
PRINT "  projectile tears entirely through an armor plate so its base is on far side"
PRINT "  at all higher striking velocities (projectile damage can change this).  The"
PRINT "  hole is at least projectile-diameter (caliber) in width--'Base Through'. If"
PRINT "  shell breaks up, use 80% of shell body weight (ignore nose coverings)."
PRINT "At the NBL, the hole in the plate back is always circular if the impact angle"
PRINT "  --'Obliquity' where zero is right-angles to plate face--is up to 45 degrees."
PRINT "  Above 45 degrees, the hole becomes more elongated in the forward direction."
PRINT "*For this program, no plugs form, which sometimes makes Exit Velocity wrong.*"

REM ** END SUBROUTINE INTRODOC1 **
END SUB

SUB INTRODOC2 STATIC

CLS
PRINT "**>>AP Cap is a solid steel crash helmet which covers at least the upper part"
PRINT "of the projectile's nose to prevent shock-induced shatter on impact.  It was"
PRINT "originally only soft and deformable, but later caps were found to work better"
PRINT "if hardened (sometimes considerably) to punch a pit in the plate prior to the"
PRINT "projectile nose hitting the plate.  Originally for use against face-hardened"
PRINT "armor, when high-velocity short-range impacts occurred in land battles against"
PRINT "tanks, shatter could occur even against softer homogeneous tank armor.  A cap"
PRINT "in many cases worked here, too.  However, when later tanks began to use sloped"
PRINT "armor to deflect projectiles instead of stopping them, caps became less useful"
PRINT "& even reduced penetration as they soaked up energy as they were destroyed on"
PRINT "impact or, even when intact against thinner plate, their blunt shape was not"
PRINT "optimum to give the minimum velocity to make a hole in the armor.  A tradeoff."
PRINT
PRINT "**>>Windscreen is a thin steel 'dunce cap' on projectile nose to streamline it"
PRINT "& increase range, which is screwed/crimped to the lower nose, Hood, or AP cap."
PRINT "Widely used, especially after WWI.  Several variations, usually for a dye bag."
PRINT
PRINT "**>>Hood is a thin AP-Cap-like mild steel nose covering soldered to the nose"
PRINT "like an AP Cap, but only used to give a thick threaded ring at the lower nose"
PRINT "where the windscreen is screwed on without cutting weakening threads into the"
PRINT "nose of uncapped base-fuzed Common/Semi-Armor-Piercing (thin armor) HE shells."
PRINT
PRINT "Hood & Windscreen logic in this program use the US Navy 6-inch Mark 27 MOD 7"
PRINT "Special Common Projectile (105 lb; 5.2% Hood & 5.1% (very long) Windscreen)."
PRINT
PRINT "***FIRST UPDATE***: If projectile weighs under 1 lb, 5-decimal places allowed."

REM ** END SUBROUTINE INTRODOC2 **
END SUB

SUB INTRODOC3 STATIC

CLS
PRINT "AP Cap portion of program has two selectable caps (different at oblique hits):"
PRINT "    (1) Thick (20% shell wt) hard (515 Brinell) cap of 6-in Mark 35 MOD 5 AP."
PRINT "        One of my 'Type 1' caps knocked off against 0.0805-caliber & up plate."
PRINT "        Projectile 130 lb with blunt oval nose and 2.9% (medium) windscreen."
PRINT "        Shattered Cap Effect@<50 degrees. Intact Cap Effect at 40-75 degrees"
PRINT "        due to dislodged/tilted cap (<=0.866 caliber Nose Height). Both Cap"
PRINT "        Has only a small notch cut into upper edge for windscreen threads."
PRINT "    (2) Average (13.9% shell wt) hard (494 Brinell) cap of Army 76mm M62 APC."
PRINT "        One of my 'Type 2' caps knocked off against 0.1605-caliber & up plate."
PRINT "        Projectile 15.44 lb with blunt point nose and 2.5% (short) windscreen."
PRINT "        Shattered Cap Effect@<65 degrees. No Intact Cap Effect (>0.866 caliber"
PRINT "        Nose Height). Has deep notch cut into cap for windscreen threads."
PRINT
PRINT ">NOTE: NOSE HEIGHT VALUE FOR INTACT CAP EFFECT IGNORED -- USER SELECTS THIS<"
PRINT
PRINT "'Hard' Cap has a Brinell Hardness >350 on face.  Hard Caps break, do not bend."
PRINT
PRINT "'Tough' Cap is up to 350 Brinell, but still acts like a ductile 'Soft' cap in"
PRINT "most ways, though it works out to at least 30 degrees obliquity.  I lump thin-"
PRINT "faced hard caps used by some SAPC, 'Tough' nickel-alloy caps, & Krupp WWI caps"
PRINT "with extra-strong high-temperature solder holding them, under the group Tough."
PRINT "A Soft Cap is of mild steel & a Tough Cap is of up to 25%-nickel alloy steel."
PRINT "Tough caps that I can identify as such were only used on shells introduced by"
PRINT "Russia and Austria-Hungary through the end of WWI (later only if still used by"
PRINT "a given gun).  French SAPC introduced c.1909-1930 SAPC (no APC until WWII) had"
PRINT "a hard cap -- the 1st used to my knowledge -- with only the upper cone-shaped"
PRINT "face portion hardened, giving a thin hard face unlike later hardened caps with"
PRINT "a thick hard layer, sometimes touching or even sourrounding the projectile's"
PRINT "nose.  Some post-WWI Krupp large-caliber SAPC had a thin cap for use against"
PRINT "face-hardened armor on cruisers (6 inches at most), with the cap having a face"
PRINT "with its hard layer propotionately reduced in thickness."
PRINT
PRINT "A 'Soft/Tough' Cap changes the Shattered Cap Effect by 0.5% with 1% change in"
PRINT "% cap weight; a Standard Hard Cap changes 0.6% with 1% cap weight change; & a"
PRINT "Hard Cap which is extra-hard (600 Brinell & up) or with a deeply notched upper"
PRINT "edge for threads for the windscreen changes 0.75% with 1% cap weight change."  

REM ** END SUBROUTINE INTRODOC3 **
END SUB

SUB INTRODOC4 STATIC

CLS
PRINT "The 'True' NBL is the Striking Velocity that barely will allow complete shell"
PRINT "penetration as previously defined, no matter what the shell condition is after"
PRINT "the impact -- it does not care if the projectile can explode properly, either."
PRINT "At under 45 degrees Obliquity (again, where 0 = right angles ('Normal')),"
PRINT "the projectile usually slows to a stop if it barely penetrates, but at higher"
PRINT "Obliquity, it is partially deflected and partially slowed, so it never comes"
PRINT "to a complete stop while still in the plate even at the NBL.  It goes straight"
PRINT "from ricochet to punching through, at some possibly low but non-zero velocity."
PRINT
PRINT "A Base-First penetration is when the projectile goes through the plate sideways"
PRINT "or backwards on a very high velocity impact against thin armor as the nose goes"
PRINT "up as it tries to ricochet, but the base gets caught in the long slot the nose"
PRINT "made in the plate as the base slams down when the nose goes up, causing the"
PRINT "projectile to 'surf' through the armor, rapidly slowing down, until it either"
PRINT "glances off or flips through the long, narrow hole in the armor it just made."
PRINT "Base-First penetrations end when the striking velocity gets high enough so that"
PRINT "the nose can dig in and penetrate at an elevated Nose-First NBL ('NBL(N.F.)')."
PRINT "M79 AP Shot Base-First penetrations occur between the True NBL & NBL(N.F.) if:"
PRINT "  T/D <= 0.25 CALIBER & OB > 65 DEG"
PRINT "  T/D <= 0.1  CALIBER & OB > 67.5 DEG (Nose-First easier, so angle greater)"
PRINT "where 'T' = plate thickness, 'D' = projectile diameter, & 'OB' = Obliquity."
PRINT "Since this is a geometry-related effect, the ACTUAL plate thickness is used,"
PRINT "ignoring any quality factors, here.  No data for most other nose shapes."
PRINT
PRINT "If the impact is at most 45 degrees Obliquity, the projectile moves out the"
PRINT "back at the NBL at an Exit Angle (EX) of roughly right angles to the plate face"
PRINT "and with a near zero Remaining Velocity (VR).  Above 45 degrees Obliquity, VR"
PRINT "is never zero, though perhaps rather low at times, with the higher the OB, the"
PRINT "closer VR gets to VS and the closer EX gets to OB; that is, the deflection of"
PRINT "angle OB - EX decreases with increasing VR at any particular OB.  This does not"
PRINT "matter for a Base-First penetration, since the values of both are random, but"
PRINT "but it does mean with a Nose-First penetration at a high VS, the projectile is"
PRINT "barely 'inconvenienced' by the impact if no major damage occurs.  A deflection"
PRINT "can cause the projectile nose to wobble (yaw/tilt) until it straightens out."
PRINT
PRINT "Linear interpolation is used here to be compatible with all other nose shape"
PRINT "computation formulae.  Error is negligible."

REM ** END SUBROUTINE INTRODOC4 **
END SUB

SUB SHATDOC1 STATIC

PRINT "THE CHANGES IN THE SHATTERED CAP EFFECT WITH CHANGING CAP PERCENTAGE WEIGHT"
PRINT "DIFFER FOR UNNOTCHED HARD CAPS, NOTCHED HARD/HIGH HARDNESS CAPS, & SOFT CAPS:"
PRINT "ALL OF THESE CAPS USE THE SAME BASIC FORMULA FOR THE SHATTERED CAP EFFECT:"
PRINT "        SHATTERED CAP EFFECT = (%CAP/N)*CAPMULT*(CAP # TABLE OB VALUE)"
PRINT "WHERE 'N' IS THE BASELINE PERCENTAGE FOR THE TWO CAP NUMBERS (20 FOR #1, 6-IN"
PRINT "MK 35 MOD 5, AND 13.9 FOR #2, 76mm M62) AND 'CAPMULT' IS THE CHANGE IN EFFECT"
PRINT "AS THE PERCENT WEIGHT CHANGES FROM THE BASELINES, BEING:"
PRINT "    **UNNOTCHED** MODERATE HARDNESS CAPS (MOST HARD CAPS)   -- CAPMULT = 0.6"
PRINT "    **NOTCHED** HARD CAPS & FACE HARDNESS>=600 BRINELL CAPS -- CAPMULT = 0.75"
PRINT "    **SOFT**    CAPS (INCLUDES WWI-ERA 'TOUGH' CAPS)        -- CAPMULT = 0.5"
PRINT "THUS, NOTCHED CAPS & EXTRA-BRITTLE (HIGHER HARDNESS) CAPS CHANGE THE MOST."
PRINT "THE 'CAPMULT' MULTIPLIER IS NOT USED FOR ANY OTHER FUNCTION IN THIS PROGRAM."

REM ** END SUBROUTINE SHATDOC1 **
END SUB

SUB SHATDOC2 STATIC

PRINT "OTHER AP CAP EFFECTS REDUCE PENETRATION ABILITY OF PROJECTILE WHEN THEY OCCUR."
PRINT "INTACT EFFECT CHANGES CAP FACE SHAPE, SINCE IT REPLACES PROJECTILE NOSE SHAPE."
PRINT "CAP FACE IS USUALLY BLUNT & MAY HAVE A SHARP CORNER, IMPROVING OBLIQUE IMPACT."
PRINT "SHATTERED EFFECT CHANGES *ACTUAL* PROJECTILE NOSE, *NOT* CAP WHICH IS CRUSHED."
PRINT
PRINT "FOLLOWING IS ONLY USED IF SHATTERED CAP EFFECT OCCURS (FOR PLATE THICKNESS)."
PRINT "CAP HARDNESS HAS A SIGNIFICANT EFFECT.  SUPER-HARD 6-IN MK 35 MOD 9 & 10 CAPS"
PRINT "DEGRADED PENETRATION BY ABOUT 40% MORE (SHATTERED CAP MULTIPLIER=1.4) DUE TO"
PRINT "FASTER & MORE THOROUGH DESTRUCTION ON IMPACT WITH PLATE FACE (I THINK). THUS,"
PRINT "IMPROVED PERFORMANCE AGAINST KC ARMOR HAD A COST AGAINST HOMOGENEOUS ARMOR."
PRINT "SHATTERED CAP EFFECT OCCURS AT <50 DEG OBLIQUITY FOR 6-IN MK 35 AP & <65 DEG"
PRINT "FOR 76mm MK 62 APC.  IT IS ALMOST CONSTANT UNTIL NEAR MAXIMUM OBLIQUITY."

REM ** END SUBROUTINE SHATDOC2 **
END SUB

SUB SHATDOC3 STATIC

PRINT "DR. HERSHEY USED A FIXED LINEAR DROP IN SHATTER PLATE THICKNESS WITH OBLIQUITY"
PRINT "TO 55 DEG, THEN A SLOWER LINEAR DROP TO 65 DEG, REMAINING CONSTANT AT >65 DEG."
PRINT "FOR THE 6-IN MK 35 MOD 5 PROJECTILE (CAP #1), DEFAULT IMPACT SHATTER THICKNESS"
PRINT "FOR STANDARD STS PLATE WAS 0.66 CALIBER AT NORMAL & 0.44 CALIBER @ 55 DEG, SO:"
PRINT "           TMK35SHAT = 0.66 - (0.18)*(OB/45) CAL"
PRINT "GIVING 0.44 @ 55 DEG, AS REQUIRED, THEN A SLOWER LINEAR DROP TO 0.42 CALIBER"
PRINT "AT 65 DEG & CONSTANT ABOVE THIS ANGLE:"
PRINT "           TMK35SHAT = 0.44 - 0.002*(OB' - 55) CAL  (OB' = 65 MAXIMUM)"
PRINT "FOR THE 76mm M62 (CAP #2), MULTIPLY THESE VALUES BY 0.8 (= 0.528 CAL @ NORMAL)."
PRINT "OTHER U.S. NAVY HARD CAPS VARIED THEIR NORMAL SHATTER THICKNESS FROM THE 0.66"
PRINT "VALUE DOWN TO 0.38 CALIBER, WITH THE FOLLOWING ROUGH RULE:  HARDER CAPS & THOSE"
PRINT "WITH DEEP NOTCHES FOR THE WINDSCREEN THREADS CUT INTO THEIR UPPER EDGES (SOME"
PRINT "90mm OR SMALLER PROJECTILES) HAVE A LOWER SHATTER THICKNESS, BEING EASIER TO"
PRINT "BREAK WHEN SUDDENLY COMPRESSED BY IMPACT.  ALTERNATIVELY, A SOFT CAP VERSUS STS"
PRINT "(CAP OF EQUAL HARDNESS OR LESS) FLATTENS ON THE PLATE FACE (ACTS LIKE SHATTER)"
PRINT "AT AN ESTIMATED THICKNESS OF HALF OF THE 6-IN MK 35 MOD 5 (0.33 CAL @ NORMAL)."
PRINT
PRINT ">>>>NOTE: THE TEST DATA FOR A PROJECTILE THAT I HAVE GIVES SHATTER THICKNESS"
PRINT "VERSUS OBLIQUITY IN CURVE (SHALLOW NEAR NORMAL, STEEP AT HIGH OBLIQUITY), NOT"
PRINT "A STRAIGHT LINE, BUT DR. HERSHEY WAS TRYING TO MATCH THE 'TYPICAL' CAP SHATTER"
PRINT "THICKNESS DROP WITH OBLIQUITY SO HE USED A UNIVERSAL 'BEST FIT' STRAIGHT LINE."

REM ** END SUBROUTINE SHATDOC3 **
END SUB

SUB TITLEDOC STATIC

PRINT " NAVY BALLISTIC LIMIT, ENERGY, EXIT ANGLE, & REMAINING VELOCITY FOR PROJECTILES"
PRINT " SIMILAR TO WWII U.S. ARMY 15-LB 76MM (3-INCH) M79 AP SHOT WITH A TANGENT OGIVE"
PRINT " NOSE WITH 1.667-CALIBER (M79=5 INCH) ARC RADIUS ('CRH')(IN-BETWEEN WWI & WWII)"
PRINT "  WITH THE OPTION OF AN ARMOR-PIERCING CAP OR A HOOD AND/OR A WINDSCREEN ADDED"
PRINT "VS WWII U.S. NAVY CLASS 'B' ARMOR OR S.T.S. OF 115,000 P.S.I. TENSILE STRENGTH."
PRINT " THIS ARMOR IS ABOUT 225 BRINELL (A SOFT FORM OF ROLLED HOMOGENEOUS TANK ARMOR)"
PRINT "AND IT HAS A PLATE QUALITY FACTOR OF 1.00 & A PERCENT ELONGATION OF 25% (BEST)."
PRINT "               BY: NATHAN OKUN (FIRST UPDATE -- 8/11/2012)"

REM ** END SUBROUTINE TITLEDOC **
END SUB

SUB WNDSCRNDOC1 STATIC

PRINT ">>ACTUAL PLATE THICKNESS IN CALIBERS USED FOR NOSE-COVERING CALCULATIONS<<":
PRINT "**ALL PLATE THICKNESSES IN ANY UNITS ROUNDED TO 3 DECIMAL PLACES AFTER ENTRY**"
PRINT
PRINT "SIMPLE UNPIERCED, STEEL, WELL-ANCHORED WINDSCREENS UNDAMAGED AFTER IMPACT ON"
PRINT "  ANY IRON OR STEEL PLATE UNDER 0.03-CALIBER.  IF WINDSCREEN REMAINS INTACT"
PRINT "  THEN NO WINDSCREEN/HOOD/CAP EFFECTS -- JUST A LONG POINTED UNDAMAGED NOSE."
PRINT
PRINT "WINDSCREEN EFFECT IS ONLY PARTIALLY DUE TO ENERGY LOST CRUSHING WINDSCREEN,"
PRINT "  SINCE THIN MILD STEEL IS EASY TO COLLAPSE.  THE WINDSCREEN OR PART OF IT"
PRINT "  IS TRAPPED BETWEEN THE NOSE AND THE PLATE AND IS TWISTED AND TORN AS THE"
PRINT "  PROJECTILE PUSHES THRU THE WINDSCREEN AND PLATE.  ALSO, BY MAKING NOSE SEEM"
PRINT "  TO BE MORE ROUNDED BY BLUNTING EDGES/POINTS & BY FLATTENING OUT TO SLIGHTLY"
PRINT "  WIDEN THE HOLE IN THE PLATE FACE, MORE ENERGY MUST BE USED TO DEFORM PLATE."

REM ** END SUBROUTINE WNDSCRNDOC1 **
END SUB

SUB WNDSCRNDOC2 STATIC

PRINT "THERE ARE SOME VARIATIONS TO SIMPLE WINDSCREEN DESIGN FOR SEVERAL PROJECTILES."
PRINT "THESE CHANGE THE WINDSCREEN EFFECTS TABLE RESULTS FROM ONE-PIECE STEEL DESIGNS:"
PRINT " 1) US POST-WWI AP WITH DYE BAG & MANY PLUGGED HOLES TO LET WATER THRU  (0.5-1)"
PRINT " 2) GERMAN WWII BREAK-AWAY ALUMINUM WINDSCREENS ON 'L/4.4' (LAST) APC    (0.33)"
PRINT " 3) JAP. TYPE 88/91/1 AP WITH WEAK THREADS FOR UNDERWATER HITS   (0.1 if OB>45)"
PRINT " 4) FRENCH WWII LONG BASE-REINFORCED ('K') WITH DYE BAG, HE, & TIP FUZE  (0.33)"
PRINT " 5) BRITISH WWII SLIGHTLY REINFORCED ('K') WITH DYE BAG, HE, & TIP FUZE  (0.05)"
PRINT "***NUMBER IN PARENTHESIS IS THE WINDSCREEN EFFECTS MULTIPLIER (BEST GUESS)***"
PRINT "  ***THIS IS SEPARATE FROM THE WINDSCREEN PERCENTAGE WEIGHT ADJUSTMENT***"
PRINT "NOTE:  PLATES (<0.03 CALIBER + WSMULT>0.75) OR (<0.015 CALIBER + WSMULT>0.4) DO"
PRINT "NOT DAMAGE WINDSCREEN, SO IT MERELY BECOMES NEW NOSE (NO WS/HOOD/CAP EFFECTS)."

REM ** END SUBROUTINE WNDSCRNDOC2 **
END SUB

