REM *** MAIN FILE FOR THE PROGRAM 'HCWCLCR1' (FIRST UPDATE OF 'HCWCALC' OF 8/11/2012)
REM
REM ***SUBROUTINES IN LINKED FILE 'HCWCS1R1.BAS'
DECLARE SUB INTRODOC1 ()
DECLARE SUB INTRODOC2 ()
DECLARE SUB INTRODOC3 ()
DECLARE SUB INTRODOC4 ()
DECLARE SUB SHATDOC1 ()
DECLARE SUB SHATDOC2 ()
DECLARE SUB SHATDOC3 ()
DECLARE SUB INTACTDOC1 ()
DECLARE SUB INTACTDOC2 ()
DECLARE SUB INTACTDOC3 ()
DECLARE SUB EDGEDOC ()
DECLARE SUB ALTNBLDOC ()
DECLARE SUB WNDSCRNDOC1 ()
DECLARE SUB WNDSCRNDOC2 ()
DECLARE SUB TITLEDOC ()
DECLARE SUB DECAPDOC ()
REM ***
DIM MPLTBITE(18), MPTBL(14, 18), TSLASHDMAX(11), NC(11), TCOEF(11), JA(11), JB(11), JC(11), MPNF(5)
DIM HWTBL(16), INTACTCAP1(15), SHATCAP1(16), SHATCAP2(16), HOOD(16, 16), WNDSCRN(16, 16)
REM ****
SCREEN 13
WIDTH 80, 43
CLS
REM ****
'*
CALL TITLEDOC
'*
REM ****
REM INITIALIZE PROGRAM CONSTANTS
QA = 1: PE = 25: VS = 1500: D = 3: TA = 3: WT = 15: OB = 0: RAD45 = .78539816#: REPEAT = 1
CAP1WTPC = 20: CAP2WTPC = 13.9: HDWTPC = 5.2: WSWTPC = 5.1: SCAPMULT = 1: ICAPMULT = 1
SOFTCAP = 0: CAPSHAT = 0: CAPNMBR = 0: CAPSHTHCKUSD = .66: WSMULT = 1: EDGEVAL = -12
EDGEFLAG = 0: EDGEUSED = 0: CAPMULT = .6: DCAPT = .0805: DECAPPED = 0: EDGTHMULT = 1
CAPWTPC = 20: REM CAP #1 DEFAULT
GOSUB 500: GOSUB 800
REM ****
CALL INTRODOC1
REM ****
PRINT
PRINT "CONTINUE INTRODUCTION?  Type 'Y' to continue or 'N' to begin inputs: ";
GOSUB 1500
IF (YESNO = 0) THEN GOTO 9: REM BEGIN INPUTS IMMEDIATELY
REM ****
CALL INTRODOC2
REM ****
PRINT
PRINT "CONTINUE INTRODUCTION?  Type 'Y' to continue or 'N' to begin inputs: ";
GOSUB 1500
IF (YESNO = 0) THEN GOTO 9: REM BEGIN INPUTS IMMEDIATELY
REM ****
CALL INTRODOC3
REM ****
PRINT
PRINT "CONTINUE INTRODUCTION?  Type 'Y' to continue or 'N' to begin inputs: ";
GOSUB 1500
IF (YESNO = 0) THEN GOTO 9: REM BEGIN INPUTS IMMEDIATELY
REM ****
CALL INTRODOC4
REM ****
PRINT
PRINT "==>> TYPE ANY CHARACTER TO BEGIN INPUTS";
GOSUB 1600
REM ****
9 : CLS
PRINT "BEGIN INPUTS:"
PRINT
PRINT " *>SET WINDSCREEN, HOOD, & AP CAP WEIGHTS TO 0 TO GET OLD 'M79APCLC' RESULTS<*"
PRINT
PRINT "EXCEPT AS NOTED BELOW, ALL INPUTS ARE ROUNDED TO NEAREST 3 DECIMAL PLACES."
PRINT "DECAPPING PLATE THICKNESS INPUT CAN BE TO 4 DECIMAL PLACES."
PRINT "VELOCITIES ARE IN WHOLE NUMBERS ONLY (PREVENTS ROUNDING ERROR EFFECTS)."
PRINT
PRINT "Press ENTER with no entry to repeat last legal number (must enter a 'Y or N')."
PRINT
10 : INPUT "Projectile Diameter (Inches): ", D$
IF (D$ = "") THEN
  PRINT "Projectile Diameter Used is"; D;
  IF (D <= 1!) THEN PRINT "inch":  ELSE PRINT "inches"
ELSE
  D = VAL(D$): XXXX = 1000 * (D) + .5: D = INT(XXXX) / 1000
  IF (D <= 0) THEN D = 3: GOTO 10
END IF
REM ****
PRINT
PRINT "WEIGHT CAN BE ENTERED TO 5 DECIMAL PLACES FOR VERY SMALL PROJECTILES."
PRINT "IF PROJECTILE WEIGHS 1 POUND OR MORE, 3-DECIMAL-PLACE RULE APPLIES."
PRINT
20 : INPUT "Projectile Total Weight (Pounds): ", WT$
IF (WT$ = "") THEN
  PRINT "Projectile Weight Used is"; WT;
  IF (WT <= 1!) THEN PRINT "pound":  ELSE PRINT "pounds"
ELSE
  WT = VAL(WT$): IF (WT <= 0) THEN WT = 15: GOTO 20
  IF (WT >= 1) THEN
    XXXX = 1000 * (WT) + .5: WT = INT(XXXX) / 1000
  ELSE
    XXXX = 100000 * (WT) + .5: WT = INT(XXXX) / 100000
  END IF
END IF
REM ****
30 :
REM SET UP PROJECTILE DENSITY & DEFAULT SCALE FACTOR VALUE
PROJDENSITY = WT / D ^ 3
LOGTMP = D / 3!: SCALEFACTOR = (1 - .04 * LOG(LOGTMP)) ^ .5: REM NATURAL LOG (BASE E)
REM ****
PRINT
PRINT "MAXIMUM ALLOWED PLATE THICKNESS IS 6 CALIBERS ="; 6 * D;
IF (D <= 1) THEN PRINT "INCH":  ELSE PRINT "INCHES"
PRINT "MINIMUM ALLOWED PLATE THICKNESS IS .001 CALIBER ="; .001 * D; "INCH"
PRINT
TOVERD = TA / D: YYYY = 1000 * TOVERD + .5: TOVERD = INT(YYYY) / 1000: REM PREVIOUS VALUE
35 : INPUT "Plate Thickness (Inches): ", TA$
IF (TA$ = "") THEN
  PRINT "Plate Thickness Used is"; TA;
  IF (TA <= 1!) THEN PRINT "inch":  ELSE PRINT "inches"
ELSE
  TA = VAL(TA$): XXXX = 1000 * (TA) + .5: TA = INT(XXXX) / 1000
  TOVERD = TA / D: YYYY = 1000 * TOVERD + .5: TOVERD = INT(YYYY) / 1000: REM USED FOR NOSE COVERING CALCS
  IF ((TOVERD < 9.999999999999998D-04) OR (TOVERD > 6.00000001#)) THEN TA = 3: GOTO 35
END IF
IF (TOVERD >= 6!) THEN
  TA = 5.99999# * D: REM MUST KEEP BELOW UPPER EDGE (USED IN TSLASHD VALUE FOR M79 CALCS)
  TOVERD = TA / D: YYYY = 1000 * TOVERD + .5: TOVERD = INT(YYYY) / 1000
END IF
36 : PRINT "PLATE THICKNESS IN CALIBERS ="; TOVERD
REM ****
PRINT
PRINT "PLATE QUALITY FACTOR = MULTIPLIER TO GIVE ACTUAL PLATE THICKNESS WITH SAME NAVY"
PRINT "BALLISTIC LIMIT (MINIMUM STRIKING VELOCITY TO ALLOW PROJECTILE TO GO ENTIRELY"
PRINT "THROUGH PLATE) AS THE STANDARD NAVY STS/CLASS 'B' ARMOR MATERIALS HAVE UNDER"
PRINT "THE GIVEN IMPACT CONDITIONS, ASSUMING NO PROJECTILE DAMAGE (BEST ENEMY SHELL)."
PRINT "= T(STS)/T(PLATE).  STANDARD US NAVY WWII STS/CLASS 'B' ARMOR DEFAULT = 1.00."
PRINT
37 : INPUT "Plate Quality Factor (Dimensionless): ", QA$
IF (QA$ = "") THEN
  PRINT "Plate Quality Factor Used is"; QA
ELSE
  QA = VAL(QA$): IF (QA <= 0) THEN QA = 1: GOTO 37
  XXXX = 1000 * (QA) + .5: QA = INT(XXXX) / 1000
END IF
REM ****
38 : PRINT
PRINT "PERCENT ELONGATION (PE) IS HOW MUCH A SAMPLE STRETCHED BEFORE SNAPPING IN TWO"
PRINT "WHEN IT IS SLOWLY PULLED WITH INCREASING FORCE IN A TENSILE TESTING MACHINE."
PRINT "PE MEASURES RESILIENCE AS A HOLE WIDENS. A LOWER PE INCREASES SCALING EFFECTS."
PRINT "PE DECREASES NBL WITH INCREASING PROJECTILE SIZE ONLY IF PROJECTILE OVER 8 INCH."
PRINT "IF PE IS 25% OR MORE, IT HAS NO EFFECT & ONLY SMALL DEFAULT SCALING USED.  THE"
PRINT "DEFAULT PE IS 25% (US NAVY WWII STS/CLASS 'B' ARMOR), WHICH IS MAXIMUM USED."
PRINT
39 : INPUT "Percent Elongation of Armor Metal Used (Range Allowed 10-25): ", PE$
IF (PE$ = "") THEN
  PRINT "Percent Elongation Used is"; PE; "percent"
ELSE
  PE = VAL(PE$)
  IF (PE < 10) THEN PE = 25: GOTO 39
  XXXX = 1000 * (PE) + .5: PE = INT(XXXX) / 1000
  IF (PE > 25) THEN PE = 25: PRINT "Percent Elongation Used is 25 percent": REM LIMIT VALUE TO BEST
END IF
REM ****
PRINT
40 : INPUT "Obliquity Angle ('OB' = 0 = Right Angles) (Degrees) (80 Deg Maximum): ", OB$
IF (OB$ = "") THEN
  PRINT "Obliquity Angle Used is"; OB;
  IF (OB <= 1!) THEN PRINT "degree":  ELSE PRINT "degrees"
ELSE
  OB = VAL(OB$): IF ((OB < 0) OR (OB > 80!)) THEN OB = 0: GOTO 40
  XXXX = 1000 * (OB) + .5: OB = INT(XXXX) / 1000
END IF
41 : PRINT
IF (OB = 80!) THEN OB = 79.9999#: REM INTERPOLATION FORMULA WILL CRASH AT ITS EXTREME EDGE HERE, SO KEEP MAXIMUM A HAIR BELOW
OBRAD = OB * 3.1415927# / 180!: CSOB = COS(OBRAD): CSOBSQD = CSOB ^ 2: REM BASIC USES RADIANS
REM ****
TSLASHD = TA / D: REM NOTE ACTUAL TA USED FOR NBL CALCS PRIOR TO FINAL ADJUSTMENT, UNMODIFIED
REM PLATE QUALITY FACTOR 'QA' USED FOR FINAL NBL ADJUSTMENT, NOT FOR GEOMETRICAL PLATE THICKNESS AND OBLIQUITY EFFECTS
REM ****
'*
CALL WNDSCRNDOC1
'*
PRINT
42 : INPUT "Percent Windscreen Weight (0-25): ", WSWTPCIN$
IF (WSWTPCIN$ = "") THEN
  IF (WSWTPCIN = 0) THEN
    PRINT "No windscreen.": WSMULT = 1
    GOTO 46
  ELSE
    PRINT "Windscreen Percent Used is"; WSWTPCIN; "percent"
  END IF
ELSE
  WSWTPCIN = VAL(WSWTPCIN$)
  XXXX = 1000 * (WSWTPCIN) + .5: WSWTPCIN = INT(XXXX) / 1000
  IF ((WSWTPCIN < 0) OR (WSWTPCIN > 25!)) THEN WSWTPCIN = 0: GOTO 42
  IF (WSWTPCIN = 0) THEN PRINT "No windscreen.": WSMULT = 1: GOTO 46
END IF
PRINT
'*
CALL WNDSCRNDOC2
'*
PRINT
43 : INPUT "Windscreen Effects Multiplier (to fit tests) (Default=1): ", WSMULT$
IF (WSMULT$ = "") THEN
  PRINT "Windscreen Effects Multiplier Used is"; WSMULT
ELSE
  WSMULT = VAL(WSMULT$): IF (WSMULT <= 0) THEN WSMULT = 1: GOTO 43
  XXXX = 1000 * (WSMULT) + .5: WSMULT = INT(XXXX) / 1000
END IF
REM ****
46 : PRINT
PRINT "HOOD REMAINS UNDAMAGED & PENETRATES ALONG WITH PROJECTILE IF ANY IRON OR STEEL"
PRINT "PLATE IS UNDER 0.1 CALIBER.  ALSO, HOOD REMAINS ATTACHED TO PROJECTILE NOSE IF"
PRINT "PLATE IS UNDER 0.0805 CALIBER, JUST LIKE A TYPE 1 AP CAP.  HOOD EFFECT FOR"
PRINT "THESE PLATES IS THUS CAUSED BY THICK RING AT BASE OF NOSE, NOT BY DAMAGE."
PRINT
47 : INPUT "Percent Hood Weight (0-50): ", HDWTPCIN$
IF (HDWTPCIN$ = "") THEN
  IF (HDWTPCIN > 0) THEN
    CAPWTPCIN = 0: SOFTCAP = 0: CAPNMBR = 0: CAPMULT = .6: ICAPMULT = 1
    EDGEUSED = 0: DECAPPED = 0: EDGTHMULT = 1: SCAPMULT = 1: TSHAT = 0
    CAPSHTHCKUSD = .66: EDGEVAL = -12: EDGEFLAG = 1: DCAPT = .0805
    CAPSHAT = 0: EDGEPRT = 0: CAPWTPC = CAP1WTPC: REM CAP #1 DEFAULT
    PRINT "Hood Percent Used is"; HDWTPCIN; "percent"
    PRINT "Hood replaces AP Cap, so AP Cap Weight zeroed & cap entries set to defaults."
    GOTO 80
  ELSE
    PRINT "No Hood."
    PRINT : GOTO 48
  END IF
ELSE
  HDWTPCIN = VAL(HDWTPCIN$)
  IF ((HDWTPCIN < 0) OR (HDWTPCIN > 50!)) THEN HDWTPCIN = 0: GOTO 47
  XXXX = 1000 * (HDWTPCIN) + .5: HDWTPCIN = INT(XXXX) / 1000
  IF (HDWTPCIN > 0) THEN
    CAPWTPCIN = 0: SOFTCAP = 0: CAPNMBR = 0: CAPMULT = .6: ICAPMULT = 1
    EDGEUSED = 0: DECAPPED = 0: EDGTHMULT = 1: SCAPMULT = 1: TSHAT = 0
    CAPSHTHCKUSD = .66: EDGEVAL = -12: EDGEFLAG = 1: DCAPT = .0805
    CAPSHAT = 0: EDGEPRT = 0: CAPWTPC = CAP1WTPC: REM CAP #1 DEFAULT
    PRINT "Hood replaces AP Cap, so AP Cap Weight zeroed & cap entries set to defaults."
    GOTO 80
  ELSE
    PRINT "No Hood."
  END IF
END IF
REM ****
PRINT
48 : INPUT "Percent AP Cap Weight (0-50): ", CAPWTPCIN$
IF (CAPWTPCIN$ = "") THEN
  IF (CAPWTPCIN = 0) THEN
    CAPWTPCIN = 0: SOFTCAP = 0: CAPNMBR = 0: CAPMULT = .6: ICAPMULT = 1
    EDGEUSED = 0: DECAPPED = 0: EDGTHMULT = 1: SCAPMULT = 1: TSHAT = 0
    CAPSHTHCKUSD = .66: EDGEVAL = -12: EDGEFLAG = 1: DCAPT = .0805
    CAPSHAT = 0: EDGEPRT = 0: CAPWTPC = CAP1WTPC: REM CAP #1 DEFAULT
    PRINT "No AP Cap."
    GOTO 80
  ELSE
    PRINT "AP Cap Percent Used is"; CAPWTPCIN; "percent"
    HDWTPCIN = 0: PRINT "AP Cap replaces Hood, so Hood Weight zeroed."
    PRINT : GOTO 49
  END IF
ELSE
  CAPWTPCIN = VAL(CAPWTPCIN$)
  IF ((CAPWTPCIN < 0) OR (CAPWTPCIN > 50!)) THEN CAPWTPCIN = 0: GOTO 48
  XXXX = 1000 * (CAPWTPCIN) + .5: CAPWTPCIN = INT(XXXX) / 1000
  IF (CAPWTPCIN > 0) THEN
    HDWTPCIN = 0: PRINT "AP Cap replaces any Hood, so Hood Weight zeroed."
  ELSE
    PRINT "No AP Cap."
    CAPWTPCIN = 0: SOFTCAP = 0: CAPNMBR = 0: CAPMULT = .6: ICAPMULT = 1
    EDGEUSED = 0: DECAPPED = 0: EDGTHMULT = 1: SCAPMULT = 1: TSHAT = 0
    CAPSHTHCKUSD = .66: EDGEVAL = -12: EDGEFLAG = 1: DCAPT = .0805
    CAPSHAT = 0: EDGEPRT = 0: CAPWTPC = CAP1WTPC: REM CAP #1 DEFAULT
    GOTO 80
  END IF
END IF
REM ****
PRINT
49 :
INPUT "Select AP Cap # --> 1 (6-in Mk 35-5) or 2 (Army 76mm M62): ", CAPNMBR$
IF (CAPNMBR$ = "") THEN
  IF (CAPNMBR > 0) THEN
    PRINT "AP Cap # Used is"; CAPNMBR
  ELSE
    GOTO 49
  END IF
ELSE
  CAPNMBR = VAL(CAPNMBR$)
  IF (((CAPNMBR < 1!) OR (CAPNMBR > 2!)) OR ((CAPNMBR <> INT(CAPNMBR)))) THEN CAPNMBR = 0: GOTO 49
END IF
REM CAP1WTPC=20: CAP2WTPC=13.9: REM ADJUST THIS WHEN MORE CAPS ADDED
IF (CAPNMBR <> 2) THEN CAPWTPC = CAP1WTPC:  ELSE CAPWTPC = CAP2WTPC: REM CAP #1 IS DEFAULT
REM ****
50 : PRINT
'*
CALL SHATDOC1
'*
SOFTCAP = 0
PRINT
PRINT "Is AP Cap Soft/Tough = Under 350 Brinell Everywhere? (Y or N) ";
GOSUB 1500
IF (YESNO = 1) THEN
  SOFTCAP = 1: CAPMULT = .5: YESNO = 0
  PRINT
  PRINT "SKIPPING AP CAP NOTCH/HARDNESS LOGIC"
  GOTO 53
END IF
51 : PRINT
PRINT "ACTUAL CAP #1 DID NOT HAVE A DEEPLY NOTCHED EDGE, BUT THE MOD 9 & 10 VERSIONS"
PRINT "WERE EXTREMELY HARD (650-680 BRINELL ENTIRELY THROUGH).  ACTUAL CAP #2 HAD A"
PRINT "DEEPLY NOTCHED & THREADED UPPER EDGE, BUT MODERATE HARDNESS.  OTHERS VARIED."
PRINT
PRINT "AP Cap Edge Deeply Notched Or Face Hardness >= 600 Brinell? (Y or N) ";
GOSUB 1500
IF (YESNO = 1) THEN CAPMULT = .75: YESNO = 0:  ELSE CAPMULT = .6
REM ****
53 : PRINT
'*
CALL DECAPDOC
'*
PRINT
PRINT "THIS VALUE CAN BE ACCURATE TO 4 DECIMAL PLACES."
PRINT
55 : INPUT "Decapping Plate Thickness in Calibers (0.0301-0.25; Default=0.0805): ", DCAPT$
IF (DCAPT$ = "") THEN
  PRINT "Decapping Plate Thickness Used is"; DCAPT; "Caliber"
ELSE
  DCAPT = VAL(DCAPT$): IF ((DCAPT < .0301) OR (DCAPT > .25)) THEN DCAPT = .0805: GOTO 55
  XXXX = 10000 * (DCAPT) + .5: DCAPT = INT(XXXX) / 10000
END IF
IF (TOVERD >= DCAPT) THEN DECAPPED = 1:  ELSE DECAPPED = 0
PRINT
'*
CALL SHATDOC2
'*
PRINT
58 : INPUT "Shattered AP Cap Effects Multiplier (to fit tests) (Default=1): ", SCAPMULT$
IF (SCAPMULT$ = "") THEN
  PRINT "Shattered AP Cap Multiplier Used is"; SCAPMULT
ELSE
  SCAPMULT = VAL(SCAPMULT$): IF (SCAPMULT <= 0) THEN SCAPMULT = 1: GOTO 58
  XXXX = 1000 * (SCAPMULT) + .5: SCAPMULT = INT(XXXX) / 1000
END IF
REM ****
REM BEST MATCH TO DR. HERSHEY'S TABLE OF MK 35 MOD 5 2-DECIMAL PLACE SHATTER THICKNESS VALUES
IF (OB > 65) THEN
  TMK35SHAT = .42: REM CONSTANT 0.42 MINIMUM FOR OB=65-80 DEG
ELSE
  IF (OB > 55) THEN
    TMK35SHAT = .44 - .002 * (OB - 55): REM HIGH-ANGLE SHALLOW LINEAR PORTION
  ELSE
    TMK35SHAT = .66 - .18 * (OB / 45): REM LOW-ANGLE STEEP LINEAR PORTION
  END IF
END IF
TMK35TMP = (1000 * TMK35SHAT) + .5: TMK35SHAT = INT(TMK35TMP) / 1000: REM ROUND TO 3 DEC PLACES
REM CHANGE OBLIQUITY VALUE TO USE A PREVIOUSLY MODIFIED CAP NORMAL SHATTERED THICKNESS VALUE
TSHATTMP = (1000 * (CAPSHTHCKUSD / .66) * TMK35SHAT) + .5: TSHAT = INT(TSHATTMP) / 1000
PRINT
'*
CALL SHATDOC3
'*
PRINT
PRINT "SHATTER PLATE THICKNESS DEFAULTS:"
PRINT "  0.66  CALIBER @ NORMAL FOR HARD CAP #1"
PRINT "  0.528 CALIBER @ NORMAL FOR HARD CAP #2"
PRINT "  0.33  CALIBER @ NORMAL FOR ANY SOFT/TOUGH CAP"
PRINT "ENTER ZERO OR NEGATIVE NUMBER TO SET/RESET DEFAULTS."
PRINT
PRINT ">>>OLD CAP SHATTER THICKNESS AT NORMAL (0 DEG) IS"; CAPSHTHCKUSD; "CALIBER"
PRINT ">>>OLD CAP SHATTER THICKNESS AT OB ANGLE       IS"; TSHAT; "CALIBER"
PRINT
60 : INPUT "AP Cap Shatter Plate Thickness in Calibers @ Normal (Maximum=1): ", CAPSHTHCK$
IF (CAPSHTHCK$ = "") THEN
  PRINT : PRINT ">>CAP SHATTER THICKNESS AT NORMAL IN CALIBERS UNCHANGED": GOTO 64
ELSE
  CAPSHTHCKUSD = VAL(CAPSHTHCK$)
  IF (CAPSHTHCKUSD > 1) THEN CAPSHTHCKUSD = .66: GOTO 60
  IF (CAPSHTHCKUSD > 0) THEN
REM USER ENTERED A NEW VALUE FOR NORMAL SHATTER THICKNESS
    XXXX = 1000 * (CAPSHTHCKUSD) + .5
    CAPSHTHCKUSD = INT(XXXX) / 1000
  ELSE
REM USER ENTERED 0 OR NEGATIVE NUMBER, SO USE DEFAULTS
    IF (CAPNBR = 1) THEN
REM 6" MK 35 MOD 5
      IF (SOFTCAP = 1) THEN
        CAPSHTHCKUSD = .33
      ELSE
        CAPSHTHCKUSD = .66
      END IF
    ELSE
REM 76mm M62
      IF (SOFTCAP = 1) THEN
        CAPSHTHCKUSD = .33
      ELSE
        CAPSHTHCKUSD = .528
      END IF
    END IF
  END IF
END IF
PRINT
PRINT ">>>NEW CAP SHATTER THICKNESS @ NORMAL        IS"; CAPSHTHCKUSD; "CALIBER"
64 : TSHATTMP = (1000 * (CAPSHTHCKUSD / .66) * TMK35SHAT) + .5
TSHAT = INT(TSHATTMP) / 1000
PRINT ">>>NEW CAP SHATTER THICKNESS AT NEW OB ANGLE IS"; TSHAT; "CALIBER"
IF (TOVERD >= TSHAT) THEN DECAPPED = 1: REM POSSIBLE PROBLEM IF VALUES MANUALLY ADJUSTED
REM ****
PRINT
'*
CALL INTACTDOC1
'*
PRINT
INTCAPEFF = 0: PRINT "Allow Intact Cap Effect (Y or N)? ";
GOSUB 1500: REM ANSWER QUESTION
IF (YESNO = 1) THEN INTCAPEFF = 1: YESNO = 0:  ELSE ICAPMULT = 1: GOTO 72
PRINT
'*
CALL INTACTDOC2
'*
PRINT
70 : INPUT "Intact AP Cap Effects Multiplier (to fit tests) (Default=1): ", ICAPMULT$
IF (ICAPMULT$ = "") THEN
  PRINT "Intact AP Cap Multiplier Used is"; ICAPMULT
ELSE
  ICAPMULT = VAL(ICAPMULT$): IF (ICAPMULT <= 0) THEN ICAPMULT = 1: GOTO 70
  XXXX = 1000 * (ICAPMULT) + .5: ICAPMULT = INT(XXXX) / 1000
END IF
REM ****
72 : PRINT
IF (SOFTCAP = 1) THEN
  PRINT "SOFT/TOUGH CAP HAS NO CAP EDGE EFFECT."
  PRINT "RESTORING DEFAULT DROP = -12% & THICKNESS MULTIPLIER = 1.00 FOR FUTURE RUN."
  EDGEFLAG = 0: EDGTHMULT = 1: EDGEUSED = 0: EDGEVAL = -12: EDGEPRT = 0: GOTO 80: REM NO EDGE EFFECT
END IF
'*
CALL EDGEDOC
'*
PRINT
74 : PRINT "Allow Cap Edge Effect? ('Y' or 'N'): ";
GOSUB 1500: REM ANSWER QUESTION
IF (YESNO = 1) THEN
REM DO NOT CHANGE PREVIOUS EDGEVAL
  EDGEFLAG = 1: YESNO = 0
ELSE
  EDGEFLAG = 0: EDGEUSED = 0: EDGEVAL = -12: EDGEPRT = 0
  PRINT "RESTORING DEFAULT DROP = -12% & THICKNESS MULTIPLIER = 1.00 FOR FUTURE RUN.": GOTO 80
END IF
PRINT
PRINT "ENTER NEGATIVE VALUE -- EFFECT CANNOT MAKE PENETRATION MORE DIFFICULT."
PRINT
76 : INPUT "% NBL Decrease for Cap Edge Effect (to fit tests) (Default=-12): ", EDGEVAL$
IF (EDGEVAL$ = "") THEN
  PRINT "Cap Edge Effect % NBL Decrease Used is "; EDGEVAL
ELSE
  EDGEVAL = VAL(EDGEVAL$): IF (EDGEVAL >= 0) THEN EDGEVAL = -12: GOTO 76
  XXXX = 1000 * (EDGEVAL) + .5: EDGEVAL = INT(XXXX) / 1000
END IF
PRINT
PRINT "ENTER MULTIPLIER TO DEFAULT MINIMUM PLATE THICKNESS TO CAUSE EDGE EFFECT.  IT"
PRINT "CHANGES ALL VALUES BY THE SAME FRACTION, WHICH MAY NOT BE CORRECT FOR ALL OB."
PRINT "NEEDED IF CAP EDGE SHARPER THAN ~133-135 DEG INNER ANGLE USED BY US WWII CAPS."
PRINT
77 : INPUT "Cap Edge Effect Minimum Thickness Multiplier (0.1-2.0) (Default=1): ", EDGTHMULT$
IF (EDGTHMULT$ = "") THEN
  PRINT "Cap Edge Effect Plate Thickness Multiplier Used is "; EDGTHMULT
ELSE
  EDGTHMULT = VAL(EDGTHMULT$)
  IF ((EDGTHMULT <= .1) OR (EDGTHMULT > 2)) THEN EDGTHMULT = 1: GOTO 77
  XXXX = 1000 * (EDGTHMULT) + .5: EDGTHMULT = INT(XXXX) / 1000
END IF
78 : REM DEFAULT VALUES FOR US AP CAPS WITH 50-DEG FACE SLOPE (FLAT FACE = 0 DEG)
IF (OB > 75) THEN OBMAX = 80: EDGA = .125: EDGB = .106: GOTO 79: REM 0.106 IS EXTRAPOLATION TO 80 DEG
IF (OB > 70) THEN OBMAX = 75: EDGA = .15: EDGB = .125: GOTO 79
IF (OB > 65) THEN OBMAX = 70: EDGA = .185: EDGB = .15: GOTO 79
IF (OB > 60) THEN OBMAX = 65: EDGA = .25: EDGB = .185: GOTO 79
IF (OB > 55) THEN OBMAX = 60: EDGA = .35: EDGB = .25: GOTO 79
IF (OB >= 50) THEN OBMAX = 55: EDGA = .5: EDGB = .35: GOTO 79
EDGEUSED = 0: GOTO 80: REM NO-OP BELOW 50 DEG OBLIQUITY
79 :
EDGECHK = (EDGTHMULT) * (PE / 25) * (EDGB + (EDGA - EDGB) * ((OBMAX - OB) / 5))
IF (TOVERD >= EDGECHK) THEN EDGEUSED = 1:  ELSE EDGEUSED = 0: REM THICKER PLATE HAS EDGE EFFECT
REM ****
80 : PRINT : REM COMMON END OF ALL NOSE COVERING INPUTS
'*
CALL ALTNBLDOC
'*
PRINT
81 : INPUT "Non-M79 Bare-Nosed NBL (Ft/Sec; 3500 Maximum): ", NBLNOT$
PRINT
IF (NBLNOT$ = "") THEN
  IF (NBLNOT = 0) THEN
    PRINT "ZERO: NBL = M79 CALCULATIONS + CAP/HOOD/WINDSCREEN.": REM USE M79 CALCULATION
  ELSE
    PRINT "USING NON-M79 NBL ="; NBLNOT; "FT/SEC + CAP/HOOD/WINDSCREEN.": REM USE NBLNOT
  END IF
ELSE
  NBLNOT = VAL(NBLNOT$): IF (NBLNOT <> INT(NBLNOT)) THEN NBLNOT = 0: GOTO 81
  IF ((NBLNOT > 0) AND (NBLNOT <= 3500!)) THEN
    PRINT "USING NON-M79 NBL ="; NBLNOT; "FT/SEC + CAP/HOOD/WINDSCREEN.": REM USE NBLNOT
  ELSE
    IF (NBLNOT > 3500!) THEN NBLNOT = 0: GOTO 81
    NBLNOT = 0: PRINT "ZERO: NBL = M79 CALCULATIONS + CAP/HOOD/WINDSCREEN.": REM USE M79 CALCULATION
  END IF
END IF
99 : PRINT
100 : INPUT "Striking Velocity (Ft/Sec) (3500 Maximum): ", VS$
IF (VS$ = "") THEN
  PRINT "Striking Velocity Used is"; VS; "ft/sec"
ELSE
  VS = VAL(VS$)
  IF ((VS <= 0) OR (VS > 3500!) OR (VS <> INT(VS))) THEN VS = 1500: GOTO 100
END IF
105 : PENWT = WT: CPLOS = 0: HDLOS = 0: WSLOS = 0: REM TOTAL PROJ WT PENETRATES UNLESS ONE OF THE FOLLOWING CHANGES IT
IF ((CAPSHAT = 1) AND (CAPWTPCIN > 0)) THEN
  PENWTTEMP = 1000 * WT * (1 - ((CAPWTPCIN + WSWTPCIN) / 100)) + .5
  PENWT = INT(PENWTTEMP) / 1000: CPLOS = 1: WSLOS = 1
  GOTO 110: REM SHATTERED CAP REMOVES CAP & WINDSCREEN FROM PROJ ON PLATE FACE
END IF
IF ((TOVERD >= .1) AND (HDWTPCIN > 0)) THEN
  PENWTTEMP = 1000 * WT * (1 - ((HDWTPCIN + WSWTPCIN) / 100)) + .5
  PENWT = INT(PENWTTEMP) / 1000: HDLOS = 1: WSLOS = 1
  GOTO 110: REM ANY IRON OR STEEL PLATE >0.1 CALIBER REMOVES HOOD & WINDSCREEN FROM PROJ ON PLATE FACE
END IF
IF ((TOVERD >= .03) AND (WSWTPCIN > 0)) THEN
  PENWTTEMP = 1000 * WT * (1 - (WSWTPCIN / 100)) + .5
  PENWT = INT(PENWTTEMP) / 1000: WSLOS = 1
REM ANY IRON OR STEEL PLATE >=0.03 CALIBER REMOVES WINDSCREEN FROM PROJ ON PLATE FACE (MODIFED WINDSCREENS USE OTHER LOGIC)
END IF
110 : PRINT
PRINT "==>> TYPE ANY CHARACTER TO PRINT OUTPUTS";
GOSUB 1600
REM ****** END INPUTS ******
120 : GOSUB 700: REM COMPUTE VELOCITY OBLIQUITY MULTIPLIER M
GOSUB 600: REM SELECT COEFFICIENTS FOR PLATE THICKNESS RANGE & COMPUTE GREEN'S FUNCTION, IF USED
REM CALCULATE REGULAR NBL
NAVYBLM79 = NUM * J * MOBLIQUITY * SCALEFACTOR * (QA * TSLASHD) ^ TEXP / PROJDENSITY ^ .5
REM ****
REM ADD IN EXTRA PERCENT ELONGATION SCALING EFFECTS, IF ANY
IF ((PE < 25) AND (D > 8)) THEN NAVYBLM79 = NAVYBLM79 * (1 - (1 - SQR(PE / 25)) * (D - 8) / 8)
REM ****
REM COMPUTE EFFECTS OF AP CAP, HOOD, AND WINDSCREEN
HDCHG = 0: CAPCHG = 0: WSCHG = 0: CAPSHAT = 0: INTTBLDIF = 0: SHATTBLDIF = 0: REM FIRST INITIALIZE CALC VALUES TO NOT USED
OB5 = INT(OB / 5): OBDIF = (OB - INT(OB)) / 5
IF ((HDWTPCIN = 0) AND (WSWTPCIN = 0)) THEN GOTO 124: REM CHECK FOR AP CAP
REM ***
REM HOOD AND WINDSCREEN CALCULATION
TDVAL = 0: IF (TOVERD >= 2.5) THEN TDVAL = 16!: GOTO 122: REM MAXIMUM=2.5 CAL
121 :
REM FIND THICKNESS INTERVAL FOR HOOD(X,Y) &/OR WNDSCRN(X,Y) TABLES
REM TOVERD IS BETWEEN HWTBL(TDVAL-1) (UNDER) & HWTBL(TDVAL) (OVER OR EQUAL)
IF (TOVERD > HWTBL(TDVAL)) THEN TDVAL = TDVAL + 1!: GOTO 121
REM FOUND TABLE TD INTERVAL
122 :
IF (TDVAL = 16!) THEN
  TDDIF = 0: REM TD AXIS AT UPPER LIMIT
ELSE
  TDDIF = (TOVERD - HWTBL(TDVAL - 1)) / (HWTBL(TDVAL) - HWTBL(TDVAL - 1)): REM COMPUTE INCREMENT BETWEEN TABLE VALUES
END IF
REM >*<
IF (HDWTPCIN > 0) THEN
  IF (TDVAL <> 16!) THEN
    DELTAHD1 = HOOD(TDVAL - 1, OB5 + 1) - HOOD(TDVAL - 1, OB5)
    XHD1 = OBDIF * DELTAHD1 + HOOD(TDVAL - 1, OB5): REM LOWER ITEM OB AXIS INCRMENTAL VALUE
    DELTAHD2 = HOOD(TDVAL, OB5 + 1) - HOOD(TDVAL, OB5)
    XHD2 = OBDIF * DELTAHD2 + HOOD(TDVAL, OB5): REM UPPER ITEM OB AXIS INCREMENTAL VALUE
    XHD = TDDIF * (XHD2 - XHD1) + XHD1: REM INCREMENTAL VALUE FOUND IN BOTH AXES
  ELSE
    XHD = OBDIF * (HOOD(16, OB5 + 1) - HOOD(16, OB5)) + HOOD(16, OB5): REM INCREMENTAL IN OB AXIS, MAX IN TD AXIS
  END IF
  HDCHG = (HDWTPCIN / HDWTPC) * XHD: REM HOOD EFFECT VARIES DIRECTLY WITH HOOD WEIGHT PERCENTAGE (IF WINDSCREEN IS NOT INTACT)
ELSE
  HDCHG = 0
END IF
REM >*<
IF (WSWTPCIN > 0) THEN
  IF (TOVERD >= .03) THEN
    IF (TDVAL <> 16!) THEN
      DELTAWS1 = WNDSCRN(TDVAL - 1, OB5 + 1) - WNDSCRN(TDVAL - 1, OB5)
      XWS1 = OBDIF * DELTAWS1 + WNDSCRN(TDVAL - 1, OB5): REM LOWER ITEM OB AXIS INCREMENTAL VALUE
      DELTAWS2 = WNDSCRN(TDVAL, OB5 + 1) - WNDSCRN(TDVAL, OB5)
      XWS2 = OBDIF * DELTAWS2 + WNDSCRN(TDVAL, OB5): REM UPPER ITEM OB AXIS INCREMENTAL VALUE
      XWS = TDDIF * (XWS2 - XWS1) + XWS1: REM INCREMENTAL VALUE FOUND IN BOTH AXES
    ELSE
      XWS = OBDIF * (WNDSCRN(16, OB5 + 1) - WNDSCRN(16, OB5)) + WNDSCRN(16, OB5): REM INCREMENTAL IN OB AXIS, MAX IN TD AXIS
    END IF
REM WINDSCREEN EFFECT VARIES DIRECTLY WITH WINDSCREEN WEIGHT PERCENTAGE & EFFECTS MULTIPLIER
    WSCHG = WSMULT * (WSWTPCIN / WSWTPC) * XWS
  ELSE
REM PLATES < 0.03 CALIBER (TDVAL = 0)
    IF ((WSMULT >= .75) OR ((WSMULT >= .4) AND (TOVERD < .015))) THEN
REM NO EFFECT ON INTACT, STEEL, WELL-ANCHORED WINDSCREENS, JAPANESE TYPE 88/91/1 AP W/CAP HEADS & WEAKENED ANCHOR THREADS @ OB<=45DEG,
REM   OR FOR VERY THIN PLATE WITH US WWII APC WINDSCREENS WITH HOLES IN THEM
REM   (SIMPLY USE WINDSCREEN'S OVAL OR POINTED NOSE SHAPE AS NEW NOSE SHAPE)
      PENWT = WT: WSLOS = 0: HDLOS = 0: CAPLOS = 0: WSCHG = 0: HDCHG = 0:
      CAPCHG = 0: EDGEUSED = 0: DECAPPED = 0: CAPSHAT = 0: EDGEPRT = 0
      GOTO 129
REM IF WINDSCREEN IS INTACT, HOOD & AP CAP IS HIDDEN UNDER IT AND HAS NO EFFECT
    ELSE
REM FOR JAPANESE TYPE 88/91/1 APC WINDSCREENS @ OB>45DEG, GERMAN WWII APC WITH BRITTLE ALUMINUM WINDSCREENS, &
REM   BRITISH/FRENCH 'K' APC W/NOSE FUZE & EXPLOSIVE FOR DYE COLORATION OF OCEAN-IMPACT SPLASH & DIRECT HIT IMPACT SMOKE,
REM   RETAIN ADJUSTED WINDSCREEN EFFECTS AGAINST ANY STEEL PLATE & DO NOT HIDE HOOD OR AP CAP.  EVEN SHEET STEEL PLATE IS THICK ENOUGH.
      XWS = OBDIF * (WNDSCRN(1, OB5 + 1) - WNDSCRN(1, OB5)) + WNDSCRN(1, OB5): REM INCREMENTAL IN OB AXIS, TDVAL=1 (MIN) IN TD AXIS
      WSCHG = WSMULT * (WSWTPCIN / WSWTPC) * XWS: WSLOS = 1
    END IF
  END IF
ELSE
  WSCHG = 0: WSLOS = 0
END IF
REM END HOOD AND WINDSCREEN CALCS
REM **
124 :
IF (CAPWTPCIN = 0) THEN
REM NO CAP
  CAPWTPCIN = 0: SOFTCAP = 0: CAPNMBR = 0: CAPMULT = .6: ICAPMULT = 1
  EDGEUSED = 0: DECAPPED = 0: EDGTHMULT = 1: SCAPMULT = 1: TSHAT = 0
  CAPSHTHCKUSD = .66: EDGEVAL = -12: EDGEFLAG = 1: DCAPT = .0805
  CAPSHAT = 0: EDGEPRT = 0: CAPWTPC = CAP1WTPC: REM CAP #1 DEFAULT
  GOTO 129
END IF
REM **
REM START AP CAP CALCS
REM AP CAP SHATTERED & INTACT CAP EFFECTS CALCULATION (IF WINDSCREEN IS NOT INTACT)
REM 6-INCH MK 35 MOD 5 AP CAP (CAPNMBR=1)
CAPRATIO = CAPWTPCIN / CAPWTPC: SHATMULTVAL = CAPRATIO - 1: REM CAPMULT ONLY MODIFIES DIFFERENCE BETWEEN DEFAULT & REAL CAP WEIGHTS
IF (CAPNMBR = 1) THEN
  IF (TOVERD < TSHAT) THEN
REM INTACT OR BROKEN CAP (MOST OR ALL PIECES PENETRATE PLATE WITH PROJ)
    CAPSHAT = 0: REM CAP NOT SHATTERED
    IF ((INTCAPEFF = 0) OR ((OB <= 40!) OR (OB >= 75!)) OR (DECAPPED = 0)) THEN
      CAPCHG = 0: REM NO CAP EFFECT
    ELSE
      OBINTACT = INT((OB - 40!) / 2.5): OBINTDIF = ((OB - 40!) - (OBINTACT * 2.5)) / 2.5: REM 2.5-DEG STEPS HERE
      INTTBLDIF = INTACTCAP1(OBINTACT + 1) - INTACTCAP1(OBINTACT)
      CAPCHG = ICAPMULT * (CAPWTPCIN / CAPWTPC) * ((OBINTDIF * INTTBLDIF) + INTACTCAP1(OBINTACT)): REM INTACT CAP EFFECT
    END IF
  ELSE
REM SHATTERED CAP
    CAPSHAT = 1
    IF (OB >= 50!) THEN
      CAPCHG = 0: REM NO CAP EFFECT
    ELSE
      SHATTBLDIF = (SHATCAP1(OB5 + 1) - SHATCAP1(OB5))
      CAPCHG = SCAPMULT * (1 + (CAPMULT * SHATMULTVAL)) * ((OBDIF * SHATTBLDIF) + SHATCAP1(OB5)): REM SHATTERED CAP EFFECT
REM 'CAPMULT' ADJUSTMENT IS FOR SHATTERED CAPS ONLY
    END IF
  END IF
ELSE
REM 76mm (3-INCH) M62 APC CAP (CAPNMBR=2)
  IF (TOVERD < TSHAT) THEN
REM INTACT OR BROKEN CAP (MOST OR ALL CAP PIECES PENETRATE PLATE WITH PROJ)
    CAPSHAT = 0: REM CAP NOT SHATTERED
    IF ((INTCAPEFF = 0) OR ((OB <= 40!) OR (OB >= 75!)) OR (DECAPPED = 0)) THEN
      CAPCHG = 0: REM NO CAP EFFECT
    ELSE
REM USING 6-INCH MK 35 MOD 5 VALUES AS MODIFIED BY USER
      OBINTACT = INT((OB - 40!) / 2.5): OBINTDIF = ((OB - 40!) - (OBINTACT * 2.5)) / 2.5: REM 2.5-DEG STEPS HERE
      INTTBLDIF = INTACTCAP1(OBINTACT + 1) - INTACTCAP1(OBINTACT)
      CAPCHG = ICAPMULT * (CAPWTPCIN / CAPWTPC) * ((OBINTDIF * INTTBLDIF) + INTACTCAP1(OBINTACT)): REM INTACT CAP EFFECT
    END IF
  ELSE
REM SHATTERED CAP
    CAPSHAT = 1
    IF (OB >= 65!) THEN
      CAPCHG = 0: REM NO CAP EFFECT
    ELSE
      SHATTBLDIF = (SHATCAP2(OB5 + 1) - SHATCAP2(OB5))
      CAPCHG = SCAPMULT * (1 + (CAPMULT * SHATMULTVAL)) * ((OBDIF * SHATTBLDIF) + SHATCAP2(OB5)): REM SHATTERED CAP EFFECT
REM 'CAPMULT' ADJUSTMENT IS FOR SHATTERED CAPS ONLY
    END IF
  END IF
END IF
REM END AP CAP CALCS
REM ****
REM ADD IN FRACTIONAL INCREASES & LOSSES DUE TO AP CAP, HOOD, & WINDSCREEN
129 : REM IF USING MANUAL NBL INPUT, USE NBLNOT TO COMPUTE 'NBLALL' (WITH ALL EFFECTS ADDED)
IF (NBLNOT > 0) THEN
  NBLALL = NBLNOT * (1 + CAPCHG + HDCHG + WSCHG + (EDGEUSED * (EDGEVAL / 100)))
ELSE
  NBLALL = NAVYBLM79 * (1 + CAPCHG + HDCHG + WSCHG + (EDGEUSED * (EDGEVAL / 100)))
END IF
REM ****
REM FINAL NBL (TO NEAREST WHOLE NUMBER)
NAVYBLTMP = NAVYBLM79 + .5: NAVYBLM79RNDED = INT(NAVYBLTMP)
NAVYBLTMP = NBLALL + .5: NBLALLRNDED = INT(NAVYBLTMP)
REM ****
VSTMP = VS + .5: VSRNDED = INT(VSTMP): REM USE ROUNDED VALUES FOR COMPARISONS
IF (NBLNOT <= 0) THEN GOSUB 1000: REM CALCULATE VMIN = NOSE-FIRST NBL WHEN OB>45 AND WHEN USING M79 CALC
REM ****
REM SET BASE-FIRST PENETRATION FLAG 'BFPEN' TO VARIOUS VALUES
IF ((OB <= 45!) OR (NBLNOT > 0)) THEN BFPEN = 0: GOTO 130: REM NOSE-FIRST ALWAYS BECAUSE OB TOO SMALL OR NOT USING M79 CALC
REM OB>45 DEG FOLLOWS:
REM IF NBLNF=NBLALL, THEN NO BASE-FIRST PENETRATION POSSIBLE AT THIS OB AGAINST THIS PLATE THICKNESS
IF (NBLNFRNDED = NBLALLRNDED) THEN BFPEN = -1: GOTO 130: REM NOSE-FIRST ONLY
REM NBLNF>NBLALL, SO BASE-FIRST PENETRATIONS POSSIBLE HERE AGAINST THIS PLATE @ THIS OB
IF (VSRNDED >= NBLNFRNDED) THEN BFPEN = -2: GOTO 130
REM A NOSE-FIRST PENETRATION HAS OCCURRED AT THIS VS
BFPEN = 1
REM A BASE-FIRST PENETRATION HAS OCCURRED AT THIS VS
REM ****
REM HOW MUCH ENERGY PER VOLUME OF ARMOR MATERIAL REMOVED WAS NEEDED TO OPEN UP A CALIBER-DIAMETER HOLE IN THAT PLATE
130 : ENERGYDENSITY = .5 * (WT / 32.186) * NBLALL ^ 2 / (3.1415927# * TA * (D / 2) ^ 2)
ENERGYTMP = ENERGYDENSITY + .5: ENERGYRNDED = INT(ENERGYTMP)
REM ENERGY PER VOLUME USING ONLY COMPONENT OF NBL NORMAL TO PLATE FACE AT IMPACT POINT (=NBL*COS(OB))
ENERGYCOSSQD = ENERGYDENSITY * CSOBSQD: ECTMP = ENERGYCOSSQD + .5: ECSOBRNDED = INT(ECTMP)
REM **********
CLS
PRINT "BEGIN OUTPUTS:"
TATMP = 1000 * TA + .5: TAPRNT = INT(TATMP) / 1000: DTMP = 1000 * D + .5: DPRNT = INT(DTMP) / 1000
TACLBR = TA / D: TACLBRTMP = 1000 * TACLBR + .5: TACALPRNT = INT(TACLBRTMP) / 1000
PETMP = 1000 * PE + .5: PEPRNT = INT(PETMP) / 1000: QATMP = 1000 * QA + .5: QAPRNT = INT(QATMP) / 1000
WTTMP = 100000 * WT + .5: WTPRNT = INT(WTTMP) / 100000
PRINT "Actual Plate Thickness ="; TAPRNT; : IF (TAPRNT <= 1!) THEN PRINT "inch"; :  ELSE PRINT "inches";
PRINT " ---"; TACALPRNT; : IF (TACALPRNT <= 1!) THEN PRINT "caliber":  ELSE PRINT "calibers"
PRINT "% Elongation ="; PEPRNT; "-- Plate Quality (T(STS)/T(Plate w/Same NBL))="; QAPRNT
PRINT "Projectile Diameter ="; DPRNT; : IF (DPRNT <= 1!) THEN PRINT "inch":  ELSE PRINT "inches"
IF ((WTPRNT) <> (PENWT)) THEN
  PRINT "A HOOD/CAP/WINDSCREEN SEPARATED OR DECAPPED PENETRATES WITH SHELL UP TO 45 DEG"
  PRINT "OBLIQUITY. >45 DEG THEY RICOCHET OFF. THEY USUALLY BREAK APART DURING IMPACTS."
END IF
PRINT "Projectile Full Weight ="; WTPRNT; "lb -- Penetrator Weight > NBL ="; PENWT; "lb"
IF ((HDWTPCIN > 0) OR (CAPWTPCIN > 0)) THEN
  DCPTTMP = 10000 * (D * DCAPT) + .5: DCAPTPRT = INT(DCPTTMP) / 10000 
  PRINT "Decapping Plate Thickness ="; DCAPTPRT;
  IF (DCAPTPRT <= 1!) THEN PRINT "inch"; :  ELSE PRINT "inches"; 
  PRINT " ---"; DCAPT; "caliber"
ELSE
  PRINT 
END IF
PRINT "****>>>> ";
IF (WSWTPCIN = 0) THEN
  IF ((HDWTPCIN = 0) AND (CAPWTPCIN = 0)) THEN
    PRINT "No AP Cap, Hood, or Windscreen"
  ELSE
    IF (HDWTPCIN > 0) THEN
      PRINT "No AP Cap or Windscreen"
    ELSE
      PRINT "No Hood or Windscreen"
    END IF
  END IF
ELSE
  IF ((HDWTPCIN = 0) AND (CAPWTPCIN = 0)) THEN
    PRINT "No AP Cap or Hood"
  ELSE
    IF (HDWTPCIN > 0) THEN
      PRINT "No AP Cap"
    ELSE
      PRINT "No Hood"
    END IF
  END IF
END IF
131 :
IF (WSWTPCIN > 0) THEN
  PRINT "% Windscreen Weight ="; WSWTPCIN; "-- ";
  PRINT "Windscreen"; : IF (WSLOS = 1) THEN PRINT " destroyed on plate face":  ELSE PRINT " attached (penetrates)"
  PRINT "Windscreen Effects Multiplier ="; WSMULT
END IF
IF (HDWTPCIN > 0) THEN
  PRINT "% Hood       Weight ="; HDWTPCIN; "-- ";
  PRINT "Hood";
  IF (HDLOS = 1) THEN
     PRINT " destroyed on plate face"
  ELSE
     IF (TOVERD >= .0805) THEN PRINT " separated (penetrates)":   ELSE PRINT " attached (penetrates)"
  END IF
END IF
IF (CAPWTPCIN > 0) THEN
  PRINT "% AP Cap     Weight ="; CAPWTPCIN; "-- ";
  PRINT "AP Cap";
  IF (CAPSHAT = 1) THEN
    PRINT " shattered on plate face"
  ELSE
    IF (DECAPPED = 1) THEN PRINT " decapped (penetrates)":  ELSE PRINT " attached (penetrates)"
  END IF
  PRINT "AP Cap #: ";
  IF (CAPNMBR = 1) THEN
    PRINT "1 = Navy 6-in Mk 35 MOD 5 AP -- ";
  ELSE
    PRINT "2 = Army 76mm (3-in) M62 APC -- ";
  END IF
  IF (SOFTCAP = 1) THEN PRINT "SOFT/TOUGH":  ELSE PRINT "HARD"
  TSHATINCH = TSHAT * D: TSHATTMP = 10000 * TSHATINCH + .5: TSHINCHPRNT = INT(TSHATTMP) / 10000
  PRINT "AP Cap Shatter Plate Thickness ="; TSHINCHPRNT; : IF (TSHINCHPRNT <= 1!) THEN PRINT "inch"; :  ELSE PRINT "inches";
  PRINT " ---"; TSHAT; : IF (TSHAT <= 1!) THEN PRINT "caliber":   ELSE PRINT "calibers"
  IF (EDGEFLAG = 1) THEN
    EPRTTMP = 1000 * EDGEVAL + .5: EDGEVALPRT = INT(EPRTTMP) / 1000
    IF (EDGEUSED = 1) THEN EDGEPRT = EDGEVALPRT:  ELSE EDGEPRT = 0
    PRINT "Edge Effect % NBL Drop Entered = "; EDGEVALPRT;
    PRINT "-- % NBL Drop Used = ";
    IF (EDGEPRT = 0) THEN
      PRINT " 0"
    ELSE
      PRINT EDGEPRT
    END IF
    EDGECHKTMP = 1000 * EDGECHK + .5: EDGECHKPRNT = INT(EDGECHKTMP) / 1000
    EDGCHKINTMP = 1000 * (EDGECHK * D) + .5: EDGECHKINCH = INT(EDGCHKINTMP) / 1000
    PRINT "Edge Effect Minimum Thickness Used @ OB =";
    IF (OB < 50) THEN
      PRINT " UNDEFINED -- OB < 50 DEG"
    ELSE
      PRINT EDGECHKINCH;
      IF (EDGECHKINCH <= 1) THEN PRINT "inch ="; :  ELSE PRINT "inches =";
      PRINT EDGECHKPRNT;
      IF (EDGECHKPRNT <= 1) THEN PRINT "caliber":  ELSE PRINT "calibers"
    END IF
  END IF
  PRINT "Effect Multiplier: Intact=";
  IF (INTCAPEFF = 0) THEN PRINT "INHBTD ";  ELSE PRINT ICAPMULT;
  PRINT "--Shattered="; SCAPMULT; "--Edge Min Cal Thkns=";
  IF (EDGEFLAG = 0) THEN PRINT "INHBTD":  ELSE PRINT EDGTHMULT
END IF
REM ****
PRINT
PRINT "Striking Velocity (VS) ="; VSRNDED; "ft/sec -- ";
OBTMP = 100 * OB + .5: OBRNDED = INT(OBTMP) / 100
PRINT "Obliquity Angle (OB) ="; OBRNDED; "deg"
REM ****
PRINT
PRINT "***TRUE Navy Ballistic Limit   ="; NBLALLRNDED;
IF (NBLNOT > 0) THEN
  PRINT "ft/sec (User NBL + All effects)"
  PRINT ">>>ALWAYS NOSE-FIRST (NO BASE-FIRST DATA)<<<"
ELSE
  PRINT "ft/sec (M79 + All effects)"
  PRINT ">>>BASE-FIRST IF NBL(True) <= VS < NBL(N.F.)<<<"
END IF
IF (NBLNOT > 0) THEN
  PRINT "***User Navy Ballistic Limit   ="; NBLNOT; "ft/sec (Baseline AP Shot)"
END IF
PRINT "***M79  Navy Ballistic Limit   ="; NAVYBLM79RNDED; "ft/sec (Baseline AP Shot)"
PRINT "***     Navy B.L. (Nose-First) =";
IF ((BFPEN = 0) OR (BFPEN = -1)) THEN
  PRINT " TRUE NAVY B.L. (Never Base-First)"
ELSE
  PRINT NBLNFRNDED; "ft/sec (adjusted True NBL)"
END IF
REM ****
IF (WSCHG > 0) THEN
  WSTMP = 10000 * WSCHG + .5: WSCHGPRT = INT(WSTMP) / 100
ELSE
  WSCHGPRT = 0
END IF
IF (HDCHG > 0) THEN
  HDTMP = 10000 * HDCHG + .5: HDCHGPRT = INT(HDTMP) / 100
ELSE
  HDCHGPRT = 0
END IF
IF (CAPCHG > 0) THEN
  CAPTMP = 10000 * CAPCHG + .5: CAPCHGPRT = INT(CAPTMP) / 100
ELSE
  CAPCHGPRT = 0
END IF
IF ((WSWTPCIN = 0) AND (HDWTPCIN = 0) AND (CAPWTPCIN = 0)) THEN
  PRINT "Using Bare-Nose NBL for all computations"
ELSE
  PRINT "% NBL Change: ";
  IF (WSWTPCIN > 0) THEN PRINT "Windscrn="; WSCHGPRT;
  IF ((WSWTPCIN > 0) AND ((HDWTPCIN > 0) OR (CAPWTPCIN > 0))) THEN PRINT "--";
  IF (HDWTPCIN > 0) THEN PRINT "Hood="; HDCHGPRT;
  IF (CAPWTPCIN > 0) THEN
    PRINT "AP Cap="; CAPCHGPRT;
    PRINT "--Edge="; : IF (EDGEPRT < 0) THEN PRINT " ";
    PRINT EDGEPRT;
  END IF
  TOTLPRT = WSCHGPRT + HDCHGPRT + CAPCHGPRT + EDGEPRT
  PRINT ">TOTAL=";
  IF (TOTLPRT = 0) THEN PRINT " 0": GOTO 140
  IF (TOTLPRT < 0) THEN
    PRINT " "; TOTLPRT
  ELSE
    PRINT TOTLPRT
  END IF
END IF
REM ****
140 : EX = 0: EXRAD = 0: EXRNDED = 0: VR = 0: VRRNDED = 0: DF = 0: DFRAD = 0: DFRNDED = 0: REM INIT POST-IMPACT VALUES
NBLRATMP0 = NBLNFRNDED / NBLALLRNDED: NBLRATMP1 = 10000 * NBLRATMP0 + .5: NBLRATIO = INT(NBLRATMP1) / 10000
VSNBLTMP0 = VSRNDED / NBLALLRNDED: VSNBLTMP1 = 10000 * VSNBLTMP0 + .5: VSNBLRATIO = INT(VSNBLTMP1) / 10000
REM ****
PRINT
PRINT "STRIKING VELOCITY/TRUE NBL (V/TN) Ratio ="; VSNBLRATIO
IF (NBLALLRNDED > 3500) THEN
  PRINT ">>** TRUE NBL ABOVE MAXIMUM STRIKING VELOCITY -- NO PENETRATION POSSIBLE"
ELSE
  IF ((BFPEN <> 0) AND (BFPEN <> -1)) THEN
    PRINT "Base-First penetration possible:  NBL(N.F.)/TRUE NBL (NF/TN) Ratio ="; NBLRATIO
  ELSE
    PRINT "Base-First penetration not possible:  NBL(N.F.)/TRUE NBL (NF/TN) Ratio = 1"
  END IF
REM ****
  IF (VSNBLRATIO < 1!) THEN
    PRINT ">>** COMPLETE PENETRATION DID NOT OCCUR:  V/TN < 1"
  ELSE
    IF (BFPEN <> 1) THEN
      PRINT ">>** A NOSE-FIRST PENETRATION OCCURRED:  V/TN >= NF/TN"
    ELSE
      PRINT ">>** A BASE-FIRST PENETRATION OCCURRED:  1 <= V/TN < NF/TN"
    END IF
  END IF
END IF
REM ****
PRINT
PRINT "True NBL Penetration Energy/Hole Volume (KE Density) & KE Density Component for"
PRINT "a Normal (Minimum) Hole Size=Cylinder of projectile diameter & plate thickness:"
PRINT "True NBL Energy/Unit Hole Volume ="; ENERGYRNDED; "ft-lbs/in^3 (Total Energy)"
PRINT "DITTO X [COS(OB)]^2              ="; ECSOBRNDED; "ft-lbs/in^3 (Normal Component)"
REM ****
VMIN = NBLALL: VMINRNDED = NBLALLRNDED: REM USE NOSE-FIRST NBL AT OB<=45 OR BASE-FIRST NBL AT OB>45
IF (BFPEN <> 0) THEN GOTO 150: REM CHECK FOR BASE-FIRST PENETRATION IF OB>45
REM OB<=45 (BFPEN=0)
REM VMIN ALWAYS EQUALS REGULAR NBL, WHICH IS FOR NOSE-FIRST PENETRATIONS HERE
GOTO 160
REM ****
REM OB>45 (BFPEN=1 (BASE-FIRST PEN) OR BFPEN<0 (NOSE-FIRST PEN))
150 : IF (BFPEN <> 1) THEN GOTO 170: REM JUMP TO COMPUTE V'MIN(OB) IF NOT A BASE-FIRST PENETRATION
REM BASE-FIRST PENETRATION IF VS>NBL (BFPEN=1)
PRINT "Base-First penetration:  Projectile tumbling, any base fuze very rarely works,"
PRINT "Remaining Velocity is zero or very low, & Exit Angle is 0-80 degrees at random."
GOTO 400: REM FINISHED -- NO EX OR VR COMPUTATIONS
REM ****
REM VR FORMULA FOR OB<=45
160 : PRINT "**OB<=45 penetration, VR=[COS(DEF)]xSQRT[(PENWT/WT)x(VS^2-(TRUE NBL)^2)]"
GOTO 180
REM ****
REM NOSE-FIRST PENETRATION AT OB>45 IF VS>NOSE-FIRST N.L. (BFPEN<0)
170 : GOSUB 1100: REM COMPUTE ENERGY NBL, WHICH REPLACES NBL IN VR CALC WHEN NOSE-FIRST PEN OCCURS AT OB>45
VMINRATIO = VMINRNDED / NBLALLRNDED: VMINRATTEMP = 10000 * VMINRATIO + .5: VMINRATRNDED = INT(VMINRATTEMP) / 10000
PRINT "ENERGY NBL=NBL using energy estimate to make hole if OB>45 deg (ignore glancing)"
PRINT "ENERGY NBL ="; VMINRNDED; "ft/sec -- ENERGY NBL/TRUE NBL Ratio ="; VMINRATRNDED
PRINT "**OB>45 & Nose-1st only, VR=[COS(DEF)]xSQRT[(PENWT/WT)x(VS^2-(ENERGY NBL)^2)]"
REM ****
180 : IF (VSRNDED < NBLALLRNDED) THEN PRINT ">>** NO COMPLETE PENETRATION -- EX & VR are UNDEFINED.": GOTO 400: REM JUMP TO END-OF-PROGRAM LOGIC
REM ****        
REM CALCULATE AND PRINT EX, DF, AND VR
GOSUB 1200: REM CALCULATE EX & DF
PRINT "Exit Angle (EX)              ="; EXRNDED; "deg (assumed in same plane as OB)"
PRINT "Deflection Angle (DEF=OB-EX) ="; DFRNDED; "deg"
REM ****
REM ***CALCULATE VR OF PENETRATOR ONLY
REM VMIN IS EITHER REGULAR M79 NBL OR CALCULATED ENERGY NBL, AS SELECTED ABOVE
IF (VS < VMIN) THEN VMIN = VS: REM PREVENT ROUND-OFF ERROR CRASHING PROGRAM
ELEFTTOTAL = (VS ^ 2 - VMIN ^ 2): REM ENERGY REMAINING AFTER MAKING HOLE IN PLATE TAKEN FROM TOTAL PROJ WT
ELEFTPEN = ELEFTTOTAL * (PENWT / WT): REM ENERGY REMAINING IN PENETRATING PORTION OF PROJECTILE IF UNDEFLECTED
VR = COS(DFRAD) * SQR(ELEFTPEN): REM VR REDUCED BY DEFLECTION ANGLE (BILLIARD-BALL EFFECT -- PLATE PUSHED SIDEWAYS IN OPPOSITE DIRECTION)
VRTMP = VR + .5: VRRNDED = INT(VRTMP): REM ROUND VR TO WHOLE NUMBER
PRINT "Remaining Velocity (VR)      ="; VRRNDED; "ft/sec (VR of penetrator only)"
REM **********
REM END-OF-PROGRAM LOGIC
400 : PRINT : PRINT ">>>>**** ANOTHER RUN (Y or N)? ";
GOSUB 1500: REM ANSWER QUESTION
IF (YESNO = 1) THEN CLS : GOTO 10: REM DO ANOTHER RUN
END: REM TERMINATE PROGRAM
REM ********** SUBROUTINES FOLLOW **********
REM TABLE OF VALUES FOR VARIOUS PARTS OF THE M79 PENETRATION FORMULA PLUS
REM   THE MAXIMUM THICKNESS IN CALIBERS FOR USING THAT SET OF VALUES
500 : TSLASHDMAX(1) = .01156: NC(1) = 335.25392#: TCOEF(1) = .4336513: JA(1) = 0: JB(1) = 0: JC(1) = 0
TSLASHDMAX(2) = .05: NC(2) = 516.85756#: TCOEF(2) = .5306597: JA(2) = -.02: JB(2) = 4682.6223#: JC(2) = 54.131113#
TSLASHDMAX(3) = .075: NC(3) = 902.41425#: TCOEF(3) = .7166931: JA(3) = -.01: JB(3) = 7200!: JC(3) = 360!
TSLASHDMAX(4) = .1: NC(4) = 1290.90181#: TCOEF(4) = .8549115: JA(4) = 0: JB(4) = 0: JC(4) = 0
TSLASHDMAX(5) = .2549: NC(5) = 1687.6956#: TCOEF(5) = .9713125: JA(5) = 0: JB(5) = 0: JC(5) = 0
TSLASHDMAX(6) = .47931: NC(6) = 1361.41055#: TCOEF(6) = .8141355: JA(6) = .02: JB(6) = 802.10329#: JC(6) = 204.45613#
TSLASHDMAX(7) = 1!: NC(7) = 1179.94178#: TCOEF(7) = .619609: JA(7) = 0: JB(7) = 0: JC(7) = 0
TSLASHDMAX(8) = 2!: NC(8) = 1179.94178#: TCOEF(8) = .6387357: JA(8) = 0: JB(8) = 0: JC(8) = 0
TSLASHDMAX(9) = 3!: NC(9) = 1173.77728#: TCOEF(9) = .6462927: JA(9) = 0: JB(9) = 0: JC(9) = 0
TSLASHDMAX(10) = 4!: NC(10) = 1201.73299#: TCOEF(10) = .6248678: JA(10) = 0: JB(10) = 0: JC(10) = 0
TSLASHDMAX(11) = 6!: NC(11) = 1227.31234#: TCOEF(11) = .609576: JA(11) = 0: JB(11) = 0: JC(11) = 0
REM **********
REM
REM >>> AP CAP, HOOD, & WINDSCREEN EFFECTS TABLES <<<
REM
REM *****
REM VALUES GIVEN ARE FRACTIONAL INCREASES IN NAVY BALLISTIC LIMIT FROM THIS CAUSE
REM VALUE FOUND IS ADJUSTED LINEARLY BY ACTUAL WEIGHT PERCENT OF NOSE COVERING AND THEN ADDED TO BASELINE M79 NBL
REM SMOOTHED EXTRAPOLATED CURVES ARE USED TO FILL BLANKS IN DATA AT BOTH ENDS OF TABLES -- MY BEST ESTIMATES
REM MOST VALUES ARE FROM DR. ALLEN V. HERSHEY'S 1955 NPG/DAHLGREN REPORT #1211 ON AP CAP/HOOD/WINDSCREEN EFFECTS
REM *****
REM
REM AP CAP TABLES
REM
REM AP CAP EFFECTS ON PENETRATION INCLUDE TABLES FOR 2 U.S. HARD CAP TYPES:
REM DATA SMOOTHED FROM ENTRIES IN TABLES ON PGS 28 & 29 OF REPORT #1211 (ONLY 0-75 DEG; I ADDED 80 DEG DATA)
REM CAP #1 -- NAVY 6-INCH MK 35 MOD 5 AP  PROJ W/20%   CAP
REM CAP #2 -- ARMY 76mm (3-INCH) M62  APC PROJ W/13.9% CAP (IT ALSO HAD A 'BALLISTIC CAP' (BC) = WINDSCREEN)
REM 76mm M62 CAP IS ONE OF MY 'TYPE 2' CAPS USING EXTRA-STRONG HIGH-TEMPERATURE SOLDER
REM ***
REM 6-INCH AP MK 35 MOD 5 INTACT CAP EFFECT AT HIGH OBLIQUITY ONLY (OB>=40 DEG) -- SELECTABLE FOR ALL CAPS BY USER
REM CAP DISLODGED AND TILTED DURING PENETRATION, ENLARGING HOLE SLIGHTLY -- MODIFIES CAP SHAPE SINCE CAP HIDES ACTUAL NOSE
REM 2.5-DEG STEPS (INDEX 0=40 DEG & INDEX 14=75 DEG; NO EFFECT IF <=40 DEG OR >=75 DEG)
INTACTCAP1(0) = 0: INTACTCAP1(1) = .005: INTACTCAP1(2) = .015: INTACTCAP1(3) = .035: INTACTCAP1(4) = .055: REM 40-50 DEG
INTACTCAP1(5) = .075: INTACTCAP1(6) = .082: INTACTCAP1(7) = .08: INTACTCAP1(8) = .07: REM 50.01-60 DEG
INTACTCAP1(9) = .051: INTACTCAP1(10) = .032: INTACTCAP1(11) = .018: INTACTCAP1(12) = .005: REM 60.01-70 DEG
INTACTCAP1(13) = .001: INTACTCAP1(14) = 0: INTACTCAP1(15) = 0: REM 70.01-77.5 DEG (EXTRA ENTRY TO PREVENT CRASH NEAR 75 DEG)
REM ***
REM ACTUAL US ARMY 76mm APC M62 HAS ZERO INTACT CAP EFFECT
REM *****
REM SHATTERED CAP AT ALL OBLIQUITIES (EACH PROJ DIFFERENT) -- MODIFIES ACTUAL NOSE SHAPE VALUE, NOT AP CAP SHAPE
REM CAP DESTROYED ON PLATE SURFACE & FEW CAP PIECES PENETRATE WITH PROJECTILE
REM 5-DEG STEPS (0-80 DEG)
REM ***
REM 6-INCH AP MK 35 MOD 5 (NO EFFECT >50 DEG OBLIQUITY)
SHATCAP1(0) = .12: SHATCAP1(1) = .121: SHATCAP1(2) = .124: SHATCAP1(3) = .131: SHATCAP1(4) = .141
SHATCAP1(5) = .153: SHATCAP1(6) = .167: SHATCAP1(7) = .177: SHATCAP1(8) = .146: SHATCAP1(9) = .055
SHATCAP1(10) = 0: SHATCAP1(11) = 0: SHATCAP1(12) = 0: SHATCAP1(13) = 0: SHATCAP1(14) = 0
SHATCAP1(15) = 0: SHATCAP1(16) = 0
REM ***
REM 76mm APC M62 (NO EFFECT >65 DEG OBLIQUITY)
SHATCAP2(0) = .104: SHATCAP2(1) = .105: SHATCAP2(2) = .108: SHATCAP2(3) = .115: SHATCAP2(4) = .125
SHATCAP2(5) = .137: SHATCAP2(6) = .151: SHATCAP2(7) = .165: SHATCAP2(8) = .173: SHATCAP2(9) = .153
SHATCAP2(10) = .097: SHATCAP2(11) = .035: SHATCAP2(12) = .006: SHATCAP2(13) = 0: SHATCAP2(14) = 0
SHATCAP2(15) = 0: SHATCAP2(16) = 0
REM **********
REM
REM HOOD & WINDSCREEN TABLES
REM
REM **********
REM ALL DATA BASED ON US NAVY 105-LB 6-INCH SPECIAL COMMON MK 27 MOD 7 PROJECTILE
REM THESE HOOD & WINDSCREEN TABLE VALUES NOT IN DR. HERSHEY REPORT SO ESTIMATED & EXTRAPOLATED BY ME:
REM ALL > 1 CALIBER PLATE
REM ALL < 0.03 "
REM IF 0.03    " & < 60 DEG
REM IF 0.05    " & < 55 DEG
REM IF 0.075   " & < 50 DEG
REM ******
REM FOR BOTH HOOD & WINDSCREEN TABLES: 1ST INDEX IS PLATE THICKNESS & 2ND INDEX IS OBLIQUITY (17 x 17 TABLE)
REM ******
REM FIND THICKNESS INTERVAL BETWEEN HOOD & WINDSCREEN TABLE ENTRIES (OBLIQUITY ALWAYS IN 5 DEG STEPS)
HWTBL(0) = 0: HWTBL(1) = .03: HWTBL(2) = .05: HWTBL(3) = .075: HWTBL(4) = .1: HWTBL(5) = .15
HWTBL(6) = .2: HWTBL(7) = .3: HWTBL(8) = .4: HWTBL(9) = .5: HWTBL(10) = .6: HWTBL(11) = .7
HWTBL(12) = .8: HWTBL(13) = .9: HWTBL(14) = 1!: HWTBL(15) = 1.5: HWTBL(16) = 2.5
REM IF PLATE > 2.5 CAL THICK, ALWAYS USE 2.5 CAL VALUE.
REM ******
REM
REM HOOD EFFECTS
REM
REM ***
REM HOOD IS A MILD STEEL THREADED RING AROUND BASE OF NOSE JUST ABOVE START OF TAPER WITH A THIN SHELL
REM   COVERING THE UPPER PORTION OF NOSE LIKE A THIN AP CAP, ALL SOLDERED TO NOSE LIKE SAID CAP.
REM   ITS PURPOSE IS TO HOLD ONTO WINDSCREEN WITH NO WEAKENING THREADS CUT INTO THE NOSE ITSELF.
REM   HOOD, LIKE A SOFT 'TYPE 1' AP CAP, IS KNOCKED OFF AGAINST >=0.0805-CAL PLATE WHEN PENETRATING IT.
REM HOOD = 5.2% OF TOTAL PROJ WEIGHT
REM NPG REPORT #1211 PGS 26 & 27
REM ***
HOOD(0, 0) = 2.257: HOOD(0, 1) = 2.14: HOOD(0, 2) = 2.023: HOOD(0, 3) = 1.91: HOOD(0, 4) = 1.79
HOOD(0, 5) = 1.68: HOOD(0, 6) = 1.58: HOOD(0, 7) = 1.47: HOOD(0, 8) = 1.4: HOOD(0, 9) = 1.52
HOOD(0, 10) = 1.66: HOOD(0, 11) = 1.475: HOOD(0, 12) = 1!: HOOD(0, 13) = .46: HOOD(0, 14) = .135
HOOD(0, 15) = .09: HOOD(0, 16) = .084
HOOD(1, 0) = 1.52: HOOD(1, 1) = 1.44: HOOD(1, 2) = 1.36: HOOD(1, 3) = 1.27: HOOD(1, 4) = 1.19
HOOD(1, 5) = 1.11: HOOD(1, 6) = 1.035: HOOD(1, 7) = .955: HOOD(1, 8) = .9: HOOD(1, 9) = 1.01
HOOD(1, 10) = 1.12: HOOD(1, 11) = .98: HOOD(1, 12) = .614: HOOD(1, 13) = .27: HOOD(1, 14) = .089
HOOD(1, 15) = .059: HOOD(1, 16) = .055
HOOD(2, 0) = .96: HOOD(2, 1) = .91: HOOD(2, 2) = .859: HOOD(2, 3) = .805: HOOD(2, 4) = .759
HOOD(2, 5) = .71: HOOD(2, 6) = .66: HOOD(2, 7) = .61: HOOD(2, 8) = .57: HOOD(2, 9) = .645
HOOD(2, 10) = .73: HOOD(2, 11) = .663: HOOD(2, 12) = .376: HOOD(2, 13) = .172: HOOD(2, 14) = .064
HOOD(2, 15) = .046: HOOD(2, 16) = .043
HOOD(3, 0) = .62: HOOD(3, 1) = .57: HOOD(3, 2) = .535: HOOD(3, 3) = .5: HOOD(3, 4) = .465
HOOD(3, 5) = .43: HOOD(3, 6) = .39: HOOD(3, 7) = .35: HOOD(3, 8) = .32: HOOD(3, 9) = .37
HOOD(3, 10) = .455: HOOD(3, 11) = .394: HOOD(3, 12) = .24: HOOD(3, 13) = .12: HOOD(3, 14) = .05
HOOD(3, 15) = .039: HOOD(3, 16) = .037
HOOD(4, 0) = .382: HOOD(4, 1) = .353: HOOD(4, 2) = .322: HOOD(4, 3) = .297: HOOD(4, 4) = .272
HOOD(4, 5) = .251: HOOD(4, 6) = .227: HOOD(4, 7) = .205: HOOD(4, 8) = .18: HOOD(4, 9) = .217
HOOD(4, 10) = .291: HOOD(4, 11) = .264: HOOD(4, 12) = .171: HOOD(4, 13) = .09: HOOD(4, 14) = .043
HOOD(4, 15) = .035: HOOD(4, 16) = .034
HOOD(5, 0) = .191: HOOD(5, 1) = .176: HOOD(5, 2) = .164: HOOD(5, 3) = .152: HOOD(5, 4) = .14
HOOD(5, 5) = .13: HOOD(5, 6) = .12: HOOD(5, 7) = .109: HOOD(5, 8) = .098: HOOD(5, 9) = .114
HOOD(5, 10) = .153: HOOD(5, 11) = .147: HOOD(5, 12) = .103: HOOD(5, 13) = .061: HOOD(5, 14) = .035
HOOD(5, 15) = .031: HOOD(5, 16) = .031
HOOD(6, 0) = .119: HOOD(6, 1) = .111: HOOD(6, 2) = .104: HOOD(6, 3) = .097: HOOD(6, 4) = .09
HOOD(6, 5) = .085: HOOD(6, 6) = .079: HOOD(6, 7) = .073: HOOD(6, 8) = .066: HOOD(6, 9) = .076
HOOD(6, 10) = .098: HOOD(6, 11) = .097: HOOD(6, 12) = .073: HOOD(6, 13) = .047: HOOD(6, 14) = .032
HOOD(6, 15) = .029: HOOD(6, 16) = .029
HOOD(7, 0) = .069: HOOD(7, 1) = .065: HOOD(7, 2) = .062: HOOD(7, 3) = .059: HOOD(7, 4) = .056
HOOD(7, 5) = .053: HOOD(7, 6) = .05: HOOD(7, 7) = .047: HOOD(7, 8) = .045: HOOD(7, 9) = .049
HOOD(7, 10) = .06: HOOD(7, 11) = .059: HOOD(7, 12) = .047: HOOD(7, 13) = .036: HOOD(7, 14) = .029
HOOD(7, 15) = .027: HOOD(7, 16) = .027
HOOD(8, 0) = .054: HOOD(8, 1) = .052: HOOD(8, 2) = .05: HOOD(8, 3) = .048: HOOD(8, 4) = .046
HOOD(8, 5) = .044: HOOD(8, 6) = .043: HOOD(8, 7) = .044: HOOD(8, 8) = .047: HOOD(8, 9) = .051
HOOD(8, 10) = .051: HOOD(8, 11) = .046: HOOD(8, 12) = .038: HOOD(8, 13) = .03: HOOD(8, 14) = .027
HOOD(8, 15) = .027: HOOD(8, 16) = .027
HOOD(9, 0) = .052: HOOD(9, 1) = .05: HOOD(9, 2) = .048: HOOD(9, 3) = .047: HOOD(9, 4) = .046
HOOD(9, 5) = .046: HOOD(9, 6) = .047: HOOD(9, 7) = .05: HOOD(9, 8) = .057: HOOD(9, 9) = .065
HOOD(9, 10) = .059: HOOD(9, 11) = .047: HOOD(9, 12) = .037: HOOD(9, 13) = .029: HOOD(9, 14) = .026
HOOD(9, 15) = .026: HOOD(9, 16) = .026
HOOD(10, 0) = .055: HOOD(10, 1) = .054: HOOD(10, 2) = .053: HOOD(10, 3) = .052: HOOD(10, 4) = .051
HOOD(10, 5) = .051: HOOD(10, 6) = .054: HOOD(10, 7) = .059: HOOD(10, 8) = .068: HOOD(10, 9) = .082
HOOD(10, 10) = .075: HOOD(10, 11) = .054: HOOD(10, 12) = .039: HOOD(10, 13) = .029: HOOD(10, 14) = .026
HOOD(10, 15) = .026: HOOD(10, 16) = .026
HOOD(11, 0) = .061: HOOD(11, 1) = .06: HOOD(11, 2) = .059: HOOD(11, 3) = .058: HOOD(11, 4) = .058
HOOD(11, 5) = .059: HOOD(11, 6) = .063: HOOD(11, 7) = .07: HOOD(11, 8) = .081: HOOD(11, 9) = .098
HOOD(11, 10) = .094: HOOD(11, 11) = .06: HOOD(11, 12) = .041: HOOD(11, 13) = .029: HOOD(11, 14) = .026
HOOD(11, 15) = .026: HOOD(11, 16) = .026
HOOD(12, 0) = .067: HOOD(12, 1) = .066: HOOD(12, 2) = .066: HOOD(12, 3) = .065: HOOD(12, 4) = .065
HOOD(12, 5) = .066: HOOD(12, 6) = .07: HOOD(12, 7) = .077: HOOD(12, 8) = .088: HOOD(12, 9) = .11
HOOD(12, 10) = .114: HOOD(12, 11) = .065: HOOD(12, 12) = .041: HOOD(12, 13) = .029: HOOD(12, 14) = .026
HOOD(12, 15) = .025: HOOD(12, 16) = .025
HOOD(13, 0) = .071: HOOD(13, 1) = .071: HOOD(13, 2) = .07: HOOD(13, 3) = .07: HOOD(13, 4) = .07
HOOD(13, 5) = .072: HOOD(13, 6) = .075: HOOD(13, 7) = .082: HOOD(13, 8) = .095: HOOD(13, 9) = .118
HOOD(13, 10) = .126: HOOD(13, 11) = .066: HOOD(13, 12) = .04: HOOD(13, 13) = .029: HOOD(13, 14) = .025
HOOD(13, 15) = .025: HOOD(13, 16) = .025
HOOD(14, 0) = .073: HOOD(14, 1) = .073: HOOD(14, 2) = .073: HOOD(14, 3) = .073: HOOD(14, 4) = .073
HOOD(14, 5) = .074: HOOD(14, 6) = .078: HOOD(14, 7) = .085: HOOD(14, 8) = .098: HOOD(14, 9) = .123
HOOD(14, 10) = .133: HOOD(14, 11) = .066: HOOD(14, 12) = .04: HOOD(14, 13) = .028: HOOD(14, 14) = .025
HOOD(14, 15) = .025: HOOD(14, 16) = .025
HOOD(15, 0) = .075: HOOD(15, 1) = .075: HOOD(15, 2) = .075: HOOD(15, 3) = .075: HOOD(15, 4) = .075
HOOD(15, 5) = .075: HOOD(15, 6) = .079: HOOD(15, 7) = .087: HOOD(15, 8) = .101: HOOD(15, 9) = .128
HOOD(15, 10) = .139: HOOD(15, 11) = .066: HOOD(15, 12) = .04: HOOD(15, 13) = .028: HOOD(15, 14) = .025
HOOD(15, 15) = .025: HOOD(15, 16) = .025
HOOD(16, 0) = .076: HOOD(16, 1) = .076: HOOD(16, 2) = .076: HOOD(16, 3) = .076: HOOD(16, 4) = .076
HOOD(16, 5) = .077: HOOD(16, 6) = .08: HOOD(16, 7) = .088: HOOD(16, 8) = .104: HOOD(16, 9) = .132
HOOD(16, 10) = .143: HOOD(16, 11) = .066: HOOD(16, 12) = .04: HOOD(16, 13) = .025: HOOD(16, 14) = .024
HOOD(16, 15) = .024: HOOD(16, 16) = .024
REM ******
REM
REM WINDSCREEN EFFECTS
REM
REM ***
REM WINDSCREEN = 5.1% OF TOTAL PROJ WEIGHT (VERY LONG; ~50% OF PROJ TOTAL LENGTH)
REM NPG REPORT #1211 PGS 24 & 25
REM ***
REM 1ST ROW FOR ZERO PLATE THICKNESS WNDSCRN(0,N) IS ALWAYS ZERO BECAUSE FOR VERY THIN PLATES WINDSCREEN
REM IS NOT DAMAGED AND MERELY ACTS LIKE A VERY POINTED NOSE, SO NOSE SHAPE LOGIC APPLIES INSTEAD.  DUMMY
REM VALUES -- MINIMUM USED IS '(1, N)' WITH '(0, N)' (<0.03 CALIBER) SKIPPING TABLE IF THERE IS NO EFFECT.
REM ***
WNDSCRN(0, 0) = 0: WNDSCRN(0, 1) = 0: WNDSCRN(0, 2) = 0: WNDSCRN(0, 3) = 0: WNDSCRN(0, 4) = 0
WNDSCRN(0, 5) = 0: WNDSCRN(0, 6) = 0: WNDSCRN(0, 7) = 0: WNDSCRN(0, 8) = 0: WNDSCRN(0, 9) = 0
WNDSCRN(0, 10) = 0: WNDSCRN(0, 11) = 0: WNDSCRN(0, 12) = 0: WNDSCRN(0, 13) = 0: WNDSCRN(0, 14) = 0
WNDSCRN(0, 15) = 0: WNDSCRN(0, 16) = 0
WNDSCRN(1, 0) = .865: WNDSCRN(1, 1) = .92: WNDSCRN(1, 2) = .959: WNDSCRN(1, 3) = .981: WNDSCRN(1, 4) = 1!
WNDSCRN(1, 5) = 1.012: WNDSCRN(1, 6) = 1.025: WNDSCRN(1, 7) = 1.03: WNDSCRN(1, 8) = 1.02: WNDSCRN(1, 9) = 1!
WNDSCRN(1, 10) = .96: WNDSCRN(1, 11) = .4: WNDSCRN(1, 12) = .236: WNDSCRN(1, 13) = .112: WNDSCRN(1, 14) = .07
WNDSCRN(1, 15) = .053: WNDSCRN(1, 16) = .047
WNDSCRN(2, 0) = .586: WNDSCRN(2, 1) = .638: WNDSCRN(2, 2) = .67: WNDSCRN(2, 3) = .685: WNDSCRN(2, 4) = .699
WNDSCRN(2, 5) = .711: WNDSCRN(2, 6) = .723: WNDSCRN(2, 7) = .73: WNDSCRN(2, 8) = .723: WNDSCRN(2, 9) = .7
WNDSCRN(2, 10) = .585: WNDSCRN(2, 11) = .302: WNDSCRN(2, 12) = .15: WNDSCRN(2, 13) = .078: WNDSCRN(2, 14) = .052
WNDSCRN(2, 15) = .042: WNDSCRN(2, 16) = .038
WNDSCRN(3, 0) = .38: WNDSCRN(3, 1) = .418: WNDSCRN(3, 2) = .45: WNDSCRN(3, 3) = .459: WNDSCRN(3, 4) = .47
WNDSCRN(3, 5) = .477: WNDSCRN(3, 6) = .482: WNDSCRN(3, 7) = .48: WNDSCRN(3, 8) = .473: WNDSCRN(3, 9) = .44
WNDSCRN(3, 10) = .311: WNDSCRN(3, 11) = .185: WNDSCRN(3, 12) = .102: WNDSCRN(3, 13) = .059: WNDSCRN(3, 14) = .043
WNDSCRN(3, 15) = .036: WNDSCRN(3, 16) = .034
WNDSCRN(4, 0) = .228: WNDSCRN(4, 1) = .25: WNDSCRN(4, 2) = .266: WNDSCRN(4, 3) = .278: WNDSCRN(4, 4) = .285
WNDSCRN(4, 5) = .292: WNDSCRN(4, 6) = .295: WNDSCRN(4, 7) = .299: WNDSCRN(4, 8) = .292: WNDSCRN(4, 9) = .264
WNDSCRN(4, 10) = .201: WNDSCRN(4, 11) = .129: WNDSCRN(4, 12) = .078: WNDSCRN(4, 13) = .049: WNDSCRN(4, 14) = .038
WNDSCRN(4, 15) = .033: WNDSCRN(4, 16) = .031
WNDSCRN(5, 0) = .12: WNDSCRN(5, 1) = .129: WNDSCRN(5, 2) = .137: WNDSCRN(5, 3) = .143: WNDSCRN(5, 4) = .146
WNDSCRN(5, 5) = .149: WNDSCRN(5, 6) = .151: WNDSCRN(5, 7) = .152: WNDSCRN(5, 8) = .149: WNDSCRN(5, 9) = .136
WNDSCRN(5, 10) = .11: WNDSCRN(5, 11) = .078: WNDSCRN(5, 12) = .054: WNDSCRN(5, 13) = .038: WNDSCRN(5, 14) = .032
WNDSCRN(5, 15) = .03: WNDSCRN(5, 16) = .029
WNDSCRN(6, 0) = .078: WNDSCRN(6, 1) = .083: WNDSCRN(6, 2) = .087: WNDSCRN(6, 3) = .091: WNDSCRN(6, 4) = .093
WNDSCRN(6, 5) = .095: WNDSCRN(6, 6) = .096: WNDSCRN(6, 7) = .097: WNDSCRN(6, 8) = .096: WNDSCRN(6, 9) = .088
WNDSCRN(6, 10) = .074: WNDSCRN(6, 11) = .056: WNDSCRN(6, 12) = .043: WNDSCRN(6, 13) = .033: WNDSCRN(6, 14) = .03
WNDSCRN(6, 15) = .028: WNDSCRN(6, 16) = .028
WNDSCRN(7, 0) = .05: WNDSCRN(7, 1) = .052: WNDSCRN(7, 2) = .054: WNDSCRN(7, 3) = .056: WNDSCRN(7, 4) = .057
WNDSCRN(7, 5) = .058: WNDSCRN(7, 6) = .059: WNDSCRN(7, 7) = .059: WNDSCRN(7, 8) = .058: WNDSCRN(7, 9) = .055
WNDSCRN(7, 10) = .048: WNDSCRN(7, 11) = .04: WNDSCRN(7, 12) = .033: WNDSCRN(7, 13) = .029: WNDSCRN(7, 14) = .027
WNDSCRN(7, 15) = .027: WNDSCRN(7, 16) = .027
WNDSCRN(8, 0) = .042: WNDSCRN(8, 1) = .043: WNDSCRN(8, 2) = .044: WNDSCRN(8, 3) = .045: WNDSCRN(8, 4) = .045
WNDSCRN(8, 5) = .045: WNDSCRN(8, 6) = .046: WNDSCRN(8, 7) = .047: WNDSCRN(8, 8) = .049: WNDSCRN(8, 9) = .049
WNDSCRN(8, 10) = .042: WNDSCRN(8, 11) = .035: WNDSCRN(8, 12) = .03: WNDSCRN(8, 13) = .028: WNDSCRN(8, 14) = .027
WNDSCRN(8, 15) = .026: WNDSCRN(8, 16) = .026
WNDSCRN(9, 0) = .042: WNDSCRN(9, 1) = .042: WNDSCRN(9, 2) = .042: WNDSCRN(9, 3) = .043: WNDSCRN(9, 4) = .043
WNDSCRN(9, 5) = .044: WNDSCRN(9, 6) = .045: WNDSCRN(9, 7) = .047: WNDSCRN(9, 8) = .052: WNDSCRN(9, 9) = .055
WNDSCRN(9, 10) = .043: WNDSCRN(9, 11) = .033: WNDSCRN(9, 12) = .029: WNDSCRN(9, 13) = .027: WNDSCRN(9, 14) = .026
WNDSCRN(9, 15) = .026: WNDSCRN(9, 16) = .026
WNDSCRN(10, 0) = .045: WNDSCRN(10, 1) = .045: WNDSCRN(10, 2) = .045: WNDSCRN(10, 3) = .045: WNDSCRN(10, 4) = .045
WNDSCRN(10, 5) = .046: WNDSCRN(10, 6) = .048: WNDSCRN(10, 7) = .052: WNDSCRN(10, 8) = .059: WNDSCRN(10, 9) = .068
WNDSCRN(10, 10) = .057: WNDSCRN(10, 11) = .037: WNDSCRN(10, 12) = .029: WNDSCRN(10, 13) = .027: WNDSCRN(10, 14) = .026
WNDSCRN(10, 15) = .026: WNDSCRN(10, 16) = .026
WNDSCRN(11, 0) = .05: WNDSCRN(11, 1) = .05: WNDSCRN(11, 2) = .05: WNDSCRN(11, 3) = .05: WNDSCRN(11, 4) = .05
WNDSCRN(11, 5) = .051: WNDSCRN(11, 6) = .053: WNDSCRN(11, 7) = .058: WNDSCRN(11, 8) = .067: WNDSCRN(11, 9) = .082
WNDSCRN(11, 10) = .068: WNDSCRN(11, 11) = .04: WNDSCRN(11, 12) = .029: WNDSCRN(11, 13) = .027: WNDSCRN(11, 14) = .026
WNDSCRN(11, 15) = .026: WNDSCRN(11, 16) = .026:
WNDSCRN(12, 0) = .055: WNDSCRN(12, 1) = .055: WNDSCRN(12, 2) = .055: WNDSCRN(12, 3) = .055: WNDSCRN(12, 4) = .055
WNDSCRN(12, 5) = .056: WNDSCRN(12, 6) = .059: WNDSCRN(12, 7) = .064: WNDSCRN(12, 8) = .074: WNDSCRN(12, 9) = .093
WNDSCRN(12, 10) = .074: WNDSCRN(12, 11) = .041: WNDSCRN(12, 12) = .029: WNDSCRN(12, 13) = .026: WNDSCRN(12, 14) = .026
WNDSCRN(12, 15) = .026: WNDSCRN(12, 16) = .026
WNDSCRN(13, 0) = .059: WNDSCRN(13, 1) = .059: WNDSCRN(13, 2) = .059: WNDSCRN(13, 3) = .059: WNDSCRN(13, 4) = .059
WNDSCRN(13, 5) = .06: WNDSCRN(13, 6) = .063: WNDSCRN(13, 7) = .069: WNDSCRN(13, 8) = .08: WNDSCRN(13, 9) = .1
WNDSCRN(13, 10) = .078: WNDSCRN(13, 11) = .042: WNDSCRN(13, 12) = .029: WNDSCRN(13, 13) = .026: WNDSCRN(13, 14) = .026
WNDSCRN(13, 15) = .026: WNDSCRN(13, 16) = .026
WNDSCRN(14, 0) = .061: WNDSCRN(14, 1) = .061: WNDSCRN(14, 2) = .061: WNDSCRN(14, 3) = .061: WNDSCRN(14, 4) = .061
WNDSCRN(14, 5) = .062: WNDSCRN(14, 6) = .066: WNDSCRN(14, 7) = .072: WNDSCRN(14, 8) = .083: WNDSCRN(14, 9) = .105
WNDSCRN(14, 10) = .079: WNDSCRN(14, 11) = .043: WNDSCRN(14, 12) = .029: WNDSCRN(14, 13) = .026: WNDSCRN(14, 14) = .026
WNDSCRN(14, 15) = .026: WNDSCRN(14, 16) = .026
WNDSCRN(15, 0) = .063: WNDSCRN(15, 1) = .063: WNDSCRN(15, 2) = .063: WNDSCRN(15, 3) = .063: WNDSCRN(15, 4) = .063
WNDSCRN(15, 5) = .064: WNDSCRN(15, 6) = .0695: WNDSCRN(15, 7) = .0755: WNDSCRN(15, 8) = .086: WNDSCRN(15, 9) = .109
WNDSCRN(15, 10) = .08: WNDSCRN(15, 11) = .043: WNDSCRN(15, 12) = .029: WNDSCRN(15, 13) = .026: WNDSCRN(15, 14) = .026
WNDSCRN(15, 15) = .026: WNDSCRN(15, 16) = .026
WNDSCRN(16, 0) = .064: WNDSCRN(16, 1) = .064: WNDSCRN(16, 2) = .064: WNDSCRN(16, 3) = .064: WNDSCRN(16, 4) = .064
WNDSCRN(16, 5) = .065: WNDSCRN(16, 6) = .068: WNDSCRN(16, 7) = .074: WNDSCRN(16, 8) = .088: WNDSCRN(16, 9) = .112
WNDSCRN(16, 10) = .081: WNDSCRN(16, 11) = .043: WNDSCRN(16, 12) = .029: WNDSCRN(16, 13) = .026: WNDSCRN(16, 14) = .026
WNDSCRN(16, 15) = .026: WNDSCRN(16, 16) = .026
REM ******
REM END OF NON-OBLIQUITY MULTIPLIER TABLES INIT
RETURN
REM **********
REM SELECT COEFFICIENTS FOR PENETRATION FORMULAE BASED ON TA/D RANGE
600 : N = 1
610 : IF (TSLASHD > TSLASHDMAX(N)) THEN N = N + 1: GOTO 610: REM SELECT PROPER CONSTANT SET FOR PLATE THICKNESS RANGE
NUM = NC(N): TEXP = TCOEF(N): JCA = JA(N): JCB = JB(N): JCC = JC(N)
REM COMPUTE GREEN'S FUNCTION (J), WHEN USED (CREATE A SMOOTH BRIDGE BETWEEN 2 CURVES AT JOINT)
JSIN = 0: REM DEFAULT VALUE (J = 1)
IF (JCA <> 0) THEN JDEG = JCB * (TA / D) - JCC: JRAD = JDEG / 57.29578: JSIN = SIN(JRAD)
IF (JSIN < 0) THEN JSIN = 0
J = 1! + JCA * JSIN: REM "J" USUALLY IS 1.00 (NOT USED)
RETURN
REM **********
REM COMPUTE OBLIQUITY MULTIPLIER (FUNCTION OF OB ONLY IF OB <= 45, BUT TA NEEDED IF OB > 45)
700 : IF (OB >= 45!) THEN 710: REM ABOVE 45 DEG PLATE THICKNESS CHANGES MULTIPLIER COEFFICIENT M'
REM ****
REM COMPUTE M' FOR U.S. ARMY 76mm M79 AP SHOT BELOW 45 DEGREES OBLIQUITY USING LINEAR INTERPOLATION
I1TMP = OB / 2.5: I1 = INT(I1TMP): I2 = (OB - 2.5 * I1) / 2.5: REM 2.5 DEG INTERVAL
MPRIME = MPLTBITE(I1) + I2 * (MPLTBITE(I1 + 1) - MPLTBITE(I1)): REM M' FOR OBLIQUITY UP TO 45 DEGREES
GOTO 720: REM JUMP TO CALCULATE OBLIQUITY ANGLE VELOCITY MULTIPLIER 'MOBLIQUITY'
REM ****
REM COMPUTE M' FOR U.S. ARMY 76mm M79 AP SHOT AT AND ABOVE 45 DEGREES OBLIQUITY
710 : C1TMP = (OB - 45!) / 2.5: C1 = INT(C1TMP): C2 = ((OB - 45!) - 2.5 * C1) / 2.5: REM OBLIQUITY AXIS: DELTA(OB) =2.5-DEGREE  INTERVAL (INCREASING)
TSLASHDPR = TSLASHD: IF (TSLASHD > .899) THEN TSLASHDPR = .899: REM M' BECOMES CONSTANT AT 0.9 CALIBER (OR LESS) FOR ALL OBLIQUITY VALUES
T1TMP = TSLASHDPR / .05: T1 = INT(T1TMP): T2 = (TSLASHDPR - .05 * T1) / .05: REM         THICKNESS AXIS: DELTA(T/D)=.05-CALIBER INTERVAL (INCREASING)
N = 0: GOSUB 900: MP0 = MPVAL: REM FIND THE LOWEST  OB INTERPOLATION POINTS HOLDING OBLIQUITY AXIS FIXED
N = 1: GOSUB 900: MP1 = MPVAL: REM FIND THE HIGHEST OB INTERPOLATION POINTS HOLDING OBLIQUITY AXIS FIXED
REM USING THE ABOVE TWO THICKNESS-AXIS POINTS JUST FOUND, CALCULATE THE FINAL OBLIQUITY-AXIS INTERPOLATED VALUE USING LINEAR INTERPOLATION
MPRIME = MP0 + C2 * (MP1 - MP0): REM COMPUTE M' FOR OBLIQUITY ANGLES OF 45 DEGREES AND UP
REM ****
720 : MOBLIQUITY = MPRIME / CSOB: REM FINAL VALUE OF OBLIQUITY ANGLE VELOCITY MULTIPLIER
RETURN
REM **********
REM TABLE OF M' VALUES FOR OBLIQUITY ANGLES UP TO 45 DEGREES (ALL PLATE THICKNESSES)
800 : MPLTBITE(0) = 1!: MPLTBITE(1) = .999: MPLTBITE(2) = .998: MPLTBITE(3) = .995: MPLTBITE(4) = .991
MPLTBITE(5) = .986: MPLTBITE(6) = .981: MPLTBITE(7) = .974: MPLTBITE(8) = .966: MPLTBITE(9) = .958
MPLTBITE(10) = .948: MPLTBITE(11) = .937: MPLTBITE(12) = .925: MPLTBITE(13) = .912: : MPLTBITE(14) = .901
MPLTBITE(15) = .889: MPLTBITE(16) = .881: MPLTBITE(17) = .879: MPLTBITE(18) = .885:
REM **********
REM TABLE OF M' VALUES FOR OBLIQUITY ANGLES ABOVE 45 DEGREES (PLATE THICKNESS ALTERS RESULTS)
REM FIRST  INDEX IS OBLIQUITY ANGLE IN 2.5-DEGREE  INCREMENTS UP TO 80 DEGREES
REM SECOND INDEX IS PLATE THICKNESS IN .05-CALIBER INCREMENTS UP TO INDEX 18 = .9 CALIBER
MPTBL(0, 0) = .885: MPTBL(0, 1) = .885: MPTBL(0, 2) = .885: MPTBL(0, 3) = .885: MPTBL(0, 4) = .885: MPTBL(0, 5) = .885: REM 45.0 DEG
MPTBL(0, 6) = .885: MPTBL(0, 7) = .885: MPTBL(0, 8) = .885: MPTBL(0, 9) = .885: MPTBL(0, 10) = .885: MPTBL(0, 11) = .885
MPTBL(0, 12) = .885
MPTBL(0, 13) = .885: MPTBL(0, 14) = .885: MPTBL(0, 15) = .885: MPTBL(0, 16) = .885: MPTBL(0, 17) = .885: MPTBL(0, 18) = .885
MPTBL(1, 0) = .918: MPTBL(1, 1) = .916: MPTBL(1, 2) = .912: MPTBL(1, 3) = .906: : MPTBL(1, 4) = .902: MPTBL(1, 5) = .901: REM 47.5 DEG
MPTBL(1, 6) = .905: MPTBL(1, 7) = .909: MPTBL(1, 8) = .912: MPTBL(1, 9) = .914: : MPTBL(1, 10) = .914: MPTBL(1, 11) = .914
MPTBL(1, 12) = .914
MPTBL(1, 13) = .914: MPTBL(1, 14) = .914: MPTBL(1, 15) = .914: MPTBL(1, 16) = .914: MPTBL(1, 17) = .914: MPTBL(1, 18) = .914
MPTBL(2, 0) = .968: MPTBL(2, 1) = .96: MPTBL(2, 2) = .949: MPTBL(2, 3) = .932: : MPTBL(2, 4) = .922: MPTBL(2, 5) = .921: REM 50.0 DEG
MPTBL(2, 6) = .928: MPTBL(2, 7) = .936: MPTBL(2, 8) = .944: MPTBL(2, 9) = .951: : MPTBL(2, 10) = .956: MPTBL(2, 11) = .96:
MPTBL(2, 12) = .961
MPTBL(2, 13) = .961: MPTBL(2, 14) = .961: MPTBL(2, 15) = .961: MPTBL(2, 16) = .961: MPTBL(2, 17) = .961: MPTBL(2, 18) = .961
MPTBL(3, 0) = 1.05: MPTBL(3, 1) = 1.028: MPTBL(3, 2) = 1!: MPTBL(3, 3) = .97: : MPTBL(3, 4) = .958: MPTBL(3, 5) = .952: REM 52.5 DEG
MPTBL(3, 6) = .96: MPTBL(3, 7) = .968: MPTBL(3, 8) = .982: MPTBL(3, 9) = .995: : MPTBL(3, 10) = 1.005: MPTBL(3, 11) = 1.015
MPTBL(3, 12) = 1.021
MPTBL(3, 13) = 1.023: MPTBL(3, 14) = 1.023: MPTBL(3, 15) = 1.023: MPTBL(3, 16) = 1.023: MPTBL(3, 17) = 1.023: MPTBL(3, 18) = 1.023
MPTBL(4, 0) = 1.153: MPTBL(4, 1) = 1.111: MPTBL(4, 2) = 1.057: MPTBL(4, 3) = 1.008: MPTBL(4, 4) = .992: MPTBL(4, 5) = .987: REM 55.0 DEG
MPTBL(4, 6) = .993: MPTBL(4, 7) = 1.006: MPTBL(4, 8) = 1.024: MPTBL(4, 9) = 1.042: MPTBL(4, 10) = 1.062: MPTBL(4, 11) = 1.076
MPTBL(4, 12) = 1.088
MPTBL(4, 13) = 1.094: MPTBL(4, 14) = 1.098: MPTBL(4, 15) = 1.098: MPTBL(4, 16) = 1.098: MPTBL(4, 17) = 1.098: MPTBL(4, 18) = 1.098
MPTBL(5, 0) = 1.272: MPTBL(5, 1) = 1.203: MPTBL(5, 2) = 1.12: MPTBL(5, 3) = 1.053: MPTBL(5, 4) = 1.027: MPTBL(5, 5) = 1.021: REM 57.5 DEG
MPTBL(5, 6) = 1.031: MPTBL(5, 7) = 1.049: MPTBL(5, 8) = 1.072: MPTBL(5, 9) = 1.094: MPTBL(5, 10) = 1.12: MPTBL(5, 11) = 1.14
MPTBL(5, 12) = 1.154
MPTBL(5, 13) = 1.165: MPTBL(5, 14) = 1.172: MPTBL(5, 15) = 1.179: MPTBL(5, 16) = 1.182: MPTBL(5, 17) = 1.184: MPTBL(5, 18) = 1.184
MPTBL(6, 0) = 1.376: MPTBL(6, 1) = 1.29: MPTBL(6, 2) = 1.178: MPTBL(6, 3) = 1.092: MPTBL(6, 4) = 1.058: MPTBL(6, 5) = 1.052: REM 60.0 DEG
MPTBL(6, 6) = 1.067: MPTBL(6, 7) = 1.089: MPTBL(6, 8) = 1.116: MPTBL(6, 9) = 1.142: MPTBL(6, 10) = 1.172: MPTBL(6, 11) = 1.197
MPTBL(6, 12) = 1.215
MPTBL(6, 13) = 1.231: MPTBL(6, 14) = 1.241: MPTBL(6, 15) = 1.25: MPTBL(6, 16) = 1.257: MPTBL(6, 17) = 1.26: MPTBL(6, 18) = 1.261
MPTBL(7, 0) = 1.441: MPTBL(7, 1) = 1.354: MPTBL(7, 2) = 1.213: MPTBL(7, 3) = 1.119: MPTBL(7, 4) = 1.083: MPTBL(7, 5) = 1.079: REM 62.5 DEG
MPTBL(7, 6) = 1.095: MPTBL(7, 7) = 1.119: MPTBL(7, 8) = 1.147: MPTBL(7, 9) = 1.178: MPTBL(7, 10) = 1.211: MPTBL(7, 11) = 1.24
MPTBL(7, 12) = 1.262
MPTBL(7, 13) = 1.28: MPTBL(7, 14) = 1.294: MPTBL(7, 15) = 1.302: MPTBL(7, 16) = 1.31: MPTBL(7, 17) = 1.315: MPTBL(7, 18) = 1.316
MPTBL(8, 0) = 1.5: MPTBL(8, 1) = 1.4: MPTBL(8, 2) = 1.232: MPTBL(8, 3) = 1.134: MPTBL(8, 4) = 1.099: MPTBL(8, 5) = 1.094: REM 65.0 DEG
MPTBL(8, 6) = 1.111: MPTBL(8, 7) = 1.139: MPTBL(8, 8) = 1.165: MPTBL(8, 9) = 1.194: MPTBL(8, 10) = 1.232: MPTBL(8, 11) = 1.262
MPTBL(8, 12) = 1.291
MPTBL(8, 13) = 1.313: MPTBL(8, 14) = 1.326: MPTBL(8, 15) = 1.339: MPTBL(8, 16) = 1.345: MPTBL(8, 17) = 1.351: MPTBL(8, 18) = 1.353
MPTBL(9, 0) = 1.519: MPTBL(9, 1) = 1.414: MPTBL(9, 2) = 1.232: MPTBL(9, 3) = 1.13: MPTBL(9, 4) = 1.098: MPTBL(9, 5) = 1.092: REM 67.5 DEG
MPTBL(9, 6) = 1.109: MPTBL(9, 7) = 1.138: MPTBL(9, 8) = 1.165: MPTBL(9, 9) = 1.195: MPTBL(9, 10) = 1.232: MPTBL(9, 11) = 1.265
MPTBL(9, 12) = 1.295
MPTBL(9, 13) = 1.32: MPTBL(9, 14) = 1.337: MPTBL(9, 15) = 1.35: MPTBL(9, 16) = 1.36: MPTBL(9, 17) = 1.365: MPTBL(9, 18) = 1.37
MPTBL(10, 0) = 1.498: MPTBL(10, 1) = 1.386: MPTBL(10, 2) = 1.2: MPTBL(10, 3) = 1.109: MPTBL(10, 4) = 1.075: MPTBL(10, 5) = 1.07: REM 70.0 DEG
MPTBL(10, 6) = 1.087: MPTBL(10, 7) = 1.114: MPTBL(10, 8) = 1.14: MPTBL(10, 9) = 1.171: MPTBL(10, 10) = 1.209: MPTBL(10, 11) = 1.24
MPTBL(10, 12) = 1.27
MPTBL(10, 13) = 1.293: MPTBL(10, 14) = 1.311: MPTBL(10, 15) = 1.325: MPTBL(10, 16) = 1.337: MPTBL(10, 17) = 1.344: MPTBL(10, 18) = 1.349
MPTBL(11, 0) = 1.448: MPTBL(11, 1) = 1.326: MPTBL(11, 2) = 1.157: MPTBL(11, 3) = 1.064: MPTBL(11, 4) = 1.029: MPTBL(11, 5) = 1.02: REM 72.5 DEG
MPTBL(11, 6) = 1.037: MPTBL(11, 7) = 1.064: MPTBL(11, 8) = 1.091: MPTBL(11, 9) = 1.119: MPTBL(11, 10) = 1.156: MPTBL(11, 11) = 1.189
MPTBL(11, 12) = 1.217
MPTBL(11, 13) = 1.24: MPTBL(11, 14) = 1.257: MPTBL(11, 15) = 1.268: MPTBL(11, 16) = 1.28: MPTBL(11, 17) = 1.287: MPTBL(11, 18) = 1.292
MPTBL(12, 0) = 1.36: MPTBL(12, 1) = 1.255: MPTBL(12, 2) = 1.087: MPTBL(12, 3) = 1.004: MPTBL(12, 4) = .968: MPTBL(12, 5) = .961: REM 75.0 DEG
MPTBL(12, 6) = .977: MPTBL(12, 7) = 1!: MPTBL(12, 8) = 1.026: MPTBL(12, 9) = 1.055: MPTBL(12, 10) = 1.087: MPTBL(12, 11) = 1.112
MPTBL(12, 12) = 1.149
MPTBL(12, 13) = 1.17: MPTBL(12, 14) = 1.19: MPTBL(12, 15) = 1.202: MPTBL(12, 16) = 1.212: MPTBL(12, 17) = 1.218: MPTBL(12, 18) = 1.221
MPTBL(13, 0) = 1.26: MPTBL(13, 1) = 1.167: MPTBL(13, 2) = 1.013: MPTBL(13, 3) = .932: MPTBL(13, 4) = .897: MPTBL(13, 5) = .891: REM 77.5 DEG
MPTBL(13, 6) = .906: MPTBL(13, 7) = .929: MPTBL(13, 8) = .957: MPTBL(13, 9) = .98: MPTBL(13, 10) = 1.012: MPTBL(13, 11) = 1.04
MPTBL(13, 12) = 1.066
MPTBL(13, 13) = 1.088: MPTBL(13, 14) = 1.109: MPTBL(13, 15) = 1.121: MPTBL(13, 16) = 1.132: MPTBL(13, 17) = 1.14: MPTBL(13, 18) = 1.145
MPTBL(14, 0) = 1.153: MPTBL(14, 1) = 1.071: MPTBL(14, 2) = .933: MPTBL(14, 3) = .858: MPTBL(14, 4) = .826: MPTBL(14, 5) = .82: REM 80.0 DEG
MPTBL(14, 6) = .837: MPTBL(14, 7) = .853: MPTBL(14, 8) = .881: MPTBL(14, 9) = .908: MPTBL(14, 10) = .933: MPTBL(14, 11) = .961
MPTBL(14, 12) = .982
MPTBL(14, 13) = 1.007: MPTBL(14, 14) = 1.025: MPTBL(14, 15) = 1.039: MPTBL(14, 16) = 1.049: MPTBL(14, 17) = 1.055: MPTBL(14, 18) = 1.06
REM *****
REM BASE-FIRST PENETRATION COMPUTATION M'(OB) VALUES
REM MPNF(0)-MPNF(2) AT 67.5 DEG; ADD MPNF(3)-MPNF(5) AT 65 DEG
MPNF(0) = 1.519: MPNF(1) = 1.414: MPNF(2) = 1.232: MPNF(3) = 1.134: MPNF(4) = 1.099: MPNF(5) = 1.094
REM *****
RETURN
REM **********
REM USE TABLE'S THICKNESS INCREMENT TO COMPUTE THE EFFECT THAT THICKNESS HAS ON M' USING LINEAR INTERPOLATION
900 : MPTH0 = MPTBL(C1 + N, T1): MPTH1 = MPTBL(C1 + N, T1 + 1): MPVAL = MPTH0 + T2 * (MPTH1 - MPTH0)
RETURN
REM **********
REM COMPUTE NOSE-FIRST PENETRATION NBL WHEN NOT TRUE NBL USING MPNF(T/D) TABLE (UP TO T/D=0.25 AND OB FROM 65-67.5 DEG TO 80 DEG)
1000 : IF ((TSLASHD > .1) AND (TSLASHD < .25) AND (OB > 65)) THEN GOTO 1010: REM 65 DEG M' IS MAXIMUM VALUE
IF ((TSLASHD <= .1) AND (OB > 67.5)) THEN GOTO 1010: REM 67.5 DEG M' IS MAXIMUM VALUE (SAME AS 65 DEG VALUE AT T/D=0.1)
REM ****
NBLNF = NBLALL: NBLNFRNDED = NBLALLRNDED: RETURN: REM NL IS ALWAYS NLNF OUTSIDE DEFINED REGION
REM ****
REM NOSE-FIRST NL (NLNF) AT HIGHER VELOCITY THAN ACTUAL NL, WHICH IS FOR BASE-FIRST PENETRATIONS IN DEFINED REGION
1010 : MPRNF0 = MPNF(T1): MPRNF1 = MPNF(T1 + 1)
MPRIMEMAX = MPRNF0 + T2 * (MPRNF1 - MPRNF0): REM M' FOR 65 (T/D>0.1) OR 67.5 DEG (T/D=0-0.1) (MAXIMUM VALUE)
MPRIMENF = MPRIMEMAX - (MPRIMEMAX - MPRIME) * (TSLASHD / .25): REM AT T/D=0.25 AND UP, ALL NLNF VALUES MERGE WITH ACTUAL NL VALUES
NBLNF = (MPRIMENF / MPRIME) * NBLALL: NFTMP = NBLNF + .5: NBLNFRNDED = INT(NFTMP)
RETURN
REM **********
REM COMPUTE EFFECTIVE V'MIN(OB) FOR OB OVER 45 DEG FOR VR CALCULATION WHEN NOSE-FIRST PENETRATIONS OCCUR
1100 : E1 = 1 + (OB - 45!) / 45!: REM FRACTION OF OB OVER 45 DEG
E2 = 2 * SIN(OBRAD) * CSOB: REM (1/DEFLECTION AT 45 DEG) TIMES (DEFLECTION AT OB WHEN VS IS THE NOSE-FIRST NL)
E3 = E1 / E2: E4 = SQR(2 * E3 - 1) / E3
VMIN = E4 * NBLALL: VMINTMP = VMIN + .5: VMINRNDED = INT(VMINTMP)
RETURN
REM **********
REM COMPUTE EXIT ANGLE EX FROM STRIKING VELOCITY, OBLIQUITY, AND NBL VALUES
1200 : IF (OB > .005) THEN 1210
EX = 0: EXRAD = 0: EXRNDED = 0: DF = OB: DFRAD = OB / 57.29578: RETURN: REM PREVENT DIVIDE-BY-ZERO ERROR
REM ****
1210 : VRAT = VS / VMIN: IF (VRAT < 1) THEN VRAT = 1: REM PREVENT ROUND-OFF ERROR
TMPV = VRAT ^ 2 - 1: TMPVEL = VRAT ^ 2 + VRAT * SQR(TMPV)
SNCSTST = SIN(OBRAD) * CSOB: SNCS = SNCSTST: REM NOSE-FIRST PENETRATION AT ALL OB VALUES
REM ****
REM CHECK FOR AND FLAG BASE-FIRST PENETRATION AT OB>45, IF IT OCCURS
IF (BFPEN = 1) THEN SNCS = SIN(RAD45) * COS(RAD45)
REM ****
REM CALCULATE DEFLECTION ANGLE DF (SYMMETRICAL ABOUT OB=45 IF NOSE-FIRST PENETRATION)
TMPDF1 = SNCS / TMPVEL: TMPDF2 = 1 - 4 * TMPDF1 ^ 2
TANDF = (1 - SQR(TMPDF2)) / (2 * TMPDF1): REM TRIG IDENTITY FOR TANGENT OF DF
DF = ATN(TANDF) * 57.29578
REM ****
REM CHECK FOR BASE-FIRST PENETRATION WHEN OB>45
IF (SNCS <> SNCSTST) THEN OBM45 = (OB - 45!) / 45!: DF = DF * (1 + OBM45): REM EX IS ZERO AT NBL IN THIS CASE
REM ****
DFRAD = DF / 57.29578: DFTMP = 10 * DF + .5: DFRNDED = INT(DFTMP) / 10: REM RADIANS REQUIRED IN ALL BASIC TRIG FUNCTIONS
EX = OB - DF: EXRAD = EX / 57.29578: EXTMP = 10 * EX + .5: EXRNDED = INT(EXTMP) / 10
RETURN
REM **********
REM YES/NO ANSWER SUBROUTINE ("YESNO = 1" MEANS "YES" ELSE "NO")
1500 : YN$ = INKEY$: IF (YN$ = "") THEN 1500: REM WAIT FOR USER ENTRY
IF (YN$ = "Y") OR (YN$ = "y") THEN PRINT "Yes": YESNO = 1: RETURN
IF (YN$ = "N") OR (YN$ = "n") THEN PRINT "No": YESNO = 0: RETURN
GOTO 1500: REM ALL OTHER INPUTS ARE ILLEGAL (IGNORE)
REM **********
REM  ANY KEY ANSWER SUBROUTINE
1600 : YN$ = INKEY$: IF (YN$ = "") THEN 1600: REM WAIT FOR USER ENTRY
RETURN: REM ANY INPUT LEGAL
REM **********
REM *** >>> END OF PROGRAM LISTING <<< ***

