' >>>>**** FACE-HARDENED ARMOR PENETRATION PROGRAM BY NATHAN OKUN ****<<<<
'               >>>>**** VERSION 6.9 OF 4 MARCH 2012 ****<<<<
'      >>>>**** 2ND PRINT & SUBPROGRAM MODULE "FH69SBM2.BAS" ****<<<<
'
'  THE FOLLOWING MUST BE IDENTICAL AT TOP OF ALL MODULES OF THIS PROGRAM !!
'
COMMON SHARED NATION, PROJ, ARMOR, SC, D, PENTP, OLDVALUE, NEWVALUE, CMT, VXP
COMMON SHARED Q, QDAM, UB, CARTWL, CMPND, SOFTSHAT, THNCHL, MSHAT, CRTGD
COMMON SHARED TA, UBMAN, UBCALC, TPCAL, THIN, YS, MTLBACK, TRUTHIN, PSHMAX
COMMON SHARED TD, LCMOD, POLMOD, POIMOD, SHAT, CART, VS, OB, OBRAD, EX, EXRAD
COMMON SHARED VLMT, VLSHAT, VLTRU, VITRU, TOTPLUGWT, NORMPLUGWT, DELTAPLUGWT
COMMON SHARED UBSV, QSV, QDAMSV, CARTWLSV, CMPNDSV, THNCHLSV, SOFTSHATSV, HF
COMMON SHARED CRITAGL, SHATRES, NSDAMAGL, BRAAK, APCAP, LTCASE, PLIM, PDAM
COMMON SHARED ALD, BLD, CLD, AED, BED, CED, NDAP, BRK, NSBRK, BDYDM, BEND, WT
COMMON SHARED BKEFF, PNL, PNI, PNLSHAT, CARDONALD, PNLPR, VHSHAT, PENFLG, VLND
COMMON SHARED VDFSTD, VDFUSED, VDFSTDWW1, VDFSTDWW2, VSCRIT, CAPHD, OBCRIT, WB
COMMON SHARED VHOL, WTSAVE, BRAIK, VDFBND, VDFBRK, MAXDIFF, SNCSMAX, OBDF, MO
COMMON SHARED THKTHN, THKTHNSV, MINEV, MINEV1, MINEV2, MINEV3, MINEV4, MINEV5
COMMON SHARED NVRFLAG, MAXOB, THVAL, THSPD, HARD, WD, VHTRU, CRTAPR, MTMP, VR
COMMON SHARED CURV, CRVRL, CRVFLAG, VRATMIN, VHEXREV, VLEXREV, VHDAM, VLDAM
COMMON SHARED VRAT, VRATVEL, EXMIN, TMPOBDF, NSSHAT, VNPLUG, VDPLUG, VRSHATNS
COMMON SHARED OB45, OB45CALC, VHSHATMAX, VLSHATMAX, CRITVEL, SHATVDF, NOTEFLAG
COMMON SHARED VDFUSEDPR, VRPR, VHND, EXTH, OBRK, TCAL, NSTEST, NSTESTV, SAMPRJ
COMMON SHARED OPRIMEL, OPRIMED, OBPRNT, EXPRNT, MTMPCR, MTMPNS, VCNT, FLAG
COMMON SHARED WTSVPRNT, WTPRNT, WBPRNT, SOFTQPMAX, MINSHVEL, PENCONST#, TEFF
COMMON SHARED SHATMULT, VTOTAL, UBFLAG, VDFHARVEY, SHATPRT, SAMEPLATE, VSCHECK
COMMON SHARED NBL1$, NBL2$, NBL3$, NBL4$, NBL5$, NBL6$, NBL7$, RESNOTE$, PSL$
COMMON SHARED HBL1$, HBL2$, HBL3$, HBL4$, HBL5$, HBL6$, HBL7$, HBL8$, HBL9$, ND$
COMMON SHARED PAND$, FLAKE$, CAP$, REMV$, NOTE1$, NOTE2$, NOTE3$, NOTE4$, NOTE5$
COMMON SHARED BDYDM1$, BDYDM2$, BDYDM3$, NSBRK1$, NSBRK2$, NSBRK3$, BD1$, BD2$
COMMON SHARED BKPRT1$, BKPRT2$, BKPRT3$, BKPRT4$, BKPRT5$, CALC$, EBL$, EFFVEL$
COMMON SHARED HBLTONBL$, N1$, N2$, N3$, N4$, H1$, H2$, H3$, H4$, PRJ$, NATN$
COMMON SHARED VELLTRU$, VELLSHAT$, VELLSHATMAX$, VELLND$, EFFPRINT1$, BDYDM4$
COMMON SHARED VELHTRU$, VELHSHAT$, VELHSHATMAX$, VELHND$, EFFPRINT2$, BDYDM5$
COMMON SHARED YS$, PEN1$, PEN2$, WBL1$, WBL2$, WBL3$, WBL4$, VEL$, NOTE5A$
COMMON SHARED ONEPC$, RVU$, DPLG$, REMVEL$, BSNS1$, BSNS2$, BSNS3$, NOTE5B$
COMMON SHARED TWOVEL$, AMPER$, NOPLG$, PEN3$
DIM SHARED M(15), MS(17)
COMMON M(), MS()
'
' ** END OF MODULE-LEVEL "FH69SBM2.BAS" CODE **

SUB BACKPRINT STATIC
'
' PRINT METAL BACKING LAYER TYPES
'
PRINT : PRINT "Select general type of backing plate from the following table:": PRINT
BKNGT1$ = "Wrought Iron": BKNGQ1$ = " (Q = 0.6)"
BKNG1$ = BKNGT1$ + "                                                   " + BKNGQ1$: BKPRT1$ = BKNGT1$ + BKNGQ1$
BKNGT2$ = "Mild (Medium) Steel thru WWI": BKNGQ2$ = " (Q = 0.7)"
BKNG2$ = BKNGT2$ + "                                   " + BKNGQ2$: BKPRT2$ = BKNGT2$ + BKNGQ2$
BKNGT3$ = "High Tensile Steel thru WWI, Nickel Steel, Post-WWI Mild Steel": BKNGQ3$ = " (Q = 0.8)"
BKNG3$ = BKNGT3$ + " " + BKNGQ3$: BKPRT3$ = BKNGT3$ + BKNGQ3$
BKNGT4$ = "Post-WWI High Tensile Steel & British/Japanese Ducol (D) Steel": BKNGQ4$ = " (Q = 0.9)"
BKNG4$ = BKNGT4$ + " " + BKNGQ4$: BKPRT4$ = BKNGT4$ + BKNGQ4$
BKNGT5$ = "All Special Treatment (homogeneous Krupp-armor grade) Steels": BKNGQ5$ = " (Q = 1.0)"
BKNG5$ = BKNGT5$ + "   " + BKNGQ5$: BKPRT5$ = BKNGT5$ + BKNGQ5$
PRINT " 1. " + BKNG1$: PRINT " 2. " + BKNG2$: PRINT " 3. " + BKNG3$
PRINT " 4. " + BKNG4$: PRINT " 5. " + BKNG5$
PRINT
'
'  ** END OF SUB BACKPRINT **
'
END SUB

SUB CHGARMRPRNT STATIC
'
' PRINT A MESSAGE IF ARMOR HAS HAD ANY DEFAULT VALUES CHANGED BY USER.
'
PRINT
ARMRCHGD = 0
IF ((ARMOR = 1) OR (ARMOR = 3) OR (ARMOR = 4) OR (ARMOR = 12)) THEN
  IF (UBMAN > 0) THEN ARMRCHGD = 1
ELSE
  IF (UB <> UBSV) THEN ARMRCHGD = 1
END IF
IF ((QSV <> Q) OR (QDAMSV <> QDAM)) THEN
   ARMRCHGD = 1
ELSEIF ((CARTWLSV <> CARTWL) OR (CMPNDSV <> CMPND)) THEN
   ARMRCHGD = 1
ELSEIF ((THNCHLSV <> THNCHL) OR (SOFTSHATSV <> SOFTSHAT)) THEN
   ARMRCHGD = 1
ELSEIF (THKTHNSV <> THKTHN) THEN
   ARMRCHGD = 1
END IF
IF (ARMRCHGD = 1) THEN
  PRINT "ARMOR HAS BEEN CHANGED FROM DEFAULT PARAMETERS.  USER-ENTERED CHANGES"
  PRINT "ARE ONLY PRESERVED FOR NEXT IMPACT IF PLATE TYPE & THICKNESS UNCHANGED."
END IF
'
'  ** END OF SUB CHGARMRPRNT **
END SUB

SUB DAMAGESETUP STATIC
'
' SET UP TO PRINT PROJECTILE DAMAGE MESSAGES
'
'**
'HARVEY ARMOR VS MIDVALE PRE-UNBREAKABLE TOUGH-STEEL PROJ
SUBEND = 0
IF (NSBRK = 8) THEN
  EFFPRINT1$ = " HOLING BL (TOUGH PROJ VS HARVEY ARMOR)"
  SUBEND = 1
END IF
IF (SUBEND = 1) THEN EXIT SUB
'**
'
IF ((CRVFLAG = 1) AND ((MINEV <= 0) OR (MINEV >= VHOL))) THEN
'NOTE: IF NOT TRUE, THEN PROJ ALREADY EFFECTIVE WHEN CURVED-PLATE RULE BEGINS AT HBL (SKIP LOGIC)
'CURVED-PLATE RULE APPLIED
  IF ((MINEV = 0) OR (MINEV1 = -1) OR (MINEV3 = -1)) THEN
    MINEV = 0: NOTEFLAG = 2: 'REGULAR CURVED-PLATE RULE FORCES NOSE-ONLY SHATR
  ELSEIF ((MINEV > VHOL) AND (MINEV <= VLMT)) THEN
    NOTEFLAG = 3: 'CURVED-PLATE RULE LOWERS EFFECTIVE LIMIT TO HBL
  ELSEIF (MINEV > VLMT) THEN
    NOTEFLAG = 4: 'GAP EXISTS BETWEEN EFFECTIVE LIMIT AND CURVED-PLATE RULE VEL REGION
  END IF
END IF
'
IF (LTCASE > 0) THEN
'LARGE-CAVITY PROJ
  IF (SHAT = 1) THEN
    EFFPRINT1$ = " NEVER (NOSE SHATTER REACHES CAVITY)"
    GOTO SOFTSHATRULE: 'NOSE-ONLY SHATR DOES NOT PREVENT CAVITY DAMAGE OF A LIGHTCASE PROJ
  END IF
  IF ((MINEV2 > 0) AND (MINEV = MINEV2)) THEN
    NSFLG = 1: NOTEFLAG = 0: 'ALL NOSE BREAKAGE OF A LIGHTCASE PROJ CAUSES LOSS OF EFFECTIVENESS
  END IF
END IF
'*
'EFFECTIVE PROJ
'
IF (NOTEFLAG >= 2) THEN
'CURVED-PLATE RULE
  IF (NOTEFLAG = 4) THEN
    EFFVEL$ = VEL$
    IF (VHOL <= 4000) THEN PAND$ = " *AND*"
  END IF
  IF (((NOTEFLAG = 2) OR (NOTEFLAG = 4)) AND (VHOL <= 4000)) THEN
    HBLTONBL$ = " BETWEEN HOLING BL & NAVY BL (SEE BELOW)"
    GOTO CRVPLATERULE: 'REGULAR RULE USE
  END IF
END IF
'
IF (NOTEFLAG = 3) THEN
  MINEV = VHOL: 'MIN EFFECTIVE LIMIT LOWERED TO HBL BY CURVED-PLATE RULE
ELSE
  IF ((MINEV = 0) AND (MINEV1 <> -1) AND (MINEV3 <> -1)) THEN
    EFFPRINT1$ = " USUALLY EFFECTIVE (CAVITY IMMUNE TO NOSE DAMAGE)"
    GOTO SOFTSHATRULE
  END IF
END IF
'
IF ((MINEV = 0) AND (MINEV1 = -1)) THEN
  EFFPRINT1$ = " NEVER (COMPLETE SHATTER)"
  GOTO ENDSPG: 'EXIT
END IF
'
IF (MINEV3 = -1) THEN
  NVRFLAG = 1
  EFFPRINT1$ = " RARELY EFFECTIVE.  EXCEEDS BREAKAGE ANGLE (DEGREES):"
  GOTO ENDSPG: 'EXIT
END IF
'
IF ((HARD = -1) AND (SHATRES < 2) AND (MINEV <= VLMT)) THEN
  EFFPRINT1$ = " NAVY BL"
  NVRFLAG = 0: NSFLG = 1
ELSEIF ((MINEV <> VLMT) AND (MINEV > VHOL)) THEN
  EFFVEL$ = VEL$
ELSE
  IF (MINEV = VLMT) THEN
    EFFPRINT1$ = " NAVY BL"
  ELSE
    EFFPRINT1$ = " HOLING BL"
    IF (NOTEFLAG = 3) THEN
      EFFPRINT2$ = " (DUE TO CURVED PLATE) (SEE BELOW)"
      GOTO CRVPLATERULE
    END IF
  END IF
END IF
'
IF (NVRFLAG = 0) AND (NSFLG = 1) THEN EFFPRINT2$ = " (NOSE DAMAGE REACHES CAVITY)"
'
GOTO SOFTSHATRULE
'*
CRVPLATERULE:
' PRINT OUT CURVE PLATE RULE ON SCREEN OR ON PAPER WHEN IT APPLIES
'
NOTE1$ = "SPECIAL CURVED-PLATE RULE FOR BODY DAMAGE:"
NOTE2$ = " Strong steel projectiles frequently remain effective against curved plates at"
NOTE3$ = " over 45 degrees obliquity if Striking Velocity is between Holing BL & Navy BL."
IF (SHAT = 1) THEN
  NOTE4$ = " Complete shatter of this projectile will occur otherwise."
ELSEIF (BEND = 1) AND (OB >= OBCRIT) AND (CARDONALD = 0) THEN
  NOTE4$ = " Complete breakup of this projectile will occur otherwise."
ELSE
  IF (MINEV = VHOL) THEN
    NOTE4$ = " Other effects keep projectile effective above Navy BL."
  END IF
END IF
'*
GOTO ENDSPG: 'EXIT
'*
SOFTSHATRULE:
IF (NOTEFLAG = 1) THEN
  IF (HARD = 1) THEN
    NOTE1$ = "SPECIAL SOFT CAP & EXTRA-TOUGH PLATE NOSE-ONLY SHATTER RULE:"
  ELSE
    NOTE1$ = "SPECIAL HOOD & NOT-EXTRA-TOUGH PLATE NOSE-ONLY SHATTER RULE:"
  END IF
  NOTE2$ = "Nose-only shatter if Complete Penetration @ OB<=15deg, sometimes if 15<OB<20deg."
  NOTE3$ = "Complete shatter of this projectile against this armor will occur otherwise."
END IF
'*
ENDSPG:
' ** END OF SUB DAMAGESETUP **
END SUB

SUB DOCRTGOOD STATIC
' DO 'CRTGD' PASS-CRTAPR-CHECK LOGIC
'
IF ((NSBRK > 0) OR (PENFLG = 2)) THEN
'*
  IF ((CRTAPR <= 0) OR ((CRTAPR > 0) AND ((OB - EX) >= CRTAPR)) OR ((SHAT = 1) AND (HARD <> 2))) THEN GOTO SKIPVMOD: 'TEST FAILED
'*
  CRTGD = 1: 'PERFORMED & PASSED 'CRITAGL'/'NSDAMAGL' COMBINED TEST
'*
'MUST REVISE REMAINING VELOCITY CALC IF 'CRITAGL'/'NSDAMAGL' COMBINED TEST PASSED
  VHDAM = VHND: VLDAM = VLND
  IF (VHDAM > VHSHATMAX) THEN
    VHDAM = VHSHATMAX
  END IF
  IF (SHAT = 1) THEN
'JAP UNCAPPED TYPE 91 AP W/CAP HEAD IN PLACE
    VLDAM = VLSHATMAX
  END IF
  IF (H1$ = "-!#-") THEN
    H4$ = "-#-": H1$ = "-!-": ''VHND' REPLACES 'VHOL' FOR POST-IMPACT CALC
  ELSEIF (H2$ = "-!#-") THEN
    H3$ = "-#-": H2$ = "-!-": ''VHSHATMAX' REPLACES 'VHOL' FOR POST-IMPACT CALC
  END IF
  IF (N1$ = "-!#-") THEN
    N4$ = "-#-": N1$ = "-!-": ''VLND' REPLACES 'VLMT' FOR POST-IMPACT CALC
  ELSEIF (N2$ = "-!#-") THEN
    N3$ = "-#-": N2$ = "-!-": ''VLSHATMAX' REPLACES 'VLMT' FOR POST-IMPACT CALC
  END IF
SKIPVMOD:
ELSE
  CRTGD = 1: ''CRITAGL'/'NSDAMAGL' COMBINED TEST NOT DONE & LOWER BODY ASSUMED OK
END IF
'
IF ((PENFLG > 0) AND (CRTGD = 0)) THEN BRK = 4
'
' ** END OF SUB DOCRTGOOD **
END SUB

SUB FACECALC STATIC

' CALCULATE VARIABLE BACK LAYER THICKNESS (UB) FOR GRUSON CHILLED CAST IRON,
' HARVEY ARMOR (BOTH TYPES), & WWII ITALIAN TERNI CEMENTED ARMORS

IF (ARMOR = 1) THEN
' GRUSON ARMOR
  IF (TA <= 15.75) THEN
    UBCALC = 45: 'MINIMUM BACKING LAYER THICKNESS
  ELSEIF (TA >= 33.07) THEN
    UBCALC = 67: 'THICKEST PLATE KNOWN (84CM) W/MAX BACK LAYER THICKNESS
  ELSE
    UBCALCTMP = 45 + 22 * (TA - 15.75) / 17.32: 'LINEAR INCREASE FROM 45% TO 67% UNAFFECTED BACK ASSUMED
    UBCALC = INT(UBCALCTMP): 'MATCH INTERNAL VALUE TO DISPLAYED VALUE (ROUND DOWN TO WHOLE NUMBER)
  END IF
ELSEIF ((ARMOR = 3) OR (ARMOR = 4)) THEN
' HARVEYIZED STEEL (3 = MILD STEEL & 4 = NICKEL-STEEL)
  UBCALCTMP = 100 * (1 - (1.25 / TA)): 'FIXED 1-1.5" FACE LAYER THICKNESS (USE AVERAGE)
  UBCALC = INT(UBCALCTMP): 'MATCH INTERNAL VALUE TO DISPLAYED VALUE (ROUND DOWN TO WHOLE NUMBER)
ELSE
' TERNI ARMOR
  IF (TA < 6.2205) THEN
    UBCALC = 50: 'BB SECONDARY GUN MOUNTS & OTHER LIGHT ARMOR (13CM = 5.1181" PLATE KNOWN)
  ELSEIF (TA > 10.433) THEN
    UBCALC = 70: 'BB BELT & BARBETTE/TURRET/CONNING TOWER & OTHER HEAVY ARMOR (28CM = 11.0236" PLATE KNOWN)
  ELSE
' SHAPE OF FACE THICKNESS CURVE BETWEEN 13CM & 28CM NOT KNOWN.  ASSUME SIMPLEST CURVE THAT DOES NOT CAUSE PROBLEMS.
    FACE = 3.1102 + (.004682) * (TA - 6.2205):   'VALUES USED PREVENT ERROR AT EITHER 50 OR 70 BOUNDARY
    UBCALCTMP = 100 * (1 - (FACE / TA)): 'ALL INTERMEDIATE PLATES (NEARLY CONSTANT FACE THICKNESS)
    UBCALC = INT(UBCALCTMP): 'MATCH INTERNAL VALUE TO DISPLAYED VALUE (ROUND DOWN TO WHOLE NUMBER)
  END IF
END IF

' ** END OF SUB FACECALC **

END SUB

SUB GETPLATETHICKNESS STATIC
'
' INPUT AND STORE ACTUAL PLATE THICKNESS
'
THICKNESS:
IF (TA > 0) THEN PRINT "CURRENT ACTUAL PLATE THICKNESS ="; TA; "inches"
INPUT "Armor plate actual thickness at impact center (TA), inches: ", TA$
IF ((TA$ = "") AND (TA > 0)) THEN
  PRINT "Using"; TA
  SAMEPLATE = 2
ELSE
  TATEST = TA: TA = VAL(TA$)
  IF (TATEST = TA) THEN SAMEPLATE = 2
END IF
IF (TA <= 0) THEN SAMEPLATE = 0: GOTO THICKNESS: 'BAD INPUT
'

'  ** END OF SUB GETPLATETHICKNESS **
END SUB

SUB GETPROJDWTWB STATIC
'
' PRINT OLD D, WT, WB AND ASK USER FOR NEW VALUES.  SET/CLEAR 'CAPHD' FLAG
IF (D > 0) THEN
  PRINT "CURRENT PROJECTILE DIAMETER ="; D; "inch";
  IF (D > 1!) THEN PRINT "es":  ELSE PRINT
END IF
DIAMETER:
INPUT "Projectile diameter (D), inches: ", PRJD$
IF ((PRJD$ = "") AND (D > 0)) THEN
  PRINT "Using"; D
ELSE
  D = VAL(PRJD$)
END IF
IF (D <= 0) THEN GOTO DIAMETER: 'BAD INPUT
IF (WTSAVE > 0) THEN
  PRINT "CURRENT PROJECTILE TOTAL WEIGHT ="; WTSAVE; "pound";
  IF (WTSAVE > 1!) THEN PRINT "s":  ELSE PRINT
END IF
TOTALWT:
INPUT "Projectile total weight (WT), pounds: ", WT$
IF ((WT$ = "") AND (WTSAVE > 0)) THEN
  PRINT "Using"; WTSAVE: WT = WTSAVE
ELSE
  WT = VAL(WT$): WTSAVE = WT
END IF
IF (WT <= 0) THEN GOTO TOTALWT: 'BAD INPUT
CAPHD = 0: 'RESET 'CAP HEAD' FLAG
IF ((NATION = 6) AND (PROJ >= 8)) THEN
'JAP TYPE 88/91 AP/APC PROJ W/'CAP HEAD' LOGIC: UNCAPPED(AP)=10 & CAPPED(APC)=8 & 9
  IF (PROJ = 10) THEN
    CAPHD = 1: 'UNCAPPED 15.5/20.3CM TYPE 91 AP (20CM TYPE 88 HAS AP CAP, I THINK)
    PRINT "'CAP HEAD' IS NOT PART OF BODY BECAUSE IT SHATTERS BEFORE NOSE DOES."
  ELSE
    CAPHD = 2: 'CAPPED TYPE 88/91/1 AP
  END IF
END IF
IF (WB > 0) THEN
  PRINT "CURRENT PROJECTILE BODY WEIGHT ="; WB; "pound";
  IF (WB > 1!) THEN PRINT "s":  ELSE PRINT
END IF
BODYWT:
INPUT "Projectile body weight (WB), pounds (Maximum=WT & Minimum=WT/2): ", WB$
IF ((WB$ = "") AND (WB >= WT / 2) AND (WB <= WT)) THEN
  PRINT "Using"; WB
ELSE
  WB = VAL(WB$)
END IF
IF ((WB < (WT / 2)) OR (WB > WT)) THEN GOTO BODYWT: 'BAD INPUT
PRINT
'ALWAYS COMPUTE SOFT CAP OR HOOD EXTRA ENERGY LOSS EVEN IF NOT USED
SOFTQPTMP = 1! - (1.1 * ((WT - WB) / WT) - .0268): 'MAXIMUM QUALITY FOR SOFT-CAPPED OR HOODED PROJ
SOFTQPTEMP = INT(1000 * SOFTQPTMP + .5): SOFTQPMAX = SOFTQPTEMP / 1000
IF (SOFTQPMAX > 1!) THEN SOFTQPMAX = 1!: 'QUALITY CANNOT BE IMPROVED BY A SMALL SOFT CAP OR HOOD
'
' ** END SUB GETPROJDWTWB **
END SUB

SUB GRSNHRVYTC STATIC

' GRUSON (ARMOR = 1) OR HARVEY (ARMOR = 3 OR 4) OR TERNI CEMENTED (ARMOR = 12)
' ARMOR FACE THICKNESS LOGIC
'
PRINT
IF (ARMOR = 1) THEN
  PRINT "Gruson Armor Back Layer Percent (UB) varies linearly (estimate) from a minimum"
  PRINT "of 45% if TA <= 15.75 inches to a maximum of 67% if TA >= 33.07 inches (84cm,"
  PRINT "the thickest known Gruson plate ever made)."
ELSEIF ((ARMOR = 3) OR (ARMOR = 4)) THEN
  PRINT "Harveyized Armor (Mild Steel or Ni-Steel) has thin (1-1.5-inch) 'Cemented' face"
  PRINT "layer made by carburizing the face against hot charcoal or flaming natural gas"
  PRINT "for a couple of weeks & then chilling that face so only it gets very hard while"
  PRINT "the rest of the plate is not changed much.  Limited shatter-causing ability."
ELSE
  PRINT "Terni Cemented Armor Back Layer Percent (UB) varies linearly (estimate) from a"
  PRINT "minimum of 50% if TA < 6.2205 inches to a maximum of 70% if TA > 10.433 inches."
  PRINT "Between these two boundaries, face thickness is very close to constant for all"
  PRINT "plate thicknesses.  The simplest estimate between known 13cm & 28cm TC plates."
END IF
PRINT "UB values calculated are rounded down to the nearest whole percent."
PRINT "  CURRENT PLATE BACK LAYER FROM 'UB' DEFAULT CALCULATION (%) ="; UBCALC
PRINT "  CURRENT MANUAL 'UB' OVERRIDE VALUE (%) =";
IF (UBMAN <> 0) THEN PRINT UBMAN:  ELSE PRINT " NONE (Default value in use)"
'

' ** END OF SUB GRUSONANDTC **
END SUB

SUB IMPACTPRNT STATIC
'
' PRINT PROJ IMPACT INFORMATION
'
PRINT "Projectile Diameter (Caliber)   ="; D; "inches -- Nation ="; NATION; "& Type ="; PROJ
PRINT "Projectile Striking Velocity    ="; VS; "ft/sec"
OBPRNT = INT(100 * OB + .5) / 100: EXPRNT = INT(100 * EX + .5) / 100
PRINT "Angles, degrees:  Obliquity     ="; OBPRNT; "& Exit =";
IF (EX >= 0) THEN PRINT EXPRNT:  ELSE PRINT " NOT DEFINED"
'
' NOSE COVERING LOSS INFO
IF (WB = WTSAVE) THEN
  REMV$ = "Projectile does not use any nose coverings by design."
ELSEIF (WT = WTSAVE) THEN
  REMV$ = "All projectile nose coverings intact and in place on impact."
ELSEIF (WT = WB) THEN
  REMV$ = "All projectile nose coverings stripped off by prior impact."
ELSEIF (CAPHD > 0) THEN
'PROJ WT ABOVE WB BUT BELOW ORIGINAL WT & SHELL HAS CAP HEAD (WINDSCREEN LOSS
'  ALWAYS TAKES CAP HEAD WITH IT)
  REMV$ = "Windscreen and Cap Head stripped off by prior impact.  AP cap intact."
ELSE
'PROJ WT ABOVE WB (SOMETHING STILL ON NOSE) BUT BELOW ORIGINAL WT (SOMETHING
'  WAS REMOVED PRIOR TO IMPACT) & SHELL HAS NO CAP HEAD
  IF (APCAP < 0) THEN CAP$ = "  Hood intact.":  ELSE CAP$ = "  AP cap intact."
  REMV$ = "Windscreen stripped off by prior impact." + CAP$
END IF
PRINT REMV$
'
WTSVPRNT = INT(100 * WTSAVE + .5) / 100: WTPRNT = INT(100 * WT + .5) / 100
WBPRNT = INT(100 * WB + .5) / 100
PRINT "Projectile Weights, pounds: Original="; WTSVPRNT; "*Impact="; WTPRNT; "*Body="; WBPRNT
'
'  ** END OF SUB IMPACTPRNT **
END SUB

SUB MINEVSHATCALC STATIC

' SHATR MINIMUM EFFECTIVE VELOCITY SORTING CALCULATION
'
IF (NSSHAT = 0) OR ((NSSHAT > 0) AND (LTCASE > 1)) THEN
' COMPLETE SHATR OR ANY SHATR OF LARGE-CAVITY (LIGHTCASE) PROJ
  MINEV1 = -1: ' COMPLETE SHATR FLAG
  NOTEFLAG = 0: ' NO-OP
ELSEIF (NSSHAT = 1) THEN
' NOSE-ONLY SHTR DUE TO SOFT CAP ON SOFTSHAT ARMOR
  MINEV1 = VLMT: ' PROJ BODY UNBROKEN AT SHATRD NBL
  NOTEFLAG = 1: ' SOFT CAP AND HOOD SHATR VS SOFTSHAT ARMOR
ELSEIF (NSSHAT = 2) THEN
' NOSE-ONLY SHATR DUE TO LOW IMPACT VEL
  MINEV1 = VHOL: ' PROJ USUALLY BREAKS UP WHEN NO HOLE MADE
  NOTEFLAG = 0: ' NO-OP
ELSEIF (NSSHAT = 3) THEN
' CURVED-PLATE RULE IN FORCE
  MINEV1 = -1: ' COMPLETE SHTR & CURVED-PLATE RULE FLAG
  NOTEFLAG = 0: ' NO-OP
ELSEIF (NSSHAT = 4) THEN
' NOSE-ONLY SHTR DUE TO HOOD ON NON-SOFTSHAT ARMOR
  MINEV1 = VLMT: ' PROJ UNBROKEN AT SHATRD NBL
  NOTEFLAG = 1: ' SOFT CAP AND HOOD SHATR VS SOFTSHAT ARMOR
END IF
'
' ** END OF SUB MINEVSHATCALC **
END SUB

SUB MODIFYVDF STATIC

' CHANGE THE HBL-TO-NBL VELOCITY RANGE FOR SPECIAL CASES

'DAMAGED-PROJ HBL ('VLTRU' IF NOT 'VHND') IS REPLACED BY 'VHSHAT' IF THIS HBL > 'VHSHAT'
'UNDAMAGED-PROJ HBL ('VLND') IS REPLACED BY 'VHSHATMAX' IF THIS HBL > 'VHSHATMAX'
'STANDARD WWI "15% THICKNESS DIFFERENCE RULE":  PLATE'S HBL = NBL OF A PLATE 15% THINNER;
'WWII PLATES ARE USUALLY MUCH TOUGHER & HAVE A NARROWER DIFFERENCE.
'AGAINST BRITISH DEFORMING PROJ, GAP IS NARROW TO 22.5 DEG & THEN WIDENS UNTIL REGULAR GAP USED ABOVE 45 DEG.
'PROJ THAT BREAK IF THEY DO NOT COMPLETELY PENETRATE HAVE 'VDFBRK' > 0 EXCEPT BRITISH-CPC-TYPE PROJ WHICH KEEP WWII-SIZE GAP
'BRITISH NON-CARDONALD DEFORMING ('VDFBND' > 0) PROJ MAY HAVE A NARROW OR WIDE NBL-TO-HBL DIFFERENCE (ESTIMATE HERE)
'*
VDFUSEDPR = VDFUSED: SHATVDFPR = VDFUSED: 'DEFAULT VALUES
'*
IF ((ARMOR = 3) OR (ARMOR = 4)) THEN
' HARVEYIZED STEEL ARMOR
  IF (TA >= 8) THEN
'FOR THINNER FACES (<= ~1.25/8 = 0.15625), PUNCHING THROUGH THE FACE DOES NOT
' FORM A PLUG THAT PUNCHES A HOLE THRU THE REST OF THE PLATE.  PLATE ACTS LIKE
' A HOMOGENEOUS PLATE IN THIS REGARD, WITH SMALL DIFFERENCE BETWEEN HBL & NBL.
' UNLIKE HOMOGENEOUS PLATE, THIS IS AT ALL OBLIQUITIES (NO LONG SLOT & SPUR
' AT HIGH OBLIQUITY).
    VDFTHIN = 0: 'NO CHANGE
  ELSE
'HARVEY BEGINS TO ACT LIKE A LITTLE KC ARMOR AS FACE PERCENT INCREASES IN THINNER PLATES
    VDFTHIN = -.023 * TA + .184
  END IF
  VHTRU = (1 - (VDFBRK + VDFTHIN)) * VLTRU
  VHND = (1 - (VDFBRK + VDFTHIN)) * VLND
'SHATR HBL IS RAISED (REDUCED PEN) FOR THESE PROJ, BUT NOT THE SHATR NBL
  VHSHAT = (1 - (VDFBRK + VDFTHIN)) * VLSHAT: VHSHAT = INT(VHSHAT): 'DITTO FOR SHATR HBL
  VHSHATMAX = (1 - (VDFBRK + VDFTHIN)) * VLSHATMAX: VHSHATMAX = INT(VHSHATMAX): 'DITTO FOR SHATR HBL
  VDFUSEDPR = VDFBRK + VDFTHIN
  IF ((VDFBRK + VDFTHIN) < SHATVDF) THEN SHATVDFPR = VDFBRK + VDFTHIN
ELSE
'ALL NON-HARVEY ARMOR
  IF ((VDFBND = 0) AND ((BRAIK = 0) OR (LTCASE = 2))) THEN
    VHTRU = (1 - VDFSTD) * VLTRU: 'DEFAULT AVERAGE NBL-TO-HBL DIFFERENCE FOR STRONGER, NON-DEFORMABLE PROJ OR 'LTCASE'=2 COLLAPSING PROJ BODY
    VHND = (1 - VDFSTD) * VLND
  ELSEIF (VDFBND > 0) THEN
    IF ((UB > 45) AND (UB < 70) AND (CART = 0) AND (SOFTSHAT = 1)) THEN
      VHTRU = (1 - (VDFSTD + VDFBND) / 2) * VLTRU: 'AVERAGE NBL-TO-HBL DIFFERENCE FOR DEFORMABLE PROJ & MEDIUM-THICKNESS FACE LAYERS
      VHND = (1 - (VDFSTD + VDFBND) / 2) * VLND
      VDFUSEDPR = (VDFSTD + VDFBND) / 2
    ELSE
      VHTRU = (1 - VDFBND) * VLTRU: 'AVERAGE NBL-TO-HBL DIFFERENCE FOR DEFORMABLE PROJ
      VHND = (1 - VDFBND) * VLND
      VDFUSEDPR = VDFBND
    END IF
  ELSE
'THIS IS THE AVERAGE NBL-TO-HBL DIFFERENCE FOR WEAK-BODIED PROJECTILES
' (EXCEPT BRITISH-CPC-TYPE) WHEN NO COMPLETE PEN OCCURS
    VHTRU = (1 - VDFBRK) * VLTRU
    VHND = (1 - VDFBRK) * VLND
'SHATR HBL IS RAISED (REDUCED PEN) FOR THESE PROJ, BUT NOT THE SHATR NBL
    VHSHAT = (1 - VDFBRK) * VLSHAT: VHSHAT = INT(VHSHAT): 'DITTO FOR SHATR HBL
    VHSHATMAX = (1 - VDFBRK) * VLSHATMAX: VHSHATMAX = INT(VHSHATMAX): 'DITTO FOR SHATR HBL
    VDFUSEDPR = VDFBRK
    IF (VDFBRK < SHATVDF) THEN SHATVDFPR = VDFBRK
  END IF
END IF
'
VHTRU = INT(VHTRU)
VHND = INT(VHND)
'
' ** END OF SUB MODIFYVDF **
END SUB

SUB NOSEBROKE STATIC

'UNSHATRD PROJ 'NSBRK > 0' SET LOGIC

'ALL FH PLATES USUALLY CAUSE NOSE DAMAGE (NOT SHATR HERE) IF VEL<NBL WHEN ANY OF THESE CONDITIONS APPLY:
' (1) PROJ BODY IS WEAK/BRITTLE (IMPLIES NOSE BRITTLE, TOO) & BREAKS IF IT DOES NOT
'     COMPLETELY PENETRATE PLATE ('BRAAK'>0)--INCLUDES ALL CHILLED CAST IRON PROJ ('SHATRES'=2)
' (2) PROJ HAS NO AP CAP ('HARD'=0) OR IT HAS ONLY A HOOD ('HARD'=-1) (LOW-GRADE SOFT AP CAP)
'     & HAS A WEAK BODY ('SHATRES' = 1) & IT HITS ARMOR OTHER THAN COMPOUND ARMOR ('CMPND'=0)
' (3) PLATE IS AN EXTRA-TOUGH (MOST POST-WWI) PLATE ('SOFTSHAT'=1)
'     & PROJ HAS A HOOD OR A SOFT AP CAP ('HARD'=-1 OR 1)
' (4) PLATE IS EXTRA-TOUGH BRITISH 1912-1930 ('SOFTSHAT'=2) & PROJ W/O HARD AP CAP
'     NOT MAX STRENGTH (NOT 'CARDONALD'=2)
' (5) OB>'NDAP' (FINAL CRIT NOSE DAM (OB-EX) THRESHOLD) & HITS WITH 'VS'<HBL ('PENFLG'=0)
' (6) HOLING PEN ('PENFLG'=1) & (OB-EX)>'NDAP' REGULAR LOGIC (ALSO USED FOR COMPLETE PEN)
' (7) PROJ 'VS'<HBL, NOT 'CARDONALD'=2 HOOD/SOFT-CAP MAX-STRENGTH TYPE,
'     & NEEDS EXTRA VEL TO HOLE ('VLMT'>'VLND')
' (8) OB>45 DEG NO MATTER WHAT

IF (NSBRK = 0) THEN
'IF SHATR 'NSBRK' = 2 ALREADY SET, IGNORE THIS LOGIC
  IF (BRAIK > 0) THEN
    IF (((ARMOR = 3) OR (ARMOR = 4)) AND (BEND = 2)) THEN
      NSBRK = 8: ' MIDVALE POST-1896 & PRE-UNBREAKABLE NOSE DEFORMED RATHER THAN BROKEN IF NO OTHER DAMAGE
    ELSE
      NSBRK = 1: ' WEAK-BODIED PROJ HAVE WEAK NOSES, TOO
    END IF
  END IF
' CHECK FOR OTHER NOSE DAMAGE THAT OVERRIDES DEFORMED NOSE RESULT
  IF (NSBRK <> 1) THEN
    IF ((HARD = -1) AND (SHATRES = 1) AND ((CMPND = 0) AND (ARMOR <> 3) AND (ARMOR <> 4))) THEN
      NSBRK = 4: ' HOODED COMMON PROJ NOSE BREAKAGE (ONLY WITH KC-TYPE ARMORS)
    ELSEIF ((ABS(HARD) = 1) AND (SOFTSHAT = 1)) THEN
      NSBRK = 5: ' ALL HOODED OR SOFT-CAPPED FULL AP PROJ NOSE BREAKAGE VS MAX-EXTRA-TOUGH PLATE
    ELSEIF ((ABS(HARD) = 1) AND (SOFTSHAT = 2) AND (CARDONALD < 2)) THEN
      NSBRK = 5: ' AVE HOODED OR SOFT-CAPPED FULL AP PROJ NOSE BREAKAGE VS BRIT 1912-30 EXTRA-TOUGH PLATE
    ELSEIF ((PENFLG = 0) AND (OB >= NDAP)) THEN
      NSBRK = 3: ' NO HOLE 'NDAP' CHECK
    ELSEIF ((PENFLG = 1) AND ((OB - EX) > NDAP)) THEN
      NSBRK = 3: ' HOLING 'NDAP' CHECK
    ELSEIF ((HARD > 1) AND (PENFLG = 0) AND (VLMT > VLND) AND (CARDONALD = 0)) THEN
      NSBRK = 6: ' IF HARD-CAPPED PROJ NEEDS HIGHER VEL TO MAKE HOLE, NOSE BREAKAGE IS PROBABLE CAUSE
    ELSEIF (OB > 45!) THEN
      NSBRK = 7
    END IF
  END IF
END IF

' ** END OF SUB NOSEBROKE **
END SUB

SUB NOSEDAM

'* NOSE DAMAGE CRITICAL OB MODIFICATION AND RESULTS CALC *
'
NDAP = NSDAMAGL: ''NSDAMAGL' VALUES ARE FOR AVERAGE WWI ARMOR, SO MODIFY THEM FOR OTHER KINDS OF ARMOR
IF (CMPND = 1) THEN
  NDAP = NDAP + 10: 'COMPOUND ARMOR IS WEAK
ELSEIF ((ARMOR = 3) OR (ARMOR = 4)) THEN
'HARVEY ARMOR FACE THICKNESS GETS VERY THIN
  IF (TA >= 8) THEN
'FACE LAYER CIRCA 12.5-18.75% (USING 1.25" FACE, SO USING 15.625%) AT 8"
'  & STEADILY DECREASES FROM THERE
    NDAP = NDAP + 10
  ELSE
'FACE LAYER UNDER 25% OF PLATE (AN OVER-5"-THICK PLATE), BUT OVER 15.625%
    IF (THNCHL = 1) THEN NDAP = NDAP + (5 + 5 * ((TA - 5) / 3))
  END IF
ELSEIF (THNCHL = 1) THEN
  NDAP = NDAP + 5: 'OTHER THIN CHILL ARMORS ARE ALSO WEAK, BUT NOT AS BAD
END IF
IF (SOFTSHAT = 1) THEN
  NDAP = NDAP - 10: ''SOFTSHAT' ARMOR IS MUCH BETTER THAN AVERAGE WWI ARMOR
ELSEIF (SOFTSHAT = 2) THEN
  NDAP = NDAP - 5: 'BRITISH WWI-ERA CA SHATTERS SOFT-CAPPED AP EXCEPT MIDVALE UNBREAKABLE
END IF
IF ((NDAP < 5) AND (NSDAMAGL > 0)) THEN NDAP = 5: 'USE A 5-DEGREE MIN ANGLE > 0
IF (NDAP < 0) THEN NDAP = 0: 'MIN ANGLE = 0

' ** END OF SUB NOSEDAM **
END SUB

SUB NSBDYDAMPRNT STATIC
' PRINT RESULTS OF PROJECTILE NOSE AND BODY DAMAGE COMPUTATIONS
'
BDYDM1$ = ""
BDYDM2$ = ""
BDYDM3$ = ""
BDYDM4$ = ""
BDYDM5$ = ""
NSBRK1$ = ""
NOPRNT = 0
'
SELECT CASE SHATPRT
  CASE 0
    PRINT "STANDARD SHATTER LOGIC USED"
  CASE 1
    PRINT "PLATE TOO THIN TO SHATTER PROJECTILE AT THIS OBLIQUITY"
  CASE 2
    PRINT "HARVEY ARMOR WILL NOT SHATTER THIS PROJECTILE"
  CASE 3
    PRINT "COMPOUND ARMOR WILL NOT SHATTER THIS PROJECTILE"
END SELECT
'
SELECT CASE BDYDM
  CASE 0
    IF (PENFLG = 2) THEN
' COMPLETE PENETRATION
      IF (NSBRK = 8) THEN
        BDYDM1$ = "Projectile nose upset and deformed, but little lower body damage from impact."
        BDYDM2$ = " It is still 'effective' and intact, other than losing nose coverings."
      ELSEIF ((NSBRK > 0) AND (NSBRK < 8)) THEN
        BDYDM1$ = "Projectile nose " + ND$ + " by impact, but lower body undamaged."
        BDYDM2$ = " It is only 'effective' if this nose damage does not reach explosive cavity."
        IF (ND$ <> "deformed") THEN
          BDYDM3$ = " Nose loses" + BD1$ + "33% body weight and what's left is much weaker."
        END IF
      ELSE
        BDYDM1$ = "Neither projectile nose nor lower body damaged by impact."
        BDYDM2$ = " It is still 'effective' and intact other than losing nose coverings."
      END IF
    ELSE
' EITHER NO HOLE OR ONLY A HOLE MADE
      IF (NSBRK = 8) THEN
        BDYDM1$ = "Projectile nose upset & deformed; usually only insignificant lower body damage."
      ELSEIF ((NSBRK > 0) AND (NSBRK < 8)) THEN
        BDYDM1$ = "Projectile nose " + ND$ + " so 50% chance of major internal lower body damage."
        IF (ND$ <> "deformed") THEN
          BDYDM3$ = " Nose loses" + BD1$ + "33% body weight and what's left is much weaker."
        END IF
      ELSE
' NSBRK = 0
        BDYDM1$ = "Projectile nose intact so usually insignificant lower body damage occurs."
      END IF
      BDYDM2$ = " It is still 'effective' unless lower body damage is major internal damage or if"
      BDYDM4$ = "  nose damage reaches explosive cavity, then projectile will not be effective."
      BDYDM5$ = " 'Major internal'=base plug/fuze broken, deep cracks or base pieces snapped off."
    END IF
  CASE 1
    IF (NSBRK = 0) THEN
      BDYDM1$ = "Projectile nose undamaged, but lower body damaged by impact."
    ELSEIF (NSBRK = 8) THEN
      BDYDM1$ = "Projectile nose upset and deformed and lower body damaged by impact."
    ELSE
      BDYDM1$ = "Projectile nose " + ND$ + " and lower body damaged by impact."
      IF (ND$ <> "deformed") THEN
        BDYDM3$ = " Nose loses" + BD1$ + "33% body weight and what's left is much weaker."
      END IF
    END IF
    IF (((SHATRES > 0) AND (CMPND = 0)) OR ((SHATRES = 2) AND (CMPND = 1))) THEN
      BDYDM2$ = " It is not 'effective' and lower body is always broken apart by impact."
      BDYDM3$ = "": ' NOSE DAMAGE NOT IMPORTANT HERE
      NOPRNT = 1
    ELSE
      BDYDM2$ = " It is not 'effective' and lower body always suffers major internal damage."
      BDYDM5$ = " 'Major internal'=base plug/fuze broken, deep cracks or base pieces snapped off."
      NOPRNT = 1
    END IF
  CASE 2
    BDYDM1$ = "Projectile nose " + ND$ + " and lower body damaged by impact."
    BDYDM2$ = " It is not 'effective' and lower body is always broken apart by impact."
    NOPRNT = 1
END SELECT
'
'CHECK FOR NOSE DAMAGE
IF ((NSBRK = 0) OR (NSBRK = 8)) THEN
  NSBRK1$ = "If any, only projectile nose coverings stripped off. Nose still in one piece."
ELSEIF ((NSBRK < 8) AND (NOPRNT = 0)) THEN
  IF (LTCASE > 0) THEN
    NSBRK1$ = " Projectile's large explosive cavity is 'ineffective' due to major nose damage."
  ELSE
    NSBRK1$ = " Projectile's small explosive cavity rarely affected by any nose breakage."
  END IF
END IF
'*
'**** PRINT IT ****
'*
PRINT BDYDM1$
PRINT BDYDM2$
IF (BDYDM4$ <> "") THEN PRINT BDYDM4$
IF (BDYDM5$ <> "") THEN PRINT BDYDM5$
'*
IF (NSBRK1$ <> "") THEN PRINT NSBRK1$
IF (BDYDM3$ <> "") THEN PRINT BDYDM3$

'  ** END SUB NSBDYDAMPRNT **
END SUB

SUB NUMVALHDR STATIC
'
PRINT "NUMERICAL VALUES:"
PRINT " 'UB'   = Percent Unhardened Back Layer (Scaling Factor step function logic)"
PRINT " 'Q'    = Relative Armor Resistance Quality (compared to best WWII armors)"
PRINT " 'QDAM' = Relative Armor Projectile Damaging Ability (ditto)"
PRINT "**Minimum value for 'Q' & 'QDAM' = 0.1.  Also, 'QDAM' can never exceed 'Q'.**"
PRINT "FLAGS:"
PRINT " 'CARTWL'   = If '1', brittle armor ejects huge plugs; if '2', at high OB only"
PRINT " 'CMPND'    = Compound Armor (never shatters steel projectiles)"
PRINT " 'THNCHL'   = Back layer over 75% of plate (reduced damage-causing ability)"
PRINT " 'SOFTSHAT' = Shatter soft-capped proj (='1'); except Midvale Unbreakable (='2')"
PRINT " 'THKTHN'   = Ductility lowers THIN boundary from .55 cal(0) to .45(2) or .35(1)"
PRINT "NOTE:  SEE PROGRAM LISTING OR DESCRIPTION DOCUMENT FOR DETAILS."

' ** END OF SUB NUMVALHDR **
END SUB

SUB PENPRINT (PNTP) STATIC
'
IF (SHAT = 1) THEN
  ND$ = "shattered"
ELSEIF (NSBRK = 8) THEN
  ND$ = "deformed"
ELSE
  ND$ = "broken"
END IF
REMVEL$ = "Proj Remaining Velocity: ": ONEPC$ = "": VTOTAL = 0
IF (SHAT = 1) THEN
  BD1$ = " at least "
  IF (BRK = 0) THEN BD1$ = " about ": 'NOSE-ONLY SHATR
ELSE
  BD1$ = " up to "
END IF
PEN1$ = "": PEN2$ = "": PEN3$ = "": BDYDM1$ = "": BDYDM2$ = "": BDYDM3$ = ""
NSBRK1$ = "": NSBRK2$ = "": NSBRK3$ = "": FLAKE$ = "": NOPLG$ = ""
WBL1$ = "": WBL2$ = "": WBL3$ = "": WBL4$ = "": TWOVEL$ = "": AMPER$ = ""
BSNS1$ = "": BSNS2$ = "": BSNS3$ = "": DPLG$ = "": RVU$ = ""

'
SELECT CASE PNTP
  CASE 0
    PEN1$ = "NO HOLING OF PLATE: Only impact shock & plate distortion damage behind plate"
    PEN2$ = " due to ductile plate &/or a plate backing layer (Projectile may be damaged)"
  CASE 1
    PEN1$ = "NO HOLING OF PLATE: Impact shock & plate distortion & thrown splinters cause"
    PEN2$ = " damage behind this brittle plate w/o any backing (Projectile may be damaged)"
  CASE 2
    PEN1$ = "PLATE HOLED AND NORMAL PLUG PUNCHED OUT, BUT INTACT PROJECTILE REJECTED"
    PEN2$ = " (No significant projectile damage suffered due to impact)"
    PEN3$ = " Proj might imbed in plate near NBL. If so, filler may cause damage thru plate."
  CASE 3
    PEN1$ = "PLATE HOLED AND NORMAL PLUG PUNCHED OUT, BUT DAMAGED PROJECTILE REJECTED"
    PEN2$ = " (If nose breaks up at OB<45 deg, part of nose (<= 33% body weight) penetrates)"
    PEN3$ = " Proj might imbed in plate near NBL. If so, filler may cause damage thru plate."
  CASE 4
    PEN1$ = "PARTIAL PENETRATION: Broken-up lower body (= 50% body weight) penetrates, but"
    PEN2$ = " projectile nose ricochets (Major damage behind plate if filler explodes/burns)"
  CASE 5
    PEN1$ = "PARTIAL PENETRATION: Broken-up nose & upper body (= 50% body weight) penetrate,"
    PEN2$ = " but projectile lower body rejected (Filler rarely has any effect behind plate)"
    PEN3$ = " Proj might imbed in plate near NBL. If so, filler may cause damage thru plate."
  CASE 6
    PEN1$ = "COMPLETE PENETRATION ACHIEVED: If Exit Angle > 0, Delta Plug pieces ejected"
    PEN2$ = " (If projectile is broken up, at least 80% of body weight exits plate back)"
END SELECT
PRINT PEN1$
PRINT PEN2$
IF (PEN3$ <> "") THEN PRINT PEN3$
' ** END OF SUB PENPRINT **
END SUB

SUB PENVRVPLGCALC STATIC

'DETERMINE 'PENTYP' & CALC REMAINING PLUG & PROJ VELOCITIES

'FOR PROJ LOWER/MIDDLE BODY PIECES AT HIGH OB BELOW NBL OR FOR ALL SHTRD BASE PIECES,
'   TOTAL PROJ WT ALWAYS USED IN NORMAL PLUG HOLE PUNCHING LOGIC.
'* VS >= NBL -- COMPLETE PEN *
''HF' = 1 MEANS NO UNSHTRD COMPLETE PEN (OB > 70 DEG)
IF ((HF = 1) OR (VS < VLMT)) THEN
'* VS < NBL -- HOLING ONLY *
  IF (OB < 45!) THEN
    IF ((SHAT = 0) OR ((SHAT = 1) AND (HARD = 2) AND (VS < VHSHAT) AND (VHOL < VHSHAT))) THEN
'UNSHATRD PROJ OR JAP UNCAPPED TYPE 91 AP W/CAP HEAD IN PLACE BELOW 'VHSHAT' (ACTS LIKE UNSHATRD PROJ)
      IF (BRK = 0) THEN
'PROJ REMAINS IN ONE PIECE OR HAS ONLY NOSE DAMAGE
        GOTO LTLPROJPEN
      ELSE
'* PROJ ASSUMED HERE TO BE BROKEN IN MIDDLE INTO AT LEAST 2 PIECES ON TOP OF ANY NOSE DAMAGE *
        PENTP = 5: VR = -1: VDPLUG = VRSHATNS: ''VRSHATNS' USED FOR ALL PARTIAL PEN
        GOTO ROUNDPLUG: 'EXIT
      END IF
    ELSE
'SHATRD PROJ
      IF (BRK = 0) THEN
        GOTO LTLPROJPEN: 'NOSE-ONLY SHATR
      ELSE
'* PROJ ASSUMED HERE TO BE BROKEN IN MIDDLE INTO AT LEAST 2 PIECES ON TOP OF ANY NOSE DAMAGE *
        PENTP = 5: VR = -1: VDPLUG = VRSHATNS: ''VRSHATNS' USED FOR ALL PARTIAL PEN
        GOTO ROUNDPLUG: 'EXIT
      END IF
    END IF
  ELSE
''OB'>=45 DEG
'* BASE/SIDE-FIRST HOLING W/NO DAMAGE, SHTR, OR LOWER/MIDDLE BODY DAMAGE *
'IF PROJ MIDDLE BODY BREAKS AT HIGH OB THEN ONLY LOWER BODY PIECES PEN,
'   BUT INCLUDES MOST OR ALL OF EXPLOSIVE FILLER.
    IF (BRK > 0) THEN
'* PROJ ASSUMED HERE TO BE BROKEN IN MIDDLE INTO AT LEAST 2 PIECES ON TOP OF ANY NOSE DAMAGE *
      PENTP = 4: VDPLUG = VRSHATNS: VR = -1
      GOTO ROUNDPLUG: 'EXIT
    ELSE
'* ONLY NOSE DAMAGE OCCURS SO NOTHING PENETRATES PLATE *
      GOTO LTLPROJPEN
    END IF
  END IF
'*
LTLPROJPEN:
'NONE OR FEW PROJ PIECES GO THRU PLATE
'*
  VR = -1: TOTPLUGWT = NORMPLUGWT: DELTAPLUGWT = 0
  IF (NSBRK > 0) THEN
    PENTP = 3: 'ONLY NOSE (33% OF PROJ BODY WEIGHT OR LESS) PENETRATES AT 'OB'<45 DEG
    IF (OB >= 45!) THEN
      VDPLUG = -1: 'NOTHING PENETRATES PLATE
    ELSE
      VDPLUG = 0: 'NOSE PIECES PENETRATE PLATE WITH VERY LOW REMAINING VEL
    END IF
  ELSE
    PENTP = 2: 'INTACT PROJ REJECTED/RICOCHETS
    VDPLUG = -1: 'NOTHING PENETRATES PLATE
  END IF
  GOTO ROUNDPLUG: 'EXIT
'*
ELSE
'*
'* COMPLETE PEN W/DELTA PLUG *
'DELTA PLUG, IF ANY, RIDES ON PROJ NOSE AT SAME VEL IN SAME DIRECTION.
'PROJ BASE VEL = 'VR' (SHTRD OR NOT) & SHTRD NOSE PIECES VEL IS 'VDPLUG'
''VDPLUG' = 'VR' ONLY IF NO SHATR
  PENTP = 6
  IF (SHAT = 1) THEN
'* SHATRD PROJ *
'BASE (OR NOSE PIECES AT OB >= 45 DEG):
'ONLY PEN IF 'VS' >= 'VLSHAT' & SUFFER EXTRA ENERGY LOSS
'THEY DO NOT AFFECT DELTA PLUG
    VR = VRPR
'NOSE PIECES (OR BASE PORTION ONLY AT OB >= 45 DEG THOUGH DELTAPLUGWT = 0 HERE):
    VDPLUG = VRSHATNS: IF (VDPLUG < VR) THEN VDPLUG = VR
'*
  ELSE
'*
'* UNSHATRD PROJ *
'PROJ REMAINING VEL = DELTA PLUG VEL (ONE VEL FOR ALL PROJ PIECES)
    IF ((OB < 45!) OR ((OB >= 45!) AND (BDYDM = 0))) THEN
      VR = VRPR: VDPLUG = VR
    ELSE
'NOSE PIECES AT OB >= 45 DEG W/BODY BREAKAGE:
      VR = VRPR
'BASE PIECES AT OB >= 45 DEG W/BODY BREAKAGE:
      VDPLUG = VRSHATNS: IF (VDPLUG < VR) THEN VDPLUG = VR
    END IF
  END IF
END IF
'*
ROUNDPLUG:
'*
VNPLUG = INT(VNPLUG): VDPLUG = INT(VDPLUG): VR = INT(VR): 'USE WHOLE NUMBERS IN COMPARES

' ** END OF SUB PENVRVPLGCALC **
END SUB

SUB PRNTARMR STATIC

' LIST ALL ARMOR TYPES TO CHOOSE FROM

PRINT "SELECT FACE-HARDENED ARMOR PLATE TYPE:":
PRINT "   1. Gruson Chilled Cast Iron (1868-90) (land fortification dome turrets)"
PRINT "   2. Average Compound (hardened-steel-faced wrought iron) (1880-90)"
PRINT "   3. Harveyized (cemented/carburized/case hardened) Mild Steel (1891-1900)"
PRINT "   4. Harveyized Nickel-Steel (1890-1900) (usual 'Harvey' armor)"
PRINT "   5. German original Krupp Cemented (1894-1918) ('KC a/A' (KC 'Old Type'))"
PRINT "   6. German new KC 'n/A' ('New Type') (1928-36) for 'Pocket BB' turrets only"
PRINT "   7. German improved thick-plate KC n/A (1936-45) (SCHARNHORST & BISMARCK)"
PRINT "   8. Austro-Hungarian Witkowitz KC-type Armor (1898-1918)"
PRINT "   9. British average KC-type Armor manufactured 1911-21 (all manufacturers)"
PRINT "  10. British average KC-type Armor manufactured 1922-30 (all manufacturers)"
PRINT "  11. British average post-1930 Cemented Armor (CA)      (all manufacturers)"
PRINT "  12. Italian Terni Cemented Armor (TC) (thin face for thick plates) (1935-45)"
PRINT "  13. Japanese Vickers Hardened Armor (VH) (non-cemented) (1937-45)"
PRINT "  14. U.S. Midvale Non-Cemented Class 'A' (1907-12 & one cemented Lot in 1922)"
PRINT "  15. U.S. Bethlehem Thin Chill Class 'A' (1921-25) (also made by Midvale)"
PRINT "  16. U.S. average of all other Class 'A' manufactured 1911-25"
PRINT "  17. U.S. average 1935-1943    Class 'A' (all manufacturers) (original)"
PRINT "  18. U.S. average 1944-1950    Class 'A' (all manufacturers) (improved)"
PRINT "  19. Average of all other KC introduced before 1911 (including U.S. & Britain)"
PRINT "  20. Average of all other KC introduced between 1911 and 1921"
PRINT "  21. Average of all other KC introduced between 1922 and 1930"
PRINT "  22. Average of all other KC introduced after   1930"
IF (ARMOR > 0) THEN PRINT "CURRENT ARMOR SELECTION ="; ARMOR; "-- ";

' ** END OF SUB PRNTARMR **
END SUB

SUB REMVELPRNT STATIC
'PRINT REMAINING VELOCITY MESSAGES ON SCREEN
'
IF (VDPLUG < 0) THEN
  RVU$ = "Projectile Remaining Velocity NOT DEFINED"
  PRINT RVU$: ' NO PARTIAL OR COMPLETE PEN
ELSE
'
' CALC AVE PROJ REMAINING VEL FOR 1-PIECE DAMAGED PEN, IF USED & DIFFERENT FROM 'VDPLUG'
  IF (VDPLUG <> VR) THEN
    VTMP = (VDPLUG ^ 2 + VR ^ 2) / 2
    VTEMP = SQR(VTMP): VTOTAL = INT(VTEMP + .5): 'K.E. UNCHANGED
  END IF
  IF (DELTAPLUGWT > .05) THEN DPLG$ = "& Delta Plug ": ' ADD DELTA PLUG, IF THERE
'
  IF ((SHAT = 0) OR (PENTP = 3)) THEN
'UNSHATRD PROJ & UNCAPPED JAP TYPE 91 AP W/'VS'<'VHSHAT' BUT 'VS'>'VHOL' ('PENTP'=3)
    IF (OB < 45!) THEN
      IF (PENTP = 2) THEN
        BSNS3$ = "No Part of Projectile completely penetrates plate."
      END IF
      IF (PENTP = 3) THEN
        IF ((SHAT = 1) OR ((SHAT = 0) AND ((NSBRK > 0) AND (NSBRK < 8)))) THEN
          BSNS1$ = "Nose Pieces "
          BSNS3$ = "Projectile Body up to forward bourrelet fails to completely penetrate."
        ELSE
          BSNS3$ = "No Part of Projectile completely penetrates plate."
        END IF
      END IF
      IF (PENTP = 5) THEN
        IF ((NSBRK = 0) OR (NSBRK = 8)) THEN
          BSNS1$ = "Nose & Upper Body "
        ELSE
          BSNS1$ = "Nose Pieces & Upper Body"
        END IF
        IF (BDYDM < 2) THEN
          BSNS3$ = "Projectile Lower Body fails to completely penetrate."
          ONEPC$ = "If Projectile Body not broken up, No Part of Projectile completely penetrates."
        ELSE
          BSNS3$ = "Projectile Lower Body Pieces fail to completely penetrate."
        END IF
      END IF
      IF (PENTP = 6) THEN
        IF (BDYDM = 1) THEN
          IF (VDPLUG <> VR) THEN
            IF ((NSBRK = 0) OR (NSBRK = 8)) THEN
              BSNS1$ = "Nose & Upper Body "
            ELSE
              BSNS1$ = "Nose Pieces & Upper Body "
            END IF
            BSNS2$ = "Lower Body "
            ONEPC$ = "If Proj not broken, it ": 'ONLY IF PROJ DEFORMED, NOT BROKEN
          ELSE
            BSNS1$ = "Entire Projectile "
          END IF
        ELSEIF (BDYDM = 2) THEN
          IF (VDPLUG <> VR) THEN
            BSNS1$ = "Nose & Upper Body Pieces "
            BSNS2$ = "Lower Body Pieces "
          ELSE
            BSNS1$ = "All Projectile Pieces "
          END IF
        ELSE
'NO PROJ DAMAGE
          BSNS1$ = "Entire Projectile "
        END IF
      END IF
    ELSE
''OB'>=45 DEG
      IF (PENTP = 2) THEN
        BSNS3$ = "No Part of Projectile completely penetrates plate."
      END IF
      IF (PENTP = 3) THEN
' ONLY NOSE DAMAGE OCCURS (ABOVE FORWARD BOURRELET)
        BSNS3$ = "Entire Projectile ricochets off of plate."
      END IF
      IF (PENTP = 4) THEN
        IF ((NSBRK = 0) OR (NSBRK = 8)) THEN
          BSNS1$ = "Lower Body "
          BSNS3$ = "Projectile Nose & Upper Body ricochet off of plate."
        ELSE
          BSNS1$ = "Lower Body & Some Nose Pieces "
          BSNS3$ = "Most of Projectile Nose & Upper Body Pieces ricochet off of plate."
        END IF
        ONEPC$ = "If Projectile Body not broken up, All of Projectile ricochets off of plate."
      END IF
      IF (PENTP = 6) THEN
        IF (BDYDM = 1) THEN
          IF (VDPLUG <> VR) THEN
            IF ((NSBRK = 0) OR (NSBRK = 8)) THEN
              BSNS2$ = "Nose & Upper Body "
            ELSE
              BSNS2$ = "Nose Pieces & Upper Body "
            END IF
            BSNS1$ = "Lower Body "
          ELSE
            BSNS1$ = "Entire Projectile "
          END IF
          ONEPC$ = "If Proj not broken, it "
        ELSEIF (BDYDM = 2) THEN
          IF (VDPLUG <> VR) THEN
            BSNS1$ = "Lower Body Pieces "
            BSNS2$ = "Nose & Upper Body Pieces "
          ELSE
            BSNS1$ = "All Pieces "
          END IF
        ELSE
'NO PROJ DAMAGE
          BSNS1$ = "Entire Projectile "
        END IF
      END IF
    END IF
  ELSE
'SHATR ('SHAT'=1) EXCEPT 'VHSHAT'<='VS'<'VLSHAT' ('PENTP'=3)
'  INCLUDING JAP UNCAPPED TYPE 91 AP W/'VS'<'VHSHAT'
    IF (OB < 45!) THEN
      BSNS1$ = "All Nose Pieces "
      IF (VR >= 0) THEN
        IF (VDPLUG <> VR) THEN
          BSNS2$ = "Body Pieces "
        ELSE
          BSNS1$ = "All Pieces "
        END IF
      ELSE
        IF (VS >= VHSHAT) THEN
          BSNS3$ = "Projectile Body does not completely penetrate."
        END IF
      END IF
    ELSE
''OB'>=45 DEG
      BSNS1$ = "Body & Some Nose Pieces "
      IF (VR >= 0) THEN
        IF (VDPLUG <> VR) THEN
          BSNS2$ = "Most Nose Pieces "
        ELSE
          BSNS1$ = "All Pieces "
        END IF
      ELSE
        BSNS3$ = "Most Projectile Nose Pieces do not completely penetrate."
      END IF
    END IF
  END IF
'*
  IF (BSNS1$ <> "") THEN
    PRINT REMVEL$; BSNS1$; DPLG$;
    IF (VDPLUG >= 25) THEN
      PRINT "="; VDPLUG; "ft/sec"
    ELSE
      PRINT "ARE VERY SLOW"
    END IF
  END IF
  IF (BSNS2$ <> "") THEN
    PRINT REMVEL$; BSNS2$;
    IF (VR >= 25) THEN
      PRINT "="; VR; "ft/sec"
    ELSE
      PRINT "ARE VERY SLOW"
    END IF
  END IF
  IF (ONEPC$ <> "") THEN
    IF (PENFLG = 2) THEN
      PRINT ONEPC$; DPLG$;
      IF (DPLG$ = "") THEN PRINT "has"; :  ELSE PRINT "have";
      IF (VTOTAL >= 25) THEN
        PRINT " Remaining Velocity ="; VTOTAL; "ft/sec"
      ELSE
        PRINT " VERY SLOW Remaining Velocity"
      END IF
      IF (BSNS3$ <> "") THEN PRINT BSNS3$
    ELSE
      IF (BSNS3$ <> "") THEN PRINT BSNS3$
      PRINT ONEPC$
    END IF
  ELSE
    IF (BSNS3$ <> "") THEN PRINT BSNS3$
  END IF
END IF
'
'** END OF SUB REMVELPRNT **

END SUB

SUB SHATRDAM STATIC
'SHATRD PROJ DAMAGE LOGIC. SEPARATE NOSE-ONLY SHATR FROM REGULAR COMPLETE-BODY SHATR
'
IF (((CRVRL = 1) AND (BRAIK = 0)) OR ((PENFLG = 2) AND (NSSHAT > 0) AND (NSSHAT <> 2)) OR (NSSHAT = 2)) THEN
  NSBRK = 2: BRK = 0: BDYDM = 0: 'ONLY NOSE BREAKAGE IF CURVED-PLATE RULE OR SOFTSHAT PLATE RULE OR UNDER MIN NOSE SHTR VEL FOR STRONGER PROJ
ELSEIF ((PENFLG < 2) AND (NSSHAT > 0)) THEN
  NSBRK = 2: BRK = 2: BDYDM = 2: 'NOSE SHATR WEAKENS PROJ SO THAT IT BREAKS UP IF VEL < NBL
ELSE
  NSBRK = 2: BRK = 1: BDYDM = 2: 'REGULAR COMPLETE BODY SHATR OCCURS
END IF

' ** END OF SUB SHATRDAM **
END SUB

SUB SHTRMULTSELECT STATIC

' SHATTER INCREASES HBL, WHICH ALSO INCREASES NBL.
' SELECT WHICH HBL SHATTER MULTIPLIER TO USE

IF ((ARMOR = 3) OR (ARMOR = 4)) THEN
  IF (TA >= 8) THEN
    SHATMULT = 1!:  'NORMAL OB BONUS FOR THICK HARVEYIZED ARMORS
  ELSE
    SHATMULT = 1.25 - .03125 * TA
  END IF
' SHATR FOR HARVEY ARMOR TURNS UNSHTRED NBL INTO **FACE-LAYER** HBL USING KC
'  'VDFSTDWWI' HBL-TO-NBL VEL DIFF, *BUT* THIN FACE CANNOT PUNCH OUT BACK
'  LAYER (HOLE COMPLETELY THRU PLATE) UNTIL HBL USING SMALLER 'VDFBRK' REACHED,
'  BUT BELOW 8" PLATE THICKNESS VEL DIFF BEGINS TO WIDEN DUE TO THICKER FACE
ELSEIF ((SOFTSHAT = 2) AND (ABS(HARD) = 1) AND (NSSHAT = 1) AND (OB <= 20!)) THEN
  SHATMULT = 1.2: 'NORMAL OB BONUS FOR IMPROVED BRITISH WWI PLATES & REGULAR SOFT-CAPPED PROJ AT OB<=20 DEG
ELSEIF ((SOFTSHAT = 1) AND (HARD < 3) AND (BEND = 0) AND ((NSSHAT = 0) OR (OB > 20!))) THEN
  SHATMULT = 1.4: 'NORMAL OB BONUS FOR BEST SOFTSHAT PLATES WHEN PROJ HAS COMPLETE SHATR
ELSE
  SHATMULT = 1.3: 'NORMAL OB BONUS FOR EVERY OTHER CASE
END IF

' ** END OF SUBROUTINE SHTRMULTSELECT **
END SUB

SUB SPLNTRPRNT STATIC
'
' PRINT INFORMATION ON SPLINTERS THROWN FROM PLATE BACK ON HITS BELOW THE HBL
FLAKE$ = ""
IF (NORMPLUGWT <= .05) THEN
  IF (BKEFF = 0) THEN
    IF (CART > 0) THEN
      FLAKE$ = "Many dangerous splinters thrown from plate back likely due to impact shock."
    ELSE
      FLAKE$ = "Few dangerous splinters thrown from plate back due to impact shock."
    END IF
  ELSE
    FLAKE$ = "Backing material stops splinters thrown from plate back due to impact shock."
  END IF
END IF
IF (FLAKE$ <> "") THEN PRINT FLAKE$

'  ** END OF SUBROUTINE SPLNTERPRNT **
END SUB

SUB THINPRINT STATIC

'CALCULATE 'TRUTHIN' & PRINT OUT THIN EFFECTS INFO

IF (THIN = .35) THEN
  TRUTHIN = .25
ELSEIF (THIN = .45) THEN
  TRUTHIN = .35
ELSE
  TRUTHIN = .45
END IF
THNTP = 100 * TRUTHIN * D + .5: THINPRT = INT(THNTP) / 100
THKTP = 100 * THIN * D + .5: THKPRT = INT(THKTP) / 100
PRINT
IF (TRUTHIN = .25) THEN
  PRINT "THIS ARMOR IS THE MOST DUCTILE ('THKTHN' = 1) TYPE FACE-HARDENED PLATE."
ELSEIF (TRUTHIN = .35) THEN
  PRINT "THIS ARMOR IS A MORE DUCTILE ('THKTHN' = 2) TYPE FACE-HARDENED PLATE."
ELSE
  PRINT "THIS ARMOR IS AN OLDER, BRITTLE ('THKTHN' = 0) TYPE FACE-HARDENED PLATE."
END IF
PRINT "IT IS 'THIN' BELOW"; TRUTHIN; "CALIBER =";
ES$ = "": IF (THINPRT > 1!) THEN ES$ = "ES"
PRINT THINPRT; "INCH"; ES$; " FOR D ="; D; "INCH";
IF (TRUTHIN <> THIN) THEN
  IF (D > 1!) THEN PRINT "ES":  ELSE PRINT
  PRINT "  AND IT IS 'THICK' ABOVE"; THIN; "CALIBER =";
  ES$ = "": IF (THKPRT > 1!) THEN ES$ = "ES"
  PRINT THKPRT; "INCH"; ES$; "."
  PRINT "BETWEEN THESE 2 EXTREME VALUES, PROGRAM STEPS DOWN PLATE RESISTANCE TWICE."
ELSE
  IF (D > 1!) THEN PRINT "ES.":  ELSE PRINT "."
  PRINT "WITH THIS ARMOR, THE CHANGE FROM 'THICK' TO 'THIN' IS ABRUPT."
END IF

' ** END OF SUB THINPRINT **
END SUB

SUB THINSELECT STATIC

'U.S. WWI-ERA TESTS SHOW BRITTLE FH ARMORS LOST STRENGTH IF <0.55-CAL EFFECTIVE THICKNESS,
'  REDUCING 'MSHAT' FOR SUCH 'THIN' ARMOR. LATER, TOUGHER PLATES ('THKTHN' FLAG = 1 OR 2)
'  ACT AS 'THIN' PLATES IF <0.35-CAL ('THKTHN= 1'), BASED ON FRENCH 15CM KC-TYPE TURRET ROOF
'  PLATE OF *DUNKERQUE* HIT BY BRITISH 15" MK 13A APC PROJ IN 1940. VALUES FOR 'THKTHN = 2'
'  ARE ON BRITISH 15" MK 5A 'GREENBOY' PROJ HITS ON 7" WWI BRITISH KC. MODIFICATION BASED ON
'  BRITISH 15" MK 17B APC PROJ HITS ON 4.9" CA PLATES AT 60 DEG., 'THKTHN=1' ARMOR HAS TRUE
'  THIN FOR <0.25-CAL EFFECTIVE THICKNESS & 'THKTHN=2' ARMOR HAS TRU THIN FOR <0.35-CAL
'  EFFECTIVE THICKNESS.  BOTH NON-ZERO 'THKTHN' ARMORS USE A 4-STEP DROP FROM THE THICK VALUE
'  TO THE TRUE THIN VALUE WITH THE INTERMEDIATE STEPS BISECTING THE RANGE BETWEEN THICK & THIN.
'  THE 0.3-0.35 THICKNESS PART FOR 'THKTHN=1' & THE 0.4-0.45 PART FOR 'THKTHN=2', USE 0.625
'  OF THE DIFFERENCE IN RESULTS, & 0.3 OF THE DIFFERENCE IN REMAINING RANGE (FROM BRIT TESTS).
IF (THKTHN = 1) THEN
  THIN = .35
ELSEIF (THKTHN = 2) THEN
  THIN = .45
ELSE
  THIN = .55
END IF

' ** END OF SUB THINSELECT **
END SUB

SUB THRESHOLDCALC STATIC
' COMPUTE MINIMUM EFFECTIVE-FILLER OR NO-NOSE-DAMAGE VELOCITY THRESHOLD VALUE
'
'ALWAYS USE DAMAGE/NO-DAMAGE BOUNDARY FOR 'EBL' & USE ACTUAL 'VLEX/VHEX' VALUES FOR NOSE DAMAGE CALC
'
''THVAL' IS PROJ CRITICAL DEFLECTION ANGLE CALCULATED PREVIOUSLY (NOSE OR BODY, AS SELECTED)
''THVAL' = DEFLECTION = 'OB' - 'EX' WHEN STRIKING VEL IS AT MIN FOR DAMAGE
'WE MUST FIND THE STRIKING VEL THAT GIVES AN 'EX' FOR GIVEN 'OB' SUCH THAT 'THVAL' IS EXACTLY REACHED
'SHATRD PROJ NEVER USES THIS LOGIC ('VHEXREV' = 'THSPD' FOR NOSE-ONLY SHATTR ONLY) (HOWEVER, SHATR IS INCLUDED IN LOGIC)
THSPD = 0: 'INITIALIZE FINAL CRITICAL THRESHOLD VELOCITY 'THSPD'
IF (THVAL <= OB) THEN
'PROJECTILE DAMAGE POSSIBLE, SO DO CALCULATION OF THRESHOLD VELOCITY
  EXTH = OB - THVAL: ''EXTH' = VALUE OF 'EX' WHEN VEL = CRITICAL VEL (MIN 'EX' = 15 IF 'OB' >= 15 & NO SHAT)
  IF ((SHAT = 1) OR ((EXTH > 15!) AND (OB > 15!))) THEN
'IF 'EXTH' > 15, THEN MINIMUM UNDAMAGED PROJ VEL IS ABOVE 'VLEXREV'
'
'USE ALL OF 'THVAL' FOR COMPUTATION
'COMPUTE 'THSPD' USING INVERSE OF 'EX' VEL RATIO FORMULA IF > 'VLEXREV'
'SNCSMAX' IS DEFLECTION-AT-'VLEXREV' ('MAXDF') FUNCTION FOR (OB - EXMIN) <= 45 DEG (SEE 'EX' CALC LOGIC)
'DIVIDE BY '(1 + OB45)' FIX IS FOR (OB - EXMIN) > 45 DEG (CHANGE IN 'OB45' SAME AS CHANGE AT 45 DEG)
    TEMP0 = THVAL / 57.29578
    TEMP1 = TEMP0 / (1 + OB45)
    TEMP2 = SIN(TEMP1) * COS(TEMP1): 'CRITICAL BODY OR NOSE DEFLECTION FUNCTION (AS SELECTED)
    TEMP3 = SNCSMAX / TEMP2
    TEMP4 = 2 * TEMP3 - 1
    IF (TEMP4 < 0) THEN TEMP4 = 0
    THSPD = VLEXREV * TEMP3 / SQR(TEMP4)
    IF (THSPD < VLEXREV) THEN THSPD = VLEXREV: 'VEL THAT CAUSES DEFLECTION ANGLE 'THVAL'
  ELSE
'LOGIC FOR THRESHOLD VEL 'THSPD' IF IT IS AT OR UNDER 'VLEXREV' ('EXTH' <= 15)
'   OR IF 'OB' <= 15:  BOTH USE A LINEAR INCREASE IN 'EX' WITH VEL BETWEEN 'VHOL' & 'VLMT'
    IF (OB <= 15!) THEN
      THVUSD = THVAL: 'ALL OF 'THVAL' USED IN LINEAR CALC ('MAXDIFF' = 'OB' & MIN 'EX' = 0)
    ELSE
'FIND VEL BY SUBTRACTING RATIO OF DIFF BETWEEN 'EX' AT 'VLEXREV' ( = 'MAXDIFF' = 15) & 'EX' AT MIN CRITICAL VEL
      THVUSD = 15! - EXTH: 'USE ONLY PORTION OF 'THVAL' IN THE UNDER 15 REGION FOR CRITICAL VEL CALC
    END IF
    THSPD = VLEXREV - (THVUSD / MAXDIFF) * (VLEXREV - VHEXREV): 'LINEAR INCREASE IN 'EX' WITH VEL FROM HBL TO NBL
  END IF
'ROUND 'THSPD' TO EXACTLY EQUAL 'VLMT' OR 'VHOL' IF SO ROUNDED ON DISPLAY
  THCHK = ABS(THSPD - VLMT): IF (THCHK < .5) THEN THSPD = VLMT
  THCHK = ABS(THSPD - VHOL): IF (THCHK < .5) THEN THSPD = VHOL
END IF
'
'  ** END OF SUB THRESHOLDCALC **
END SUB

SUB USPROJ STATIC
'
' SCREEN PRINT OF AMERICAN PROJECTILE OPTIONS
'
PRINT " 1. Ave. Army/Navy (A/N) Chilled Cast Iron Shot & All Common Shell(1890-1910)(*)"
PRINT " 2. Ave. capped Chilled Cast Iron Army Coast Defense (ACD) Shot/Shell(1898-1910)"
PRINT " 3. A/N Steel AP Shot/Shell          (0-6% black-powder/Ex.D filler) (1890-1910)"
PRINT " 4. A/N soft-capped Steel APC Shot/Shell(0-6% blk-pwdr/Ex.D flr)(1897-1910N/20A)"
PRINT " 5. Midvale tough-steel AP Shot/Shell (0-6% black-powder/Ex.D filler)(1895-1910)"
PRINT " 6. Midvale tough soft-capped APC Shot/Shell(0-6% blk-pwdr/Ex.D filr)(1897-1910)"
PRINT " 7. Base-fuzed 7/12/14-in 'Bombardment' (Light-case)(9-11% Ex.D filler)(1914-42)"
PRINT " 8. Ave. Navy 1911-23 APC except Navy Midvale 8-in Mk 11 (1911) & 'Midvale 1916'"
PRINT " 9. Navy Midvale 8-in Mk 11 (1911) & all Navy 'Midvale Unbreakable 1916' APC"
PRINT "10. Average 1921-1935 ACD APC Shot    (2-3% Ex. D filler)  ('Midvale Army 1921')"
PRINT "11. Average post-1935 ACD APC Shot (1.4-2% Ex. D filler)(= Ave. Navy APC c.1940)"
PRINT "12. Ave WWI-era base-fuzed Common(some w/windscreens)(4-5% Ex.D filler)(1910-30)"
PRINT "13. Ave Special Common(w/Hood/windscreen/base fuze)(3-4.4% Ex.D filler)(1930-45)"
PRINT "      ** EXCEPT 6-in Mark 27 and 8-in Mark 15 Special Common **"
PRINT "14. 6-in Mk 27-1-6 Special Common (= US Army AP) (2.1-2.4% Ex.D filler)(1933-45)"
PRINT "15. 8-in Mk 15-1 hard-capped Special Common (= SAPC)   (4.4% Ex.D filler) (1930)"
PRINT "16. 3-in Mk 29-1/30-1 (to 1944) and 8-in Mk 19-1-3 (to 1941) & ACD Mk 20-1 APC"
PRINT "17. 8-in Mk 19-4-6 APC"
PRINT "18. 6-in Mk 35-1-8 and 16-in Mk 8-1-5 (to 1944) APC"
PRINT "19. 8-in Mk 21-1-4, 14-in Mk 16-1-6 (to 1943) & ACD Mk 20-1, and"
PRINT "      16-in Mk 5-1-4 (to 1944) & Mk 5-6 (ex-ACD Mk 12-1 w/Mk 21 BDF) APC"
PRINT "20. 3-in Mk 29-2/30-2, 6-in Mk 35-9-11, 8-in Mk 21-5, 12-in Mk 18-1,"
PRINT "      14-in Mk 16-7-11, and 16-in Mk 5-5 & Mk 8-6-8 APC"

' ** END OF SUB USPROJ **
END SUB

SUB VERSIONPRNT (VCOUNT)

' PRINT DEFINITIONS AND NEW VERSION INFORMATION (6.8 & 6.9 HERE)

SELECT CASE VCOUNT
  CASE 1
    PRINT "IMPORTANT DEFINITIONS:"
    PRINT "NBL = MINIMUM STRIKING VELOCITY TO ALLOW PROJECTILE TO COMPLETELY PASS THROUGH": '1
    PRINT "      PLATE WITH THE MINIMUM POSSIBLE REMAINING VELOCITY.  IF PROJECTILE BREAKS": '2
    PRINT "      THEN 80% OF THE BODY MAKES IT THROUGH.  ALWAYS IGNORE AP CAP, HOOD, OR": '3
    PRINT "      WINDSCREEN, IF ANY, IN THIS DETERMINATION. (NAVY BALLISTIC LIMIT)": '4
    PRINT "HBL = MINIMUM STRIKING VELOCITY TO MAKE A HOLE IN THE PLATE OF ROUGHLY CALIBER": '5
    PRINT "      SIZE OR GREATER, PUNCHING OUT A PLUG OF ARMOR THROUGH PLATE BACK, INTACT": '6
    PRINT "      OR BROKEN UP.  MAY BE JUST BELOW OR FAR BELOW NBL, DEPENDING ON PLATE": '7
    PRINT "      TYPE, PROJECTILE TYPE, PROJECTILE CONDITION AFTER IMPACT, & OBLIQUITY.": '8
    PRINT "      A LITTLE ABOVE 'THROUGH-CRACK' BALLISTIC LIMIT. (HOLING BALLISTIC LIMIT)": '9
    PRINT "EBL = MINIMUM STRIKING VELOCITY, WHEN IT EXISTS, TO ALLOW PROJECTILE FILLER TO": '10
    PRINT "      EXPLODE PROPERLY (FUZE & BASE PLUG OK AND NO CAVITY CRACKS). NOSE DAMAGE": '11
    PRINT "      WILL ONLY COMPROMISE THIS IF PROJECTILE HAS A VERY LARGE CAVITY (OVER 6%": '12
    PRINT "      FILLER CAN FIT INTO CAVITY, EVEN IF LESS WAS USED) OR USES A NOSE FUZE.": '13
    PRINT "      USUALLY, I ASSUME PROJECTILE BODY COMPLETELY INTACT, THOUGH NOSE-ONLY": '14
    PRINT "      SHATTER, AMONG OTHER THINGS, MAY MODIFY THIS. (EFFECTIVE BALLISTIC LIMIT)": '15
    PRINT "OB  = ANGLE OF PROJECTILE CENTERLINE COMPARED TO NORMAL (RIGHT ANGLES) LINE AT": '16
    PRINT "      CENTER OF IMPACT SITE (YAW ASSUMED ZERO OR ALREADY INCLUDED). MAXIMUM OB": '17
    PRINT "      USED (DEG): NO SHATTER-->70; IF SHATTER-->75 W/THICK PLATE, 80 OTHERWISE": '18
    PRINT "EX  = ANGLE PROJECTILE REMAINING VELOCITY VECTOR MAKES WITH NORMAL LINE ABOVE": '19
    PRINT "      WHEN PROJECTILE EXITS PLATE BACK (ALSO COMPUTED FOR PLUG VELOCITY CALCS": '20
    PRINT "      EVEN IF PROJECTILE FAILS TO COMPLETELY PENETRATE, BUT IS ABOVE HBL).": '21
'COMMENT OUT EITHER 'CONTINUE?' (at least one more page) OR 'FINISHED?' (this is last page) below.
'
    PRINT "CONTINUE? (Y=Yes/N=Skip Rest (Any other entry does nothing)) ";
'    PRINT "FINISHED? Y=Yes (Any other entry does nothing) ";
'
  CASE 2
    PRINT "VERSION 6.8 & 6.9 CHANGE INFORMATION (ALL 6.8 EXCEPT FOR LAST FEW):"
    PRINT "(1)  Harveyized Mild Steel or Nickel-Steel puts a 1-1.5-inch thick 'cemented'"
    PRINT "       face layer (up to 2% carbon & 600-700 Brinell when quenched) onto an"
    PRINT "       otherwise standard homogeneous plate. Developed in 1891 in the US. Since"
    PRINT "       the face layer gets thinner and thinner compared to the plate thickness"
    PRINT "       as the plates get thicker, this has a different effect from KC armor."
    PRINT "       In this update, 'UB' -- the amount of soft back as a percentage of the"
    PRINT "       total thickness -- gets larger as thickness goes up for Harvey armors."
    PRINT "       This change decreases the scaling effect for thicker Harvey armor and"
    PRINT "       reduces the amount of damage (shatter and otherwise) on the projectiles,"
    PRINT "       with a minimum when UB = 90%. The result is a drop in effective plate"
    PRINT "       quality with increasing thickness, fast from 3-8 inches and slower above"
    PRINT "       that thickness. AP shot and AP shell (capped or not) acted identically."
    PRINT "       I recently obtained a large number of tests of Harveyized Nickel-Steel"
    PRINT "       versus several US and a couple of European AP projectiles in the 1890's"
    PRINT "       most without AP caps, but some with soft AP caps. Also, some original"
    PRINT "       Krupp KC armor (later called 'KC a/A') tests were included. I was able"
    PRINT "       to completely re-do my Harvey logic. My KC logic did not need to change."
    PRINT "(2)  I am finally adding a section on Russian AP projectiles.  Much of this is"
    PRINT "       estimated, but tests of the Russian Model 1909 APC shells indicate that"
    PRINT "       they equaled the later 13.5-15-inch British 'Greenboy' post-Jutland APC"
    PRINT "       shells in tests up to 20 degrees obliquity, so I am using this quality"
    PRINT "       in the Russian Model 1909 and, until more data is found, later shells."
'
'COMMENT OUT EITHER 'CONTINUE?' (at least one more page) OR 'FINISHED?' (only this page) below.
'
    PRINT "CONTINUE? (Y=Yes/N=Skip Rest (Any other entry does nothing)) ";
'    PRINT "FINISHED? Y=Yes (Any other entry does nothing) ";
'
  CASE 3
    PRINT "VERSION 6.8 CHANGES CONTINUED:"
    PRINT "(3)  During my Harvey armor analysis I discovered that most of the old AP/APC":   '1
    PRINT "       projectiles used did not act as I had previously assumed, so I have:":     '2
    PRINT "       (A) Lumped AP Shot (small or no filler) with AP Shell (up to 6% filler).": '3
    PRINT "       (B) Found that the combined AP shot/shell results closely matched Krupp":  '4
    PRINT "           AP results I already had against KC armor. (A good double-check.)":    '5
    PRINT "       (C) Found that adding a soft AP cap to these old shot/shells also had an": '6
    PRINT "           identical effect on both, so that they could still be combined.":      '7
    PRINT "       (D) Discovered that some 1890's Midvale AP shells (and, thus, most later": '8
    PRINT "           stronger AP shells of any manufacturer) **COULD NOT BE SHATTERED BY":  '9
    PRINT "           HARVEY ARMOR** (they deformed & one had its nose tip broken, but no":  '10
    PRINT "           shatter). These began development of 'Midvale Unbreakable 1916' APC.": '11
    PRINT "       (E) Discovered that AP shatter had a mild effect compared to KC armor,":   '12
    PRINT "           which I had expected, though even less than I thought it would, but":  '13
    PRINT "           it had a full KC-type effect on 1890's 'Common' shells (cast iron?),": '14
    PRINT "           so I now lump 1890's Common shells with Palliser/Gruson shot/shells.": '15
    PRINT "(4)  Removed 'NOCAP' 5% bonus to APC projectile quality if it lost its AP cap":   '16
    PRINT "       (no energy absorbed by cap). Sound in theory but lost in the 'noise'.":    '17
    PRINT "(5)  Fixed MAJOR error in Jap uncapped Type 91 AP logic (it never shattered).":   '18
    PRINT "(6)  Revised the screen printouts to fix a few errors, reflect above changes,":   '19
    PRINT "       and simplify results printout.  Number of possible shell selections may":  '20
    PRINT "       differ and there are differences in all nations for the oldest shells.":   '21
    PRINT "(7)  Thinnest plates that cause shatter logic restricted to steel projectiles.":  '22
'COMMENT OUT EITHER 'CONTINUE?' (at least one more page) OR 'FINISHED?' (this is last page) below.
'
    PRINT "CONTINUE? (Y=Yes/N=Skip Rest (Any other entry does nothing)) ";
'    PRINT "FINISHED? Y=Yes (Any other entry does nothing) ";
  CASE 4
    PRINT "VERSION 6.8 CHANGES CONTINUED:"
    PRINT "(8)  Fixed weak plate (COMPOUND or THINCHILL) 10% or 20% projectile quality"
    PRINT "       bonus due to reduced impact stress on projectile.  Only changed for"
    PRINT "       CAST IRON, 1890's WEAK STEEL, and 1890's MIDVALE DEFORMABLE shells,"
    PRINT "       which get no bonus from THINCHILL (steel with a thin face, such as"
    PRINT "       HARVEY or BETHLEHEM THIN CHILL armors) -- other shells get 10% a bonus"
    PRINT "       -- while COMPOUND armor gives a 20% bonus to all shells but cast iron,"
    PRINT "       which gets no bonus, or 1890's WEAK STEEL OR MIDVALE DEFORMABLE shells,"
    PRINT "       which get only a 10% bonus from that weakest armor plate."
    PRINT "(9)  For Thin Harvey Armor (under 8 inches thick), the Shatter Plate Thickness"
    PRINT "       Multiplier (1.00 for thick Harvey Armor) increases slowly as plate"
    PRINT "       thickness decreases from 8 inches, due to the thin cemented face layer"
    PRINT "       becoming a significant part of the total thickness in such thin plates."
    PRINT "(10) For Version 6.4:  I found a huge hole -- my error -- due to not updating"
    PRINT "       all projectiles in all Nation tables with the changes needed to handle"
    PRINT "       HArvey armor. I had tunnel vision fixing the program in the first place"
    PRINT "       and forgot that not all nations used the defaults.  I went over every"
    PRINT "       projectile and made sure its data table was correct.  In the process I"
    PRINT "       rebuilt the Italian table to track the revised British table changes."
    PRINT "(11) For Version 6.5: Common Proj. errors: Fixed Hood logic & LTCASE never 0"
    PRINT "       except for US 6-inch MK 27 Special Common)."
    PRINT "(12) For Version 6.6: Completely rebuilt nose-only shatter logic for hoods and"
    PRINT "       soft AP caps (BIG problems) & improved projectile damage printouts."
    PRINT "       Corrected British deformable projectile Holing Limit logic."
'
'COMMENT OUT EITHER 'CONTINUE?' (at least one more more page) OR 'FINISHED?' (this is last page) below.
'
    PRINT "CONTINUE? (Y=Yes/N=Skip Rest (Any other entry does nothing)) ";
'    PRINT "FINISHED? Y=Yes (Any other entry does nothing) ";
  CASE 5
'
'THIS IS ASSUMED TO BE THE LAST PAGE POSSIBLE.
'
    PRINT "VERSION 6.8 CHANGES CONTINUED:"
    PRINT "(13) For Version 6.7: I found a very small but important bug that made the"
    PRINT "       EBL computation incorrect when hitting at below the NBL under some"
    PRINT "       conditions.  I had an '>=' when I needed a '>' at the NBL.  This"
    PRINT "       tiny bug prevented the under-NBL breakage logic from working right."
    PRINT "(14) For Version 6.8:  NSBRK = 4 nose breakage set logic is supposed to"
    PRINT "       exclude COMPOUND and HARVEYIZED armors. Needed to change an 'OR' to"
    PRINT "       an 'AND'. For filler cavity > 4.4% steel Hooded Common projectiles."
'VERSION 6.9 CHANGES
    PRINT
    PRINT "THESE ARE THE ONLY VERSION 6.9 CHANGES:"
    PRINT "(15) Changed the wording about when you need more details about the nose"
    PRINT "       covering weights other than just their total to compute body weight."
    PRINT "       You only need each one separately if the windscreen is knocked off by"
    PRINT "       a prior impact. This also removes Japanese Type 88/91/1 AP Cap Head."
    PRINT "(16) Fixed a few printing typos (minimum Striking Velocity is 1, not .01)."
    PRINT "(17) Added a hard-capped SAPC projectile to the French selection, introduced"
    PRINT "       around 1909, since there is a French book on this subject at that time"
    PRINT "       that talks about hard AP caps and why they should be used (it is mostly"
    PRINT "       correct).  I assume it replaced the previous soft-capped SAPC that were"
    PRINT "       used prior to that time.  It is possible that the date is even earlier."
    PRINT "(18) Added 'Tough' cap type = Thin WWII SAPC hard AP cap (limited protection)."
    PRINT "       Several WWI Russian, A-H, & German caps changed (most have no effect)."
    PRINT "(19) Increased number of lines on screen to 43 from 25."
'
    PRINT "FINISHED? Y=Yes (Any other entry does nothing) ";
'FOR FUTURE USE:
'END OF FOR FUTURE USE
END SELECT

' ** END OF SUB VERSIONPRNT **
END SUB

SUB YESNO STATIC
'
' SET YES OR NO FLAG 'YS' DEPENDING ON USER INPUT
'
YSNO:
YS$ = INKEY$
IF ((YS$ <> "Y") AND (YS$ <> "y") AND (YS$ <> "N") AND (YS$ <> "n")) THEN GOTO YSNO: 'BAD INPUT
YS = 0: IF ((YS$ = "Y") OR (YS$ = "y")) THEN YS = 1
'
' **** END OF SUB YESNO ****
END SUB

