' >>>>**** FACE-HARDENED ARMOR PENETRATION PROGRAM BY NATHAN OKUN ****<<<<
'              >>>>**** VERSION 6.9 OF 4 MARCH 2012 ****<<<<
'           >>>>**** MAIN PROGRAM MODULE "FH69MAIN.BAS" ****<<<<
'
' ** THE FOLLOWING SUBROUTINES ARE IN MODULES "FH69SBM1.BAS" & "FH69SBM2.BAS":
'
DECLARE SUB ALLPROJDATA (ZZX, ZZY)
DECLARE SUB ARMORINFO (ZZX)
DECLARE SUB LPUS (ZZX)
DECLARE SUB PENPRINT (ZZX)
DECLARE SUB LPBRITISH (ZZX)
DECLARE SUB LPGERMAN (ZZX)
DECLARE SUB LPFRENCH (ZZX)
DECLARE SUB LPITALIAN (ZZX)
DECLARE SUB LPJAPANESE (ZZX)
DECLARE SUB LPAUSTHUNG (ZZX)
DECLARE SUB LPRUSSIAN (ZZX)
DECLARE SUB SCALEFACTOR (ZZX)
DECLARE SUB VERSIONPRNT (ZZX)
DECLARE SUB GRSNHRVYTC ()
DECLARE SUB SHOWORIGARMR ()
DECLARE SUB SETOBMULT ()
DECLARE SUB OBMULT ()
DECLARE SUB PRNTARMR ()
DECLARE SUB PROJNATION ()
DECLARE SUB USPROJ ()
DECLARE SUB BRITAINPROJ ()
DECLARE SUB GERMANYPROJ ()
DECLARE SUB FRANCEPROJ ()
DECLARE SUB ITALYPROJ ()
DECLARE SUB JAPANPROJ ()
DECLARE SUB AUSTHUNGPROJ ()
DECLARE SUB RUSSIAPROJ ()
DECLARE SUB NUMVALHDR ()
DECLARE SUB LPRINTHDR ()
DECLARE SUB SETVALUE ()
DECLARE SUB NOSEDAM ()
DECLARE SUB PROJQMODS ()
DECLARE SUB PLUGCALC ()
DECLARE SUB YESNO ()
DECLARE SUB LMTSTRINGS ()
DECLARE SUB CALCVDF ()
DECLARE SUB SPLNTRPRNT ()
DECLARE SUB BENDLOGIC ()
DECLARE SUB IMPACTPRNT ()
DECLARE SUB NSBDYDAMPRNT ()
DECLARE SUB THRESHOLDCALC ()
DECLARE SUB CHGARMRPRNT ()
DECLARE SUB GETPLATETHICKNESS ()
DECLARE SUB ARMORBACK ()
DECLARE SUB BACKPRINT ()
DECLARE SUB OBHDSAPCAP ()
DECLARE SUB PROJMOTIONPRNT ()
DECLARE SUB OBINPUT ()
DECLARE SUB INITVALHDR ()
DECLARE SUB SCPGPRNT ()
DECLARE SUB LPRNTSECPG ()
DECLARE SUB LPRNTARMOR ()
DECLARE SUB DEFLECCALC ()
DECLARE SUB SHATRDAM ()
DECLARE SUB NOSEBROKE ()
DECLARE SUB PENVRVPLGCALC ()
DECLARE SUB SETMINEV ()
DECLARE SUB LPPROJIMPACT ()
DECLARE SUB EFFVELINIT ()
DECLARE SUB LPDAMAGE ()
DECLARE SUB GETPROJDWTWB ()
DECLARE SUB DAMAGESETUP ()
DECLARE SUB DOCRTGOOD ()
DECLARE SUB REMVELPRNT ()
DECLARE SUB FACECALC ()
DECLARE SUB MODIFYVDF ()
DECLARE SUB SHTRMULTSELECT ()
DECLARE SUB MINEVSHATCALC ()
DECLARE SUB THINSELECT ()
DECLARE SUB THINPRINT ()
'
'  THE FOLLOWING MUST BE IDENTICAL AT TOP OF ALL MODULES OF THIS PROGRAM !!
'
COMMON SHARED NATION, PROJ, ARMOR, SC, D, PENTP, OLDVALUE, NEWVALUE, CMT, VXP
COMMON SHARED Q, QDAM, UB, CARTWL, CMPND, SOFTSHAT, THNCHL, MSHAT, CRTGD
COMMON SHARED TA, UBMAN, UBCALC, TPCAL, THIN, YS, MTLBACK, TRUTHIN, PSHMAX
COMMON SHARED TD, LCMOD, POLMOD, POIMOD, SHAT, CART, VS, OB, OBRAD, EX, EXRAD
COMMON SHARED VLMT, VLSHAT, VLTRU, VITRU, TOTPLUGWT, NORMPLUGWT, DELTAPLUGWT
COMMON SHARED UBSV, QSV, QDAMSV, CARTWLSV, CMPNDSV, THNCHLSV, SOFTSHATSV, HF
COMMON SHARED CRITAGL, SHATRES, NSDAMAGL, BRAAK, APCAP, LTCASE, PLIM, PDAM
COMMON SHARED ALD, BLD, CLD, AED, BED, CED, NDAP, BRK, NSBRK, BDYDM, BEND, WT
COMMON SHARED BKEFF, PNL, PNI, PNLSHAT, CARDONALD, PNLPR, VHSHAT, PENFLG, VLND
COMMON SHARED VDFSTD, VDFUSED, VDFSTDWW1, VDFSTDWW2, VSCRIT, CAPHD, OBCRIT, WB
COMMON SHARED VHOL, WTSAVE, BRAIK, VDFBND, VDFBRK, MAXDIFF, SNCSMAX, OBDF, MO
COMMON SHARED THKTHN, THKTHNSV, MINEV, MINEV1, MINEV2, MINEV3, MINEV4, MINEV5
COMMON SHARED NVRFLAG, MAXOB, THVAL, THSPD, HARD, WD, VHTRU, CRTAPR, MTMP, VR
COMMON SHARED CURV, CRVRL, CRVFLAG, VRATMIN, VHEXREV, VLEXREV, VHDAM, VLDAM
COMMON SHARED VRAT, VRATVEL, EXMIN, TMPOBDF, NSSHAT, VNPLUG, VDPLUG, VRSHATNS
COMMON SHARED OB45, OB45CALC, VHSHATMAX, VLSHATMAX, CRITVEL, SHATVDF, NOTEFLAG
COMMON SHARED VDFUSEDPR, VRPR, VHND, EXTH, OBRK, TCAL, NSTEST, NSTESTV, SAMPRJ
COMMON SHARED OPRIMEL, OPRIMED, OBPRNT, EXPRNT, MTMPCR, MTMPNS, VCNT, FLAG
COMMON SHARED WTSVPRNT, WTPRNT, WBPRNT, SOFTQPMAX, MINSHVEL, PENCONST#, TEFF
COMMON SHARED SHATMULT, VTOTAL, UBFLAG, VDFHARVEY, SHATPRT, SAMEPLATE, VSCHECK
COMMON SHARED NBL1$, NBL2$, NBL3$, NBL4$, NBL5$, NBL6$, NBL7$, RESNOTE$, PSL$
COMMON SHARED HBL1$, HBL2$, HBL3$, HBL4$, HBL5$, HBL6$, HBL7$, HBL8$, HBL9$, ND$
COMMON SHARED PAND$, FLAKE$, CAP$, REMV$, NOTE1$, NOTE2$, NOTE3$, NOTE4$, NOTE5$
COMMON SHARED BDYDM1$, BDYDM2$, BDYDM3$, NSBRK1$, NSBRK2$, NSBRK3$, BD1$, BD2$
COMMON SHARED BKPRT1$, BKPRT2$, BKPRT3$, BKPRT4$, BKPRT5$, CALC$, EBL$, EFFVEL$
COMMON SHARED HBLTONBL$, N1$, N2$, N3$, N4$, H1$, H2$, H3$, H4$, PRJ$, NATN$
COMMON SHARED VELLTRU$, VELLSHAT$, VELLSHATMAX$, VELLND$, EFFPRINT1$, BDYDM4$
COMMON SHARED VELHTRU$, VELHSHAT$, VELHSHATMAX$, VELHND$, EFFPRINT2$, BDYDM5$
COMMON SHARED YS$, PEN1$, PEN2$, WBL1$, WBL2$, WBL3$, WBL4$, VEL$, NOTE5A$
COMMON SHARED ONEPC$, RVU$, DPLG$, REMVEL$, BSNS1$, BSNS2$, BSNS3$, NOTE5B$
COMMON SHARED TWOVEL$, AMPER$, NOPLG$, PEN3$
DIM SHARED M(15), MS(17)
COMMON M(), MS()
'
' **** BEGIN ACTUAL PROGRAM CODE ****
'*
'**INITIALIZE PROGRAM FIRST TIME ONLY**
'*
'INIT OB MULTIPLIER TABLES 'M()' & 'MS()' & OTHER CONSTANTS
'*
CALL OBMULT
'*
'ENLARGE SCREEN & PRINT SCREEN HEADER MSG
'*
REM ****
SCREEN 13
WIDTH 80, 43
CLS
REM ****
'*
CALL INITVALHDR
'*
PRINT "Show DEFINITIONS & VERSION 6.8 & 6.9 Changes Information Screens? (Y/N) ";
GOSUB CHKYESNO: PRINT YS$: IF (YS = 0) THEN PRINT : GOTO STARTPROG
CLS : VCNT = 1: ' PAGE 1 (DEFINITIONS)
CALL VERSIONPRNT(VCNT)
GOSUB CHKYESNO: IF (YS = 0) THEN CLS : GOTO STARTPROG: 'SHOW 1ST CHANGE X.X PAGE IF Y = 1
CLS : VCNT = 2: ' PAGE 2 (1ST CHANGE PAGE; ALWAYS USED)
CALL VERSIONPRNT(VCNT)
GOSUB CHKYESNO: IF (YS = 0) THEN CLS : GOTO STARTPROG: 'NO-OP ON LAST PAGE
CLS : VCNT = 3: ' PAGE 3 (2ND CHANGE PAGE; 6.8 USES)
CALL VERSIONPRNT(VCNT)
GOSUB CHKYESNO: IF (YS = 0) THEN CLS : GOTO STARTPROG: 'NO-OP ON LAST PAGE
CLS : VCNT = 4: ' PAGE 4 (3RD CHANGE PAGE; 6.8 USES)
CALL VERSIONPRNT(VCNT)
GOSUB CHKYESNO: IF (YS = 0) THEN CLS : GOTO STARTPROG: 'NO-OP ON LAST PAGE
CLS : VCNT = 5: ' PAGE 5 (4TH CHANGE PAGE; 6.8 USES)
CALL VERSIONPRNT(VCNT)
'*
'MOVE THE NEXT LINE TO JUST AFTER LAST CHANGE PAGE USED
GOTO PRINFO1: '4 CHANGE PAGES IN 6.8, SO ONLY CHECK FOR START PROGRAM (ONLY 'Y' LEGAL)
'
'* FOR FUTURE USE *
'
'ALLOW ONLY 5 CHANGE EXPLANATION PAGES
'CLS : VCNT = 5: ' PAGE 5
'CALL VERSIONPRNT(VCNT)
'GOSUB CHKYESNO: IF (YS = 0) THEN CLS : GOTO STARTPROG
'GOTO PRINFO1: 'ONLY X PAGES NOW (MOVED TO AFTER LAST USED PAGE & KILL GOSUB)
'* END OF FOR FUTURE USE *
'
PRINFO1:
GOSUB CHKYESNO: IF (YS = 1) THEN CLS :  ELSE GOTO PRINFO1: 'ONLY 'Y' ANSWER ALLOWED
'
'***
'** TOP OF MAIN PROGRAM LOOP **
'***
'
STARTPROG:
'
IF (SAMEPLATE > 0) THEN GOTO OLDARMOR
'IF NEW RUN USES SAME PLATE AS LAST RUN, SKIP ARMOR INPUTS
'
'INPUT ACTUAL PLATE THICKNESS VALUE ('TA')
'*
CALL GETPLATETHICKNESS
'*
'SELECT ARMOR TYPE
'*
CALL PRNTARMR
'*
MX = 22: OLDSEL = ARMOR: GOSUB SELECTION: ARMOR = SEL
'
IF ((OLDSEL = SEL) AND (SAMEPLATE = 2)) THEN GOTO MODARMOR
'PLATE TYPE AND THICKNESS UNCHANGED
'*
'SET NEW ARMOR VALUES & FLAGS
'*
CALL ARMORINFO(ARMOR)
'*
'SAVE NEW ARMOR VALUES AND FLAGS FROM ORIGINAL TABLE
UBSV = UB: QSV = Q: QDAMSV = QDAM: CARTWLSV = CARTWL: CMPNDSV = CMPND
THNCHLSV = THNCHL: SOFTSHATSV = SOFTSHAT: THKTHNSV = THKTHN
'
IF ((ARMOR = 1) OR (ARMOR = 3) OR (ARMOR = 4) OR (ARMOR = 12)) THEN
'GRUSON CHILLED CAST IRON, HARVEYIZED ARMORS, & TERNI CEMENTED FACE THICKNESS PERCENT
'  DECREASES ('UB' GOES UP) WITH INCREASING PLATE THICKNESS
'  (GRUSON & TERNI CHANGE ESTIMATED)
  IF (UBMAN > 0) THEN UB = UBMAN: 'CHANGE CURRENT UB VALUE IF MANUAL VALUE USED LAST RUN
  IF (UB > 75) THEN THNCHL = 1 ELSE THNCHL = 0
'*
  CALL GRSNHRVYTC
'*
END IF
'
MODARMOR:
'PRINT MESSAGE IF DEFAULT PARAMETERS HAVE BEEN CHANGED BY USER
'*
CALL CHGARMRPRNT
'*
GOSUB CHANGEARMOR: 'ALLOW USER TO MODIFY ARMOR PARAMETERS
'
'CHECK IF PLATE FALLS UNDER 'THIN' LOGIC
'*
CALL THINSELECT
'*
OLDARMOR:
TP = TA * Q: 'PEN EFFECTIVE THICKNESS W/O BACKING
TD = TA * QDAM: 'PROJ DAMAGE EFFECTIVE THICKNESS
'CURVED-PLATE RULE DEFINED: CURVED FH PLATES ELIMINATE BODY DAMAGE TO STEEL PROJ AT
'  OB>45 DEG IF HBL <= VEL < NBL. IF SHATR OCCURS, RESULTS IN NOSE-ONLY SHATR INSTEAD OF
'  USUAL COMPLETE SHATR.
PRINT : PRINT "Is plate strongly curved (part of dome, cylinder, ellipse, etc.)? (Y/N) ";
GOSUB CHKYESNO: PRINT YS$: CURV = 0: IF (YS = 1) THEN CURV = 1
PRINT : PRINT "Is there any backing material behind the face-hardened plate? (Y/N) ";
GOSUB CHKYESNO: PRINT YS$:
IF (YS = 0) THEN
'NO, SKIP BACKING MATERIAL ENTRIES
  WD = 0: CMT = 0: MTLBACK = 0: NBK = 0
  BTP = 0: QBK = 0: BKEFF = 0: TEFF = TP
  GOTO NOBACK
END IF
'ENTER BACKING DATA. THEY ONLY INCREASE RESISTANCE, NOT PROJ DAMAGE
'
'INPUT THICKNESS OF WOOD, CEMENT, &/OR METAL BACK SUPPORT LAYERS BEHIND ARMOR PLATE
'*
CALL ARMORBACK
'
IF (MTLBACK = 0) THEN
  BKEFF = 0: BTP = 0: NBK = 0: QBK = 0: 'ZERO METAL BACKING PLATE VALUES
ELSE
  GOSUB SELMTLBK: 'SELECT BACKING METAL TYPE
  IF (NBK = 0) THEN NBK = 1: 'SET DEFAULT = 1 IF NON-ZERO METAL BACKING THICKNESS
  PRINT "CURRENT NUMBER OF METAL BACKING PLATES ="; NBK
PLATENMBR:
  INPUT "Number of (laminated) metal backing plates: ", NBK$
  IF (NBK$ = "") THEN
    PRINT "Using"; NBK: NBKTEST = NBK
  ELSE
    NBKTEST = VAL(NBK$)
  END IF
  IF ((NBKTEST < 1) OR (NBKTEST <> INT(NBKTEST))) THEN GOTO PLATENMBR: 'BAD INPUT
  NBK = NBKTEST
'ALL METAL BACKING PLATES ASSUMED IDENTICAL (USUAL DESIGN)
  BKEFF = .5 * (NBK * (MTLBACK * QBK / NBK) ^ 1.4) ^ .714286: 'DE MARRE SPACED ARMOR/2
END IF
TEFF = TP + WD + CMT + BKEFF: 'TOTAL EFFECTIVE THICKNESS OF PLATE + BACKING
NOBACK:
PRINT
'****
'PROJECTILE SELECTION LOGIC
'****
IF (SAMPRJ = 1) THEN GOTO SAMEPROJ: ''SAMPRJ'=1 MEANS REPEAT SAME PROJ
SAMEARMOR:
'*
GOSUB SELECTNATION: 'SELECT PROJ NATION & TYPE
'*
PRINT
'*
' INPUT PROJ DIAM, TOTAL WT, & BODY WT & SET/CLEAR 'CAPHD' FLAG
'*
CALL GETPROJDWTWB
'*
SAMEPROJ:
'*
' *BEGIN NOSE COVERINGS LOST PRIOR TO FACE-HARDENED ARMOR IMPACT LOGIC*
'*
IF (WB = WTSAVE) THEN
  PRINT "IF ANY EXISTED, ALL NOSE COVERINGS WERE ALREADY REMOVED PRIOR TO IMPACT"
ELSE
  PRINT "YOU NEED SEPARATE NOSE COVERING WEIGHTS IF ONLY WINDSCREEN IS NOW MISSING"
END IF
PRINT
HARD = APCAP: CAPHDRMV = 0: WT = WTSAVE: 'INIT DEFAULT VALUES FOR POSSIBLE CHANGE
'ONLY POST-WWI JAP 'DIVING' TYPE 88/91/1 AP PROJ HAD A REMOVABLE NOSE-TIP CALLED
'   A 'CAP HEAD' (FLAT END UNDER IT). LOSS OF WINDSCREEN ALWAYS CAUSED LOSS OF
'   CAP HEAD, WHICH WAS HELD ON ONLY BY NOTCHED WINDSCREEN THREADS.
'CAP HEAD WAS AP CAP TIP IN LARGER, CAPPED JAP TYPE 88/91/1 PROJ, SO LOSING
'   CAP HEAD KEPT MOST OF AP CAP.
'UNCAPPED JAP TYPE 91 AP W/O CAP HEAD & WINDSCREEN REVERTS TO PRE-WWI UNCAPPED
'   AP & COMMON PROJ (DEFAULT #3)
IF (WT = WB) THEN
'DISCARD ALL NOSE COVERINGS
  HARD = 0: 'SET NO AP CAP FLAG
'IF CAPPED PROJ, USE AP-CAP-REMOVED BONUS, IF APPLICABLE
  GOTO CAPGONE: 'SKIP REST OF NOSE-COVERINGS-LOST LOGIC
END IF
''HOOD' IS THIN SOFT-AP-CAP-LIKE NOSE COVERING FOR SCREWING ON WINDSCREEN.
'  IT ACTS AS A LOW-GRADE SOFT AP CAP.  A HOOD WILL ACT AS AN SOFT AP CAP,
'  BUT IF IMPACT IS BELOW THE NBL, THE PROJECTILE NOSE BREAKS UP NO MATTER WHAT.
'HOMOGENEOUS IRON PLATES > .0805 CAL THICK & ALL FH PLATES REMOVE AP CAPS OR HOODS.
'ALMOST ALL METAL PLATES USED IN WARSHIPS REMOVE WINDSCREENS
'  (ALL IMPACTS WITH ANYTHING REMOVE GERMAN WWII BRITTLE ALUMINUM WINDSCREENS OR
'  EXPLOSIVE-TIPPED FRENCH/BRITISH 'K' SHELLS USED WITH DYE BAGS)
IF ((APCAP > 0) AND (CAPHD <> 1) AND (WT > WB)) THEN
  PRINT "Has the AP Cap (and all other nose coverings) been removed? (Y/N) ";
  GOSUB CHKYESNO: PRINT YS$
  IF (YS = 1) THEN HARD = 0: WT = WB: GOTO CAPGONE
'IF YES, SKIP REST OF NOSE-COVERINGS-LOST LOGIC
END IF
IF (CAPHD > 0) THEN
'JAP TYPE 88/91 AP PROJ LOGIC
  PRINT "IF WINDSCREEN IS REMOVED, JAPANESE TYPE 88/91/1 AP/APC CAP HEAD IS ALSO REMOVED."
  PRINT "THIS TURNS UNCAPPED AP PROJECTILE INTO A VERY BLUNT UNCAPPED SAP PROJECTILE WITH"
  PRINT "  POOR FH ARMOR PENETRATION.  CAPPED DESIGNS LOSE SOME PENETRATION ABILITY, TOO."
  PRINT
  PRINT "Have the Windscreen and Cap Head been removed? (Y/N) ";
  GOSUB CHKYESNO: PRINT YS$
  IF (YS = 1) THEN
'YES
    CAPHDRMV = 1
    IF (CAPHD = 1) THEN
'UNCAPPED TYPE 91 AP PROJ (LOSES MOST OF NOSE; MUST ALSO CHANGE PROJ PEN/DAM PARAMETERS)
      WT = WB: 'ONLY FLAT-NOSED BODY REMAINS
    ELSE
'CAPPED TYPE 88/91/1 AP PROJ (ONLY LOSES WINDSCREEN & AP CAP TIP)
      WTDIFF = WT - WB
      IF (WCHWT >= WTDIFF) THEN WCHWT = 0: 'SET WCHWT = 0 IF TOO BIG
      PRINT "MOST OF AP CAP REMAINS ATTACHED.  SOME LOSS OF PROJECTILE QUALITY."
      PRINT "CURRENT COMBINED WINDSCREEN & CAP HEAD WEIGHT ="; WCHWT; "pound";
      IF (WCHWT > 1!) THEN PRINT "s":  ELSE PRINT
WINDCPHD:
      INPUT "Combined Windscreen and Cap Head Weights (WCH), pounds: ", WCHWT$
      IF ((WCHWT$ = "") AND (WCHWT >= 0) AND (WCHWT < WTDIFF)) THEN
	PRINT "Using"; WCHWT
      ELSE
	WCHWT = VAL(WCHWT$)
      END IF
      IF ((WCHWT < 0) OR (WCHWT >= WTDIFF)) THEN GOTO WINDCPHD: 'BAD INPUT
      WT = WT - WCHWT
    END IF
  ELSE
    CAPHDRMV = 0: 'CAP HEAD STILL THERE
  END IF
'USE WHAT'S LEFT AS 'WT' FROM NOW ON (WITH OR WITHOUT CAP HEAD & WINDSCREEN)
ELSE
'LOGIC FOR ALL OTHER PROJ TYPES
  IF ((APCAP <= 0) AND (WT > WB)) THEN
    PRINT "Have both Hood, if any, and Windscreen been removed? (Y/N) ";
    GOSUB CHKYESNO: PRINT YS$: IF (YS = 1) THEN WT = WB: HARD = 0
  END IF
  IF (WT > WB) THEN
'WINDSCREEN LOSS ONLY LOGIC (MINOR WEIGHT LOSS EFFECT)
    WDIFF = WT - WB
    PRINT "Has only the Windscreen, if any, been removed? (Y/N) ";
    GOSUB CHKYESNO: PRINT YS$
    IF (YS = 1) THEN
'YES (IF NO, THEN NOTHING HAS BEEN REMOVED)
      IF (WWT > WDIFF) OR ((APCAP <> 0) AND (WWT = WDIFF)) THEN WWT = 0: 'SET WWT = 0 IF TOO BIG
      PRINT "CURRENT WINDSCREEN WEIGHT ="; WWT; "pound";
      IF (WWT > 1!) THEN PRINT "s":  ELSE PRINT
WINDSCRNWT:
      INPUT "Windscreen Weight (WW), pounds: ", WWT$
      IF ((WWT$ = "") AND (WWT >= 0) AND ((WWT < WDIFF) OR ((APCAP = 0) AND (WWT = WDIFF)))) THEN
	PRINT "Using"; WWT
      ELSE
	WWT = VAL(WWT$)
      END IF
      IF ((WWT < 0) OR (WWT > (WT - WB)) OR ((APCAP <> 0) AND (WWT = (WT - WB)))) THEN
	GOTO WINDSCRNWT: 'BAD INPUT
      END IF
      WT = WT - WWT: 'USE WHAT'S LEFT AS 'WT' FROM NOW ON
    END IF
  END IF
END IF
'*
CAPGONE:
'LOSS OF AP CAP ASSUMES LOSS OF ALL PROJ NOSE COVERINGS
IF (WT = WB) THEN
  IF ((CAPHD = 1) AND (PROJ = 10)) THEN
'WHEN UNCAPPED TYPE 91 AP PROJ LOSES ITS CAP HEAD, SWITCH TO
'  PRE-WWI UNCAPPED AP & COMMON PROJ PARAMETERS (DEFAULT #3)
    SHATRES = 1: APCAP = 0: NSDAMAGL = 5: PLIM = .795: PDAM = .7
    ALD = .000143: BLD = 2.249: CLD = .00267: CRITAGL = 0: BRAAK = 2: LTCASE = 0
    AED = .000247: BED = 2.129: CED = .00172: BEND = 0: CARDONALD = 0
  END IF
  HARD = 0: 'NO CAP REMAINING ON SHELL
ELSE
  HARD = APCAP: 'AP CAP OR HOOD STILL THERE
END IF
'END OF NOSE-COVERINGS-LOST LOGIC
'***
'* DETERMINE WHEN THIN PLATE LOGIC SETS IN
'
' TA<='THIN'-->START EFFECTS; TA<='TRUTHIN'-->FULL EFFECTS
'*
CALL THINPRINT
'*
PRINT
IF (VS > 0) THEN
  PRINT "CURRENT STRIKING VELOCITY ="; VS;
  IF (VS > 1!) THEN PRINT "feet/second":  ELSE PRINT "foot/second"
END IF
STRIKEVEL:
INPUT "Striking velocity (VS), feet/second (Whole number only; 1-4000): ", VS$
IF ((VS$ = "") AND (VS > 0)) THEN
  PRINT "Using"; VS
ELSE
  VSTEST = VAL(VS$): VSINT = INT(VSTEST)
END IF
IF ((VSTEST < 1) OR (VSTEST > 4000) OR (VSTEST <> VSINT)) THEN GOTO STRIKEVEL: 'BAD INPUT
VS = VSTEST
'*
'PRINT DISCUSSION ON OBLIQUITY, SOFT AP CAPS, & HOODS
'*
CALL OBHDSAPCAP
'*
MAXOB = 75!: TPCAL = TP / D: IF (TPCAL < THIN) THEN MAXOB = 80!
'*
' INPUT IMPACT OB IN DEG
'*
CALL OBINPUT
'*
'CAP HEAD LOSS LOGIC FOR CAPPED JAP TYPE 88/91/1 PROJ
IF ((CAPHD = 2) AND (CAPHDRMV = 1)) THEN
'CAP HEAD LOSS IN CAPPED TYPE 88/91/1 DEGRADES PEN, BUT HAS LESS EFFECT AT OB>45 DEG
  CAPHDLOSS = .045: 'FOR OB<45 DEG ONLY
  IF (OB >= 45!) THEN CAPHDLOSS = CAPHDLOSS * (COS(2 * (OB - 45!) / 57.29578)) ^ 2
ELSE
  CAPHDLOSS = 0
END IF
'*
BRAIK = BRAAK: 'IF 'BRAAK'>0, PROJ BREAKS IF VEL<NBL. SET 'WORKING' VALUE.
PRINT
'*
'** ALL INPUTS DONE EXCEPT SHATR-ZONE-OF-MIXED-RESULTS (Z-O-M-R) QUESTION **
'*
' * SHATR & NOSE-ONLY SHATR DETERMINATION LOGIC *
'
'UNLIKE HOM ARMOR, SHATR VEL ASSUMED ZERO (UNCAPPED PROJ ALWAYS SHATR) FOR ALL FH ARMORS,
' EXCEPT FOR COMPOUND ARMOR (& SOMETIMES WITH HARVEYIZED STEEL ARMOR), WHERE ONLY
' CHILLED CAST IRON PROJ WILL SHATR.
'SHATR OVERRIDES CARTWHEEL EFFECTS (EXCEPT SPLINTERS IF NO PEN), IF BOTH OCCUR
SHAT = 0: SHATPRT = 0: CART = CARTWL: 'INIT SHATR & INTERNAL CARTWHEEL FLAGS
''SHAT'=1 SETS 'CART'=0
'*
TOTHNFLG = 0: 'SOME PLATES TOO THIN TO DAMAGE STEEL PROJ MUCH IF SET TO 1
IF (((TD / D) / COS(OBRAD)) < .25) THEN TOTHNFLG = 1: 'PLATE DOES MINIMAL DAMAGE
IF ((((SHATRES <> 2) OR ((SHATRES = 2) AND (HARD = 1) AND (OB < 20!))) AND (TOTHNFLG = 1))) THEN
'ALL-STEEL PLATE EFFECTIVE DAMAGE-CAUSING THICKNESS TOO THIN TO SHATR ANY STEEL PROJ
'  OR A SOFT-CAPPED CHILLED CAST IRON PROJ WHEN CAP WORKS
  IF (CMPND = 1) THEN
    SKIPSHTR = 2
'CHECK Z-O-M-R FOR SHATR
  ELSE
    SKIPSHTR = 1: SHATPRT = 1
'NEVER SHATR, TOO THIN
  END IF
ELSEIF ((SHATRES <> 2) AND ((ARMOR = 3) OR (ARMOR = 4))) THEN
'HARVEY ARMOR VS STEEL PROJ LOGIC
  IF ((BRAIK < 2) OR (BEND = 2)) THEN SKIPSHTR = 1: SHATPRT = 2
'NOT WEAKEST PROJ, SO NO SHATR
ELSEIF (CMPND = 1) THEN
'COMPOUND ARMOR LOGIC
  SKIPSHTR = 2: 'DO Z-O-M-R LOGIC UNLESS CHANGED
  IF (SHATRES = 2) THEN
'CHILLED CAST IRON (GRUSON/PALLISER) PROJ LOGIC
    IF (HARD = 0) THEN
'UNCAPPED CHILLED CAST IRON PROJ
      SHAT = 1: CART = 0
'ALWAYS SHATR
      SKIPSHTR = 1: 'SHATR SET, SO SKIP REST OF SHATR LOGIC
    END IF
'IF 'HARD'<>0, THEN DO Z-O-M-R FOR SOFT-CAPPED CHILLED CAST IRON PROJ
' (NO HARD-CAPPED DESIGNS MADE)
  ELSE
    SKIPSHTR = 1
'NOT IRON PROJ, SO SKIP ALL SHATR LOGIC
    SHATPRT = 3
  END IF
END IF
IF (SKIPSHTR = 1) THEN SKIPSHTR = 0: GOTO IRONPROJ: 'SKIP SHATR LOGIC
IF (SKIPSHTR = 2) THEN SKIPSHTR = 0: GOTO CASTIRONCMPND: 'CHECK Z-O-M-R
' ***
' ** REGULAR SET SHATR LOGIC **
' ***
' BRIT IMPROVED WWI KC ('SOFTSHAT' = 2) WHEN NOT VS MIDVALE UNBRKBLE PROJ
' ('CARDONALD' NOT 2) SAME AS 'SOFTSHAT' = 1
IF ((SOFTSHAT = 1) OR ((SOFTSHAT = 2) AND (CARDONALD < 2))) THEN SHATSOFT = 1:  ELSE SHATSOFT = 0
' HIGHEST QUALITY ARMOR DEF
IF ((TD / D) >= .67) THEN TOOTHICK = 1:  ELSE TOOTHICK = 0
'ARMOR DAMAGE-CAUSING THICKNESS IS TOO THICK FOR THIN HARD/TOUGH CAP AT OB>20 DEG
IF ((HARD = 0) OR (HARD = -1)) THEN
  SHAT = 1: ' HOOD OR NO AP CAP VS MOST FH ARMOR
ELSEIF (HARD = 1) THEN
  IF ((OB > 20!) OR (SHATSOFT = 1)) THEN SHAT = 1
'SOFT CAPS DO NOT WORK OVER 20 DEGR OR AGAINST HIGHEST QUALITY ARMOR
ELSEIF (HARD = 3) THEN
  IF ((SHATSOFT = 1) AND (TOOTHICK = 1) AND (OB > 20!)) THEN SHAT = 1
'SMALL/THIN HARD CAP ONLY WORKS AT ALL OB VS THINNER HIGHEST QUALITY PLATES
ELSEIF ((CAPHD = 1) AND (HARD = 2)) THEN
'CAP HEAD ON UNCAPPED TYPE 91 SHELL STILL IN PLACE
  SHAT = 1
'CAP HEAD PROTECTION TO UNCAPPED JAP TYPE 88/91/1 NOSE VERY LIMITED
END IF
'
IF (SHAT = 1) THEN
  IF ((HARD = 1) AND (((SOFTSHAT = 2) AND (CARDONALD < 2)) OR (SOFTSHAT = 1)) AND (OB <= 20!)) THEN
    NSSHAT = 1
'PUT SOFT CAP & SOFTSHAT NOSE-ONLY SHATR RULE IN FORCE
  ELSEIF ((HARD = -1) AND (SOFTSHAT = 0) AND (SHATRES < 2) AND (OB <= 20!)) THEN
    NSSHAT = 4
'PUT HOOD NON-SOFTSHAT NO-SHATTER RULE IN FORCE FOR STEEL PROJECTILES
  END IF
END IF
'
CASTIRONCMPND:
IF ((OB > 15!) AND (OB <= 20!) AND (ABS(HARD) = 1)) THEN
'USER SELECTS SOFT CAP FUNCTION (RAPID ROLL-OFF W/INCREASING OB IN REAL IMPACTS)
  PRINT "INSIDE SOFT AP CAP & HOOD 15-20 DEGREE SHATTER ZONE OF MIXED RESULTS."
  IF (SHATRPRT <> 0) THEN SHATRPRT = 0: 'REGULAR SHATR LOGIC
  PRINT "  Do you wish the projectile's SOFT AP cap or HOOD to work? (Y/N) ";
  GOSUB CHKYESNO: PRINT YS$
  IF (YS = 0) THEN
    SHAT = 1: CART = 0: NSSHAT = 0: 'NO -- USE COMPLETE SHTR AGAIN
  END IF
END IF
'
MINSHVEL = 0: ' RESET MIN COMPLETE SHTR VEL
IF ((SHAT = 1) AND (NSSHAT = 0)) THEN
  MINSHVEL = 1170 * COS(OBRAD): ' MIN VEL FOR COMPLETE SHATR FOR STRONGER SHELLS
  IF ((BRAIK = 0) AND (VS <= MINSHVEL)) THEN NSSHAT = 2
END IF
'*
IRONPROJ:
'
IF (SHAT = 1) THEN CART = 0:  ELSE CART = CARTWHL
'LARGE SHATR HOLE REPLACES CARTWHEEL HOLE
'
HF = 0: IF ((SHAT = 0) AND (OB > 70!)) THEN HF = 1
'COMPLETE PEN NOT POSSIBLE IF 'HF' = 1
CLS : PRINT SPC(30); "USUAL RESULTS": 'PRINT SCREEN HEADER
'* DO CALCULATIONS *
GOSUB CALCBL: 'COMPUTE VARIOUS BALLISTIC LIMITS
GOSUB BLPLUSEX: 'SELECT APPLICABLE LIMIT VELOCITIES FOR THIS CASE & COMPUTE EXIT ANGLE
GOSUB DAMAGECALC: 'COMPUTE PROJ CONDITION AFTER IMPACT
GOSUB PLUGWTS: 'COMPUTE EJECTED PLUG WEIGHTS
GOSUB FINALRESULTS: 'DETERMINE WHAT HAPPENED TO PLATE
GOSUB RESULTSPRINT: 'PRINT RESULTS
'*
'* END-OF-RUN LOGIC *
PRINT "OUTPUT RESULTS TO PRINTER? (Y/N) ";
GOSUB CHKYESNO: PRINT YS$: IF (YS = 1) THEN GOSUB HARDCOPY
PRINT "ANOTHER RUN? (Y/N) ";
GOSUB CHKYESNO: PRINT YS$: IF (YS = 0) THEN END: '** END OF PROGRAM **
IF (CAPHD = 1) AND (PROJ = 10) THEN
'RE-INIT UNCAPPED JAP TYPE 91 AP PROJ (15.5CM & 20.3CM) ORIGINAL PARAMETERS
  CRITAGL = 15: SHATRES = 1: NSDAMAGL = 20: BRAAK = 1: APCAP = 2
  LTCASE = 1: PLIM = .945: PDAM = -1
  ALD = .00336: BLD = 1.418: CLD = .0091701
  AED = -1: BED = -1: CED = -1
END IF
SAMPRJ = 0: NEWRUN = 0: SAMEPLATE = 0: PREVARMOR = ARMOR
PRINT "USE SAME PROJECTILE? (Y/N) ";
GOSUB CHKYESNO: PRINT YS$: IF (YS = 1) THEN NEWRUN = 1: SAMPRJ = 1
PRINT "USE SAME ARMOR PLATE (RETAIN PARAMETER CHANGES, IF ANY)? (Y/N) ";
GOSUB CHKYESNO: IF (YS = 1) THEN NEWRUN = NEWRUN + 2: SAMEPLATE = 1
CLS : PRINT
PENTP = 0: PENFLG = 0: SHAT = 0: NSSHAT = 0: BRK = 0: NSBRK = 0
SELECT CASE NEWRUN
  CASE 0
    GOTO STARTPROG: 'RE-DO ALL INPUTS ('SAMPRJ' = 0)
  CASE 1
    GOTO STARTPROG: 'RE-DO ARMOR INPUTS ONLY ('SAMPRJ' = 1, SO USE SAME PROJECTILE)
  CASE 2
    GOTO SAMEARMOR: 'REDO PROJ INPUTS ONLY ('SAMPRJ' = 0)
  CASE 3
    GOTO SAMEPROJ: 'USE BOTH OLD ARMOR & PROJ INPUTS
'    (ONLY REDO STRIKING CONDITIONS) ('SAMPRJ' = 1)
END SELECT
'
'***
' >>* END OF MAIN PROGRAM LOOP *<<
'***
'
' **** SUBROUTINES FOLLOW ****
'
'* CENTRAL B.L. CALC--DO THE MATH! *
CALCBL:
'*
'COMPUTE SCALE FACTOR 'SC'
'*
CALL SCALEFACTOR(UB)
'*
'SCALING FACTOR 'SC=(AZ)(D^BZ)+CZ' BASED ON UNAFFECTED BACK PERCENTAGE OF
'  ACTUAL PLATE THICKNESS (STEP-FUNCTION APPROX)
'THINNER BACK = LARGER SCALING EFFECTS FROM FACE & TRANSITION LAYER SHEARING
'  & BRITTLE FRACTURE FAILURE
''AZ' & 'BZ' FOR FACE & TRANSITION LAYER & 'CZ' FOR SOFT BACK LAYER
'*
DEN = (WT / (D ^ 3)) ^ .2: 'PROJ WEIGHT TERM
'*
'THIN CHILL, HARVEY, & COMPOUND ARMORS CAN CAUSE LESS STRONG PROJ DAMAGE,
'  SO IF THEY CAUSE DAMAGE,
'  THE REDUCED 'QP' THEY CAUSE CAN BE INCREASED BACK UP TO 1.0 (HARD CAP)
'  OR 'SOFTQPMAX' (SOFT CAP/HOOD) MAXIMUM VALUE ("PERFECT PROJ")
'BONUS TO INNATE PROJ PEN ABILITY FOR STRONGER PROJ DUE TO WEAK PLATES
'
PPLUS = 0: 'RESET
'******
' WEAKEST PLATES STRESS STRONGER PROJ LESS SO PROJ QUALITY OF THOSE PROJ
'   INCREASED
IF (CMPND = 1) THEN
'COMPOUND ARMOR VERY WEAK
  IF (SHATRES = 2) THEN
'CAST IRON PROJ NOT IMPROVED
    PPLUS = 0
  ELSEIF (BRAIK = 2) THEN
'WEAKEST STEEL PROJ SOMEWHAT IMPROVED
    PPLUS = .1: '10% PROJ QUALITY GAIN
  ELSEIF (BEND = 2) THEN
'DEFORMABLE MIDVALE STEEL PROJ SOMEWHAT IMPROVED
    PPLUS = .1: '10% PROJ QUALITY GAIN
  ELSE
'STRONG STEEL PROJ GREATLY IMPROVED
    PPLUS = .2: '20% PROJ QUALITY GAIN
  END IF
ELSEIF (THNCHL = 1) THEN
'IF THINCHILL (THIN-CEMENTED FACE) PLATE, PLATE STRESSES SOME STRONG PROJ
'  LESS SO THEIR PROJ QUALITY INCREASED
'   STRONG STEEL PROJ
  IF (SHATRES = 2) THEN
'CAST IRON PROJ NOT IMPROVED
    PPLUS = 0
  ELSEIF (BRAIK = 2) THEN
'WEAKEST STEEL PROJ NOT IMPROVED
    PPLUS = 0
  ELSEIF (BEND = 2) THEN
'DEFORMABLE MIDVALE STEEL PROJ NOT IMPROVED
    PPLUS = 0
  ELSE
'STRONGER STEEL PROJ IMPROVED
    PPLUS = .1: '10% PROJ QUALITY GAIN
  END IF
END IF
'******
'*
'PROJ PEN QUALITY LOGIC
IF ((PLIM > 1!) AND (APCAP <> HARD)) THEN
  PLM = 1!
'IF 'PLIM'>1, AP CAP IS REASON, SO IF LOST, 'PLIM' REDUCED TO DEFAULT MAX (= 1!).
ELSE
  PLM = PLIM - CAPHDLOSS
END IF
IF (PLM < 1!) THEN
'NO BONUSES USED IF PROJ QUALITY ALREADY >= 1.00
  PLM = PLM + PPLUS
'BONUS CANNOT MAKE PROJ BETTER THAN ITS BEST POSSIBLE VALUE!!
  IF (ABS(HARD) = 1) THEN MAXPLM = SOFTQPMAX:  ELSE MAXPLM = 1!
'  SOFT AP CAP OR HOOD ROBS ENERGY FROM IMPACT BUT CONTRIBUTES NO ENERGY
  IF (PLM > MAXPLM) THEN PLM = MAXPLM
END IF
'*
'PROJ DAMAGE-RESISTANCE QUALITY LOGIC
IF ((PLIM > 1!) AND (APCAP <> HARD)) THEN
  PDM = PDAM * (1! - (PLIM - 1!) / PLIM)
'  LOSS OF THE AP CAP REDUCES 'PDAM' BY THE SAME AMOUNT AS 'PLIM'
ELSE
  PDM = PDAM - CAPHDLOSS
END IF
IF (PDM > 0) AND (PDM < 1!) THEN PDM = PDM + PPLUS
'  ONLY SOME BONUSES APPLY TO EFFECTIVE LIMIT
'*
' SPECIAL BEST U.S. PROJ LOGIC FOR IMPACT EXTREME CONDITIONS
'  (NO IMPROVEMENT OVER PREVIOUS DESIGNS IF LOGIC APPLIES)
IF ((NATION = 1) AND (PROJ = 20)) THEN
  DAMCHK = (TD / D) * OB
  IF (DAMCHK > 32.175) THEN
' USE NEXT-BEST PROJ (= 19) UNDER EXTREME CONDITIONS
    PLM = .94: PDM = .94
    CRITAGL = 25: NSDAMAGL = 25
  END IF
END IF
'*
''PNI' APPLIES TO EFFECTIVE LIMIT & 'PNL' TO HBL & NBL.
'  BY DEFINITION, MIN POSSIBLE EFFECTIVE COMPLETE PEN IS AT NBL.
PNL = PLM
'*****
PENCONST# = 1.9822E-06 * D * SC * DEN: 'CONSTANT PEN FORMULA ('CORE' TERM)
'*****
'CRITICAL DEFLECTION THRESHOLD ANGLE FOR "INEFFECTIVE" DAMAGE
'NEGATIVE VALUES ONLY USED FOR BRITISH 'BEND' EFFECTIVE PROJ LOGIC
IF (CRITAGL <= 0) THEN
  CRTAPR = 0
ELSE
  CRTAPR = CRITAGL: 'DEFAULT TABLE VALUE
END IF
IF ((CRITAGL > 0) AND (CMPND = 1) AND (SHATRES < 2)) THEN CRTAPR = CRITAGL + 10
'  COMPOUND PLATES CAUSE MUCH LESS DAMAGE TO STEEL PROJ
IF ((CRITAGL > 0) AND (THNCHL = 1)) THEN
  IF (BRAIK = 2) THEN
    CRTAPR = CRTAPR: ' NO CHANGE FOR WEAKEST STEEL PROJ
  ELSEIF (SHATRES = 2) THEN
    CRTAPR = CRTAPR: ' NO CHANGE FOR CAST IRON PROJ
  ELSE
    CRTAPR = CRITAGL + 5: 'THIN-FACED ARMOR STRESSES STRONGER STEEL PROJ LESS
  END IF
END IF
'BRITISH WWII BENDING PROJ CRITICAL ANGLE 'OBCRIT' INCREASES WITH OLDER PLATES
IF (BEND = 1) THEN
  OBCRIT = ABS(CRITAGL): ' VS WWII USUAL PLATE TYPES
  IF (((SOFTSHAT = 0) OR (CART > 0)) AND (THNCHL = 0)) THEN
    IF (CMPND = 1) THEN
      OBCRIT = OBCRIT + 12: ' VS COMPOUND ARMOR (ESTIMATE)
    ELSE
      OBCRIT = OBCRIT + 6: ' VS MORE BRITTLE NON-COMPOUND PLATES (ESTIMATE)
    END IF
  END IF
ELSE
  OBCRIT = -1: ' NO-OP VALUE
END IF
'*
'COMPUTE OBLIQUE IMPACT THICKNESS MULTIPLIERS 'MO' & 'MSHAT'
'*
CALL SETOBMULT
'*
'COMPUTE DAMAGE-RELATED LIGHTCASE & OBLIQUE IMPACT HBL, NBL,
'  & EFFECTIVE LIMIT PROJ QUALITY MODIFIERS
'*
CALL PROJQMODS
'*
''PNLPR' IS MAX PROJ QUALITY FACTOR ALLOWED. FOR USE WHEN VEL>=EFFECTIVE LIMIT
'  FOR PROJ THAT ARE DAMAGED AT NBL
IF (((PNL < 1!) AND (HARD > 1)) OR (HARD = 0)) THEN
  PNLPR = 1!: 'BEST PERFORMANCE W/REGULAR HARD AP CAPS OR NO CAPS
'  (LATTER HAS SHATR OVERRIDE THIS, OF COURSE)
ELSEIF (ABS(HARD) = 1) THEN
  PNLPR = SOFTQPMAX
'BEST PERFORMANCE W/SOFT AP CAPS (THEY DON'T DAMAGE PLATES WHILE BEING DESTROYED)
ELSE
  PNLPR = PNL
'BEST PERFORMANCE FOR PROJ W/SUPERIOR HARD AP CAP DESIGN ('PNL' > 1)
END IF
IF (PNL > PNLPR) THEN PNL = PNLPR: ' HIT THE MAX STOP VALUE
PNI = PDM: IF ((PNI < 0) OR (PNI > PNL)) THEN PNI = PNL: ' 'PNI' CAN NEVER EXCEED 'PNL'
'*
'ADD THE EFFECTS OF ALL OTHER NORMAL-OB PROJ DAMAGE TO SHATR (LIGHTCASE PROJ ONLY)
'NO OBLIQUE-IMPACT-ONLY EFFECTS USED SINCE SHATTER SCRAMBLES THEM
'LOSS OF SOFT AP CAP OR HOOD INCREASES ENERGY AVAILABLE FOR PENETRATION SLIGHTLY,
'  EVEN W/SHATR OCCURRING (NOT USED IF HARD CAP OR IF NO CAP OR HOOD TO START WITH!)
IF ((LTCASE > 0) OR (BRAIK > 0)) THEN
  PNLSHAT = PNL: 'SAME QUALITY AS FOR NO SHATR
  IF (LTCASE = 2) THEN PNLSHAT = PNLSHAT * (1 - LCMOD): 'INCLUDE ADDED LTCASE DAMAGE
  IF (((ABS(APCAP) = 1)) AND (WT <> WB)) THEN
    PSHMAX = SOFTQPMAX
'SOFT AP CAP OR HOOD STEALS EXTRA ENERGY, SO INCLUDE THIS LOSS
  ELSE
    PSHMAX = 1!
'SHATR QUALITY IS NEVER BETTER THAN PERFECT UNCAPPED VALUE
  END IF
  IF (PNLSHAT < .095) THEN PNLSHAT = .095
'MIN MOD ALLOWED TO PREVENT PROGRAM CRASH
  IF (PNLSHAT > PSHMAX) THEN PNLSHAT = PSHMAX
'MAX SHTR PROJ QUALITY IS LOWER OF 1.00 OR SOFT CAP/HOOD LIMIT
ELSE
'SMALL CAVITY (<4% HE WT) SEEMS TO PREVENT PROJ NON-SHATR DAMAGE IF A STRONGER PROJ SHATRS
  PNLSHAT = 1!
  PSHMAX = 1!
END IF
' IF THE PROJECTILE CHANGES ITS MODE OF FAILURE AS OBLIQUITY GOES UP IN THE 0-30 DEGREES RANGE
'   FROM COMPRESSION/SHOCK DAMAGE TO BENDING DAMAGE, SHATTER SEEMS TO PREVENT THE BENDING DAMAGE
'   FROM OCCURRING, SO THAT THE VALUE OF 'PLIM' AT OB=0-15 DUE TO COMPRESSION/SHOCK DAMAGE GOES
'   LINEARLY BACK TO 'PSHMAX' AT OB>=30, REGARDLESS OF ITS VALUE AT OB=0-15, IF UNDER 1!.
IF (BEND = 1) AND (PNLSHAT < 1!) THEN
  IF (OB >= 30) THEN
    PNLSHAT = PSHMAX
  ELSEIF ((OB > 15) AND (OB < 30)) THEN
    PNLSHAT = PNLSHAT + (PSHMAX - PNLSHAT) * (OB - 15) / 15
  END IF
END IF
IF (SHAT = 1) THEN PNI = PNLSHAT: 'NO SEPARATE EFFECTIVE LIMIT EXISTS FOR SHATR
'*
'*** COMPUTE ALL BALLISTIC LIMITS (NORMAL & AT GIVEN OB) ***
'*
'UNDAMAGED-PROJ NBL (USED FOR POST-IMPACT RESULTS IF DAMAGE CEASES AT SOME VEL > NBL;
'  ONLY REAL IF NO DAMAGE AT NBL, TOO)
VLND = (TEFF * MO / (PENCONST# * PNLPR)) ^ VXP: VLND = INT(VLND)
'*
' COMPUTE DIFF BETWEEN NBL & HBL FOR VARIOUS CONDITIONS
'*
CALL CALCVDF
'*
'*****>>> SHATR VEL CALC <<<*****
'*
'SHATR **HBL** HAS 0%, 20%, 30%, OR 40% PLATE THICKNESS BONUS AT NORMAL OB.
'  IT USUALLY DECREASES (NEVER NEGATIVE!) AT HIGHER OB.  THIS CHANGES NBL.
CALL SHTRMULTSELECT
'*
IF (OB <= 45!) THEN
'DIFF BETWEEN SHATR HBL & NBL IS INCREASE OVER HBL NEEDED TO COMPLETELY PENETRATE A PLATE
  SHATVDF = 1 / (1 - VDFSTD)
'BENDING OF BRITISH DEFORMABLE NON-CARDONALD PROJ HAS NO EFFECT HERE
ELSE
'DIFFERENCE BETWEEN SHATR HBL & NBL DECREASES AT OB > 45 DEG (OTHERWISE USE SAME VALUE)
  SHATVDF = 1 / (1 - (VDFSTD * COS(2 * (OB - 45!) / 57.29578) ^ 8))
END IF
'*
'"PERFECT" PROJ SHATR HBL & NBL W/NO OTHER DAMAGE EFFECTS. IGNORE BRITISH PROJ MODS HERE, TOO.
'  THIS HBL IS UNSHATRD HBL WHEN 'VHSHATMAX'<'VHTRU' DUE TO CONCENTRATION OF FORCE PUNCHING
'  HOLE MORE EASILY.
VHSHATMAX = (TEFF * SHATMULT * MSHAT / (PENCONST# * PSHMAX)) ^ VXP: VHSHATMAX = INT(VHSHATMAX)
'  NORMAL OB 'VHSHATMAX'
'*
VLSHATMAX = SHATVDF * VHSHATMAX: VLSHATMAX = INT(VLSHATMAX): 'BEST POSSIBLE SHATR NBL
'*
VHSHAT = (TEFF * SHATMULT * MSHAT / (PENCONST# * PNLSHAT)) ^ VXP: VHSHAT = INT(VHSHAT)
''VHSHAT' IS THE IMPORTANT SHATRD-PROJ LIMIT, AS SOME PROJ PIECES PENETRATE THEN
''VLSHAT' MERELY ADDS SOME MORE PIECES IN MOST CASES, THOUGH FILLER MAY SOMETIMES ADD TO DAMAGE
'*
IF (ABS(VHSHAT - VHSHATMAX) <= 1) THEN VHSHAT = VHSHATMAX: 'FIX ROUNDING ERROR PROBLEM
'*
VLSHAT = SHATVDF * VHSHAT: VLSHAT = INT(VLSHAT): 'SHATR NBL DERIVED FROM SHATR HBL
'*
'ACTUAL HBL & NBL TAKING ALL PROJ DAMAGE (EXCEPT SHATR) FROM IMPACTED PLATE INTO ACCOUNT
VLTRU = (TEFF * MO / (PENCONST# * PNL * POLMOD)) ^ VXP: VLTRU = INT(VLTRU): 'UNSHATRD-PROJ NBL
'*
IF (ABS(VLTRU - VLND) <= 1) THEN VLTRU = VLND: 'FIX ROUNDING ERROR PROBLEM
''VHTRU' OR 'VHND', AS APPLICABLE, ALSO USED WHEN SHATR OCCURS W/A HARD AP CAP
'   (JAP UNCAPPED TYPE 91 PROJ W/CAP HEAD ATTACHED ONLY)
'*
'CALC HBL DERIVED FROM 'VLND', 'VLTRU' & (IN SOME CASES ONLY) 'VLSHAT'
'*
CALL MODIFYVDF
'*
'EFFECTIVE PROJ LIMIT CALC
IF (PNL = PNI) AND (CRITAGL <> 0) THEN
  VITRU = -1: 'MIN EFFECTIVE VEL WILL BE DETERMINED LATER BY CHANGE IN PROJ DIRECTION OF MOTION
'  (DIFFERENT PROJ FAILURE CRITERIA)
ELSE
  VITRU = (TEFF * MO / (PENCONST# * PNI * POIMOD)) ^ VXP: VITRU = INT(VITRU)
'  LIMIT VEL ABOVE WHICH EFFECTIVE PEN OCCUR IN MOST CASES
  IF (VITRU < VLTRU) THEN VITRU = VLTRU: 'YOU CANNOT PENETRATE INTACT IF YOU CANNOT PENETRATE PERIOD!
'IF VEL>=NBL, PROJ ALWAYS EFFECTIVE USING 'VITRU' CRITERIA IN THIS CASE.
END IF
'*
VSCRIT = VHSHAT / (1 - .83 * VDFSTD): 'AVE CRITICAL BRITISH CARDONALD PROJ VEL
VSCRIT = INT(VSCRIT): ' ALWAYS USE INTEGER VALUE (TRUNCATED, NOT ROUNDED)
'*
'* ALL BALLISTIC LIMITS NOW CALCULATED FOR FURTHER LOGIC USE *
'*
RETURN
'
SELECTNATION:
'SELECT PROJ NATION
CALL PROJNATION
MX = 8: OLDSEL = NATION: GOSUB SELECTION: NATION = SEL
IF (OLDSEL <> SEL) THEN PROJ = 0: 'OLD PROJECTILE SELECTION INVALID IF NATION CHANGES
PRINT : PRINT
ON NATION GOSUB SELUS, SELBRIT, SELGERM, SELFR, SELIT, SELJAP, SELAH, SELRU
RETURN
'
SELMTLBK:
'
'PRINT METAL BACKING PLATE TYPES
'*
CALL BACKPRINT
'
IF (BTP > 0) THEN PRINT "CURRENT METAL BACKING PLATE TYPE SELECTION ="; BTP
MX = 5: OLDSEL = BTP: GOSUB SELECTION: BTP = SEL
PRINT
QBK = .5 + (BTP / 10): 'GOOD-ENOUGH APPROX HERE
RETURN
'
'** SELECT APPLICABLE LIMIT VEL & CALC EXIT ANGLE 'EX' **
'
'MAX 'EX'= OB = NO DEFLECTION. 'EX' = 0 AT HBL.
'   W/SHATR, NBL IS NOT INVOLVED IN 'EX' CALC ('EXMIN' = 0).
'W/O SHATR:
'   BETWEEN HBL & NBL, 'EX' GOES FROM 0 TO OB LINEARLY AS VEL INCREASES.
'   IF OB <= 15 DEG, AT NBL 'EX' = OB (NO DEFLECTION)
'   IF OB >  15 DEG, AT NBL 'EX' = 15 DEG = 'EXMIN' FOR VEL >= NBL
''PENFLG' = 2 MEANS COMPLETE PEN (FOR PROJ DAMAGE LOGIC); 'PENFLG' = 1 MEANS HOLING ONLY;
'   & 'PENFLG' = 0 MEANS NO LARGE HOLE
BLPLUSEX:
'INIT VARIABLES
N1$ = "": N2$ = "": N3$ = "": N4$ = "": H1$ = "": H2$ = "": H3$ = "": H4$ = ""
PENFLG = 2: VRAT = 0: OB45 = 0: OB45CALC = 0
VHDAM = 0: VLDAM = 0: 'INIT DAMAGE LIMITS 'VHDAM' & 'VLDAM' USED IN 'EX' LOGIC
CRVFLAG = 0
IF ((CURV = 1) AND (OB > 45!) AND (SHATRES < 2)) THEN CRVFLAG = 1: 'CURVED-PLATE RULE CAN APPLY
EXMIN = 15!: IF (OB <= 15!) THEN EXMIN = OB: 'UNSHATRD PROJ
CRTGD = 0: 'DEFAULT 'CRITAGL'/'NSDAMAGL' COMBINED TEST FLAG IS SET TO FAILURE
VSCHECK = 0: 'FOR DEFORMING BRITISH PROJECTILES
'*
IF ((SHAT = 1) AND (HARD <> 2) AND (VS >= VHSHAT)) THEN EXMIN = 0
'SHATR HAS NO 'EXMIN' ABOVE HBL (EXCEPT IF UNCAPPED JAP TYPE 91 AP 'VS' < SHATRD HBL)
MAXDFDEG = OB - EXMIN: IF (MAXDFDEG > 45!) THEN MAXDFDEG = 45!
'FORMULA DOES NOT WORK FOR (OB - EXMIN)>45 DEG WITH FH ARMOR, SO EXTRA LOGIC RQD
MAXDF = MAXDFDEG / 57.29578: SNCSMAX = SIN(MAXDF) * COS(MAXDF): 'MAX CHANGE IN DIRECTION FUNCTION
'*
'**SELECT ALL LIMIT VEL THAT APPLY TO IMPACT ('!' IS FOR PEN & '#' IS FOR POST-IMPACT EFFECTS)**
'*
IF ((SHAT = 0) OR ((SHAT = 1) AND (HARD = 2))) THEN
'NO SHATR OR SHATR W/HARD AP CAP (ONLY USED FOR JAP UNCAPPED TYPE 91 PROJ ('HARD'=1 & 'SHAT'=1)).
'   JAP CAP-HEAD DOES NOT STOP SHATR, BUT DOES ALLOW PROJ TO USE UNSHATRD HBL LOGIC.
'IF NO PEN-LIMITING DAMAGE, USE BEST-POSSIBLE NBL.
  IF (SHAT = 1) THEN
'SHATR OF JAP UNCAPPED TYPE 91 AP ONLY
    VLMT = VLSHAT: VLDAM = VLSHAT: N2$ = "-!#-"
'SHATR OF HARD-CAPPED PROJ
    VHOL = VHTRU: VHDAM = VHTRU: H1$ = "-!#-"
'HOLING BL USES UNSHATRD VALUES
    IF (VHOL >= VHSHAT) THEN
'REGULAR HOLING BL LOGIC FOR HIGH OB APPLIES
      VHOL = VHSHAT: VHDAM = VHSHAT: H1$ = "": H2$ = "-!#-"
    END IF
    IF (VHSHAT = VHSHATMAX) THEN
      N2$ = "": N3$ = "-!#-"
'BEST POSSIBLE SHATR RESULT
      IF (H2$ = "-!#-") THEN H3$ = "-!#-"
    END IF
  ELSE
'NO SHATR
'IF 'VLTRU'>'VLND' ('PLIM'<MAX POSSIBLE) & 'VLDAM'='VLND', A STEP IN MOST VALUES OCCURS AT 'VLMT'
'DEFAULT VALUES (INCLUDING 'CRITAGL' FAILURE)
    VLMT = VLTRU: VLDAM = VLTRU: N1$ = "-!#-"
    VHOL = VHTRU: VHDAM = VHTRU: H1$ = "-!#-"
    IF ((BEND = 1) AND (CARDONALD = 0) AND (OB >= OBCRIT)) THEN
      VSCHECK = 9999
'BRITISH NON-CARDONALD DEFORMABLE PROJ ALWAYS BREAKS ('OBCRIT=-1' IF NOT USED)
    ELSEIF ((CARDONALD = 1) AND (OB >= OBCRIT)) THEN
      VSCHECK = VSCRIT
'BRITISH CARDONALD PROJ BREAKS BELOW CRITICAL VEL ONLY
    ELSEIF ((BEND = 1) AND (OB < OBCRIT)) THEN
      VSCHECK = 0
'NO-OP FOR BRITISH DEFORMABLE PROJ AT BELOW CRITICAL OBLIQUITY
    ELSE
      VSCHECK = -1
'NO-OP FOR ALL OTHER PROJ
    END IF
    IF (VLTRU = VLND) THEN
'DAMAGE DOES NOT OCCUR OR DOES NOT CHANGE PENETRATION ABILITY
      VLMT = VLND: VLDAM = VLND: N1$ = "": N4$ = "-!#-"
      VHOL = VHND: VHDAM = VHND: H1$ = "": H4$ = "-!#-"
    ELSE
      VSCHKFLG = 0
      IF ((VSCHECK = -1) AND (VLTRU > VLND) AND (VITRU >= 0) AND (VS >= VITRU)) THEN VSCHKFLG = 1
      IF ((VSCHECK > 0) AND (VS >= VSCHECK)) THEN VSCHKFLG = 2
      IF (VSCHECK = 0) THEN VSCHKFLG = 3
      IF (VSCHKFLG <> 0) THEN
'NO DAMAGE OCCURRED, BUT WOULD IF BELOW EFFECTIVE BL
	VLDAM = VLND: N1$ = "-!-": N4$ = "-#-"
	VHDAM = VHND: H1$ = "-!-": H4$ = "-#-"
      END IF
    END IF
'IF OB <= 45 DEG, MAX (WORST-CASE DAMAGE) NOSE-FIRST HBL & NBL ARE SHATRD PROJ LIMITS.
'  THIS CAN OCCUR WITH AN UNDAMAGED ('VLMT' = 'VLND') PROJ IF A 'NON-THICK' PLATE IS HIT.
'IF OB > 45 DEG, ONLY HBL RESTRICTED
    IF ((OB <= 45!) AND (BEND = 0)) THEN
'AT LOW OB WHERE NOSE-FIRST PEN OCCUR, 'VLSHATMAX' IS WORST POSSIBLE CASE FOR UNDAMAGED NBL
'  IF VS<EFFECTV BL,'VLSHAT' IS WORST CASE, IF NO NOSE-FIRST PEN OCCURS.
'  FOR WWII BRITISH DEFORMABLE PROJ, THIS DOES NOT SEEM TO BE TRUE.
      IF (((N4$ = "-!#-") OR ((N4$ = "-#-") AND (VLSHAT = VLSHATMAX))) AND (VLMT >= VLSHAT)) THEN
'NBL LID FOR UNDER 45 DEG
	VLMT = VLSHATMAX: VLDAM = VLSHATMAX
	N1$ = "": N2$ = "": N4$ = "": N3$ = "-!#-"
	VHOL = VHSHATMAX: VHDAM = VHSHATMAX
	H1$ = "": H2$ = "": H4$ = "": H3$ = "-!#-"
      ELSEIF ((N4$ = "-#-") AND (VLMT >= VLSHAT)) THEN
'DITTO
	VLMT = VLSHAT: VLDAM = VLSHATMAX
	N1$ = "": N4$ = "": N2$ = "-!-": N3$ = "-#-"
	VHOL = VHSHAT: VHDAM = VHSHATMAX
	H1$ = "": H4$ = "": H2$ = "-!-": H3$ = "-#-"
      ELSEIF (VLMT >= VLSHAT) THEN
'DITTO FOR 'VLTRU'<>'VLND'
	VLMT = VLSHAT: VLDAM = VLSHAT
	VHOL = VHSHAT: VHDAM = VHSHAT
	IF (N1$ = "-!#-") THEN
'LID IF IMPACT & POST-IMPACT DO NOT USE 'VLND'
	  N1$ = "": N3$ = "": N4$ = "": N2$ = "-!#-"
	  H1$ = "": H3$ = "": H4$ = "": H2$ = "-!#-"
	  IF (VLSHAT = VLSHATMAX) THEN
'IF 'VLSHAT'='VLSHATMAX' BOTH RESULTS USE SAME VELOCITY
	    N2$ = "": N3$ = "-!#-"
	    H2$ = "": H3$ = "-!#-"
	  END IF
	ELSE
'LID IF POST-IMPACT USES 'VLND'
	  N1$ = "": N4$ = "": N2$ = "-!-": N3$ = "-#-"
	  H1$ = "": H4$ = "": H2$ = "-!-": H3$ = "-#-"
	  IF (VLSHAT = VLSHATMAX) THEN
'IF 'VLSHAT'='VLSHATMAX' BOTH RESULTS USE SAME VELOCITY
	    N2$ = "": N3$ = "-!#-"
	    H2$ = "": H3$ = "-!#-"
	  END IF
	END IF
      ELSEIF (VHOL >= VHSHAT) THEN
'HBL LID FOR NON-BRITISH PROJ AT <45 DEG
	IF (VHDAM < VHOL) THEN
	  IF (VHDAM > VHSHATMAX) THEN
	    VHDAM = VHSHATMAX: XDAM = 1
	  ELSE
	    XDAM = 2
	  END IF
	ELSE
	  XDAM = 0
	END IF
	IF ((N4$ = "-!#-") OR ((N4$ = "-#-") AND (VLSHAT = VLSHATMAX))) THEN
	  VHOL = VHSHATMAX
	  IF (XDAM = 2) THEN
	    IF (N4$ = "-!#-") THEN
	      H1$ = "": H2$ = "": H3$ = "-!-": H4$ = "-#-"
	    END IF
	  ELSE
	    VHDAM = VHSHATMAX
	    H1$ = "": H2$ = "": H4$ = "": H3$ = "-!#-"
	  END IF
	ELSEIF (N4$ = "-#-") THEN
	  VHOL = VHSHAT
	  IF (XDAM < 2) THEN
	    VHDAM = VHSHATMAX
	    H1$ = "": H4$ = "": H2$ = "-!-": H3$ = "-#-"
	  END IF
	ELSE
'DITTO FOR 'VLTRU'<>'VLND'
	  VHOL = VHSHAT: VHDAM = VHSHAT
	  IF (H1$ = "-!#-") THEN
'LID IF IMPACT & POST-IMPACT DO NOT USE 'VLND'
	    H1$ = "": H3$ = "": H4$ = "": H2$ = "-!#-"
	    IF (VHSHAT = VHSHATMAX) THEN
	      H2$ = "": H3$ = "-!#-"
	    END IF
	  ELSE
'LID IF POST-IMPACT USES 'VLND'
	    H1$ = "": H4$ = "": H2$ = "-!-": H3$ = "-#-"
	    IF (VHSHAT = VHSHATMAX) THEN
	      H2$ = "": H3$ = "-!#-"
	    END IF
	  END IF
	END IF
      END IF
    ELSE
'HBL LID FOR ALL PROJ (INCLUDING BRITISH DEFORMABLE PROJ) AT ALL OB
      IF (VHOL >= VHSHAT) THEN
	IF (VHDAM < VHOL) THEN
	  IF (VHDAM > VHSHATMAX) THEN
	    VHDAM = VHSHATMAX: XDAM = 1
	  ELSE
	    XDAM = 2
	  END IF
	ELSE
	  XDAM = 0
	END IF
	IF ((H4$ = "-!#-") OR ((H4$ = "-#-") AND (VLSHAT = VLSHATMAX))) THEN
	  VHOL = VHSHATMAX
	  IF (XDAM = 2) THEN
	    H1$ = "": H2$ = "": H3$ = "-!-": H4$ = "-#-"
	  ELSE
	    VHDAM = VHSHATMAX
	    H1$ = "": H2$ = "": H4$ = "": H3$ = "-!#-"
	  END IF
	ELSEIF (H4$ = "-#-") THEN
	  VHOL = VHSHAT
	  IF (XDAM < 2) THEN
	    VHDAM = VHSHATMAX
	    H1$ = "": H4$ = "": H2$ = "-!-": H3$ = "-#-"
	  END IF
	ELSE
'DITTO FOR 'VLTRU'<>'VLND'
	  VHOL = VHSHAT: VHDAM = VHSHAT
	  IF (H1$ = "-!#-") THEN
'LID IF IMPACT & POST-IMPACT DO NOT USE 'VLND'
	    H1$ = "": H3$ = "": H4$ = "": H2$ = "-!#-"
	    IF (VHSHAT = VHSHATMAX) THEN
	      H2$ = "": H3$ = "-!#-"
	    END IF
	  ELSEIF (H1$ = "-!-") THEN
'LID IF POST-IMPACT USES 'VLND'
	    H1$ = "": H4$ = "": H2$ = "-!-": H3$ = "-#-"
	    IF (VHSHAT = VHSHATMAX) THEN
	      H2$ = "": H3$ = "-!#-"
	    END IF
	  END IF
	END IF
      END IF
    END IF
  END IF
ELSE
'*NORMAL SHATR
'NOSE-ONLY SHATTER OCCURS WHEN CURVE-PLATE RULE OR SOFT AP CAP USED AGAINST SOFTSHAT PLATE
''EX' VEL RATIO FORMULA USED IF VEL>='VHSHAT' IF SHATR W/O SPECIAL JAP CAP-HEAD EFFECTS
  VLMT = VLSHAT: VLDAM = VLSHAT: N2$ = "-!#-"
  VHOL = VHSHAT: VHDAM = VHSHAT: H2$ = "-!#-"
  IF (VHSHAT = VHSHATMAX) THEN
'BEST POSSIBLE SHATR RESULT
    N2$ = "": N3$ = "-!#-"
    H2$ = "": H3$ = "-!#-"
  END IF
  IF ((VS >= VHOL) AND (VS < VLMT)) THEN PENFLG = 1
'PARTIAL SHATRD PEN IF 'PENFLG' = 1
END IF
'*
' *FINAL 'PENFLG' & 'EX' CALC LOGIC*
'*
'IF NO SHATR, 'EX' LINEARLY INCREASES FROM 0 TO 'EXMIN' AS VEL INCREASES FROM HBL TO NBL.
'ALWAYS USE DESIGNATED LIMITS FOR THAT POST-IMPACT PROJ DAMAGE LEVEL.
'*
'IF VEL<HBL, NO LARGE HOLE MADE IN PLATE & 'EX' IS UNDEFINED, SO EXIT 'EX' LOGIC
VRATMIN = VLMT: ' DEFAULT VALUE FOR 'EX' COMPUTATION IN 'DEFLECTION' SUBROUTINE
IF ((SHAT = 1) AND (HARD <> 2) AND (VS >= VHSHAT)) THEN VRATMIN = VHOL:
' SHATR REPLACEMENT VALUE
IF (VS < VHOL) THEN
  VRAT = -1: PENFLG = 0: EX = -1: EXRAD = -1: OBDF = -1
'MUST ALWAYS SET 'OB45' FOR REVERSE 'EX' CALC IN EFFCTV PROJ LIMIT LOGIC
  IF ((OB - EXMIN) > 45!) THEN
    OB45 = ((OB - EXMIN) - 45!) / 45!
''OB45' = FRACTION OF (OB-EXMIN)>45 DEG
  ELSE
    OB45 = 0
'DEFAULT (<=45 DEG) VALUE RESTORED
  END IF
  RTNNOW = 1: 'FINISHED HERE
END IF
IF (RTNNOW = 1) THEN RTNNOW = 0: RETURN
'*
'VEL RATIO STARTS WHEN VEL='VLMT' IF NO SHATR OR IF HARD-CAPPED SHATR.
'  IF REGULAR SHTR, THEN VEL='VHOL'
IF ((SHAT = 0) OR ((SHAT = 1) AND (HARD = 2))) THEN
'UNCAPPED JAP TYPE 91 AP W/'VS'<=VHSHAT' ACTS LIKE UNSHATRD PROJ
  IF ((VS >= VHOL) AND (VS < VLMT)) THEN
'BETWEEN HBL & NBL & NO SHATR
    EXNBL = EXMIN: PENFLG = 1
    EX = EXMIN * (VS - VHOL) / (VLMT - VHOL)
'LINEAR INCREASE IN 'EX'
'MUST ALWAYS SET 'OB45' FOR REVERSE 'EX' CALC IN EFFCTV PROJ LIMIT LOGIC
    IF ((OB - EXMIN) > 45!) THEN
      OB45 = ((OB - EXMIN) - 45!) / 45!
''OB45'=FRACTION OF (OB-EXMIN)>45 DEG
    ELSE
      OB45 = 0
'DEFAULT (=<45 DEG) VALUE RESTORED
    END IF
    GOTO EXFINISH: 'SET RADIANS & FINAL DEFLECTION ANGLE
  END IF
ELSE
'BETWEEN HBL & NBL W/SHATR
  IF ((VS >= VHSHAT) AND (VS < VLSHAT)) THEN PENFLG = 1
END IF
'*
'NO SHTR COMPLETE PEN OR SHTR HOLING LOGIC
IF ((SHAT = 1) OR (OB > 15!)) THEN
''EX' VEL RATIO FORMULA
'FOR COMPLETE PEN AT OB > 15 DEG W/O SHATR OR ALL HITS AT VEL >= HBL W/SHATR
''EX' -> OB (DEFLECTION = OB - 'EX' = 'OBDF' -> 0) AS VEL INCREASES
'  (ASSUMES PROJ DAMAGE HELD CONSTANT) IN A CONTINOUSLY-SLOWING (ASYMPTOTIC) RATE.
''OBDF' IS FOUND BY SOLVING:
'  (SEE DEFINITIONS ABOVE & BELOW)
'  SIN(OBDF)*COS(OBDF) = SNCSMAX/[VRAT^2 + VRAT*SQR(VRAT^2 - 1)]
'IF (OB-EXMIN)>45 DEG THEN ADD FRACTION OF (OB-EXMIN)>45 DEG TO 'OBDF'
  IF (OB <= .005) THEN
    EX = 0: EXNBL = 0: 'PREVENT DIVIDE-BY-ZERO ERROR FOR SHTR ONLY
  ELSE
    VRATVEL = VS
'
    GOSUB DEFLECTION
'
    OB45 = OB45CALC
'ACTUAL 'EX' (ALWAYS>='EXMIN')
    EX = OB - TMPOBDF
''EX' AT NBL FOR 'VR' CALC ONLY
    IF (SHAT = 1) THEN
      VRATVEL = VLSHAT
'
      GOSUB DEFLECTION
'
      EXNBL = OB - TMPOBDF: ''EX' AT NBL W/SHATR
    ELSE
      EXNBL = EXMIN: ''EX' AT NBL W/O SHATR
    END IF
  END IF
ELSE
'IF NO SHATR & OB<=15 DEG, THEN NO DEFLECTION IF VEL>=NBL
  EX = OB: EXNBL = OB
END IF
EXFINISH:
EXRAD = EX / 57.29578: OBDF = OB - EX: 'RADIANS FOR CALC & DEFLECTION ANGLE
RETURN
'
'CALCULATE 'EX' FROM 'OB' & 'VS' (STARTS AT 'EXMIN'; BELOW 'EXMIN' LINEAR INCREASE IN 'EX')
'FORMULA ALWAYS CALCULATES 'TMPOBDF' <= 45 DEG ("MIRROR IMAGE" IF (OB - EXMIN) > 45 DEG),
'  SO SPECIAL LOGIC NEEDED
DEFLECTION:
'*
CALL DEFLECCALC
'*
RETURN
'
'* 'TYPICAL' PROJ NOSE & BODY DAMAGE LOGIC *
DAMAGECALC:
'INIT VARIABLES
CRVRL = 0: BDYDM = 0: BRK = 0: NSBRK = 0
OBRK = 40: IF (CMPND = 1) THEN OBRK = 50
'COMPOUND ARMOR IS WEAKER SO ITS PROJ BREAK ANGLE IS 10 DEG HIGHER
IF ((PENFLG = 1) AND (CRVFLAG = 1)) THEN CRVRL = 1: 'SET CURVED-PLATE RULE IN FORCE FLAGS
'*
'SHATRD PROJ DAMAGE LOGIC
IF (SHAT = 1) THEN
'
  CALL SHATRDAM
'*
ELSE
'*
'BEGIN UNSHATRD PROJ LOGIC
'
'UNSHATRD PROJ COMPLETE PEN NOSE & BODY DAM LOGIC
'*
'*NOSE DAMAGE CRITICAL OB MOD CALC*
'*
'MODIFY 'NDAP' CRITIAL OB THRESHOLD FOR NOSE DAMAGE
'
  CALL NOSEDAM
'
'ONLY COMPUTE NOSE DAMAGE USING CRIT NOSE (OB-EX) LOGIC IF VEL>=HBL ('PENFLG'>0),
'  WHICH RELIEVES FORCE ON NOSE DUE TO INITIAL IMPACT, BUT ADDS TO TWISTING FORCES ON NOSE
'
  IF (PENFLG < 2) THEN
'
'
''NSBRK' INCOMPLETE PEN FLAG LOGIC (SEE SUBROUTINE FOR DETAILS)
'
    CALL NOSEBROKE
'
  ELSE
'
'** COMPLETE PENETRATION **
'
'* NOSE DAMAGE CRIT OB CALC FOR COMPLETE PEN *
    IF ((OB - EX) > NDAP) THEN
      NSBRK = 3
'FLAG SET TO PRINT "PROJ NOSE BROKEN" MESSAGE
'
    ELSEIF (((ARMOR = 3) OR (ARMOR = 4)) AND (BEND = 2)) THEN
'*HARVEY ARMOR VERSUS TOUGH 1895-1910 MIDVALE PROJ*
      NSBRK = 8
'NOSE DEFORMED RATHER THAN BROKEN IF NO OTHER DAMAGE
    END IF
  END IF
END IF
'*
IF (VITRU = -1) THEN
'LOWER BODY DAMAGE OCCURS USING CRITICAL ANGLE FORMULA TO U.S. WWII STANDARD-TYPE PROJ
'  IF VEL >= HBL & CURVED-PLATE RULE IS NOT IN FORCE
'ONLY APPLY LOWER BODY TEST IF NOSE IS BROKEN OR COMPLETE PENETRATION OCCURRED
'  (LOWER BODY HITS PLATE, TOO)
'
  CALL DOCRTGOOD
'
'DO BRITISH DEFORMABLE PROJ BREAKAGE LOGIC
'*
  CALL BENDLOGIC
'*
ELSE
  IF ((VS < VITRU) AND (BRK = 0) AND (PENFLG = 2)) THEN BRK = 3
' BREAK PROJ IF REGULAR BREAK LOGIC APPLIES & PROJ HITS AT TOO LOW A VEL
END IF
'*
IF ((PENFLG < 2) AND (BRK = 0)) THEN
'RICOCHET & HOLING-ONLY PEN LOGIC (SKIP IF COMPLETE PEN) W/O CURVED-PLATE RULE,
'  FOR STEEL PROJ THAT ALWAYS BREAK AT VEL<NBL AGAINST ALL-STEEL ARMOR.
'  COMPOUND PLATES CAUSE THIS ONLY IF VEL<HBL.
  SHTRSFLG = 0: IF ((SHATRES = 2) OR ((SHATRES < 2) AND (PENFLG = 0))) THEN SHTRSFLG = 1
  IF ((BRAIK > 0) AND ((CMPND = 0) OR ((CMPND = 1) AND (SHTRSFLG = 1)))) THEN
    BRK = 5
'ALL PROJ INEFFECTIVE AT OB>40 (>50 IF COMPOUND ARMOR) DEG IF VEL<HBL & PLATE FLAT
  ELSEIF ((OB > OBRK) AND ((PENFLG = 0) OR (SHATRES > 0))) THEN
    BRK = 6
'MAX EFFECTIVE OB RULE
  ELSEIF (VITRU > VLMT) THEN
    BRK = 3
'BREAK PROJ IF PLATE HIT AT OR UNDER 'VITRU'>=0 WHEN 'VITRU'>NBL (IS BEING USED)
  END IF
END IF
' GOOD PROJ DO NOT BREAK IF THEY HOLE, BUT NOT COMPLETELY PEN, A CURVED PLATE
'  OR IF SOFT AP CAP VS A 'SOFTSHAT'>0 OR HOOD VS A 'SOFTSHAT'=0 PLATE
'  OR UNDER MIN FULL SHATR VEL FOR STEEL ARMOR
IF (NSSHAT = 2) THEN
  BRK = 0
' LOW VELOCITY NOSE-ONLY SHATTER
ELSEIF ((CRVRL = 1) AND (BRAIK = 0)) THEN
'STILL SHATRD PROJ
  BRK = 0
  NSSHAT = 3
'ONLY NOSE BREAKS IF SHATR WITH CURVED-PLATE RULE
ELSEIF (((NSSHAT = 1) OR (NSSHAT = 4)) AND (VS >= VLMT)) THEN
  BRK = 0
'HOOD OR SOFT CAP NOSE-ONLY SHTR RULE
END IF
'*
IF (BRK > 0) THEN
  IF (SHATRES = 2) THEN
    IF (NSBRK = 0) THEN NSBRK = 1
'SET IF NOT ALREADY SET
    BDYDM = 2
'IF CHILLED CAST IRON PROJ LOWER BODY BREAKS, ALL OF IT BREAKS.
  ELSE
    IF (BDYDM = 0) THEN BDYDM = 1
'BODY RENDERED INEFFECTIVE. HOWEVER, DAMAGE SOMETIMES MIGHT NOT EFFECT FURTHER PEN.
  END IF
END IF
'*
RETURN
'END OF PROJ NOSE & BODY DAM LOGIC
'
PLUGWTS:
'** CALC EJECTED ARMOR PLUG WEIGHTS **
'*
CALL PLUGCALC
'*
RETURN
'
'** COMPUTE FINAL PEN RESULTS **
'WHEN ANY U.S.-STANDARD-TYPE PROJ COMPLETELY PEN, THEY ALWAYS ARE ASSUMED TO BE ABOVE
'  THE 'QE'-CALCULATED EFFECTIVE LIMIT (NO MAJOR BODY DAMAGE)
'THE DAMAGE COMPUTATIONS FOR U.S.-STANDARD-TYPE PROJ (CRITICAL BODY & NOSE DAMAGE) DON'T MODIFY
'  PEN INTO PLATE CAUSING DAMAGE, SO ANY COMPLETE PEN IS ASSUMED, AS W/'QE'-USING PROJ WHEN
'  VEL>='VITRU', TO BE "PERFECT" HERE.
'THESE FORMULAE DETERMINE WHETHER PEN IS ACHIEVED, WHAT KIND OF PEN, POST-IMPACT CONDITION OF PROJ,
'  & ITS REMAINING (EXIT) VEL IF IT (OR PIECES OF IT) PASS THRU PLATE.
'ALWAYS USE 'VHDAM' & 'VLDAM' FOR THESE COMPUTATIONS, SINCE ABOVE EFFECTIVE LIMIT, ENERGY LOST
'  DURING PEN IS REDUCED
FINALRESULTS:
'*
IF (VS < VHOL) THEN
'NEXT LINES GIVE EFFECTS IF NO HOLE MADE COMPLETELY THRU PLATE
''PENTP=0' MEANS THAT ONLY SHOCK EFFECTS OCCUR BEHIND PLATE UNLESS NEXT LINE
'    MODIFIES THIS TO 'PENTP = 1' FOR SPLINTERS BEING KNOCKED FROM PLATE BACK
'*
'*NO PEN THRU PLATE ACHIEVED (EXCEPT FOR SMALL POSSIBLE BACK-SPALLING & A SMALL HOLE IF SHATR NEAR HBL)*
'*
  PENTP = 0
  IF ((BKEFF <= 0) AND (CART > 0)) THEN
    PENTP = 1: 'NO BIG HOLE BUT BRITTLE PLATE SPRAYS FRAGMENTS UNLESS BACKING MATERIALS STOP THEM
  END IF
  TOTPLUGWT = 0: NORMPLUGWT = 0: DELTAPLUGWT = 0: VR = -1: VNPLUG = -1
  VDPLUG = -1: EX = -1: EXRAD = -1: OBDF = -1: HF = -1: VRPR = -1
  RETURN
END IF
'*
'*SOME FORM OF PEN ENTIRELY THRU PLATE ACHIEVED (VEL>=HBL)*
'*
'FACE IS CRACKED THRU AT A VEL<'VHOL', THEN SLOWS PROJ DOWN BY CONSERVATION OF MOMENTUM,
'   THEN ADDS ITSELF TO PROJ NOSE DURING PUSHING OUT OF NORMAL PLUG THRU BACK LAYER.
'   ONCE PUNCHED OUT, BACK LAYER NOW ALSO ADDS TO PROJ NOSE TO FORM NORMAL PLUG & ENTIRE MASS IS SLOWED
'   TO A STOP IF VEL<=HBL (AT HIGH OBLIQUITY, PROJECTILE WILL RICOCHET AT AN ANGLE AS ITS SIDEWAYS
'   VELOCITY PORTION IS NOT REDUCED).  AT HIGHER VEL, NORMAL PLUG KEEPS GOING AFTER PROJ SLOWS DOWN TO
'   A STOP OR RICOCHETS IF VEL<NBL.  THEREFORE, PUSH THRU BACK LAYER IS AN *INELASTIC* COLLISION W/PROJ
'   & NORMAL PLUG IN ONE PIECE AT HBL.  MAX NORMAL PLUG VEL IS AT MOMENT OF EJECTION UNDER FORCE OF PROJ
'   NOSE &, AT HIGH OB, BODY. ONLY COMPONENT OF FORCE DIRECTLY INTO PLATE HAS AN EFFECT ON NORMAL PLUG VEL.
'REMAINING VEL CALC NEEDS TO REMOVE NORMAL PLUG ENERGY & ENERGY LOST TEARING THRU PLATE BETWEEN HBL & NBL.
'*
KETOTAL = .5 * WB * VS ^ 2
'ENERGY AVAILABLE (AP CAP & WINSCREEN DO NOT PEN)
KEPUNCH = .5 * WB * VHDAM ^ 2
'ENERGY NEEDED TO PUNCH OUT NORMAL PLUG AT OB
' (BASE SLAP ENLARGES PLUG W/O INCREASING HBL)
KE1 = KETOTAL - KEPUNCH
'ENERGY LEFT TO SPLIT BETWEEN PROJ & PLUGS
V1 = SQR(KE1 / (.5 * WB))
'VEL EQUIVALENT OF KE1
VNPLUG = SQR(WB / (WB + NORMPLUGWT)) * V1 * COS(OBRAD)
'NORMAL PLUG VEL (FUSED W/PROJ IN ONE LUMP WHEN PLUG FORMED)
VSPR = VNPLUG / COS(OBRAD)
'NORMAL COMPONENT OF PROJ VEL SAME AS NORMAL PLUG VEL WHEN PLUG EJECTED
KEVSPR = .5 * WB * VSPR ^ 2
'PROJ ENERGY PRIOR TO TRYING TO PASS THRU PLATE
'DEFLECTION OF PROJ (=OB-EX) SLOWS IT DOWN FURTHER
' (BOUNCES OFF SIDES OF HOLE DURING COMPLETE PENETRATION)
KEOBMNSEX = .5 * WB * VSPR ^ 2 * (SIN(OBRAD) ^ 2 - SIN(EXRAD) ^ 2)
'PROJ ENERGY LOST DUE TO DEFLECTION (COMPONENT PARALLEL TO PLATE FACE)
KE2 = KEVSPR - KEOBMNSEX
'PROJ ENERGY AFTER DEFLECTION
V2 = SQR(KE2 / (.5 * WB))
'VEL EQUIVALENT OF KEHBL
'*
IF (BRK > 0) THEN
  BFRACT = .5
'HALF OF BROKEN PROJ ASSUMED TO PEN BETWEEN HBL & NBL IF PARTIAL PEN SET
' ('PENTP'=5 @ 'OB'<45 DEG OR 'PENTP'=4 OTHERWISE)
ELSEIF (NSBRK > 0) THEN
  BFRACT = .667
'ONLY 1/3 OF PROJ PIECES (OF NOSE) PEN BETWEEN HBL & NBL IF PROJ NOSE BREAKS OR SHATTERS
' ('PENTP'=3 @ 'OB'<45 DEG)
ELSE
  BFRACT = 1
'IF NO NOSE DAMAGE & NO BODY BREAKAGE, ENTIRE PROJ (MINUS AP CAP & WINDSCREEN) PEN AT NBL ONLY
END IF
'*
''VRSHATNS' = VEL OF PENETRATING BROKEN-UP NOSE PIECES AT LOW OB OR BROKEN-UP LOWER BODY PIECES
'  AT HIGH OB BETWEEN HBL & NBL
VRSHATNS = V2 * SQR(WB / (WB + (1 - BFRACT) * DELTAPLUGWT)): 'BOTH EQUAL IF NO DELTAPLUG
'*
IF (VS < VLMT) THEN
  VRPR = -1
'REMAINING VEL 'VRPR' NOT DEFINED BELOW NBL
ELSE
  IF (SHAT = 1) THEN VDFCALC = SHATVDFPR:  ELSE VDFCALC = VDFUSEDPR
'PROJ REMAINING VEL CALC ABOVE NBL ONLY
''VRPR' = PROJ REMAINING VEL (BASE PIECES ONLY IF SHATR) FOR VS>=NBL (NOT DEFINED IF VS<NBL)
'CALCULATE ADDITIONAL PROJ ENERGY NEEDED TO REACH NBL
  TOPVEL = (1 / (1 - VDFCALC)) * VHDAM: IF (VLDAM < TOPVEL) THEN TOPVEL = VLDAM
'NBL ENERGY LOSS VEL
  KENBL = .5 * WB * TOPVEL ^ 2
'TOTAL ENERGY LOST AT NBL (AP CAP & WINSCREEN DO NOT PEN)
  KE1NBL = KENBL - KEPUNCH
'ENERGY LEFT TO SPLIT BETWEEN PROJ & PLUGS
  V1NBL = SQR(KE1NBL / (.5 * WB))
'VEL EQUIVALENT OF KE1NBL
  VNPLUGNBL = SQR(WB / (WB + NORMPLUGWT)) * V1NBL * COS(OBRAD)
'NORMAL PLUG VEL (FUSED W/PROJ IN ONE LUMP WHEN PLUG FORMED)
  VNBLPR = VNPLUGNBL / COS(OBRAD)
'NORMAL COMPONENT OF PROJ VEL SAME AS NORMAL PLUG VEL WHEN PLUG EJECTED
  KENBLPR = .5 * WB * VNBLPR ^ 2
'PROJ ENERGY AT NBL PRIOR TO TRYING TO PASS THRU PLATE
'DEFLECTION OF PROJ (= OB - EX) SLOWS IT DOWN FURTHER
' (BOUNCES OFF SIDES OF HOLE DURING COMPLETE PENETRATION)
  KENOME = .5 * WB * VNBLPR ^ 2 * (SIN(OBRAD) ^ 2 - SIN(EXRAD) ^ 2)
'PROJ ENERGY LOST DUE TO DEFLECTION (COMPONENT PARALLEL TO PLATE FACE)
  KE2NBL = KENBLPR - KENOME
'PROJ ENERGY AT NBL AFTER DEFLECTION
  V2NBL = SQR(KE2NBL / (.5 * WB))
'VEL EQUIVALENT OF KE2NBL
'SUBTRACT NBL ENERGY FROM PROJ ENERGY
  VRPR = SQR((WB / (WB + BFRACT * DELTAPLUGWT)) * (V2 ^ 2 - V2NBL ^ 2))
'REMAINING VELOCITY FOR PROJ & DELTA PLUG
END IF
'*
'DETERMINE 'PENTYP'(=2 THRU 6) & CALC 'VR', 'VDPLUG', & 'VNPLUG'
'*
CALL PENVRVPLGCALC
'*
RETURN
'*
'************** FINAL RESULTS PRINTOUT ******************
'*
RESULTSPRINT:
'*
'**** SET UP TO PRINT OPTIONAL DETAILS ON 2ND PAGE ****
'*
' SET UP PAGE 2 EBL, NBL, & HBL VALUES & DEFINITION TEXT
GOSUB SETUPSECPG
'*
'*PROJ BODY DAMAGE LOGIC IF IT FAILS TO PUNCH A HOLE*
'*
'IF PROJ WILL BREAK ABOVE HBL THEN IT WILL CERTAINLY DO SO BELOW HBL
IF ((PENFLG = 0) AND ((MINEV > VHOL) OR (NOTEFLAG = 3) OR (BRAIK > 0))) THEN
  BRK = 10: BDYDM = 1
END IF
'*
'*SET UP FOR PROJ, PLATE, & IMPACT DATA & DESCRIPTION OF RESULTS*
'*
' **** BEGIN 1ST DISPLAY ****
'*
'PRINT WHAT HAPPENED TO PLATE AND PROJECTILE
'*
CALL PENPRINT(PENTP)
'*
CALL NSBDYDAMPRNT
'*
TAPRNT = INT(100 * TA + .5) / 100: TEFFPRNT = INT(100 * TEFF + .5) / 100
PRINT "Plate Type ="; ARMOR
PRINT "Plate Thickness, inches: Actual ="; TAPRNT; "& Effective ('Q'+backing) ="; TEFFPRNT
PRINT "Backing Thickness, inches: ";
IF ((WD = 0) AND (CMT = 0) AND (MTLBACK = 0)) THEN
  PRINT "NONE USED."
ELSE
  IF (WD > 0) THEN PRINT "WOOD ="; 100 * WD; : AMPER$ = "& "
  IF (CMT > 0) THEN PRINT "CEMENT ="; 25 * CMT; : AMPER$ = "& "
  IF (MTLBACK = 0) THEN
    PRINT : 'NO METAL BACK SUPPORT PLATES
  ELSE
    S$ = "": IF (NBK > 1) THEN S$ = "s"
    PLTNMBR$ = LTRIM$(STR$(NBK))
    MTLPRNT$ = " (" + PLTNMBR$ + " plate" + S$ + ")"
    PRINT AMPER$; "METAL ="; MTLBACK; MTLPRNT$
    SELECT CASE BTP
      CASE 1
	BCKPRNT$ = BKPRT1$
      CASE 2
	BCKPRNT$ = BKPRT2$
      CASE 3
	BCKPRNT$ = BKPRT3$
      CASE 4
	BCKPRNT$ = BKPRT4$
      CASE 5
	BCKPRNT$ = BKPRT5$
    END SELECT
    PRINT "*TYPE: "; BCKPRNT$
  END IF
END IF
'*
'PRINT PROJ IMPACT CONDITIONS & EXIT ANGLE
'*
CALL IMPACTPRNT
'*
IF (PENFLG >= 2) THEN
'*
' PRINT DAMAGE EFFECTS ON POST-IMPACT PROJ MOTION
'*
CALL PROJMOTIONPRNT
'*
END IF
'*
NPWPRNT = INT(10 * NORMPLUGWT + .5) / 10: DPWPRNT = INT(10 * DELTAPLUGWT + .5) / 10
IF (NORMPLUGWT <= .05) THEN
  NOPLG$ = "No plugs ejected from plate.": PRINT NOPLG$
ELSE
  PRINT "Plug Weights, pounds: Normal ="; NPWPRNT; "& Delta ="; DPWPRNT
END IF
'*
'PRINT MSG ABOUT SPLINTERS THROWN FROM PLATE BACK BELOW HBL
'*
CALL SPLNTRPRNT
'*
IF (NORMPLUGWT > .05) THEN PRINT "Normal Plug Velocity ="; VNPLUG; "ft/sec"
'*
IF (BDYDM > 0) THEN
  TWOVEL$ = "IF PROJECTILE BODY BREAKS, ASSUME 50% OF BODY WEIGHT IN UPPER AND LOWER HALVES."
  PRINT TWOVEL$
END IF
'*
'PROJ REMAINING VELOCITY PRINTOUT
'*
CALL REMVELPRNT
'*
' **** END OF 1ST DISPLAY ****
'*
CALC$ = "CALCULATED HOLING, NAVY, AND EFFECTIVE BALLISTIC LIMITS"
PRINT "DISPLAY "; CALC$; "? (Y/N) ";
GOSUB CHKYESNO: PRINT YS$
'*
' **** DISPLAY SECOND PAGE WITH B.L. DETAILS IF SELECTED BY USER ****
'*
IF (YS = 1) THEN
'PRINT BALLISTIC LIMITS ONLY IF 'YS$' = 'Y' TO LAST QUESTION ABOVE
'*
  CALL SCPGPRNT
'*
' **** DONE WITH OPTIONAL 2ND SCREEN DISPLAY ****
END IF
RETURN
'
'* MIN EFFECT PEN VEL USING 'CRTAPR' LOGIC *
APCRITICALV:
THVAL = CRTAPR
VLEXREV = VLMT: VHEXREV = VHOL
'
GOSUB THRESHOLDVEL
'
CRITVEL = THSPD
RETURN
'
'* MIN NO NOSE DAMAGE VEL *
NSCRITICALV:
THVAL = NDAP
VLEXREV = VLMT: VHEXREV = VHOL
'
GOSUB THRESHOLDVEL
'
NSV = THSPD
'ITS NOSE BREAKS IF VEL < HBL ('BRAAK'>0)
IF (NSTEST = 1) THEN
  IF (VHOL >= NSV) THEN NSTESTV = VHOL:  ELSE NSTESTV = NSV: ' MIN EFF VEL TEST
ELSE
  IF (VHOL >= NSV) THEN NSVEL = VHOL:  ELSE NSVEL = NSV: 'LIGHTCASE PROJ TEST
END IF
RETURN
'
'*MIN (THRESHOLD) EFFECTIVE PROJ VEL CALC LOGIC (ALL 'CRTAPR' & FOR LIGHTCASE PROJ 'NDAP')*
THRESHOLDVEL:
'
CALL THRESHOLDCALC
'
RETURN
'
'* MAX PRINTOUT VEL LOGIC *
FOURKCHK:
FTSC$ = " ft/sec"
IF (VEL > 4000) THEN
  VEL$ = ">4000 ft/sec"
ELSE
  VEL1$ = STR$(VEL): VEL$ = VEL1$ + FTSC$
END IF
RETURN
'
'* ALLOW USER TO CHANGE PLATE DATA
CHANGEARMOR:
PRINT
PRINT "Do you want to modify armor plate's parameters? (Y/N) ";
GOSUB CHKYESNO: PRINT YS$
IF (YS = 1) THEN
'YES, DISPLAY CURRENT AND ORIGINAL PARAMETERS
'*
  CALL NUMVALHDR
  CALL SHOWORIGARMR
'*
  PRINT "Restore all original armor values? (Y/N) ";
  GOSUB CHKYESNO: PRINT YS$
  IF (YS = 1) THEN
'YES, RESTORE ARMOR'S DEFAULT TABLE VALUES
'*
    CALL ARMORINFO(ARMOR)
'*
    UBMAN = 0: UBSV = UB: QSV = Q: QDAMSV = QDAM: CARTWLSV = CARTWL
    CMPNDSV = CMPND: THNCHLSV = THNCHL: SOFTSHATSV = SOFTSHAT
    THKTHNSV = THKTHN
  END IF
  PRINT "Change any armor values? (Y/N) ";
  GOSUB CHKYESNO: PRINT YS$
  PRINT
  IF (YS = 1) THEN
'YES
    PRINT "EFFECT OF 'UB' VALUE ONLY CHANGES WHEN 'UB' > 30, 52, 62, 67.5, 75, OR 90."
    PRINT "MINIMUM 'Q' & 'QDAM' IS 0.1 AND MAXIMUM 'QDAM' IS 'Q' (USUAL VALUE)."
    PRINT
    PRINT "UB:       "; : OLDVALUE = UB: FLAG = 0: GOSUB NEWARMOR: UBTEMP = NEWVALUE
    IF ((ARMOR = 1) OR (ARMOR = 3) OR (ARMOR = 4) OR (ARMOR = 12)) THEN
      IF (UBCALC <> UBTEMP) THEN
	PRINT " *** GRUSON/HARVEY/TC ARMORS:  Manual Value used for UB (Rounded to Integer)"
	UBMAN = NEWVALUE
	UB = UBMAN
      ELSE
	PRINT " *** GRUSON/HARVEY/TC ARMORS:  Calculated Value used for UB"
       UBMAN = 0
       UB = UBCALC
      END IF
    ELSE
      UB = UBTEMP: UBMAN = 0
    END IF
    UBTEMP = 0
    IF (UB > 75) THEN THNCHL = 1 ELSE THNCHL = 0
    PRINT "Q:        "; : OLDVALUE = Q: FLAG = 2: GOSUB NEWARMOR: Q = NEWVALUE
    PRINT "QDAM:     "; : OLDVALUE = QDAM: FLAG = 3: GOSUB NEWARMOR: QDAM = NEWVALUE
    PRINT "CARTWL:   "; : OLDVALUE = CARTWL: FLAG = 4: GOSUB NEWARMOR: CARTWL = NEWVALUE
    PRINT "CMPND:    "; : OLDVALUE = CMPND: FLAG = 1: GOSUB NEWARMOR: CMPND = NEWVALUE
    PRINT "THNCHL:   "; : OLDVALUE = THNCHL: FLAG = 1: GOSUB NEWARMOR: THNCHL = NEWVALUE
    PRINT "SOFTSHAT: "; : OLDVALUE = SOFTSHAT: FLAG = 4: GOSUB NEWARMOR: SOFTSHAT = NEWVALUE
    PRINT "THKTHN:   "; : OLDVALUE = THKTHN: FLAG = 4: GOSUB NEWARMOR: THKTHN = NEWVALUE
    PRINT
  END IF
ELSE
  PRINT : 'NO CHANGES
  IF (UBMAN > 0) THEN UB = UBMAN: UBSV = UBMAN
  IF (UB > 75) THEN THNCHL = 1 ELSE THNCHL = 0
END IF
RETURN
'
'* CHANGE SELECTED ARMOR DATA
NEWARMOR:
'
CALL SETVALUE
'
RETURN
'
'* PROJ TYPE ENTRY HEADER *
SELPROJHDR:
CLS : PRINT : PRINT "SELECT SPECIFIC PROJECTILE TYPE:"
RETURN
'
'* PERFORM YES/NO ANSWER LOGIC *
CHKYESNO:
'
CALL YESNO
'
RETURN
'
'* PROJ SELECTION LOGIC *
SELECTPROJ:
IF (PROJ > 0) THEN PRINT "CURRENT PROJECTILE SELECTION ="; PROJ; "-- ";
OLDSEL = PROJ: GOSUB SELECTION: PROJ = SEL
RETURN
'
'* GENERAL-PURPOSE SELECTION LOGIC *
SELECTION:
'SELECTION IS WHOLE NUMBER>=1 & <=MAXIMUM VALUE ALLOWED ('MX')
INPUT "SELECTION"; SL$
IF ((SL$ = "") AND (OLDSEL > 0)) THEN
  SEL = OLDSEL: PRINT "Using"; OLDSEL
ELSE
  SEL = VAL(SL$)
END IF
IF ((SEL < 1) OR (SEL > MX) OR (SEL <> INT(SEL))) THEN GOTO SELECTION: 'BAD INPUT
RETURN
'
'* SELECT PROJ TYPE BY NATION *
'
'** U.S.
SELUS:
GOSUB SELPROJHDR
CALL USPROJ
MX = 20: GOSUB SELECTPROJ
'GET DATA
CALL ALLPROJDATA(NATION, PROJ)
RETURN
'
'** BRITAIN
SELBRIT:
GOSUB SELPROJHDR
CALL BRITAINPROJ
MX = 17: GOSUB SELECTPROJ
'GET DATA
CALL ALLPROJDATA(NATION, PROJ)
RETURN
'
'** GERMANY
SELGERM:
GOSUB SELPROJHDR
CALL GERMANYPROJ
MX = 15: GOSUB SELECTPROJ
'GET DATA
CALL ALLPROJDATA(NATION, PROJ)
RETURN
'
'** FRANCE
SELFR:
GOSUB SELPROJHDR
CALL FRANCEPROJ
MX = 9: GOSUB SELECTPROJ
'GET DATA
CALL ALLPROJDATA(NATION, PROJ)
RETURN
'
'** ITALY
SELIT:
GOSUB SELPROJHDR
CALL ITALYPROJ
MX = 12: GOSUB SELECTPROJ
'GET DATA
CALL ALLPROJDATA(NATION, PROJ)
RETURN
'
'** JAPAN
SELJAP:
GOSUB SELPROJHDR
CALL JAPANPROJ
MX = 10: GOSUB SELECTPROJ
'GET DATA
CALL ALLPROJDATA(NATION, PROJ)
RETURN
'
'** AUSTRO-HUNGARY
SELAH:
GOSUB SELPROJHDR
CALL AUSTHUNGPROJ
MX = 8: GOSUB SELECTPROJ
'GET DATA
CALL ALLPROJDATA(NATION, PROJ)
RETURN
'
'** RUSSIA
SELRU:
GOSUB SELPROJHDR
CALL RUSSIAPROJ
MX = 8: GOSUB SELECTPROJ
'GET DATA
CALL ALLPROJDATA(NATION, PROJ)
RETURN
'
HARDCOPY:
'* OUTPUT ALL RESULTS TO PRINTER *
'
'* BEGIN 1ST PAGE (PROJ/PLATE/RESULTS) *
'
GOSUB LPARMOR: 'PRINT ARMOR TYPE
'PRINT PROJ NATION & TYPE
LPRINT
SELECT CASE NATION
  CASE 1
    CALL LPUS(PROJ)
  CASE 2
    CALL LPBRITISH(PROJ)
  CASE 3
    CALL LPGERMAN(PROJ)
  CASE 4
    CALL LPFRENCH(PROJ)
  CASE 5
    CALL LPITALIAN(PROJ)
  CASE 6
    CALL LPJAPANESE(PROJ)
  CASE 7
    CALL LPAUSTHUNG(PROJ)
  CASE 8
    CALL LPRUSSIAN(PROJ)
END SELECT
'*
LPRINT
LPRINT SPC(26); "SPECIFIC IMPACT CONDITIONS:"
LPRINT "Plate Thickness, inches: Actual ="; TAPRNT;
LPRINT "& Effective ('Q'+backing) ="; TEFFPRNT
LPRINT "Backing Thickness, inches: ";
IF ((WD <> 0) OR (CMT <> 0) OR (MTLBACK <> 0)) THEN
  IF (WD > 0) THEN
    LPRINT "WOOD ="; WDTRU;
    IF (CMT <> 0) OR (MTLBACK <> 0) THEN LPRINT "-- "; :  ELSE LPRINT
  END IF
  IF (CMT > 0) THEN
    LPRINT "CEMENT ="; CMTTRU;
    IF (MTLBACK <> 0) THEN LPRINT "-- "; :  ELSE LPRINT
  END IF
  IF (MTLBACK <> 0) THEN
    LPRINT "METAL ="; MTLBACK; MTLPRNT$
    LPRINT "*TYPE: "; BCKPRNT$
  END IF
ELSE
  LPRINT "NONE USED."
END IF
'*
' PRINT 'D', 'VS', & 'OB' TO PRINTER
'*
CALL LPPROJIMPACT
'*
LPRINT REMV$
'*
LPRINT "Projectile Weights, pounds: Original="; WTSVPRNT;
LPRINT "*Impact="; WTPRNT; "*Body="; WBPRNT
'*
LPRINT SPC(30); "POST-IMPACT RESULTS:"
LPRINT PEN1$: LPRINT PEN2$
IF (PEN3$ <> "") THEN LPRINT PEN3$
'*
' PRINT TO PRINTER NOSE & BODY DAMAGE INFO
'*
CALL LPDAMAGE
'*
IF (EX >= 0) THEN
  LPRINT "Projectile Exit Angle ="; EXPRNT; "degrees"
ELSE
  LPRINT "Projectile Exit Angle NOT DEFINED."
END IF
'*
IF (PENFLG >= 2) THEN LPRINT "Projectile "; WBL1$; WBL2$; WBL3$; WBL4$
'*
IF (NOPLG$ = "") THEN
  LPRINT "Plug Weights, pounds: Normal ="; NPWPRNT; "& Delta ="; DPWPRNT
ELSE
  LPRINT NOPLG$: 'NO PLUG THROWN
END IF
'*
IF (FLAKE$ <> "") THEN LPRINT FLAKE$
'*
IF (NORMPLUGWT > .05) THEN LPRINT "Normal Plug Velocity ="; VNPLUG; "ft/sec"
'*
IF (TWOVEL$ <> "") THEN LPRINT TWOVEL$
'*
IF (RVU$ = "") THEN
'PARTIAL OR COMPLETE PEN OCCURRED
  IF (BSNS1$ <> "") THEN
    LPRINT REMVEL$; BSNS1$; DPLG$;
    IF (VDPLUG >= 25) THEN
      LPRINT "="; VDPLUG; "ft/sec"
    ELSE
      LPRINT "ARE VERY SLOW"
    END IF
  END IF
  IF (BSNS2$ <> "") THEN
    LPRINT REMVEL$; BSNS2$;
    IF (VR >= 25) THEN
      LPRINT "="; VR; "ft/sec"
    ELSE
      LPRINT "ARE VERY SLOW"
    END IF
  END IF
  IF (ONEPC$ <> "") THEN
'UNSHATRD PROJ, BUT INCLUDING JAP UNCAPPED TYPE 91 AP W/'VS'<'VHSHAT' & 'VS'>'VHOL'
    IF (PENFLG = 2) THEN
      LPRINT ONEPC$; DPLG$;
      IF (DPLG$ = "") THEN LPRINT "has"; :  ELSE LPRINT "have";
      IF (VTOTAL >= 25) THEN
	LPRINT " Remaining Velocity ="; VTOTAL; "ft/sec"
      ELSE
	LPRINT " VERY SLOW Remaining Velocity"
      END IF
      IF (BSNS3$ <> "") THEN LPRINT BSNS3$
    ELSE
      IF (BSNS3$ <> "") THEN LPRINT BSNS3$
      LPRINT ONEPC$
    END IF
  ELSE
    IF (BSNS3$ <> "") THEN LPRINT BSNS3$
  END IF
ELSE
  LPRINT RVU$: 'NO PARTIAL OR COMPLETE PEN
END IF
'*
'BEGIN 2ND PAGE (ALL BALLISTIC LIMITS)
'*
CALL LPRNTSECPG
'*
RETURN
'*
'* PRINT ARMOR TYPE ON PAPER *
LPARMOR:
'*
CALL LPRINTHDR
CALL LPRNTARMOR
'*
RETURN
'*
SETUPSECPG:
'*
CALL LMTSTRINGS
'*
VEL = VLTRU: GOSUB FOURKCHK: VELLTRU$ = VEL$
VEL = VLSHAT: GOSUB FOURKCHK: VELLSHAT$ = VEL$
VEL = VLSHATMAX: GOSUB FOURKCHK: VELLSHATMAX$ = VEL$
VEL = VLND: GOSUB FOURKCHK: VELLND$ = VEL$
'*
VEL = VHTRU: GOSUB FOURKCHK: VELHTRU$ = VEL$
VEL = VHSHAT: GOSUB FOURKCHK: VELHSHAT$ = VEL$
VEL = VHSHATMAX: GOSUB FOURKCHK: VELHSHATMAX$ = VEL$
VEL = VHND: GOSUB FOURKCHK: VELHND$ = VEL$
'*
'**** CALCULATE 'EFFECTIVE' LIMIT 'MINEV' FOR THIS IMPACT FROM ALL DATA ****
'*
' INIT EFF VEL CALC VARIABLES
'*
CALL EFFVELINIT
'*
IF (SHAT = 1) THEN
'***SHATRD PROJ***
'*
CALL MINEVSHATCALC
'*
ELSE
'***NO PROJ SHATR***
  IF (LTCASE > 0) THEN
    IF (LTCASE = 2) THEN
''LIGHTCASE=2' NOSE DAMAGE INCL >6% CAVITY, CHANGING CRITICAL VEL CHK
      GOSUB NSCRITICALV: MTMP = INT(NSVEL)
      IF (MTMP = NSVEL) THEN
	MINEV2 = MTMP
      ELSE
	MINEV2 = MTMP + 1
      END IF
    ELSE
''LIGHTCASE=1' NOSE DAMAGE EFFECTS CAVITY TOO (4-6% CAVITY VOLUME INCL ANY CUSHION)
      MINEV2 = VLMT
    END IF
  ELSE
    MINEV2 = 0: ' NOT USED
  END IF
  IF ((VITRU = -1) AND (CRTAPR > 0)) THEN
'CRITICAL VEL BODY DAMAGE TEST (CRTAPR DEFLECTN TEST W/O BENDING PROJ)
'
    GOSUB APCRITICALV
    MTMPCR = INT(CRITVEL)
    IF (MTMPCR < CRITVEL) THEN MTMPCR = MTMPCR + 1: ' ROUND TO NEAREST WHOLE VEL
'
'GET NOSE BROKEN MIN VEL FOR CRIT VEL USE, IF NEEDED
    NSTEST = 1
    GOSUB NSCRITICALV
    MTMPNS = INT(NSTESTV)
    IF (MTMPNS < NSTESTV) THEN MTMPNS = MTMPNS + 1: ' ROUND TO NEAREST WHOLE VEL
    NTSTV$ = STR$(MTMPNS): ' NEED NOSE DAM LIMIT STRING FOR 'NOTE5$'
'
' CRIT VEL TEST ONLY MADE IF NOSE BREAKS OR PROJ COMPLETELY PENETRATES
'FIND 'MINEV3' MIN EFFECTIVE VEL
    IF (MTMPNS >= VLMT) THEN
      MTMP = MTMPCR
'USE BODY DAMAGE THRESHOLD
' (BODY TEST USED SEPARATELY IF NOT OK WHEN 'VS'>=NBL; IF BODY TEST BECOMES OK
'   WHEN 'VS'<NBL, IT IS LOWEST)
    ELSEIF ((MTMPNS < VLMT) AND (MTMPCR <= MTMPNS)) THEN
      MTMP = MTMPCR
'USE BODY DAMAGE THRESHOLD
' (BODY TEST OK WHEN NOSE STILL BREAKS, SO IT IS LOWEST)
    ELSEIF ((MTMPNS < VLMT) AND (MTMPCR > MTMPNS) AND (MTMPCR < VLMT)) THEN
      MTMP = MTMPNS
'USE NOSE DAMAGE THRESHOLD
' (BODY TEST NEVER USED IF 'VS'>'NSTESTV' (NOSE NOT BROKEN), SO NOSE IS THE LOWEST)
    ELSE
' 'MTMPNS'<'VLMT' AND 'MTMPCR'>'MTMPNS' AND 'MTMPCR'>='VLMT'
      MTMP = MTMPCR
'USE BODY DAMAGE THRESHOLD
' (BOTH TESTS USED IF NOSE BREAKS FOR 'VS'<='NSTESTV';
'   BODY TEST ALONE USED ONLY IF 'VS'>='VLMT')
      NOTE5$ = "NO NOSE OR BODY DAMAGE IF VEL IS BETWEEN"
      NOTE5$ = NOTE5$ + NTSTV$ + " FT/SEC (NOSE MAX) & NBL (BODY MIN)"
    END IF
    MINEV3 = MTMP
    IF ((NOTE5$ = "") AND (VLMT = VLND) AND (BRAIK = 0) AND (MINEV3 < VLMT)) THEN
      MINEV3 = VHOL
      IF (SHATRES > 0) THEN
	NOTE5$ = NOTE5A$
      ELSE
	NOTE5$ = NOTE5B$
      END IF
    END IF
  ELSEIF (VITRU > -1) THEN
    MINEV3 = VITRU
'PROJ USES 'QE' FORMULA
    IF ((VITRU = VLND) AND (BRAIK = 0)) THEN
      MINEV3 = VHOL
      IF (SHATRES > 0) THEN
	NOTE5$ = NOTE5A$
      ELSE
	NOTE5$ = NOTE5B$
      END IF
    END IF
  ELSEIF ((BEND = 1) AND (OB >= OBCRIT)) THEN
'PROJ USES BRITISH DEFORMING PROJ RULES
    IF (CARDONALD = 1) THEN
      MINEV3 = VSCRIT
      NOTE5$ = "BRITISH DEFORMING CARDONALD PROJECTILE"
    ELSE
      MINEV3 = -1: ' SPECIAL FLAG FOR CURVED-PLATE RULE
      NOTE5$ = "BRITISH DEFORMING NON-CARDONALD PROJECTILE"
    END IF
  ELSE
    MINEV3 = 0: ' NOT USED
  END IF
  IF (OB > OBRK) THEN
''OBRK' IS MAX OB TO REMAIN EFFECTIVE IF 'VS' < 'VLMT'
'   UNLESS STEEL PROJ HITS CURVED ARMOR, WHICH HAS SPECIAL LOGIC
    IF (CRVFLAG = 0) THEN
      MINEV4 = VLMT
'RAISE EFFECTIVE BL TO NBL IF OB TOO HIGH
    ELSE
      MINEV4 = 0
'NOT USED
    END IF
  END IF
  IF (BRAIK > 0) THEN
'WEAK-BODIED STEEL PROJ VS. STEEL ARMOR OR COMPOUND ARMOR.
'   CHILLED CAST IRON PROJ ON COMPOUND ARMOR ACTS AS STEEL-ON-STEEL HERE.
    IF ((CMPND = 1) AND (SHATRES < 2)) THEN
      MINEV5 = VHOL
'COMPOUND ARMOR BREAKS WEAK STEEL PROJ ONLY IF NO HOLE MADE
    ELSE
      MINEV5 = VLMT
'STEEL ARMOR BREAKS THEM ONLY IF BELOW NBL (INCL CAST IRON PROJ ON COMPOUND ARMOR)
    END IF
  ELSE
    MINEV5 = 0
'NOT USED
  END IF
END IF
'*
'SORT OUT TRUE MIN EFF VEL
'*
CALL SETMINEV
'*
VEL = MINEV: GOSUB FOURKCHK: 'LIMIT MINIMUM EFFECTIVE BL TO 4000 FT/SEC MAXIMUM
'*
' **** DETERMINE DAMAGE TO PLATE & PROJ USING VARIOUS B.L. VALUES ****
'*
CALL DAMAGESETUP
'*
RETURN
'*
'*** END OF PROGRAM CODE FOR MAIN MODULE "FH69MAIN.BAS" ***

