DIM ENPTABLE(3, 4), ENTABLE(3, 13)
REM ONLY UP TO (X, 13) USED (0 TO 0.65-CALIBER MAX) NOW (NO DATA ABOVE 0.67 CALIBER),
REM   SO I AM KEEPING THIS 0.65-CALIBER ENCS MODIFIER FOR ALL LARGER T/D VALUES
REM ************
SCREEN 13
WIDTH 80, 43
REM ************
REM INITIALIZE ENCS TABLES
GOSUB INITENCS
REM ************
CLS
PRINT "        *** TAPERED FLAT NOSE ARMOR PENETRATION PROGRAM VERSION 2.0 ***"
PRINT " BALLISTIC LIMIT & ENERGY FOR A TAPERED-CONE FLAT-NOSE STEEL AP SHOT PROJECTILE"
PRINT "(TRUNCATED CONE WITH 0.85-CALIBER WIDE FLAT REGION & 0.475-CALIBER NOSE HEIGHT)"
PRINT "                                 VERSUS"
PRINT "   WWII U.S. NAVY CLASS B ARMOR/STS OF 115,000 PSI TENSILE STRENGTH (DEFAULT)"
PRINT "                                   OR"
PRINT "ARMOR OR PROJECTILE OF ANOTHER METAL W/KNOWN TEST RESULTS TO ALLOW INPUT VALUES"
PRINT "   **>> INCLUDES PLUG WEIGHT, EXIT ANGLE, REMAINING VELOCITY, & SHATTER <<**"
PRINT " **>>OPTIONS: NBL ONLY FOR MULTIPLE PLATES OR ALL OUTPUTS FOR SINGLE PLATE<<**"
PRINT "                      BY: NATHAN OKUN (30 JUNE 2011)"
PRINT
REM DEFAULTS
QA = 1: D = 3: WT = 13: OB = 0: PLATEDEN = .2833: SH = 1.1073: TSDSTEP = .001
REM **********
PRINT "The US Navy Ballistic Limit (NBL) assumed:  The entire projectile, if intact,"
PRINT "(excluding any nose coverings like AP caps, hoods, and windscreens), or 80%"
PRINT "(roughly) of its body weight (again excluding nose coverings), if broken up,"
PRINT "can pass through the plate at this striking velocity or more, but not at less."
PRINT
PRINT "All flat-nose projectiles are assumed to have no nose coverings whatosever."
PRINT
PRINT "PERCENT ELONGATION NOT USED WITH AN ALMOST-FLAT NOSE.  MINIMUM OF 4 INCHES OF"
PRINT "PLATE STRETCHING NEEDED FOR ANY EFFECT.  SHEARING OUT OF A PLUG DOES NOT DO"
PRINT "THIS.  THE TAPER NEEDS TO REDUCE THE WIDTH OF THE FLAT NOSE PORTION TO ABOUT"
PRINT "0.5-CALIBER WIDTH OR LESS TO BEGIN TO HAVE A PROPORTIONAL EFFECT, MEANING THAT"
PRINT "THE TAPERED WIDTH MINUS THE FLAT WIDTH IS USED INSTEAD OF THE TOTAL PROJECTILE"
PRINT "WIDTH IN DETERMINING THE EFFECT OF PERCENT ELONGATION.  FOR EXAMPLE, IF THE"
PRINT "FLAT WIDTH IS 0.5-CALIBER, THEN THE OVER-8-INCH MINIMUM FOR ANY EFFECT NOW HAS"
PRINT "TO BE OVER 16-INCHES (THAT IS, THE FLAT PORTION HAS NO EFFECT HERE)."
PRINT
PRINT "REASONS FOR UPDATING PROGRAM TO VERSION 2.0: (To Skip This Type S, Else Type C)"
WAITLP1:                                                                
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLP1
  IF (YN$ = "S") OR (YN$ = "s") THEN GOTO BGNINPT
  IF (YN$ = "C") OR (YN$ = "c") THEN GOTO UPDATE1
  GOTO WAITLP1: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
REM **********
UPDATE1:
CLS
PRINT "REASONS FOR UPDATING PROGRAM TO VERSION 2.0:"
PRINT
PRINT "Since writing this program, I obtained a set of right-angles impact data on"
PRINT "a 20mm full-width-flat-nose steel projectile test against a high quality"
PRINT "modern high-tensile steel.  The results caused me to revise my Flat-Nose"
PRINT "Projectile Penetration Program ('FLATNOSE') to a Version 2.1 ('FLTNS21')."
PRINT "Most of the information I obtained seems to be applicable to this Tapered"
PRINT "Flat-Nose Penetration Program, too, so I made this new one, which tracks"
PRINT "FLTNS21 as to input and output functions, but still uses a modified form"
PRINT "of its original computation method, instead of the radically revised method"
PRINT "I created for FLTNS21."
PRINT
PRINT "The most important modification to the computation of the NBL is that the"
PRINT "test data is only for a single 13-lb Tapered Flat Nose AP Projectile (which"
PRINT "had a 5%-of-total-weight windscreen that was not used in the armor tests) was"
PRINT "from 0.6-inch to 2-inch plates and from right-angles to 75 degrees obliquity,"
PRINT "so my extrapolations versus thinner and thicker plates are estimates (I also"
PRINT "extrapolated to 80 degrees obliquity, but this is probably not a problem)."
PRINT "The thin plate extrapolation is not far off, based on my current information,"
PRINT "but the thicker-plate extrapolation was incorrect.  I have corrected this to,"
PRINT "in my current opinion, more closely track in-betreen the pointed ('M79APCLC')"
PRINT "projectile and full-flat-nose projectile data for thicker plates and for any"
PRINT "projectiles with the same tapered flat-nose shape but another weight.  I have"
PRINT "added a first crude estimate of what the shatter plate thickness is for these"
PRINT "tapered flat-nose projectiles based on my more extensive full-flat-nose data."
PRINT
PRINT "The 0.65-caliber value in the ENCS table is used for all thicker plates, so"
PRINT "that the NBL is linear with increasing plate thickness in calibers above that."
PRINT "My data ends at 0.67-caliber plate thickness (2 inches), so I have to be very"
PRINT "conservative in my extrapolations to any thicker plates.  The program now is."
PRINT
REM **********
PRINT "****>>>> End of Introduction Page.  Type C to Start Inputs.";
WAITLP2:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLP2
  IF (YN$ = "C") OR (YN$ = "c") THEN GOTO BGNINPT
  GOTO WAITLP2: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
REM **********
BGNINPT:
CLS
PRINT "INITIAL DEFAULTS:"
PRINT "     Plate Quality=1 (STS), Projectile Weight=13, Projectile Diameter=3"
PRINT "     Armor Density=0.2833 (Steel), Impact Obliquity=0 (=Right-Angles)"
PRINT "     Right-Angles Shatter Thickness=1.1073 (STS vs Good Steel Projectile)"
PRINT "     Minimum Plate Thickness Step in Multi-Plate Option=0.001"
PRINT
PRINT "ENGLISH UNITS USED:  INCHES, FEET/SECOND, & POUNDS -- ANGLES IN DEGREES"
PRINT
PRINT "THE EXIT ANGLE IN PLATE BACK AT THE NBL IS ALWAYS ZERO IF IMPACT OBLIQUITY IS"
PRINT "  IS UP TO 45 DEGREES (HOLE IS CLOSE TO A CIRCLE IN SHAPE), BUT IT BECOMES MORE"
PRINT "  AND MORE ELONGATED (ELLIPTICAL) ABOVE 45 DEGREES OBLIQUITY."
REM
REM REAL PROJECTILES ARE USUALLY DAMAGED AGAINST PLATES WITH MUCH LOWER NAVY BL VALUES THAN 3500!
PRINT
PRINT "MAXIMUM COMPUTED NBL = 3500 FEET/SECOND.  ABOVE THIS, ALL PROJECTILES WILL"
PRINT "  SHATTER AND FRAGMENTS WILL BE REJECTED BY PLATE (NO HOLE IN THICK PLATE)"
PRINT
PRINT "PRESS *ENTER KEY* WITH NO NUMBER ENTRY TO REPEAT A PREVIOUS OR A DEFAULT ENTRY."
PRINT
REM **********
DIAMETER:
  INPUT "Projectile Diameter (Inches): ", D$
  IF (D$ = "") THEN
    IF (D > 0) THEN
      PRINT "Projectile Diameter Used is"; D; "inches"
    ELSE
      GOTO DIAMETER
    END IF
  ELSE
    D = VAL(D$): IF (D <= 0) THEN GOTO DIAMETER
  END IF
  PRINT
WEIGHT:
  INPUT "Projectile Total Weight (Pounds): ", WT$
  IF (WT$ = "") THEN
    IF (WT > 0) THEN
      PRINT "Projectile Weight Used is"; WT; "pounds"
    ELSE
      GOTO WEIGHT
    END IF
  ELSE
    WT = VAL(WT$): IF (WT <= 0) THEN GOTO WEIGHT
  END IF
  PRINT
  PRINT "ALL THICKNESS ENTRIES ROUNDED TO THE NEAREST 0.001 UNIT"
  PRINT "MAXIMUM PLATE THICKNESS ALLOWED IS 6 CALIBERS   ="; 6! * D;
  IF ((6! * D) <= 1) THEN
    PRINT "INCH"
  ELSE
    PRINT "INCHES"
  END IF
  PRINT "MINIMUM PLATE THICKNESS ALLOWED IS .001 CALIBER ="; .001 * D; "INCH"
  PRINT
  PRINT "Do a Single Plate Calculation with All Outputs (Y/N)? ";
WAITLP6:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLP6
  IF ((YN$ = "Y") OR (YN$ = "y")) THEN PRINT "Yes": SNGLE = 1: GOTO THICK
  IF ((YN$ = "N") OR (YN$ = "n")) THEN PRINT "No": MULT = 1: GOTO INITTHICKNESS
  GOTO WAITLP6: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
THICK:
REM MULT=1 IMPLIES NEW SINGLE-PLATE RUN AFTER A MULTIPLE-PLATE RUN.  RESET PLATE VALUES.
  IF (MULT = 1) THEN MULT = 0: TA = 0: TSLASHD = 0: TSDINIT = 0: TSDFINAL = 0: TSDSTEP = .001
  PRINT
  INPUT "Plate Thickness   (Inches): ", TA$
  IF (TA$ = "") THEN
    IF (TA > 0) THEN
      PRINT "Plate Thickness Used is"; TA;
      IF (TA <= 1) THEN
        PRINT "inch"
      ELSE
        PRINT "inches"
      END IF
    ELSE
      GOTO THICK
    END IF
  ELSE
    TA = VAL(TA$): TATMP = (1000 * TA) + .5: TA = INT(TATMP) / 1000
    IF ((TA / D) < .0009999999#) OR ((TA / D) > 6!) THEN GOTO THICK
  END IF
  TSLASHDTMP = (1000 * (TA / D)) + .5: TSLASHD = INT(TSLASHDTMP) / 1000
  PRINT
  PRINT "Plate Thickness (Calibers):"; TSLASHD
  PRINT
  TSDINIT = 0: TSDFINAL = 0: TSDSTEP = .001
  GOTO DENSITY
REM ******
INITTHICKNESS:
REM SNGLE=1 IMPLIES NEW MULTIPLE RUN AFTER A SINGLE-PLATE RUN.  RESET PLATE VALUES.
  IF (SNGLE = 1) THEN SNGLE = 0: TA = 0: TSLASHD = 0: TSDINIT = 0: TSDFINAL = 0: TSDSTEP = .001
  PRINT
  INPUT "Initial Plate Thickness (Calibers) (Minimum=0 & Maximum=2): ", TSDINIT$
  IF (TSDINIT$ = "") THEN
    IF ((TSDINIT >= 0) AND (TSDINIT <= 2!)) THEN
      PRINT "Initial Plate Thickness Used is"; TSDINIT;
      IF (TSDINIT <= 1) THEN
        PRINT "caliber"
      ELSE
        PRINT "calibers"
      END IF
    ELSE
      GOTO INITTHICKNESS
    END IF
  ELSE
    TSDINIT = VAL(TSDINIT$)
    IF ((TSDINIT < 0) OR (TSDINIT > 2!)) THEN GOTO INITTHICKNESS
  END IF
  TSLASHDTMP = (1000 * TSDINIT) + .5: TSLASHD = INT(TSLASHDTMP) / 1000: TSDINIT = TSLASHD
  PRINT
  TATEMP = (1000 * TSLASHD * D) + .5: TA = INT(TATEMP) / 1000:
  PRINT "INITIAL PLATE THICKNESS (INCHES):"; TA
  PRINT
FINALTHICKNESS:
  INPUT "Final Plate Thickness (Calibers) (Min=Initial Thickness+.001 & Max=6): ", TSDFINAL$
  IF (TSDFINAL$ = "") THEN
    IF (TSDFINAL >= (TSDINIT + .001)) THEN
      PRINT "Final Plate Thickness Used is"; TSDFINAL;
      IF (TSDFINAL <= 1) THEN
        PRINT "caliber"
      ELSE
        PRINT "calibers"
      END IF
    ELSE
      GOTO FINALTHICKNESS
    END IF
  ELSE
    TSDFINAL = VAL(TSDFINAL$)
    IF ((TSDFINAL < 0) OR (TSDFINAL > 6!)) THEN GOTO FINALTHICKNESS
  END IF
  TFTMP = (1000 * TSDFINAL) + .5: TF = INT(TFTMP) / 1000
  PRINT
  TFATMP = (1000 * (TSDFINAL * D)) + .5: TFA = INT(TFATMP) / 1000:
  PRINT "FINAL PLATE THICKNESS (INCHES):"; TFA
  PRINT
  PRINT "CURRENT THICKNESS STEP (CALIBERS) ="; TSDSTEP
  TASTEPTMP = (1000 * TSDSTEP * D) + .5: TASTEP = INT(TASTEPTMP) / 1000
  PRINT "CURRENT THICKNESS STEP (INCHES)   ="; TASTEP
  PRINT
  STEPMAX = TSDFINAL - TSDINIT
  PRINT "MAXIMUM THICKNESS STEP (CALIBERS) ="; STEPMAX
  STEPMAXATMP = (1000 * STEPMAX * D) + .5: STEPMAXA = INT(STEPMAXATMP) / 1000
  PRINT "MAXIMUM THICKNESS STEP (INCHES)   ="; STEPMAXA
  PRINT
THICKNESSSTEP:
  INPUT "Plate Thickness Step (Calibers) (Min=.001 & Max=Final-Init Thickness): ", TSDSTEP$
  IF (TSDSTEP$ = "") THEN
    IF (TSDSTEP <= STEPMAX) THEN
      PRINT "Plate Thickness Step Used is"; TSDSTEP;
      IF (TSDSTEP <= 1) THEN
        PRINT "caliber"
      ELSE
        PRINT "calibers"
      END IF
    ELSE
      GOTO THICKNESSSTEP
    END IF
  ELSE
    TSDSTEP = VAL(TSDSTEP$)
    IF ((TSDSTEP < .001) OR (TSDSTEP > STEPMAX)) THEN GOTO THICKNESSSTEP
  END IF
  TSDSTEPTMP = (1000 * TSDSTEP) + .5: TSDSTEP = INT(TSDSTEPTMP) / 1000
  PRINT
  TASTEPTMP = (1000 * (TSDSTEP * D)) + .5: TASTEP = INT(TASTEPTMP) / 1000:
  PRINT "PLATE THICKNESS STEP (INCHES):"; TASTEP
  PRINT
REM ******
  PRINT "PLATE DENSITY VARIES WITH PLATE MATERIAL USED.  THREE COMMON MATERIALS ARE:"
  PRINT "     IRON & STEEL = 0.2833 (Default)"
  PRINT "     ALUMINUM     = 0.0972"
  PRINT "     TITANIUM     = 0.2422"
  PRINT "ACTUAL DENSITIES MAY VARY SLIGHTLY FROM ALLOY TO ALLOY, OF COURSE."
  PRINT
DENSITY:
  INPUT "Plate Density (Pounds/cubic-inch): ", DEN$
  IF (DEN$ = "") THEN
    IF (PLATEDEN > 0) THEN
      PRINT "Plate Density Used is"; PLATEDEN
    ELSE
      GOTO DENSITY
    END IF
  ELSE
    PLATEDEN = VAL(DEN$): IF (PLATEDEN <= 0) THEN GOTO DENSITY
  END IF
  PRINT
  PRINT "PLATE QUALITY FACTOR (QA) DIRECTLY MULTIPLIES STANDARD STS (QA = 1.00) NBL"
  PRINT
QUALITY:
  INPUT "Plate Quality Factor (Dimensionless): ", QA$
  IF (QA$ = "") THEN
    IF (QA > 0) THEN
      PRINT "Plate Quality Used is"; QA
    ELSE
      GOTO QUALITY
    END IF
  ELSE
    QA = VAL(QA$): IF (QA <= 0) THEN GOTO QUALITY
  END IF
  PRINT
  PRINT "MAXIMUM ALLOWED STRIKING VELOCITY 3500 FEET/SECOND"
  PRINT
VEL:
  INPUT "Striking Velocity (Feet/Second -- Whole Number Only): ", V$
  IF (V$ = "") THEN
    IF (V > 0) THEN
      PRINT "Striking Velocity Used is"; V; "feet/second"
    ELSE
      GOTO VEL
    END IF
  ELSE
    V = VAL(V$): IF ((V <= 0) OR (V <> INT(V)) OR (V > 3500!)) THEN GOTO VEL
  END IF
  PRINT
OBLIQUITY:
  INPUT "Obliquity (Degrees) (80 Degrees Maximum): ", OB$
  IF (OB$ = "") THEN
    PRINT "Obliquity Angle Used is"; OB;
    IF (OB <= 1) THEN
      PRINT "degree"
    ELSE
      PRINT "degrees"
    END IF
  ELSE
    OB = VAL(OB$): IF (OB < 0) OR (OB > 80!) THEN GOTO OBLIQUITY
  END IF
REM ******
REM TAPERED-FLAT-NOSE TABLE STOPS CHANGING AT OB = 45 DEGREES
REM INTERPOLATION FORMULA WILL CRASH AT ITS EXTREME EDGES,
REM    SO KEEP MAXIMUM JUST A HAIR BELOW 45-DEGREE UPPER EDGE.
  IF (OB >= 45!) THEN
    OBTABLE = 44.99999
  ELSE
    OBTABLE = OB
  END IF
REM 'OBFLT' IS MAXIMUM OB FOR SHATTER THICKNESS ADJUSTMENT
  IF (OB >= 60!) THEN OBFLT = 60! ELSE OBFLT = OB
  OBRAD = OB * 3.141592654# / 180!: REM BASIC USES RADIANS
  CSOB = COS(OBRAD): CSOBSQD = CSOB ^ 2
REM ******
  PRINT
  PRINT "A SHATTERED PENETRATION IS ENLARGED, IRREGULAR HOLE OF DOUBLE THE VOLUME OF"
  PRINT "A HOLE MADE BY AN UNSHATTERED FULL-WIDTH-FLAT-NOSE PROJECTILE THRU THE PLATE."
  PRINT "PROJECTILE SHATTER HERE DEPENDS ON PROJECTILE STRENGTH, IMPACT OBLIQUITY,"
  PRINT "PLATE HARDNESS, & PLATE THICKNESS.  IT DOES NOT DEPEND ON STRIKING VELOCITY,"
  PRINT "SO THIS IS NOT SHOCK-INDUCED SHATTER (AS AGAINST FACE-HARDENED ARMOR), BUT IS"
  PRINT "INSTEAD DUE TO THE NOSE BEING CRUSHED BY THE PROJECTILE BODY BEHIND IT WHEN"
  PRINT "IT SUDDENLY DECLERATES ON IMPACT.  THINNER PLATES DEFORM AND REDUCE THE FORCE"
  PRINT "ON THE NOSE.  OBLIQUITY HAS ONLY A RATHER SMALL EFFECT HERE, UNLIKE FOR SHOCK-"
  PRINT "INDUCED SHATTER, SO THE SHATTER PLATE THICKNESS LINEARLY DROPS SLOWLY WITH"
  PRINT "OBLIQUITY TO 75% OF THE RIGHT-ANGLES VALUE AT 60 DEGREES (THIS IS MINIMUM)."
  PRINT "FOR A STRONG WWII AP PROJECTILE AT RIGHT ANGLES, THE FOLLOWING SHATTERS IT:"
  PRINT "               ***>>IF USING A FULL-WIDTH FLAT-NOSE<<***"
  PRINT "   TYPICAL WWII STS-TYPE ARMOR       STEEL = 0.8  CALIBER (TESTS)"
  PRINT "   TYPICAL HIGH TENSILE CONSTRUCTION STEEL = 1.05 CALIBER (TESTS)"
  PRINT "   TYPICAL MILD                      STEEL = 1.15 CALIBER (ESTIMATE)"
  PRINT "   WROUGHT IRON (CONSTRUCTION & ARMOR)     = 1.25 CALIBER (ESTIMATE)"
  PRINT "THESE VALUES WILL GO DOWN WITH SOFTER OR MORE BRITTLE PROJECTILES."
  PRINT
  PRINT "A TAPERED FLAT NOSE OF 0.85-CALIBER FLAT WIDTH HAS AN AREA 72.25% OF THE AREA"
  PRINT "OF FULL-WIDTH FLAT NOSES, SO, AS A 1ST CRUDE ESTIMATE, I WILL ASSUME THE PLATE"
  PRINT "THICKNESS NEEDED TO SHATTER AT RIGHT-ANGLES IS 1/0.7225=1.3841 TIMES THOSE, SO"
  PRINT "STS ARMOR=1.1073, HT STEEL=1.4533, MILD STEEL=1.5917, & WROUGHT IRON=1.7301."
  PRINT
SHATTER:
  INPUT "Normal (Right-Angles) Projectile Shatter Plate Thickness (Calibers): ", SH$
  IF (SH$ = "") THEN
    IF (SH > 0) THEN
      PRINT "Normal Projectile Shatter Plate Thickness (Calibers) Used is"; SH
    ELSE
      GOTO SHATTER
    END IF
  ELSE
    SH = VAL(SH$): IF (SH <= 0) THEN GOTO SHATTER
  END IF
  PRINT
  SHOBMOD = 1 - (.00416667# * OBFLT): SHOBFLT = SHOBMOD * SH: REM SHATTER THICKNESS
  SHOBTMP = (10000 * SHOBFLT) + .5: SHOBRND = INT(SHOBTMP) / 10000
  SHINCHTMP = (1000 * SHOBFLT * D) + .5: SHINCH = INT(SHINCHTMP) / 1000
  PRINT "Plate Shatter Thickness at given Obliquity Angle (calibers) ="; SHOBRND
  PRINT "Plate Shatter Thickness at given Obliquity Angle (inches)   ="; SHINCH
  PRINT
REM
REM                        ***** BEGIN COMPUTATIONS ******
REM
REM ********
  PROJDENSITY = WT / D ^ 3: REM ENGLISH UNITS TYPICAL IS 0.48 TO 0.67 (20mm TEST USED 0.89)
  SCALEFACTOR = (1 - .04 * LOG(D / 3!)) ^ .5: REM NATURAL LOG (BASE E); SAME AS M79 VALUE
REM ********
REM
REM KINETIC ENERGY (0.5*M*V^2) VERSUS COMPLETE PENETRATION THICKNESS (QA*TA)
REM   FORMULAE FOR POINTED PROJECTILES HAVE A MASS EXPONENT OF 0.5 (HALF OF
REM   VELOCITY EXPONENT), BUT A TAPERED-FLAT-NOSE PROJECTILE EJECTS A THICK
REM   PLUG THAT ABSORBS ENERGY TO ACCELERATE, REDUCING THE REMAINING VELOCITY.
REM   THE TRUNCATED-CONE-NOSE PROJECTILE DESCRIBED IN THIS PROGRAM HAS A FLAT
REM   NOSE AREA OF 72.25% OF A FULL-DIAMETER FLAT NOSE.  USING THIS RATIO OF
REM   THE FLAT AREAS BETWEEN POINTED (0%) PROJECTILE EXPONENT (M79 PROGRAM)
REM   AND FULL-FLAT-WIDTH (100%) PROJECTILE ('FLTNS21' PROGRAM) EXPONENT
REM   GIVES A VALUE OF 0.6895 HERE, WHICH IS ALMOST EXACTLY IN THE MIDDLE.
REM   THIS IS AN EDUCATED GUESS.  IF NEW DATA EVER SURFACES, I'LL FIX IT.
REM ************
REM 'NEWCONST' ADJUSTS FOR MODIFIED TRUNCATED-CONE-NOSED U.S. NAVY 13-POUND
REM   MK 29 AP TEST PROJECTILE (W/O WINDSCREEN OR AP CAP) WHEN USING THE NEW
REM   'MASSEXP' (WEIGHT EFFECTS EXPONENT USED INSTEAD OF 0.5).  CHANGE EITHER
REM   AND YOU HAVE TO CHANGE THE OTHER TO COMPENSATE FOR THE KNOWN TESTS.
  MASSEXP = .6895: NEWCONST = 1148.472: REM PREVIOUS FORM OF NEWCONST = .88344*1300
REM ************
REM CONSTANT TERM FOR GIVEN PROJECTILE AND PLATE
  PROJCONST1 = NEWCONST * SCALEFACTOR / (PROJDENSITY ^ MASSEXP)
REM ************
REM
IF (TSLASHD = 0) THEN GOTO FINAL: REM FIRST CALC IF TSDINIT=0 ALWAYS HAS EVERYTHING ZERO
REM
REM ************
COMPSTART:
REM DETERMINE SHATTER FOR ACTUAL PLATE
  IF (TSLASHD >= SHOBRND) THEN SHAT = 1:  ELSE SHAT = 0: REM DETERMINE SHATTER
  IF (SHATFLAG = 0) AND (SHAT = 1) THEN SHATFLAG = 1: REM SINGLE USE ONLY
REM COMPUTE ENCS = NORMAL ENERGY DENSITY = (ENERGY DENSITY)*COS(OB)^2 FROM TABLES
  GOSUB ENCSCALC
REM ************
REM COMPUTE TAPERED FLAT-NOSE PROJECTILE NAVY BL
REM ***>> NOTE THAT ENCS=[(TABLE VALUE x PROJCONST1)^2 x T/D], SO MULTIPLYING
REM ***>> IT BY T/D MAKES TAPERED-FLAT-NOSE NBL DIRECTLY PROPORTIONAL TO T/D
REM ***>> AS MODIFIED BY OTHER ENCS PARAMETERS IN EACH TABLE DELTA STEP,
REM ***>> SO QA, WHICH MULTIPLIES T/D, IS ALSO LINEAR (NOT IN SQUARE-ROOT)
REM
  NAVYBLTFN = QA * (TSLASHD * ENCS) ^ .5 / CSOB: REM ACTUAL PLATE NBL & NO SHATTER
  NBLSTS1 = (TSLASHD * ENCS) ^ .5 / CSOB: REM DEFAULT STS PLATE NBL (QA=1.00; SHAT(OB=0)=1.1073) & NO SHATTER
  IF (SHAT = 1) THEN NAVYBLTFN = 2 * NAVYBLTFN: REM ACTUAL PLATE NBL WITH SHATTER --> 2 x NBL
  NBLTFNRND = INT(NAVYBLTFN + .5): REM FINAL ACTUAL NBL -- WHOLE NUMBER USED IN ALL CALCS
  SHSTS = 1.1073 * SHOBMOD: IF (TSLASHD >= SHSTS) THEN STSSHAT = 1: NBLSTS1 = NBLSTS1 * 2: REM TEST FOR SHATTER --> 2 x NBLSTS
  NBLSTSTMP = NBLSTS1 + .5: NBLSTS = INT(NBLSTSTMP): REM FINAL DEFAULT STS NBL
REM
REM ************
REM NOW DO THE REST OF THE OUTPUTS AND DISPLAY THEM
  GOTO FINAL
REM
REM ********** COMPUTATIONS FOR VARIABLE ENCS (NORMAL ENERGY DENSITY FROM TABLE)
REM
ENCSCALC:
REM DO SLOWLY-CHANGING ENCS COMPUTATION FOR PLATES
  IF (TSLASHD >= .1) THEN GOTO OVERP1: REM DO T/D>=0.1 ENCS CALC
REM ****** LINEAR INTERPOLATION FORMULAE SET FOR COMPUTING ENCS
REM    BELOW 0.1-CALIBER PLATE THICKNESS
REM OBLIQUITY AXIS: DELTA(OB)   =  15-DEGREE   INTERVAL (INCREASING)
  O1 = INT(OBTABLE / 15!): O2 = (OBTABLE - (15! * O1)) / 15!
REM THICKNESS AXIS: DELTA(TA/D) = .025-CALIBER INTERVAL (INCREASING)
  THP1 = INT(TSLASHD / .025): THP2 = (TSLASHD - .025 * THP1) / .025
  ENCS = 0: IF (THP1 = 0) THEN GOTO THP1ZERO: REM BYPASS ZEROTH TABLE ENTRY
REM FIND THE LOWEST  OF THE TWO OB INTERPOLATION POINTS
REM    (BETWEEN TABULATED THICKNESS VALUES)
  N = 0: GOSUB OBUP1AX: ENPCS0 = ENPCSVAL
REM FIND THE HIGHEST OF THE TWO OB INTERPOLATION POINTS
REM    (BETWEEN TABULATED THICKNESS VALUES)
  N = 1: GOSUB OBUP1AX: ENPCS1 = ENPCSVAL
REM NOW INTERPOLATE THE OBLIQUITY AXIS BETWEEN THE THREE OBLIQUITY AXIS
REM    POINTS FOUND FROM THE THICKNESS AXIS COMPUTATION
REM CALCULATED FINAL (ENERGY DENSITY)*COS(OB)^2 VALUE
  ENCS = ENPCS0 + O2 * (ENPCS1 - ENPCS0)
  RETURN
REM ****** USE THICKNESS-AXIS INCREMENT TO FIND THE TWO OBLIQUITY-AXIS
REM    POINTS FOR ENCS BY INTERPOLATION
OBUP1AX:
  ENPCTP1 = THP1 * .025: ENPCTP2 = ENPCTP1 + .025
  ENPCSTH0 = ENPCTP1 * (PROJCONST1 * ENPTABLE(O1 + N, THP1)) ^ 2
  ENPCSTH1 = ENPCTP2 * (PROJCONST1 * ENPTABLE(O1 + N, THP1 + 1)) ^ 2
  ENPCSVAL = ENPCSTH0 + THP2 * (ENPCSTH1 - ENPCSTH0)
  RETURN
REM **********
THP1ZERO:
REM FIND THE LOWEST  OF THE TWO OB INTERPOLATION POINTS
REM    (BETWEEN TABULATED THICKNESS VALUES)
  N = 0: GOSUB OBT1ZRO: ENPCS0 = ENPCSVAL
REM FIND THE HIGHEST OF THE TWO OB INTERPOLATION POINTS
REM    (BETWEEN TABULATED THICKNESS VALUES)
  N = 1: GOSUB OBT1ZRO: ENPCS1 = ENPCSVAL
REM NOW INTERPOLATE THE OBLIQUITY AXIS BETWEEN THE THREE OBLIQUITY AXIS
REM    POINTS FOUND FROM THE THICKNESS AXIS COMPUTATION
REM CALCULATED FINAL (ENERGY DENSITY)*COS(OB)^2 VALUE
  ENCS = ENPCS0 + O2 * (ENPCS1 - ENPCS0)
  RETURN: REM NOW DO BALLISTIC LIMIT COMPUTATIONS AND PRINTOUT LOGIC
REM ****** USE THICKNESS-AXIS INCREMENT TO FIND THE TWO OBLIQUITY-AXIS POINTS
REM    FOR "ENCS" BY INTERPOLATION
OBT1ZRO:
  ENPCSTH1 = .025 * (PROJCONST1 * ENPTABLE(O1 + N, 1)) ^ 2
  ENPCSTH0 = 1.5 * ENPCSTH1
  ENPCSVAL = ENPCSTH0 + THP2 * (ENPCSTH1 - ENPCSTH0)
  RETURN
REM **********
REM TABLE OF VALUES OF PLATE (KINETIC ENERGY DENSITY*COS(OB)^2) MODIFICATION
REM    FACTOR FOR COMPUTING ENCS FOR INTERPOLATION FOR PLATES UNDER
REM    0.1-CALIBER THICKNESS
REM FIRST INDEX IS OBLIQUITY IN 15-DEGREE STEPS AND SECOND INDEX IS PLATE
REM    THICKNESS IN CALIBERS IN 0.025-CALIBER STEPS
REM LINEAR INTERPOLATION FORMULA USED. THIS FACTOR IS A CONSTANT FOR ALL
REM    OBLIQUITIES ABOVE 45 DEGREES. ERRORS ARE TOO BIG ANYWAY FOR MORE
REM    COMPLEX FORMULAE TO BE USED!  OB USED IS 'OBTABLE'.
INITENCS:
REM OB =  0 DEGREES
  ENPTABLE(0, 0) = -1: ENPTABLE(0, 1) = 3.7925: ENPTABLE(0, 2) = 2.6297
  ENPTABLE(0, 3) = 2.1381: ENPTABLE(0, 4) = 1.8517
REM OB = 15 DEGREES
  ENPTABLE(1, 0) = -1: ENPTABLE(1, 1) = 3.1888: ENPTABLE(1, 2) = 2.184
  ENPTABLE(1, 3) = 1.765: ENPTABLE(1, 4) = 1.5285
REM OB = 30 DEGREES
  ENPTABLE(2, 0) = -1: ENPTABLE(2, 1) = 2.5852: ENPTABLE(2, 2) = 1.7383
  ENPTABLE(2, 3) = 1.3918: ENPTABLE(2, 4) = 1.2053
REM OB = 45 DEGREES AND UP
  ENPTABLE(3, 0) = -1: ENPTABLE(3, 1) = 2.2356: ENPTABLE(3, 2) = 1.4958
  ENPTABLE(3, 3) = 1.2053: ENPTABLE(3, 4) = 1.0439
REM **********
REM TABLE OF VALUES OF PLATE (KINETIC ENERGY DENSITY*COS(OB)^2) MODIFICATION
REM    FACTOR FOR COMPUTING ENCS FOR INTERPOLATION FOR PLATES FROM
REM    0.1-CALIBER TO 0.65-CALIBER THICKNESS (~MAXIMUM STS PLATE THICKNESS TESTED)
REM    ** THIS 0.65-CALIBER VALUE KEPT CONSTANT FOR ALL THICKER PLATES **
REM FIRST INDEX IS OBLIQUITY IN 15-DEGREE STEPS AND SECOND INDEX IS PLATE
REM    THICKNESS IN CALIBERS IN 0.05-CALIBER STEPS
REM LINEAR INTERPOLATION FORMULA USED. THIS FACTOR IS A CONSTANT FOR ALL OBLIQUITIES
REM    ABOVE 45 DEGREES (THIS IS FROM THE TEST RESULTS) AND
REM    ALL PLATES OVER 0.65-CALIBER THICKNESS (LINEAR EXTRAPOLATION).
REM    ERRORS ARE TOO BIG ANYWAY FOR MORE COMPLEX FORMULAE TO BE USED!
REM THE FIRST TWO TABLE ENTRIES (0,0) & (0,1) ARE NOT USED HERE (SET TO -1).
REM ***>>> OB =  0 DEGREES
  ENTABLE(0, 0) = -1: ENTABLE(0, 1) = -1: ENTABLE(0, 2) = 1.8517: REM T/D=0, .05, .1
  ENTABLE(0, 3) = 1.5373: ENTABLE(0, 4) = 1.361: ENTABLE(0, 5) = 1.2457: REM T/D=.15, .2, .25
  ENTABLE(0, 6) = 1.1645: ENTABLE(0, 7) = 1.1047: ENTABLE(0, 8) = 1.0611: REM T/D=.3, .35, .4
  ENTABLE(0, 9) = 1.0283: ENTABLE(0, 10) = 1.0041: ENTABLE(0, 11) = .9886: REM T/D=.45, .5, .55
  ENTABLE(0, 12) = .9842: ENTABLE(0, 13) = .9804: REM T/D=.6 & .65 (MAX)
REM ***>>> OB = 15 DEGREES
  ENTABLE(1, 0) = -1: ENTABLE(1, 1) = -1: ENTABLE(1, 2) = 1.5285: REM T/D=0, .05, .1
  ENTABLE(1, 3) = 1.2776: ENTABLE(1, 4) = 1.1522: ENTABLE(1, 5) = 1.085: REM T/D=.15, .2, .25
  ENTABLE(1, 6) = 1.0458: ENTABLE(1, 7) = 1.0274: ENTABLE(1, 8) = 1.0211: REM T/D=.3, .35, .4
  ENTABLE(1, 9) = 1.0103: ENTABLE(1, 10) = .999: ENTABLE(1, 11) = .9886: REM T/D=.45, .5, .55
  ENTABLE(1, 12) = .9811: ENTABLE(1, 13) = .9732: REM T/D=.6 & .65 (MAX)
REM ***>>> OB = 30 DEGREES
  ENTABLE(2, 0) = -1: ENTABLE(2, 1) = -1: ENTABLE(2, 2) = 1.2053: REM T/D=0, .05, .1
  ENTABLE(2, 3) = 1.018: ENTABLE(2, 4) = .9433: ENTABLE(2, 5) = .9243: REM T/D=.15, .2, .25
  ENTABLE(2, 6) = .9271: ENTABLE(2, 7) = .9502: ENTABLE(2, 8) = .9811: REM T/D=.3, .35, .4
  ENTABLE(2, 9) = .9923: ENTABLE(2, 10) = .9939: ENTABLE(2, 11) = .9886: REM T/D=.45, .5, .55
  ENTABLE(2, 12) = .978: ENTABLE(2, 13) = .966: REM T/D=.6 & .65 (MAX)
REM ***>>> OB = 45 DEGREES AND UP
  ENTABLE(3, 0) = -1: ENTABLE(3, 1) = -1: ENTABLE(3, 2) = 1.0439: REM T/D=0, .05, .1
  ENTABLE(3, 3) = .9073: ENTABLE(3, 4) = .8734: ENTABLE(3, 5) = .8841: REM T/D=.15, .2, .25
  ENTABLE(3, 6) = .9074: ENTABLE(3, 7) = .9502: ENTABLE(3, 8) = .9811: REM T/D=.3, .35, .4
  ENTABLE(3, 9) = 1.0164: ENTABLE(3, 10) = 1.0508: ENTABLE(3, 11) = 1.072: REM T/D=.45, .5, .55
  ENTABLE(3, 12) = 1.0893: ENTABLE(3, 13) = 1.0843: REM T/D=.6 & .65 (MAX)
  RETURN
REM ****** LINEAR INTERPOLATION FORMULAE SET FOR COMPUTING ENCS FOR
REM    0.1-CALIBER & UP PLATE THICKNESS -- USE 0.65 TABLE VALUE FOR ALL THICKER PLATES
OVERP1:
REM OBLIQUITY AXIS: DELTA(OB)   =  15-DEGREE  INTERVAL (INCREASING)
  O1 = INT(OBTABLE / 15!): O2 = (OBTABLE - (15! * O1)) / 15!
REM THICKNESS AXIS: DELTA(TA/D) = .05-CALIBER INTERVAL (INCREASING)
  TH1 = INT(TSLASHD / .05): TH2 = (TSLASHD - .05 * TH1) / .05: REM TABLE DELTA (0.65-CAL MAX)
  ENCS = 0
REM FIND THE LOWEST  OF THE TWO OB INTERPOLATION POINTS
REM    (BETWEEN TABULATED THICKNESS VALUES)
  N = 0: GOSUB OBO1U9AX: ENCS0 = ENCSVAL
REM FIND THE HIGHEST OF THE TWO OB INTERPOLATION POINTS
REM    (BETWEEN TABULATED THICKNESS VALUES)
  N = 1: GOSUB OBO1U9AX: ENCS1 = ENCSVAL
REM NOW INTERPOLATE THE OBLIQUITY AXIS BETWEEN THE TWO OBLIQUITY AXIS POINTS
REM    FOUND FROM THE THICKNESS AXIS COMPUTATION
REM CALCULATED FINAL (ENERGY DENSITY*COS(OB)^2) VALUE
  ENCS = ENCS0 + O2 * (ENCS1 - ENCS0)
  RETURN
REM ****** USE THICKNESS-AXIS INCREMENT TO FIND THE TWO OBLIQUITY-AXIS POINT
REM    BY INTERPOLATION
OBO1U9AX:
REM ACTUAL T/D INCREASES WITHOUT TOP, BUT TABLE INCREMENT STOPS AT 0.65 CALIBER THICKNESS
  IF (TSLASHD < .65) THEN
    ENCTP1 = TH1 * .05: ENCTP2 = ENCTP1 + .05: REM ACTUAL THICKNESS BOUNDARY VALUES
    ENCSTH0 = ENCTP1 * (PROJCONST1 * ENTABLE(O1 + N, TH1)) ^ 2: REM TABLE DIFFERENCE BOTTOM
    ENCSTH1 = ENCTP2 * (PROJCONST1 * ENTABLE(O1 + N, TH1 + 1)) ^ 2: REM TABLE DIFFERENCE TOP
    ENCSVAL = ENCSTH0 + TH2 * (ENCSTH1 - ENCSTH0): REM ACTUAL THICKNESS MIDPOINT VALUE USED
  ELSE
REM USE .65-CALIBER TABLE MODIFIER ONLY FOR ALL LARGER T/D: ENTABLE(OB INDEX, 13)
    ENCSVAL = TSLASHD * (PROJCONST1 * ENTABLE(O1 + N, 13)) ^ 2: REM N CHANGES OB TABLE VALUE
  END IF
  RETURN
REM **************
FINAL:
  IF (FINALFLAG = 0) THEN
    COUNT = 0
    PRINT "                 *****>>>>>>>FINAL RESULTS<<<<<*****"
    PRINT
    PRINT "PROJ:  DIAMETER  ="; D; TAB(29); "WEIGHT  ="; WT; TAB(47); "VELOCITY  ="; V
    PRINT "PLATE: QUALITY   ="; QA; TAB(29); "DENSITY ="; PLATEDEN; TAB(47); "OBLIQUITY ="; OB
    SHPRNTTMP = (10000 * SH) + .5: SHPRNT = INT(SHPRNTTMP) / 10000
    PRINT "       SHATTER T @ OB=0 CALIBERS ="; SHPRNT; TAB(44); "SHATTER T @ OB CALIBERS ="; SHOBRND
    IF (TSDFINAL = 0) THEN
REM SINGLE PLATE ALL-OUTPUT CALCS
      PRINT "       THICKNESS INCHES ="; TA; TAB(37); "THICKNESS CALIBERS ="; TSLASHD
      PRINT
    ELSE
REM MULTIPLE PLATE NBL-ONLY CALC
      PRINT "INITIAL T CALIBERS ="; TSDINIT; TAB(29); "FINAL T CALIBERS ="; TSDFINAL; TAB(55); "T STEP CALIBERS ="; TSDSTEP
      PRINT
    END IF
  END IF
  IF (TSDFINAL = 0) THEN GOTO CHECKNBL: REM SINGLE-PLATE CALCS
REM
REM **** MULTIPLE-PLATES RUN WITH NBL ONLY ****
REM
GOSUB PRINTNBL: REM PRINT THIS OUTPUT
IF ((NBLTFNRND > 3500) AND (NBLSTS > 3500)) THEN
  PRINT "***>> NO MORE NBL DATA -- STOP RUN"
  PRINT
  GOTO ENDIT: REM ABORT THIS RUN
END IF
IF (TSLASHD >= TSDFINAL) THEN PRINT : GOTO ENDIT: REM FINISHED ALL INCREMENTS
IF (COUNT = 24) THEN
  PRINT "TYPE C TO CONTINUE ";
WAIT7:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAIT7
  IF (YN$ = "C") OR (YN$ = "c") THEN PRINT "Go": GOTO GOPRINT
  GOTO WAIT7: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
END IF
GOPRINT:
  IF (TSLASHD < TSDFINAL) THEN
    TSLASHDTMP = (1000 * (TSLASHD + TSDSTEP)) + .5: TSLASHD = INT(TSLASHDTMP) / 1000
    IF (TSLASHD >= TSDFINAL) THEN TSLASHD = TSDFINAL
    TATMP = (1000 * TSLASHD * D) + .5: TA = INT(TATMP) / 1000
  END IF
  COUNT = COUNT + 1: GOTO COMPSTART: REM START NEXT CALCULATION
REM ****
PRINTNBL:
  FINALFLAG = 1
  IF (SHATFLAG = 1) THEN
    SHATFLAG = -1: REM PRINT MESSAGE ONLY ONCE PER RUN
    PRINT "***>> PROJECTILE SHATTERED FROM NOW ON (NOTE THE '$') -- DOUBLE NBL"
  END IF
  PRINT "T/D="; TSLASHD; TAB(13); "-T(Actual)="; TA; TAB(32);
   IF (SHAT = 1) THEN
    PRINT "$";
  ELSE
    PRINT "-";
  END IF
  IF (NBLTFNRND > 3500) THEN
    PRINT "NBL(Actual)>*3500*";
  ELSE
    PRINT "NBL(Actual)="; NBLTFNRND;
  END IF
  PRINT TAB(53);
  IF (STSSHAT = 1) THEN
    PRINT "$";
  ELSE
    PRINT "-";
  END IF
  IF (NBLSTS > 3500) THEN
    PRINT "NBL(STS Default)>*3500*"
  ELSE
    PRINT "NBL(STS Default)="; NBLSTS
  END IF
RETURN
REM ****
REM
REM **** SINGLE-PLATE RUN WITH ALL OUTPUTS ****
REM
CHECKNBL:
  IF (SHAT = 1) THEN
    PRINT "Projectile shattered: Use double NBL &, if hole, full-caliber-width plug weight"
  ELSE
    PRINT "Projectile not shattered: Use regular NBL &, if hole, tapered-width plug weight"
  END IF
  PRINT
  IF (NBLTFNRND > 3500) THEN
    PRINT "No penetration possible -- NBL > 3500 feet/second": PRINT
    GOTO ENDIT
  END IF
REM HOW MUCH ENERGY PER VOLUME OF ARMOR MATERIAL REMOVED WAS NEEDED
REM   TO OPEN UP A CALIBER-DIAMETER HOLE IN THAT PLATE
ENERGYTEMP = .5 * (WT / 32.186) * NBLTFNRND ^ 2
ENERGYDENSITY = ENERGYTEMP / (3.141592654# * TA * (D / 2) ^ 2)
ENERGYRND = INT(ENERGYDENSITY + .5)
ENERGYCSOBSQD = ENERGYDENSITY * CSOBSQD
ECSOBRND = INT(ENERGYCSOBSQD + .5)
PRINT "Navy Ballistic Limit ="; NBLTFNRND; "feet/second"
PRINT
PRINT "ENERGY DENSITY = IMPACT ENERGY/(VOLUME OF CYLINDRICAL D-DIAM HOLE THRU PLATE):"
PRINT
PRINT "**** Energy Density ="; ENERGYRND; "foot-pounds/cubic inch"
PRINT
PRINT "ENERGY DENSITY USING ONLY NBL COMPONENT POINTING AT RIGHT ANGLES TO PLATE FACE:"
PRINT "(GRAPHS OF THIS QUANTITY VERSUS PLATE THICKNESS IN CALIBERS ARE ILLUMINATING;"
PRINT "THEY SHOW TRENDS BY ELIMINATING SIMPLE OBLIQUE IMPACT GEOMETRICAL EFFECTS)"
PRINT
PRINT "**** Energy Density X COS(OB)^2 ="; ECSOBRND; "foot-pounds/cubic inch"
PRINT
REM
REM ***** EXIT ANGLE, EXIT VELOCITY, PLUG WEIGHT. & PLUG VELOCITY CALCS *****
REM
IF (V < NBLTFNRND) THEN PRINT "No hole through plate.": PRINT : GOTO ENDIT
REM
REM *** HOLE PUNCHED IN PLATE ***
REM
PRINT "PLUG ALWAYS EJECTED ALONG CALCULATED EXIT ANGLE EVEN IF PROJECTILE REBOUNDS."
PRINT "PLUG WEIGHT IS MINIMUM (OB=0) PLUG WEIGHT DIVIDED BY COS[(OB+EXIT ANGLE)/2]."
PRINT "PLUG VELOCITY IS AT LEAST EQUAL TO PROJECTILE REMAINING VELOCITY.  IF THE"
PRINT "PROJECTILE SHATTERS, SOME PIECES OF IT WILL REBOUND SIDEWAYS, NOT THRU HOLE."
PRINT "PLUG WEIGHT IF PROJECTILE SHATTERS IS *DOUBLE* A FULL-FLAT-NOSE PLUG WEIGHT,"
PRINT "FORMED FROM ENLARGED, IRREGULARLY-SHAPED HOLE.  PLUG USUALLY REMAINS IN ONE"
PRINT "PIECE IF THE ARMOR FAILS IN A DUCTILE MANNER, BUT BREAKS UP IF ARMOR BRITTLE."
PRINT "IF PLUG IS AS HEAVY AS OR HEAVIER THAN PROJECTILE, THEN THE PROJECTILE WILL"
PRINT "*ALWAYS* REBOUND DUE TO CONSERVATION OF MOMENTUM ('CUE-BALL EFFECT')."
PRINT
PLUGMIN = PLATEDEN * (3.141592654#) * TA * (.85 * D / 2) ^ 2: REM CYLINDRICAL PLUG WEIGHT W/O SHATTER
REM FOR SHATTERED PROJ, DOUBLE FULL-CALIBER-WIDE PLUG WEIGHT USING FULL-WIDTH-FLAT-NOSE PROJECTILE VALUE
PLUGSHAT = 2 * PLATEDEN * (3.141592654#) * TA * (D / 2) ^ 2: REM CYLINDRICAL PLUG WEIGHT WITH SHATTER
REM
REM *** EXIT ANGLE COMPUTATION ***
REM
REM FIX DIVIDE-BY-ZERO FOR VERY THIN PLATES
IF (OB <= .005) THEN
  CSEX = 1: EX = 0: EXRAD = 0: EXRND = 0: DF = 0: DFRAD = OB / 57.29578
  GOTO PLUGCALC
END IF
REM
VRAT = V / NBLTFNRND: IF (VRAT < 1) THEN VRAT = 1.0000001#: REM PREVENT ROUND-OFF ERROR
TMPV = (VRAT ^ 2) - 1
TMPVEL = VRAT ^ 2 + VRAT * SQR(TMPV)
SNCSTST = SIN(OBRAD) * CSOB: SNCS = SNCSTST: REM ALWAYS NOSE-FIRST PENETRATION AT ALL OB VALUES
REM CALCULATE DEFLECTION ANGLE DF -- SYMMETRICAL ABOUT OB=45
TMPDF1 = SNCS / TMPVEL: TMPDF2 = 1 - 4 * TMPDF1 ^ 2
TANDF = (1 - SQR(TMPDF2)) / (2 * TMPDF1): REM TRIG IDENTITY FOR TANGENT OF DF
DF = ATN(TANDF) * 57.29578
DFRAD = DF / 57.29578: DFTMP = 100 * DF + .5: DFRNDED = INT(DFTMP) / 100: REM RADIANS REQUIRED
EX = OB - DF: EXRAD = EX / 57.29578: EXTMP = 100 * EX + .5: EXRND = INT(EXTMP) / 100
CSEX = COS(EXRAD)
REM
REM *** PLUG WEIGHT COMPUTATION ***
REM
PLUGCALC:
  PRINT "Exit Angle (Degrees) ="; EXRND
  PRINT
  PLUGANGLE = (OB + EX) / 2: REM PLUG SIZE MODIFIER IS MIDWAY BETWEEN OBLIQUITY & EXIT ANGLES
  PLUGAGLRAD = PLUGANGLE / 57.2957: CSPLGANGLE = COS(PLUGAGLRAD)
  IF (SHAT = 0) THEN PLUGW = PLUGMIN:  ELSE PLUGW = PLUGSHAT
  PLUGEX = PLUGW / CSPLGANGLE: REM PLUG WEIGHT MOVING ALONG EXIT ANGLE
  IF (SHAT = 0) THEN
    PRINT "Unshattered Projectile";
  ELSE
    PRINT "Shattered Projectile";
  END IF
  PLUGTMP = 1000 * PLUGEX + .5: PLUGRND = INT(PLUGTMP) / 1000: REM FINAL ACTUAL PLUG WEIGHT
  PRINT " Plug Weight (Pounds) ="; PLUGRND
  PRINT
REM
REM *** PROJECTILE REMAINING VELOCITY & PLUG VELOCITY CALC ***
REM
IF (V < NBLTFNRND) THEN NBLTFNRND = V: REM PREVENT ROUND-OFF ERROR
VNBLTFN = (V ^ 2 - NBLTFNRND ^ 2): VR1 = COS(DFRAD) * SQR(VNBLTFN)
REM *****
REM CONSERVATION OF MOMENTUM & CONSERVATION OF ENERGY USED TO CALCULATE A SINGLE VPLUG & VR
REM
VPLUG = VR1 * 2 * WT / (WT + PLUGRND): REM PLUG REMAINING VELOCITY
VR = VPLUG * (WT - PLUGRND) / (2 * WT): REM PROJECTILE REMAINING VELOCITY
REM
VPLUGTMP = VPLUG + .5: VPLUGRND = INT(VPLUGTMP): REM CALCULATE FINAL VPLUG
VRTMP = VR + .5: VRRND = INT(VRTMP): REM CALCULATE FINAL VR
REM
PRINT "ELASTIC COLLISION WITH PLUG CALCULATED USING REMAINING VELOCITY & EXIT ANGLE:"
PRINT
PRINT "Ejected Armor Plug   Velocity in Exit Angle Direction (Feet/Second) ="; VPLUGRND
PRINT "Projectile Remaining Velocity in Exit Angle Direction (Feet/Second) ="; VRRND
REM
REM ****** REPEAT PROGRAM LOGIC ******
REM
ENDIT:
  FINALFLAG = 0: SHATFLAG = 0: SHAT = 0: STSSHAT = 0:
  COUNT = 0: NAVYBLTFN = 0: NBLSTS = 0: NBLTFNRND = 0
  PRINT "                   *****>>>>>>>FINISHED<<<<<<<*****"
  PRINT "Run Again (Y/N)? ";
WAITLOOP:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLOOP
  IF (YN$ = "Y") OR (YN$ = "y") THEN PRINT "Yes": PRINT : GOTO DIAMETER
  IF (YN$ = "N") OR (YN$ = "n") THEN END: REM KILL PROGRAM
  GOTO WAITLOOP: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
REM **************
REM
REM *** END OF PROGRAM CODE ***

