DIM DELTATBL(4, 9)
SCREEN 13
WIDTH 80, 43
GOSUB INITDELTATBL
CLS
PRINT "           *** FLAT NOSE ARMOR PENETRATION PROGRAM VERSION 3.0 ***"
PRINT " BALLISTIC LIMIT & ENERGY COMPUTATION FOR A FLAT-NOSE STEEL AP SHOT PROJECTILE"
PRINT "                                 VERSUS"
PRINT "   WWII U.S. NAVY CLASS B ARMOR/STS OF 115,000 PSI TENSILE STRENGTH (DEFAULT)"
PRINT "                                   OR"
PRINT " OTHER METAL ARMOR OR PROJECTILE WITH KNOWN TEST RESULTS TO ALLOW INPUT VALUES"
PRINT "   **>> INCLUDES PLUG WEIGHT, EXIT ANGLE, REMAINING VELOCITY, & SHATTER <<**"
PRINT " **>>OPTIONS: NBL ONLY FOR MULTIPLE PLATES OR ALL OUTPUTS FOR SINGLE PLATE<<**"
PRINT "                      BY: NATHAN OKUN (12 JULY 2011)"
PRINT
REM DEFAULTS
QA = 1: D = 3: WT = 13: PLATEDEN = .2833: SH = .8: TSDSTEP = .001
REM **********
PRINT "The US Navy Ballistic Limit (NBL) assumed:  The entire projectile, if intact,"
PRINT "(excluding any nose coverings like AP caps, hoods, and windscreens), or 80%"
PRINT "(roughly) of its body weight (again excluding nose coverings), if broken up,"
PRINT "can pass through the plate at this striking velocity or more, but not at less."
PRINT
PRINT "All flat-nose projectiles are assumed to have no nose coverings whatosever."
PRINT
PRINT "PERCENT ELONGATION NOT USED WITH A FLAT NOSE.  MINIMUM OF 4 INCHES OF PLATE"
PRINT "STRETCHING NEEDED FOR ANY EFFECT.  SHEARING OUT OF A PLUG DOES NOT DO THIS."
PRINT
PRINT "REASONS FOR UPDATING PROGRAM TO VERSION 3.0: To Begin Inputs Type S Else Type C"
WAITLP0:                                                      
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLP0
  IF (YN$ = "S") OR (YN$ = "s") THEN GOTO BGNINPT
  IF (YN$ = "C") OR (YN$ = "c") THEN GOTO UPDATE0
  GOTO WAITLP0: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
REM **********
UPDATE0:
CLS
PRINT "REASONS FOR UPDATING PROGRAM TO VERSION 3.0:"
PRINT "I accidently inverted the SCALEFACTOR.  The smaller the projectile, the greater"
PRINT "the plate resistance.  When I fixed this, I realized that several other errors"
PRINT "related to the M79APCLC program's SCALEFACTOR=1-[.04*LN(D/3)] existed.  To"
PRINT "match the WELDOX 460E results, drastic changes to the SCALEFACTOR logic were"
PRINT "required:  The '(1/D^.5)' term used was actually part of SCALEFACTOR and was"
PRINT "WRONG, so I removed it, changing the Numerical Constant to keep the results for"
PRINT "the 3-inch 13-lb projectile the same.  The SCALEFACTOR still pivots on a 3-inch"
PRINT "projectile size, so nothing changes for the 3-inch 7.5-lb, 11-lb, & 15-lb STS"
PRINT "WWII test results (same weight terms kept).  WELDOX 460E is at least as strong"
PRINT "as WWII British D-Steel, so both use Quality Factor QA=0.9. I then built a new"
PRINT "larger SCALEFACTOR=1-[.45093*LN(D/3)] in M79APCLC format for want of any other."
PRINT "Is this reasonable?  It increases the NBL by about 84% for a 20mm projectile"
PRINT "scaled down from the 13-lb 3-inch projectile at only 0.2351 lb instead of the"
PRINT "very long and heavy 0.4343-lb 20mm projectile actually used, but since only"
PRINT "hole-edge shearing is resisting penetration, a large scale effect is expected."
PRINT
PRINT "Also, I reduced the shattered pojectile plug weight multiplier to only 1.333."
PRINT "I have a 1311-ft/sec 12mm WELDOX 460E flat-nose vs plate test with this result."
PRINT
PRINT "REASONS FOR UPDATING PROGRAM TO VERSION 2.1:"
PRINT "I replaced all curved plots with straight lines in Version 2.0 because for an"
PRINT "impact obliquity (OB) of zero ('Normal' or right angles) the 20mm data showed"
PRINT "a linear ratio of complete penetration to the NBL value for all plates for that"
PRINT "obliquity.  I assumed this was true for all obliquities and re-did all of the"
PRINT "old program outputs to replace them with straight lines everywhere.  This turns"
PRINT "to be incorrect.  When I graphed my tapered flat-nose penetration data, which"
PRINT "is quite accurate and precise, I noticed that in the thinner plate region below"
PRINT "0.6-caliber plate thickness, the right angles line was indeed made up only of"
PRINT "straight lines (except for the very bottom where the NBL must go to zero when"
PRINT "plate thickness goes to zero, having a curved region near zero thickness), but"
PRINT "other obliquities had curves such that the NBL for a given plate thickness was"
PRINT "*LOWER* than the straight line estimate gives.  This turned out to be true for"
PRINT "much of the penetration versus NBL curves for the full-flat-nose projectiles."
PRINT
PRINT "Dishing (wide denting about the impact point) is quite pronounced with a flat-"
PRINT "nosed projectile, since it has no point to tear open the plate prior to a deep"
PRINT "dish being made.  The higher the obliquity, the easier it is for the flat nose"
PRINT "to cut an initial 'smiley face' crescent notch in the plate by its 'chin' (the"
PRINT "projectile corner that first hits the plate).  This reduces dishing more as the"
PRINT "****>>>> Type C To Continue";
WAITLP1:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLP1
  IF (YN$ = "C") OR (YN$ = "c") THEN GOTO UPDATE1
  GOTO WAITLP1: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
REM **********
UPDATE1:
CLS
PRINT "impact obliquity increases, as shown in the Version 2.0 program.  However, with"
PRINT "this chin impact, there is a secondary effect that decreases with decreasing"
PRINT "dishing as the plate gets thicker (and has little effect for very thin plates"
PRINT "that fold up like crumpled paper as the projectile pushes forward at an oblique"
PRINT "angle)."
PRINT
PRINT "This secondary effect *IMPROVES* the penetration ability of all of the flat-"
PRINT "nosed projectile when the dishing effect is maximum (circa 0.2-0.5-caliber),"
PRINT "having little or no effect for thinner and thicker plates.  Also, this effect"
PRINT "gets *MORE* pronounced as obliquity increases, not *LESS* pronounced."
PRINT
PRINT "This effect is due to the chin cutting its initial notch in the plate face at"
PRINT "an oblique impact, which reduces widespread dishing, but it also causes a deep"
PRINT "LOCAL dish just in front of the projectile chin which reduces the effective"
PRINT "obliquity angle of the impact during the initial cutting of the notch.  Thus,"
PRINT "penetration becomes initially somewhat easier, though this disappears as the"
PRINT "notch widens to the width of the projectile's flat face, so we only get a small"
PRINT "'tweak' to the overall penetration.  But is noticable and had to be fixed."
PRINT "A small table has been added for OB>0 when 0.15<T/D<0.55.  I also found a"
PRINT "small error for OB>60 degrees against all plate thicknesses and fixed it too."
PRINT
PRINT "REASONS FOR UPDATING PROGRAM TO VERSION 2.0:"
PRINT "In 2001 and 2002 The International Journal of Impact Engineering published"
PRINT "some articles on tests with 0.7874-inch (20mm) projectiles (flat-nose,"
PRINT "hemispherical nose, conical nose, and tangent ogive nose with a radius of"
PRINT "ogive of 3 calibers).  These projectiles weighed 0.4343 lb (0.2 kg), which"
PRINT "is much heavier for their size than the 10- to 15-lb 3-inch projectiles"
PRINT "used in the WWII US Naval Proving Ground WWII STS tests.  Also, the plate"
PRINT "armor material used was a modern high-tensile construction steel called"
PRINT "'WELDOX 460E' which at optimum ductile configuration had a Tensile Strength"
PRINT "of 84,100 pounds/square-inch (average).  Some plates of this material were"
PRINT "experimentally hardened to STS-level strengths, as hard, brittle 'Martensite'."
PRINT "They failed by brittle fracture, which severely decreased resistance against"
PRINT "these projectiles when they were not shattered on imp[act.  Even against the"
PRINT "regular version of WELDOX 460E, the flat-nose projectiles shattered whenever"
PRINT "thickness (T) exceeded 1 caliber (T/Projectile Diameter (D)>1).  When shatter"
PRINT "occurred, even raising the velocity by 50% over the expected unshattered value"
PRINT "failed to penetrate (deep, wide dent only).  I assume DOUBLE velocity needed."
PRINT "****>>>> Type C To Continue";
WAITLP2:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLP2
  IF (YN$ = "C") OR (YN$ = "c") THEN GOTO UPDATE2
  GOTO WAITLP2: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
REM **********
UPDATE2:
CLS
PRINT "In the WWII STS tests, all flat-nosed projectiles -- mostly 3-inch M79 AP Shot"
PRINT "with their noses sliced off, though a few special 3-inch 15-lb flat-nose AP"
PRINT "projectiles were made for this test -- shattered above 0.75-caliber (2.25-inch)"
PRINT "plate thickness and could not penetrate.  I again assume double velocity is"
PRINT "needed to punch a hole entirely through a plate when projectile is shattered."
PRINT "Unlike the new 20mm tests at right-angles only, the 3-inch tests were at up to"
PRINT "60 degrees obliquity, allowing a complete 0-80-degree (extrapolated) program."
PRINT
PRINT "The new data gives slightly different results from the old one, since the 20mm"
PRINT "tests gave a similar penetration thickness versus striking velocity graph to"
PRINT "the 3-inch tests, but was offset from the STS graph and its graph gave straight"
PRINT "lines only.  This matches theory better than the old program did, since the STS"
PRINT "plate-to-plate quality variations were much bigger than with WELDOX 460E plate."
PRINT "Therefore, I adjusted the old STS test graph using straight lines only, as in"
PRINT "the 20mm test plots, which required only very small adjustments to a obtain a"
PRINT "set of linear plots for STS.  Projectile damage was none or complete shatter."
PRINT "Above 0.55-caliber plate thickness, there is only one straight line shifted by"
PRINT "obliquity (OB).  Impact obliquity changes this 0.55-cal point with a modified"
PRINT "Secant(OB)=1/COSINE(OB) curve. Below the 0.55-cal thickness, obliquity further"
PRINT "modifies the results through a fan of linear adjustment lines that radiate from"
PRINT "the 0.55-cal point to a set of non-zero velocity points on the T=0 axis, each"
PRINT "line representing a single OB, with the OB=0 line the steepest (gives highest"
PRINT "NBL at T=0).  A single line is used for OB=60 thru 80 degrees, which has NBL=0"
PRINT "when T=0, which is closest to merely extending the over-0.55-cal line to T=0."
PRINT
PRINT "For very thin plates, these radiating lines give the problem that all but the"
PRINT "OB=60-80 degree line will not give an NBL=0 when the plate thicknes is zero."
PRINT "It is unlikely that for a plate of T=0.001-cal (thinnest allowed) that a large"
PRINT "NBL will occur even at OB=0.  Thus, for thin plates, this fan of lines must be"
PRINT "changed to curves at some non-zero velocity/thickness point on those lines to"
PRINT "smoothly connect these fan-of-straight-lines values to give an NBL=0 when T=0."
PRINT "I drew a straight line from the OB=0 line's T=0.125-cal point to the T=0 point"
PRINT "on the OB=60-80 line, with the straight-line-to-curve-line switch point on it"
PRINT "for any obliquity.  I created an equation from there to the NBL=0 at T=0 point."
PRINT
PRINT "The 2.0 program merely adjusts the input quantities to compute a single NBL"
PRINT "for T/D = 0.55 Caliber and then sticks this value into that single cluster of"
PRINT "straight lines radiating from the 0.55-point, solving for all other plates,"
PRINT "with only a check for shatter needed to complete the computation package."
PRINT "****>>>> Type C To Continue";
WAITLP3:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLP3
  IF (YN$ = "C") OR (YN$ = "c") THEN GOTO UPDATE3
  GOTO WAITLP3: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
REM **********
UPDATE3:
CLS
PRINT "The WELDOX 460E plates gave the correct NBL using the old M79 Scaling Factor,"
PRINT "with a plate quality of 0.75, which is ckose to the Tensile Strength ratio"
PRINT "of 115,000 lb/square-inch for STS to the 81,500-85,500 lb/square inch for"
PRINT "various WELDOX 460E plates.  Therefore, until I get different information, I"
PRINT "will assume that as long as the failure is pure ductile failure ('fiber'),"
PRINT "the ratio of Tensile Strengths to STS (QA=1.00) can equal Plate Quality, but"
PRINT "if any brittle failure ('grain') occurs, then the QA goes downward rapidly."
PRINT
PRINT "I have extended this Version 2.0 program to include other kinds of iron or"
PRINT "steel plate and even to non-ferrous metals, if known test results can be used"
PRINT "to calibrate the plate density and quality factor.  I am assuming that the"
PRINT "geometrical aspects of this penetration are identical for every kind of metal"
PRINT "plate -- 0.55-caliber represents the minimum energy per unit plate thickness"
PRINT "to obtain a complete penetration.  The projectile weight input already allows"
PRINT "various projectile materials within lengths of up to about 4 calibers (not"
PRINT "long rod penetrators) and adjusting the quality factor on a sliding scale can"
PRINT "also allow for gradual projectile deformation instead of shatter, though this"
PRINT "would require a lot of work to create such a table for different thicknesses,"
PRINT "plate materials, and impact obliquities.  Adjusting the shatter thickness is"
PRINT "another challenge for non-ferrous metals in the projectile and/or plate, since"
PRINT "this may not follow the simple linear drop from the given right-angles value"
PRINT "to only 75% of that at 60 degrees obliquity and up which I use when an iron"
PRINT "alloy is used for both the projectile and the plate."
PRINT
PRINT "Pictures of the sliced-open plate holes where the impact was very slightly"
PRINT "below the NBL shows that the penetration process is similar to what happens"
PRINT "with face-hardened armor, in that there is almost no penetration, merely a"
PRINT "shallow, projectile-diameter-wide, flat-based and vertical-sided pit in the"
PRINT "plate with, for thin plates, a very wide, even-more-shallow bowl-shaped 'dish'"
PRINT "surrounding the impact point.  With a pointed nose, the depth of the pit made"
PRINT "in that plate by the point varies in depth more-or-less directly with impact"
PRINT "velocity, gradually penetrating until the entire nose and, at a slightly"
PRINT "higher velocity, the entire projectile goes through the plate.  Obviously, a"
PRINT "flat nose is more an all-or-nothing kind of penetration, as with face-hardened"
PRINT "armor.  Thus, all of the projectile's energy is used up forming the plug and"
PRINT "nothing happens of note until the velocity is raised so that the plug shears"
PRINT "out along its entire depth, at which point the NBL is reached and penetration"
PRINT "****>>>> Type C To Continue";
WAITLP4:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLP4
  IF (YN$ = "C") OR (YN$ = "c") THEN GOTO UPDATE4
  GOTO WAITLP4: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
REM **********
UPDATE4:
CLS
PRINT "suddenly becomes complete, with, it seems, the projectile and plug acting like"
PRINT "a elongated, very heavy, billiard-game cue-ball (projectile) hitting a smaller"
PRINT "numbered billiard ball (plug) in what is called an 'elastic' collision where"
PRINT "neither impacting body is permanently deformed during this final portion of"
PRINT "the impact nor do the two bodies stick together afterwards.  The plug will end"
PRINT "up moving faster than the heavier projectile's Remaining Velocity, in some"
PRINT "cases MUCH faster than the projectile when the plug is very light-weight.  If"
PRINT "the plug is as heavy or heavier than the projectile, then the projectile will"
PRINT "always either stop moving or bounce back like a cue-ball, hence the analogy."
PRINT
PRINT "Microscpic study of the edge of the plug and hole shows that the narrow zone"
PRINT "near the edge is 'work hardened' by the sudden energy input and compression"
PRINT "until it becomes a very hard and brittle steel called 'Martensite' which will"
PRINT "crack and, when this crack goes all the way through the plate, allow the plug"
PRINT "to suddenly move freely, instead of the rather small backward movement it had"
PRINT "up to then, merely forming a bulge in the plate back surface.  Different"
PRINT "steels react differently to this edge hardening, some doing it gradually and"
PRINT "some in a series of steps called 'shear banding', with the latter somewhat"
PRINT "inferior in that the plate cracks more easily.  In plates that are hardened"
PRINT "to the point where there is already some Martensite in their structure, this"
PRINT "failure process is easier to complete, obviously, and the Plate Quality used"
PRINT "here as a measure of resistance compared to fully ductile, homogeneous STS"
PRINT "armor, begins to drop faster and faster as the plate has more and more of its"
PRINT "structure made of Martensite (or other hard crystals) prior to the impact."
PRINT
PRINT "WELDOX 460E in its regular form is more-or-less at the optimum hardness to"
PRINT "resist projectile impacts, given its alloy composition.  Softening it by an"
PRINT "annealing process (the maximum anneal being called 'spheroidation') would"
PRINT "make it easier to deform and cause the plug edges to work harden faster,"
PRINT "which makes the resistance gradually go down with reduced Tensile Strength."
PRINT "On the other hand, trying to make the armor stronger by making it harder with"
PRINT "more hard crystals, resulting in Martensite (the final form being pure hard"
PRINT "crystals of iron-carbon 'Cementite', though that takes a large amount of the"
PRINT "element carbon or a hardness-enhancing element like chromium or molybdenum in"
PRINT "the alloy to start with, which WEDOX 460E does not use (costly), but STS did),"
PRINT "is counter-productive, as mentioned, in that less work hardening needs to be"
PRINT "done in the first place and that trumps any reduction in plate deformation."
PRINT "STS can be raised to a higher hardness level than WELDOX steels due to it"
PRINT "****>>>> Type C To Continue";
WAITLP5:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLP5
  IF (YN$ = "C") OR (YN$ = "c") THEN GOTO UPDATE5
  GOTO WAITLP5: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
REM **********
UPDATE5:
CLS
PRINT "also having added toughening elements, such a lots of nickel, in its alloy"
PRINT "composition that WELDOX also does not have, hence STS can tolerate a higher"
PRINT "hardness without loss of the minimum needed toughness (crack resistance, the"
PRINT "opposite of brittleness).  The drop off in Plate Quality with excessive plate"
PRINT "hardness is rather steep with increasing hardness above the optimum, showing"
PRINT "how badly brittleness effects steel (or any other) materials under a sudden"
PRINT "impact shock.  When 12mm WELDOX 700E & 900E nickel-chrome alloy plates were"
PRINT "used, which were hardened to about 129,000 & 152,000 psi Tensile Strengths,"
PRINT "respectively, with a rather brittle tempered Martensite crystal structure,"
PRINT "Plate Quality dropped by circa 8.7% and 10.9%, rspectively, compared to the"
PRINT "WELDOX 460E average and no projectiles shattered near any the NBL (one did"
PRINT "shatter at 1311 ft/sec against a 12mm WELDOX 460E plate, way above the NBL)."
PRINT "I have no data using flat-nose projectiles against harder STS plates, so I"
PRINT "cannot be sure that 115,000 psi is optimum for STS, but it is a reasonable"
PRINT "value and the true optimum value is probably somewhat higher, if not this."
PRINT
PRINT "****>>>> This Was Last Introduction Page.  Type C to Start Inputs.";
WAITLP6:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLP6
  IF (YN$ = "C") OR (YN$ = "c") THEN GOTO BGNINPT
  GOTO WAITLP6: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
REM **********
BGNINPT:
CLS
PRINT "INITIAL DEFAULTS:"
PRINT "     Plate Quality = 1 (STS), Projectile Weight = 13, Projectile Diameter = 3"
PRINT "     Armor Density = 0.2833 (Steel), Impact Obliquity = 0 (=Right-Angles)"
PRINT "     Right-Angles Shatter Thickness = .8 (STS), Minimum Thickness Step = .001"
PRINT
PRINT "ENGLISH UNITS USED:  INCHES, FEET/SECOND, & POUNDS -- ANGLES IN DEGREES"
PRINT
PRINT "THE EXIT ANGLE IN PLATE BACK AT THE NBL IS ALWAYS ZERO IF IMPACT OBLIQUITY IS"
PRINT "  IS UP TO 45 DEGREES (HOLE IS CLOSE TO A CIRCLE IN SHAPE), BUT IT BECOMES MORE"
PRINT "  AND MORE ELONGATED (ELLIPTICAL) ABOVE 45 DEGREES OBLIQUITY."
REM
REM REAL PROJECTILES ARE USUALLY DAMAGED AGAINST PLATES WITH MUCH LOWER NAVY BL VALUES THAN 3500!
PRINT
PRINT "MAXIMUM COMPUTED NBL = 3500 FEET/SECOND.  ABOVE THIS, ALL PROJECTILES WILL"
PRINT "  SHATTER AND FRAGMENTS WILL BE REJECTED BY PLATE (NO HOLE IN THICK PLATE)"
PRINT
PRINT "PRESS *ENTER KEY* WITH NO NUMBER ENTRY TO REPEAT A PREVIOUS OR A DEFAULT ENTRY."
PRINT
DIAMETER:
  INPUT "Projectile Diameter (Inches): ", D$
  IF (D$ = "") THEN
    IF (D > 0) THEN
      PRINT "Projectile Diameter Used is"; D; "inches"
    ELSE
      GOTO DIAMETER
    END IF
  ELSE
    D = VAL(D$): IF (D <= 0) THEN GOTO DIAMETER
  END IF
  PRINT
WEIGHT:
  INPUT "Projectile Total Weight (Pounds): ", WT$
  IF (WT$ = "") THEN
    IF (WT > 0) THEN
      PRINT "Projectile Weight Used is"; WT; "pounds"
    ELSE
      GOTO WEIGHT
    END IF
  ELSE
    WT = VAL(WT$): IF (WT <= 0) THEN GOTO WEIGHT
  END IF
  PRINT
  PRINT "ALL THICKNESS ENTRIES ROUNDED TO THE NEAREST 0.001 UNIT"
  PRINT "MAXIMUM PLATE THICKNESS ALLOWED IS 6 CALIBERS ="; 6! * D;
  IF ((6! * D) <= 1) THEN
    PRINT "INCH"
  ELSE
    PRINT "INCHES"
  END IF
  PRINT "MINIMUM PLATE THICKNESS ALLOWED IS .001 CALIBER ="; .001 * D; "INCH"
  PRINT
  PRINT "Do a Single Plate Calculation with All Outputs (Y/N)? ";
WAITLP7:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLP7
  IF ((YN$ = "Y") OR (YN$ = "y")) THEN PRINT "Yes": SNGLE = 1: GOTO THICK
  IF ((YN$ = "N") OR (YN$ = "n")) THEN PRINT "No": MULT = 1: GOTO INITTHICKNESS
  GOTO WAITLP7: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
THICK:
REM MULT=1 IMPLIES NEW SINGLE-PLATE RUN AFTER A MULTIPLE-PLATE RUN.  RESET PLATE VALUES.
  IF (MULT = 1) THEN MULT = 0: TA = 0: TSLASHD = 0: TSDINIT = 0: TSDFINAL = 0: TSDSTEP = .001
  PRINT
  INPUT "Plate Thickness   (Inches): ", TA$
  IF (TA$ = "") THEN
    IF (TA > 0) THEN
      PRINT "Plate Thickness Used is"; TA;
      IF (TA <= 1) THEN
        PRINT "inch"
      ELSE
        PRINT "inches"
      END IF
    ELSE
      GOTO THICK
    END IF
  ELSE
    TA = VAL(TA$): TATMP = (1000 * TA) + .5: TA = INT(TATMP) / 1000
    IF (((TA / D) < .0009999999#) OR ((TA / D) > 6!)) THEN GOTO THICK
  END IF
  TSLASHDTMP = (1000 * (TA / D)) + .5: TSLASHD = INT(TSLASHDTMP) / 1000
  PRINT
  PRINT "Plate Thickness (Calibers):"; TSLASHD
  PRINT
  TSDINIT = 0: TSDFINAL = 0: TSDSTEP = .001
  GOTO DENSITY
REM ******
INITTHICKNESS:
REM SNGLE=1 IMPLIES NEW MULTIPLE RUN AFTER A SINGLE-PLATE RUN.  RESET PLATE VALUES.
  IF (SNGLE = 1) THEN SNGLE = 0: TA = 0: TSLASHD = 0: TSDINIT = 0: TSDFINAL = 0: TSDSTEP = .001
  PRINT
  INPUT "Initial Plate Thickness (Calibers) (Minimum=0 & Maximum=2): ", TSDINIT$
  IF (TSDINIT$ = "") THEN
    IF ((TSDINIT >= 0) AND (TSDINIT <= 2!)) THEN
      PRINT "Initial Plate Thickness Used is"; TSDINIT;
      IF (TSDINIT <= 1) THEN
        PRINT "caliber"
      ELSE
        PRINT "calibers"
      END IF
    ELSE
      GOTO INITTHICKNESS
    END IF
  ELSE
    TSDINIT = VAL(TSDINIT$)
    IF ((TSDINIT < 0) OR (TSDINIT > 2!)) THEN GOTO INITTHICKNESS
  END IF
  TSLASHDTMP = (1000 * TSDINIT) + .5: TSLASHD = INT(TSLASHDTMP) / 1000: TSDINIT = TSLASHD
  PRINT
  TATEMP = (1000 * TSLASHD * D) + .5: TA = INT(TATEMP) / 1000:
  PRINT "INITIAL PLATE THICKNESS (INCHES):"; TA
  PRINT
FINALTHICKNESS:
  INPUT "Final Plate Thickness (Calibers) (Min=Initial Thickness+.001 & Max=6): ", TSDFINAL$
  IF (TSDFINAL$ = "") THEN
    IF (TSDFINAL >= (TSDINIT + .001)) THEN
      PRINT "Final Plate Thickness Used is"; TSDFINAL;
      IF (TSDFINAL <= 1) THEN
        PRINT "caliber"
      ELSE
        PRINT "calibers"
      END IF
    ELSE
      GOTO FINALTHICKNESS
    END IF
  ELSE
    TSDFINAL = VAL(TSDFINAL$)
    IF ((TSDFINAL < 0) OR (TSDFINAL > 6!)) THEN GOTO FINALTHICKNESS
  END IF
  TFTMP = (1000 * TSDFINAL) + .5: TF = INT(TFTMP) / 1000
  PRINT
  TFATMP = (1000 * (TSDFINAL * D)) + .5: TFA = INT(TFATMP) / 1000:
  PRINT "FINAL PLATE THICKNESS (INCHES):"; TFA
  PRINT
  PRINT "CURRENT THICKNESS STEP (CALIBERS) ="; TSDSTEP
  TASTEPTMP = (1000 * TSDSTEP * D) + .5: TASTEP = INT(TASTEPTMP) / 1000
  PRINT "CURRENT THICKNESS STEP (INCHES)   ="; TASTEP
  PRINT
  STEPMAX = TSDFINAL - TSDINIT
  PRINT "MAXIMUM THICKNESS STEP (CALIBERS) ="; STEPMAX
  STEPMAXATMP = (1000 * STEPMAX * D) + .5: STEPMAXA = INT(STEPMAXATMP) / 1000
  PRINT "MAXIMUM THICKNESS STEP (INCHES)   ="; STEPMAXA
  PRINT
THICKNESSSTEP:
  INPUT "Plate Thickness Step (Calibers) (Min=.001 & Max=Final-Init Thickness): ", TSDSTEP$
  IF (TSDSTEP$ = "") THEN
    IF (TSDSTEP <= STEPMAX) THEN
      PRINT "Plate Thickness Step Used is"; TSDSTEP;
      IF (TSDSTEP <= 1) THEN
        PRINT "caliber"
      ELSE
        PRINT "calibers"
      END IF
    ELSE
      GOTO THICKNESSSTEP
    END IF
  ELSE
    TSDSTEP = VAL(TSDSTEP$)
    IF ((TSDSTEP < .001) OR (TSDSTEP > STEPMAX)) THEN GOTO THICKNESSSTEP
  END IF
  TSDSTEPTMP = (1000 * TSDSTEP) + .5: TSDSTEP = INT(TSDSTEPTMP) / 1000
  PRINT
  TASTEPTMP = (1000 * (TSDSTEP * D)) + .5: TASTEP = INT(TASTEPTMP) / 1000:
  PRINT "PLATE THICKNESS STEP (INCHES):"; TASTEP
  PRINT
REM ******
  PRINT "PLATE DENSITY VARIES WITH PLATE MATERIAL USED.  THREE COMMON MATERIALS ARE:"
  PRINT "     IRON & STEEL = 0.2833 (Default)"
  PRINT "     ALUMINUM     = 0.0972"
  PRINT "     TITANIUM     = 0.2422"
  PRINT "ACTUAL DENSITIES MAY VARY SLIGHTLY FROM ALLOY TO ALLOY, OF COURSE."
  PRINT
DENSITY:
  INPUT "Plate Density (Pounds/cubic-inch): ", DEN$
  IF (DEN$ = "") THEN
    IF (PLATEDEN > 0) THEN
      PRINT "Plate Density Used is"; PLATEDEN
    ELSE
      GOTO DENSITY
    END IF
  ELSE
    PLATEDEN = VAL(DEN$): IF (PLATEDEN <= 0) THEN GOTO DENSITY
  END IF
  PRINT
  PRINT "PLATE QUALITY FACTOR (QA) DIRECTLY MULTIPLIES STANDARD STS (QA = 1.00) NBL"
  PRINT
QUALITY:
  INPUT "Plate Quality Factor (Dimensionless): ", QA$
  IF (QA$ = "") THEN
    IF (QA > 0) THEN
      PRINT "Plate Quality Used is"; QA
    ELSE
      GOTO QUALITY
    END IF
  ELSE
    QA = VAL(QA$): IF (QA <= 0) THEN GOTO QUALITY
  END IF
  PRINT
  PRINT "MAXIMUM ALLOWED STRIKING VELOCITY 3500 FEET/SECOND"
  PRINT
VEL:
  INPUT "Striking Velocity (Feet/Second -- Whole Number Only): ", V$
  IF (V$ = "") THEN
    IF (V > 0) THEN
      PRINT "Striking Velocity Used is"; V; "feet/second"
    ELSE
      GOTO VEL
    END IF
  ELSE
    V = VAL(V$): IF ((V <= 0) OR (V <> INT(V)) OR (V > 3500!)) THEN GOTO VEL
  END IF
  PRINT
OBLIQUITY:
  INPUT "Obliquity (Degrees) (80 Degrees Maximum): ", OB$
  IF (OB$ = "") THEN
    PRINT "Obliquity Angle Used is"; OB;
    IF (OB <= 1) THEN
      PRINT "degree"
    ELSE
      PRINT "degrees"
    END IF
  ELSE
    OB = VAL(OB$): IF (OB < 0) OR (OB > 80!) THEN GOTO OBLIQUITY
  END IF
REM OBFLT IS MAXIMUM OB FOR ADJUSTMENT BELOW T/D = 0.55 & FOR SHATTER ADJUSTMENT
  IF (OB >= 60!) THEN OBFLT = 60! ELSE OBFLT = OB
  OBRAD = OB * 3.141592654# / 180!: REM BASIC USES RADIANS
  CSOB = COS(OBRAD): CSOBSQD = CSOB ^ 2
  PRINT
  PRINT "SHATTERED PENETRATION MAKES AN ENLARGED, IRREGULAR HOLE OF CIRCA DOUBLE VOLUME."
  PRINT "PROJECTILE SHATTER HERE DEPENDS ON PROJECTILE STRENGTH, IMPACT OBLIQUITY,"
  PRINT "PLATE HARDNESS, & PLATE THICKNESS.  IT DOES NOT DEPEND ON STRIKING VELOCITY,"
  PRINT "SO THIS IS NOT SHOCK-INDUCED SHATTER (AS AGAINST FACE-HARDENED ARMOR), BUT IS"
  PRINT "INSTEAD DUE TO THE NOSE BEING CRUSHED BY THE PROJECTILE BODY BEHIND IT WHEN"
  PRINT "IT SUDDENLY DECLERATES ON IMPACT.  THINNER PLATES DEFORM AND REDUCE THE FORCE"
  PRINT "ON THE NOSE.  OBLIQUITY HAS ONLY A RATHER SMALL EFFECT HERE, UNLIKE FOR SHOCK-"
  PRINT "INDUCED SHATTER, SO THE SHATTER PLATE THICKNESS LINEARLY DROPS SLOWLY WITH"
  PRINT "OBLIQUITY TO 75% OF THE RIGHT-ANGLES VALUE AT 60 DEGREES (THIS IS MINIMUM)."
  PRINT "FOR A STRONG WWII AP PROJECTILE AT RIGHT ANGLES, THE FOLLOWING SHATTERS IT:"
  PRINT "   TYPICAL WWII STS-TYPE ARMOR       STEEL = 0.8  CALIBER (TESTS)"
  PRINT "   TYPICAL HIGH TENSILE CONSTRUCTION STEEL = 1.05 CALIBER (TESTS)"
  PRINT "   TYPICAL MILD                      STEEL = 1.15 CALIBER (ESTIMATE)"
  PRINT "   WROUGHT IRON (CONSTRUCTION & ARMOR)     = 1.25 CALIBER (ESTIMATE)"
  PRINT "THESE VALUES WILL GO DOWN WITH SOFTER OR MORE BRITTLE PROJECTILES."
  PRINT
SHATTER:
  INPUT "Normal (Right-Angles) Projectile Shatter Plate Thickness (Calibers): ", SH$
  IF (SH$ = "") THEN
    IF (SH > 0) THEN
      PRINT "Normal Projectile Shatter Plate Thickness (Calibers) Used is"; SH
    ELSE
      GOTO SHATTER
    END IF
  ELSE
    SH = VAL(SH$): IF (SH <= 0) THEN GOTO SHATTER
  END IF
  SHOBMOD = 1 - (.00416667# * OBFLT): SHOBFLT = SHOBMOD * SH: REM SHATTER THICKNESS
  SHOBTMP = (1000 * SHOBFLT) + .5: SHOBRND = INT(SHOBTMP) / 1000
  SHINCHTMP = (1000 * SHOBFLT * D) + .5: SHINCH = INT(SHINCHTMP) / 1000
  PRINT "Plate Shatter Thickness at given Obliquity Angle (calibers) ="; SHOBRND
  PRINT "Plate Shatter Thickness at given Obliquity Angle (inches)   ="; SHINCH
  PRINT
REM
REM                 ****** BEGIN COMPUTATIONS ******
REM
REM ********
  PROJDENSITY = WT / D ^ 3: REM ENGLISH UNITS TYPICAL IS 0.48 TO 0.67 (20mm TEST USED 0.89)
REM ********
REM
IF (TSLASHD = 0) THEN GOTO FINAL: REM FIRST CALC IF TSDINIT=0 ALWAYS HAS EVERYTHING ZERO
REM
COMPSTART:
REM ********
REM REVISION 3.0 FIXES NOTED:  PRIMARILY FIXES FOR SCALEFACTOR, AS FOLLOWS:
REM (1) MULTIPLY INSTEAD OF INCORRECT DIVIDE IN 'JJ1' CALC
REM (2) REALIZED THAT 1/D^.5 TERM DIVIDING 'NBLFNV5PT5' IS ACTUALLY PART OF SCALEFACTOR AND WRONG HERE
REM (3) REALIZED THAT WELDOX 460E HTS IS AT LEAST EQUAL TO BRITISH WWII D-STEEL, SO IT HAS QA=0.9 (MAYBE HIGHER)
REM (4) REALIZED M79APCLC SCALEFACTOR EQUATION 'SCALEFACTOR'=(1-.04*LOG(D/3!))^.5 WAS INCORRECT (TOO SMALL) HERE
REM     CHANGED IT AS SHOWN BELOW (LARGE MULTIPLIER & NO SQUARE-ROOT (WILL CRASH PROGRAM)
REM (5) REVISED SCALEFACTOR TO MATCH *BOTH* 13-LB 3" VS STS & 0.4343-LB 0.7874" (20mm) VS WELDOX 460E (QA=0.9) RESULTS (CHANGED 0.04 MULTIPLIER)
REM
REM NEW SCALEFACTOR (ESTIMATE) -- DOES NOT CHANGE 3" RESULTS:
REM PLATETYPE = 0 FOR STS; = .21 FOR HIGH-END HTS (WELDOX 460E & D-STEEL QA=.9)
  SCALEMULT = .45: REM 0.24 FOR STS & 0.45 FOR WELDOX 460E (QA=0.9) -- ALLOW QUICK MOD IF NECESSARY!!
  SCALEFACTOR = 1 - (SCALEMULT * LOG(D / 3!)): REM NATURAL LOG (NAPTURIAN OR 'LN' LOGARITHM, OR BAS E)
REM ********
REM FINAL FLAT-NOSE PROJECTILE NAVY BL FOR PLATES WITHOUT SHATTER
REM FIRST, COMPUTE NBL AT T/D=0.55 CALIBER
  IF (TSLASHD >= SHOBRND) THEN SHAT = 1:  ELSE SHAT = 0: REM DETERMINE SHATTER
  IF (SHATFLAG = 0) AND (SHAT = 1) THEN SHATFLAG = 1: REM SINGLE USE ONLY
  NUMCON = 907.017: EXPON = .381145: REM CHANGED NUMCON TO CANCEL 1/D^.5 REMOVAL (REV 3.0 FIX)
  REM 'EXPON' FROM 3" FLAT-NOSE 7.5-LB, 11-LB, & 15-LB PROJECTILE TESTS
  REM 'NUMCON' TO MATCH 0.55-CALIBER (1.65") NBL=718 FT/SEC FOR 3" 13-LB PROJECTILE
  REM WHEN 1/D^.5 IN 'JJ1' NUMCON=1571
  JJ0 = (1 / PROJDENSITY) * EXPON: REM PROJECTILE WEIGHT INPUT
  JJ1 = QA * SCALEFACTOR: REM PLATE QUALITY & PROJ SCALE INPUT (REV 3.0 FIX)
  JJ2 = (1 + (.00433 * OB)) / CSOB: REM V(T/D=.55) OBLIQUITY ADJUSTMENT
  NBLFNV5PT5 = NUMCON * JJ0 * JJ1 * JJ2: REM V(T/D=.55) @ OB: REM DELETED 1/D^.5, NOW PART OF SCALEFACTOR (REV 3.0 FIX)
REM SECOND, COMPUTE OFFSET AT ACTUAL T/D COMPARED TO V(T/D=.55)
  GOSUB VOVRV55
REM THIRD, COMPUTE V(ACTUAL T/D)
  NBLFN1 = NBLFNV5PT5 * VSLASHV55: REM ACTUAL V(T/D) -- LINEAR 1ST APPROXIMATION
REM
REM ***** VERSION 2.1 MODIFICATIONS *****
REM
REM INCREASE IN THIN PLATE OBLIQUE PENETRATION DUE TO CUTTING CORNER ("CHIN") OF
REM   FLAT NOSE NOTCHING PLATE, DECREASING LOCAL OBLIQUITY, AND SLIGHTLY REDUCING DISHING
REM   ONLY APPLIES BETWEEN T/D=0.1 & T/D=0.55; MINIMUM NBL @ OB=60 & MAXIMUM NBL (NO CHANGE) @ OB=0
REM
REM CORRECTION FOR ALL THICKNESSES WHEN OVER 60 DEGREES OBLIQUITY FOLLOWS:
  IF (OB > 60) THEN NBLFN1 = NBLFN1 / (1 + .00335 * (OB - 60))
  GOTO FINALNBL
REM **********
REM TABLE OF VALUES OF NBL MODIFICATION DUE TO DISHING TWEAK DUE TO PROJECTILE "CHIN"
REM    CUTTING INTO THIN PLATES
REM FIRST INDEX IS OBLIQUITY IN 15-DEGREE STEPS AND SECOND INDEX IS PLATE
REM    THICKNESS IN CALIBERS IN 0.05-CALIBER STEPS
REM LINEAR INTERPOLATION FORMULA USED. THIS FACTOR IS A CONSTANT FOR ALL
REM    OBLIQUITIES ABOVE 60 DEGREES.
INITDELTATBL:
REM OB = 0 DEGREES (NORMAL)
  DELTATBL(0, 0) = 0: DELTATBL(0, 1) = 0: DELTATBL(0, 2) = 0
  DELTATBL(0, 3) = 0: DELTATBL(0, 4) = 0: DELTATBL(0, 5) = 0
  DELTATBL(0, 6) = 0: DELTATBL(0, 7) = 0: DELTATBL(0, 8) = 0
  DELTATBL(0, 9) = 0
REM OB = 15 DEGREES
  DELTATBL(1, 0) = 0: DELTATBL(1, 1) = 0: DELTATBL(1, 2) = 0
  DELTATBL(1, 3) = 0: DELTATBL(1, 4) = 0: DELTATBL(1, 5) = .006
  DELTATBL(1, 6) = .012: DELTATBL(1, 7) = .01: DELTATBL(1, 8) = .009
  DELTATBL(1, 9) = 0
REM OB = 30 DEGREES
  DELTATBL(2, 0) = 0: DELTATBL(2, 1) = 0: DELTATBL(2, 2) = 0
  DELTATBL(2, 3) = .01: DELTATBL(2, 4) = .021: DELTATBL(2, 5) = .023
  DELTATBL(2, 6) = .024: DELTATBL(2, 7) = .02: DELTATBL(2, 8) = .013
  DELTATBL(2, 9) = 0
REM OB = 45 DEGREES
  DELTATBL(3, 0) = 0: DELTATBL(3, 1) = 0: DELTATBL(3, 2) = .035
  DELTATBL(3, 3) = .044: DELTATBL(3, 4) = .051: DELTATBL(3, 5) = .045
  DELTATBL(3, 6) = .038: DELTATBL(3, 7) = .03: DELTATBL(3, 8) = .015
  DELTATBL(3, 9) = 0
REM OB = 60 DEGREES & UP
  DELTATBL(4, 0) = 0: DELTATBL(4, 1) = .047: DELTATBL(4, 2) = .086
  DELTATBL(4, 3) = .085: DELTATBL(4, 4) = .085: DELTATBL(4, 5) = .068
  DELTATBL(4, 6) = .052: DELTATBL(4, 7) = .035: DELTATBL(4, 8) = .018
  DELTATBL(4, 9) = 0
RETURN
REM **********
REM *** USE THICKNESS-AXIS INCREMENT TO FIND THE TWO OBLIQUITY-AXIS POINTS BY INTERPOLATION
DELTATHICK:
  TWKTH0 = DELTATBL(O1 + N, TH1): REM THICKNESS LOWER TABLE POINT (N=0-->INT(OB); N=1-->INT(OB+15)
  TWKTH1 = DELTATBL(O1 + N, TH1 + 1): REM THICKNESS UPPER TABLE POINT (DITTO)
  TWEAKVAL = TWKTH0 + TH2 * (TWKTH1 - TWKTH0): REM IN-BETWEEN-PLATE-THICKNESS OB VALUE FOR N=0 OR N=1
  RETURN
REM **********
FINALNBL:
  IF (OB >= 60) THEN OBTWEAK = 59.9999:  ELSE OBTWEAK = OB: REM MAX TABLE OB IS 60 DEG
  NBLTWEAK = 0: REM NO EFFECT UNLESS INSIDE THE T/D REGION BETWEEN 0.1 & 0.55
  IF ((TSLASHD > .1) AND (TSLASHD < .55)) THEN
REM OBLIQUITY AXIS: DELTA(OB)   =  15-DEGREE  INTERVAL (INCREASING)
    O1 = INT(OBTWEAK / 15!): O2 = (OBTWEAK - (15! * O1)) / 15!
REM THICKNESS AXIS: DELTA(TA/D) = .05-CALIBER INTERVAL (INCREASING), STARTING AT .1 CALIBER (FOR TH1=0)
    TH1ACTUAL = INT(TSLASHD / .05): TH2 = (TSLASHD - (.05 * TH1ACTUAL)) / .05: TH1 = TH1ACTUAL - 2: REM SHIFT TH1ACTUAL DOWN BY .1 CAL = TO TABLE (X,0)
REM FIND THE LOWEST  OF THE TWO OB INTERPOLATION POINTS
REM    (BETWEEN TABULATED THICKNESS VALUES)
    N = 0: GOSUB DELTATHICK: NBLTWK0 = TWEAKVAL
REM FIND THE HIGHEST OF THE TWO OB INTERPOLATION POINTS
REM    (BETWEEN TABULATED THICKNESS VALUES)
    N = 1: GOSUB DELTATHICK: NBLTWK1 = TWEAKVAL
REM NOW INTERPOLATE THE OBLIQUITY AXIS BETWEEN THE TWO OBLIQUITY AXIS POINTS
REM    FOUND FROM THE THICKNESS AXIS INTERPOLATION
    NBLTWEAK = NBLTWK0 + O2 * (NBLTWK1 - NBLTWK0): REM FINAL ADJUSTMENT VALUE
  END IF
REM **********
REM FINAL "TWEAKED" VERSION OF FLAT-NOSE PROJ NBL WHICH WILL
REM    REDUCE NBL (IMPROVE PENETRATION) WHEN THIS "TWEAK" APPLIES
  NBLFN1 = NBLFN1 * (1 - NBLTWEAK): NBLFN = NBLFN1: REM PLATE NBL WITHOUT SHATTER
  IF (SHAT = 1) THEN NBLFN = 2 * NBLFN: REM TEST ACTUAL NBL FOR SHATTER --> 2 x NBL
  NBLSTS1 = NBLFN1 / QA: REM STS NBL WITHOUT SHATTER
  SHSTS = .8 * SHOBMOD: IF (TSLASHD >= SHSTS) THEN STSSHAT = 1: NBLSTS1 = NBLSTS1 * 2: REM TEST FOR SHATTER --> 2 x NBLSTS
  NBLSTSTMP = NBLSTS1 + .5: NBLSTS = INT(NBLSTSTMP): REM FINAL DEFAULT STS NBL -- WHOLE NUMBER USED
REM
REM ***** END OF VERSION 2.1 MODIFICATIONS *****
REM
REM WHOLE NUMBER NBL VALUE FOR COMPARISON & PRINTOUT USE
  NBLFNRND = INT(NBLFN + .5)
REM
FINAL:
  IF (FINALFLAG = 0) THEN
    COUNT = 0
    PRINT "                 *****>>>>>>>FINAL RESULTS<<<<<*****"
    PRINT "PROJ:  DIAMETER  ="; D; TAB(29); "WEIGHT  ="; WT; TAB(47); "VELOCITY  ="; V
    PRINT "PLATE: QUALITY   ="; QA; TAB(29); "DENSITY ="; PLATEDEN; TAB(47); "OBLIQUITY ="; OB
    SHPRNTTMP = (1000 * SH) + .5: SHPRNT = INT(SHPRNTTMP) / 1000
    PRINT "       SHATTER T @ OB=0 CALIBERS ="; SHPRNT; TAB(44); "SHATTER T @ OB CALIBERS ="; SHOBRND
    IF (TSDFINAL = 0) THEN
REM SINGLE PLATE ALL-OUTPUT CALCS
      PRINT "       THICKNESS INCHES ="; TA; TAB(37); "THICKNESS CALIBERS ="; TSLASHD
    ELSE
REM MULTIPLE PLATE NBL-ONLY CALC
      PRINT "INITIAL T CALIBERS ="; TSDINIT; TAB(29); "FINAL T CALIBERS ="; TSDFINAL; TAB(55); "T STEP CALIBERS ="; TSDSTEP
    END IF
  END IF
  IF (TSDFINAL = 0) THEN GOTO CHECKNBL: REM SINGLE-PLATE CALCS
REM
REM **** MULTIPLE-PLATES RUN WITH NBL ONLY ****
REM
GOSUB PRINTNBL: REM PRINT THIS OUTPUT
IF ((NBLFNRND > 3500) AND (NBLSTS > 3500)) THEN
  PRINT "***>> NO MORE NBL DATA -- STOP RUN"
  PRINT
  GOTO ENDIT: REM ABORT THIS RUN
END IF
IF (TSLASHD >= TSDFINAL) THEN PRINT : GOTO ENDIT: REM FINISHED ALL INCREMENTS
IF (COUNT = 24) THEN
  PRINT "TYPE C TO CONTINUE ";
WAIT7:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAIT7
  IF (YN$ = "C") OR (YN$ = "c") THEN PRINT "Go": GOTO GOPRINT
  GOTO WAIT7: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
END IF
GOPRINT:
  IF (TSLASHD < TSDFINAL) THEN
    TSLASHDTMP = (1000 * (TSLASHD + TSDSTEP)) + .5: TSLASHD = INT(TSLASHDTMP) / 1000
    IF (TSLASHD >= TSDFINAL) THEN TSLASHD = TSDFINAL
    TATMP = (1000 * TSLASHD * D) + .5: TA = INT(TATMP) / 1000
  END IF
  COUNT = COUNT + 1: GOTO COMPSTART: REM START NEXT CALCULATION
REM ****
PRINTNBL:
  FINALFLAG = 1
  IF (SHATFLAG = 1) THEN
    SHATFLAG = -1: REM PRINT MESSAGE ONLY ONCE PER RUN
    PRINT "***>> PROJECTILE SHATTERED FROM NOW ON (NOTE THE '$') -- DOUBLE NBL"
  END IF
  PRINT "T/D="; TSLASHD; TAB(13); "-T(Actual)="; TA; TAB(32);
   IF (SHAT = 1) THEN
    PRINT "$";
  ELSE
    PRINT "-";
  END IF
  IF (NBLFNRND > 3500) THEN
    PRINT "NBL(Actual)>*3500*";
  ELSE
    PRINT "NBL(Actual)="; NBLFNRND;
  END IF
  PRINT TAB(53);
  IF (STSSHAT = 1) THEN
    PRINT "$";
  ELSE
    PRINT "-";
  END IF
  IF (NBLSTS > 3500) THEN
    PRINT "NBL(STS Default)>*3500*"
  ELSE
    PRINT "NBL(STS Default)="; NBLSTS
  END IF
RETURN
REM ****
REM
REM **** SINGLE-PLATE RUN WITH ALL OUTPUTS ****
REM
CHECKNBL:
  IF (SHAT = 1) THEN
    PRINT "Projectile shattered.  Double calculated NBL and, if any, plug weight."
  ELSE
    PRINT "Projectile not shattered.  Use regular calculated NBL and, if any, plug weight."
  END IF
  PRINT
  IF (NBLFNRND > 3500) THEN
    PRINT "No penetration possible -- NBL > 3500 feet/second": PRINT
    GOTO ENDIT
  END IF
REM HOW MUCH ENERGY PER VOLUME OF ARMOR MATERIAL REMOVED WAS NEEDED
REM   TO OPEN UP A CALIBER-DIAMETER HOLE IN THAT PLATE
ENERGYTEMP = .5 * (WT / 32.186) * NBLFNRND ^ 2
ENERGYDENSITY = ENERGYTEMP / (3.141592654# * TA * (D / 2) ^ 2)
ENERGYRNDED = INT(ENERGYDENSITY + .5)
ENERGYCSOBSQD = ENERGYDENSITY * CSOBSQD
ECSOBRNDED = INT(ENERGYCSOBSQD + .5)
PRINT "Navy Ballistic Limit ="; NBLFNRND; "feet/second"
PRINT
PRINT "ENERGY DENSITY = IMPACT ENERGY/(VOLUME OF CYLINDRICAL D-DIAM HOLE THRU PLATE):"
PRINT
PRINT "**** Energy Density ="; ENERGYRNDED; "foot-pounds/cubic inch"
PRINT
PRINT "ENERGY DENSITY USING ONLY NBL COMPONENT POINTING AT RIGHT ANGLES TO PLATE FACE:"
PRINT "(GRAPHS OF THIS QUANTITY VERSUS PLATE THICKNESS IN CALIBERS ARE ILLUMINATING;"
PRINT "THEY SHOW TRENDS BY ELIMINATING SIMPLE OBLIQUE IMPACT GEOMETRICAL EFFECTS)"
PRINT
PRINT "**** Energy Density X COS(OB)^2 ="; ECSOBRNDED; "foot-pounds/cubic inch"
PRINT
REM
REM ***** EXIT ANGLE, EXIT VELOCITY, PLUG WEIGHT. & PLUG VELOCITY CALCS *****
REM
IF (V < NBLFNRND) THEN PRINT "No hole through plate.": PRINT : GOTO ENDIT
REM
REM *** HOLE PUNCHED IN PLATE ***
REM
PRINT "PLUG ALWAYS EJECTED ALONG CALCULATED EXIT ANGLE EVEN IF PROJECTILE REBOUNDS."
PRINT "PLUG WEIGHT IS MINIMUM (OB=0) PLUG WEIGHT DIVIDED BY COS[(OB+EXIT ANGLE)/2]."
PRINT "PLUG VELOCITY IS AT LEAST EQUAL TO PROJECTILE REMAINING VELOCITY.  IF THE"
PRINT "PROJECTILE SHATTERS, SOME PIECES OF IT WILL REBOUND SIDEWAYS, NOT THRU HOLE."
PRINT "SHATTERED PROJECTILE PLUG WEIGHT = 1.333 x UNSHATTERED PLUG WEIGHT (ONE TEST"
PRINT "RESULT), FORMED BY ENLARGED, IRREGULAR HOLE.  PLUG USUALLY REMAINS IN ONE"
PRINT "PIECE IF THE ARMOR FAILS IN A DUCTILE MANNER, BUT BREAKS UP IF ARMOR BRITTLE."
PRINT "IF PLUG IS AS HEAVY AS OR HEAVIER THAN PROJECTILE, THEN THE PROJECTILE WILL"
PRINT "*ALWAYS* REBOUND DUE TO CONSERVATION OF MOMENTUM ('CUE-BALL EFFECT')."
PRINT
PLUGMIN = PLATEDEN * (3.141592654#) * TA * (D / 2) ^ 2: REM CYLINDRICAL PLUG WEIGHT
REM
REM *** EXIT ANGLE COMPUTATION ***
REM
REM FIX DIVIDE-BY-ZERO FOR VERY THIN PLATES
IF (OB <= .005) THEN
  CSEX = 1: EX = 0: EXRAD = 0: EXRND = 0: DF = 0: DFRAD = OB / 57.29578
  GOTO PLUGCALC
END IF
REM
VRAT = V / NBLFNRND: IF (VRAT < 1) THEN VRAT = 1: REM PREVENT ROUND-OFF ERROR
TMPV = VRAT ^ 2 - 1: TMPVEL = VRAT ^ 2 + VRAT * SQR(TMPV)
SNCSTST = SIN(OBRAD) * CSOB: SNCS = SNCSTST: REM ALWAYS NOSE-FIRST PENETRATION AT ALL OB VALUES
REM CALCULATE DEFLECTION ANGLE DF -- SYMMETRICAL ABOUT OB=45
TMPDF1 = SNCS / TMPVEL: TMPDF2 = 1 - 4 * TMPDF1 ^ 2
TANDF = (1 - SQR(TMPDF2)) / (2 * TMPDF1): REM TRIG IDENTITY FOR TANGENT OF DF
DF = ATN(TANDF) * 57.29578
DFRAD = DF / 57.29578: DFTMP = 100 * DF + .5: DFRNDED = INT(DFTMP) / 100: REM RADIANS REQUIRED
EX = OB - DF: EXRAD = EX / 57.29578: EXTMP = 100 * EX + .5: EXRND = INT(EXTMP) / 100
CSEX = COS(EXRAD)
REM
REM *** PLUG WEIGHT COMPUTATION ***
REM
PLUGCALC:
  PRINT "Exit Angle (Degrees) ="; EXRND
  PLUGANGLE = (OB + EX) / 2: REM PLUG SIZE MODIFIER IS MIDWAY BETWEEN OBLIQUITY & EXIT ANGLES
  PLUGAGLRAD = PLUGANGLE / 57.2957: CSPLGANGLE = COS(PLUGAGLRAD)
  PLUGEX = PLUGMIN / CSPLGANGLE: REM UNSHATTERED PLUG WEIGHT MOVING ALONG EXIT ANGLE
  IF (SHAT = 0) THEN
    PRINT "Unshattered Projectile";
  ELSE
    PLUGEX = PLUGEX * 1.333: REM INCREASE PLUG WEIGHT BY A THIRD (= SINGLE PLUG PUNCHED BY SHATTERED PROJECTILE)
    PRINT "Shattered Projectile";
  END IF
  PLUGTMP = 1000 * PLUGEX + .5: PLUGRND = INT(PLUGTMP) / 1000: REM FINAL ACTUAL PLUG WEIGHT
  PRINT " Plug Weight (Pounds) ="; PLUGRND
  PRINT
REM
REM *** PROJECTILE REMAINING VELOCITY & PLUG VELOCITY CALC ***
REM
IF (V < NBLFNRND) THEN NBLFNRND = V: REM PREVENT ROUND-OFF ERROR
VNBLFN = (V ^ 2 - NBLFNRND ^ 2): VR1 = COS(DFRAD) * SQR(VNBLFN)
REM *****
REM CONSERVATION OF MOMENTUM & CONSERVATION OF ENERGY USED TO CALCULATE A SINGLE VPLUG & VR
REM
VPLUG = VR1 * 2 * WT / (WT + PLUGRND): REM PLUG REMAINING VELOCITY
VR = VPLUG * (WT - PLUGRND) / (2 * WT): REM PROJECTILE REMAINING VELOCITY
REM
VPLUGTMP = VPLUG + .5: VPLUGRND = INT(VPLUGTMP): REM CALCULATE FINAL VPLUG
VRTMP = VR + .5: VRRND = INT(VRTMP): REM CALCULATE FINAL VR
REM
PRINT "ELASTIC COLLISION WITH PLUG CALCULATED USING REMAINING VELOCITY & EXIT ANGLE:"
PRINT
PRINT "Ejected Armor Plug   Velocity in Exit Angle Direction (Feet/Second) ="; VPLUGRND
PRINT "Projectile Remaining Velocity in Exit Angle Direction (Feet/Second) ="; VRRND
REM
REM ****** REPEAT PROGRAM LOGIC ******
REM
ENDIT:
  FINALFLAG = 0: SHATFLAG = 0: SHAT = 0: STSSHAT = 0:
  COUNT = 0: NBLFN = 0: NBLSTS = 0: NBLFNRND = 0
  PRINT "                   *****>>>>>>>FINISHED<<<<<<<*****"
  PRINT "Run Again (Y/N)? ";
WAITLOOP:
  YN$ = INKEY$: IF (YN$ = "") THEN GOTO WAITLOOP
  IF (YN$ = "Y") OR (YN$ = "y") THEN PRINT "Yes": PRINT : GOTO DIAMETER
  IF (YN$ = "N") OR (YN$ = "n") THEN END: REM KILL PROGRAM
  GOTO WAITLOOP: REM ALL OTHER ENTRIES ARE ILLEGAL (IGNORE)
REM **************
VOVRV55:
REM PROJECTILE DAMAGE & PLATE QUALITY QA IGNORED HERE (QA=1.00 ALWAYS)
REM
REM DIVIDE PLATES BY MODIFIED T/D VALUE INTO THREE GROUPS:
REM GROUP 1 -- T/D>=0.55 CAL; GROUP 2 -- CURVE CUTOFF<=T/D<.55 CAL; GROUP 3 -- T/D<CURVE CUTOFF
  IF (TSLASHD >= .55) THEN
    VSLASHV55 = (TSLASHD + .075) / .625: REM SINGLE LINEAR V/V.55 RATIO FOR T/D>=0.55
  ELSE
    VSLSHVZERO = -.035301495# * (OBFLT ^ .720400791#) + .67417813#
    KK0 = 1 - VSLSHVZERO: KK1 = .55 / KK0: KK2 = .55 - KK1
    VSLASHV55 = (TSLASHD - KK2) / KK1: REM LINEAR V/V.55 RATIO FOR OB AT ACTUAL T/D
REM (T/D)TOP HAS LINEAR INCREASE WITH DECREASING OB FROM 0 @ OB>=60 TO 0.125 CAL FOR OB=0
    VSLSHVTOP = KK2 / (.1671123 - KK1): REM V/V.55 RATIO CURVE CUTOFF FOR OB & BELOW CERTAIN T/D=(T/D)TOP
    TSLSHDTOP = VSLSHVTOP * .1671123: REM (T/D)TOP CUTOFF THICKNESS CURVE FOR GIVEN OBFLT (MAX VAL=60 DEG)
    IF (VSLASHV55 < VSLSHVTOP) THEN
REM CURVED PORTION OF V/V.55 RATIO FOR OBFLT DOWN TO ZERO THICKNESS BELOW CUTOFF THICKNESS
REM THIS IS ALWAYS SKIPPED FOR OB>=60 DEGREES (TSLSHDTOP=0)
      VLOGZERO = LOG(TSLASHD / .6884599) / 5.8761144#
      VSLV55ZERO = EXP(VLOGZERO): REM V/V.55 AT OB=0 & ACTUAL T/D
      VLOGZEROTOP = LOG(TSLSHDTOP / .6884599) / 5.8761144#
      VSLV55ZEROTOP = EXP(VLOGZEROTOP): REM V/V.55 RATIO AT OB=0 & (T/D)TOP
      VOBTOVZERORATIO = VSLSHVTOP / VSLV55ZEROTOP: REM MULTIPLIER TO SHIFT V/V.55 TO OBFLT
      VSLASHV55 = VOBTOVZERORATIO * VSLV55ZERO: REM V/V.55 RATIO AT OBFLT & ACTUAL T/D
    END IF
  END IF
RETURN
REM ******** << END OF PROGRAM FLATNS30 >> ********

